/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import model2.AbnScheme;
import util.SBException;

class AbnSchemeTableModel
extends AbstractTableModel {
    AbnScheme scheme;
    JDialog parent;
    static final String[] titles = new String[]{"Abr.", "Minimum", "Output", "Description"};
    static final int COL_ABR = 0;
    static final int COL_MIN = 1;
    static final int COL_OUTPUT = 2;
    static final int COL_DESC = 3;
    static final int[] widths = new int[]{60, 60, 60, 150};

    AbnSchemeTableModel() {
    }

    @Override
    public int getColumnCount() {
        return titles.length;
    }

    @Override
    public int getRowCount() {
        if (this.scheme == null) {
            return 0;
        }
        return this.scheme.getNClasses();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < this.scheme.getNClasses()) {
            switch (col) {
                case 0: {
                    return this.scheme.getEntry(row);
                }
                case 1: {
                    return new Integer(this.scheme.getLowBound(row));
                }
                case 2: {
                    return new Integer(this.scheme.getOutputValue(row));
                }
                case 3: {
                    return this.scheme.getClassName(row);
                }
            }
            return "";
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (obj == null) {
            return;
        }
        try {
            switch (col) {
                case 0: {
                    String strg = ((String)obj).toUpperCase();
                    if (strg.length() > 4) {
                        strg = strg.substring(0, 4);
                        this.parent.getToolkit().beep();
                    }
                    this.scheme.setEntry(strg, row);
                    break;
                }
                case 1: {
                    this.scheme.setLowBound(((Integer)obj).intValue(), row);
                    break;
                }
                case 2: {
                    this.scheme.setOutputValue(((Integer)obj).intValue(), row);
                    break;
                }
                case 3: {
                    String strg = (String)obj;
                    if (strg.length() > 25) {
                        strg = strg.substring(0, 25);
                        this.parent.getToolkit().beep();
                    }
                    this.scheme.setClassName(strg, row);
                    break;
                }
            }
        }
        catch (NumberFormatException pe) {
        }
        catch (SBException se) {
            JOptionPane.showMessageDialog(this.parent, se.toString(), "Entry Error", 2);
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return String.class;
            }
            case 1: 
            case 2: {
                return Integer.class;
            }
            case 3: {
                return String.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: {
                return false;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
        }
        return true;
    }
}

