/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import model2.AbnScheme;
import model2.AnalystHeader;
import model2.SBdb;
import util.ColorRenderer;
import util.SB;

class AnalystHeaderTableModel
extends AbstractTableModel {
    final SBdb db;
    List<AnalystHeader> hdrs = null;
    private static String[] columnHeaders = new String[]{"Discipline", "Analyst", "Suite No.", "Abund.Sch.", "Env.Sch.", "Comments", "Colour"};
    static final int COL_DISC = 0;
    static final int COL_ANALYST = 1;
    static final int COL_NUMBER = 2;
    static final int COL_ABUND = 3;
    static final int COL_ENV = 4;
    static final int COL_COMMENTS = 5;
    static final int COL_COLOUR = 6;
    private static int[] columnWidths = new int[]{30, 20, 20, 40, 30, 120, 8};

    AnalystHeaderTableModel(SBdb sbdb) {
        this.db = sbdb;
    }

    @Override
    public int getColumnCount() {
        return columnHeaders.length;
    }

    @Override
    public int getRowCount() {
        if (this.hdrs == null) {
            return 0;
        }
        return this.hdrs.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.hdrs == null) {
            return "";
        }
        AnalystHeader hdr = this.hdrs.get(row);
        try {
            switch (col) {
                default: {
                    return "";
                }
                case 0: {
                    return hdr.getDiscipline().getAbr(true);
                }
                case 1: {
                    return hdr.getAnalyst();
                }
                case 2: {
                    return "" + hdr.getAnalyNumber();
                }
                case 3: {
                    if (hdr.getAbnSchID() > 0) {
                        return this.db.getAbnScheme(hdr.getAbnSchID(), true);
                    }
                    return "";
                }
                case 4: {
                    if (hdr.getEnvSchID() > 0) {
                        return this.db.getEnvScheme(hdr.getEnvSchID());
                    }
                    return "";
                }
                case 5: {
                    return hdr.getComments();
                }
                case 6: 
            }
            return hdr.getColour();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 6: {
                return Color.class;
            }
            case 3: {
                return AbnScheme.class;
            }
        }
        return String.class;
    }

    void setupTable(JTable jTableAnalystHeader) {
        SB.setTableHeaderBold((JTable)jTableAnalystHeader);
        for (int i = 0; i < jTableAnalystHeader.getColumnCount(); ++i) {
            jTableAnalystHeader.getColumnModel().getColumn(i).setHeaderValue(columnHeaders[i]);
            jTableAnalystHeader.getColumnModel().getColumn(i).setPreferredWidth(columnWidths[i]);
        }
        jTableAnalystHeader.setDefaultRenderer(Color.class, (TableCellRenderer)new ColorRenderer(true));
    }
}

