/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import jsbugs.TableModelSB;
import model2.Biocom;
import model2.SBdb;
import util.SBException;

public class BiocomTableModel
extends TableModelSB {
    char units = (char)77;
    List<Biocom> comments = null;
    static String[] columnTitles = new String[]{"Sample", "Discipline", "Analyst", "Comment", "Mod. By", "Modified"};
    private static final int[] defaultColumnWidths = new int[]{55, 30, 30, 200, 30, 30};
    static final int COL_SAMPLE = 0;
    static final int COL_DISC = 1;
    static final int COL_ANALYST = 2;
    static final int COL_TEXT = 3;
    static final int COL_MODIFIER = 4;
    static final int COL_MODIFIED = 5;

    @Override
    public int getColumnCount() {
        return columnTitles.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Biocom biocom = this.comments.get(row);
        switch (col) {
            case 0: {
                return biocom.getTopSample().toString(this.units, false, false, true);
            }
            case 1: {
                return biocom.getDiscipline().getNoun();
            }
            case 2: {
                try {
                    return biocom.getAnalystString();
                }
                catch (SQLException ex) {
                    return ex.getMessage();
                }
                catch (SBException ex) {
                    return ex.getMessage();
                }
            }
            case 3: {
                return biocom.getText();
            }
            case 4: {
                return biocom.getModifierAbr();
            }
            case 5: {
                return biocom.getModified();
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        if (this.comments == null) {
            return 0;
        }
        return this.comments.size();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            default: {
                return String.class;
            }
            case 5: 
        }
        return Date.class;
    }

    void setupTable(JTable jTableComments, SBdb sbdb) {
        this.init(jTableComments, sbdb);
    }

    @Override
    String[] getColumnTitles() {
        return columnTitles;
    }

    @Override
    String getPrefString() {
        return "TMBIOCOM";
    }

    @Override
    String getPrefOrderString() {
        return "TOBIOCOM";
    }

    @Override
    final String getAutoResizeString() {
        return "TARBIOCOM";
    }

    @Override
    int[] getDefaultColumnWidths() {
        return defaultColumnWidths;
    }
}

