/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

public class BlockProperties {
    ScaleType scaleType;
    float min;
    float max;
    float scale = 2000.0f;
    boolean ageLeftToRight = true;
    char units = (char)77;
    float height;

    public BlockProperties() {
        this.scaleType = ScaleType.MD;
    }

    public BlockProperties(ScaleType scaleType) {
        this.scaleType = scaleType;
    }

    public boolean setScaleType(ScaleType type) {
        boolean change = this.scaleType != this.scaleType;
        this.scaleType = type;
        return change;
    }

    boolean getNormal() {
        return true;
    }

    String getProperties() {
        String string = new String();
        String[] props = new String[]{this.scaleType.name(), "" + this.units, "" + this.min, "" + this.max, "" + this.scale, "" + (this.ageLeftToRight ? 1 : 0)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        return string;
    }

    BlockProperties(String props) {
        String[] split = props.split("\\|");
        block8: for (int i = 0; i < split.length; ++i) {
            switch (i) {
                case 0: {
                    this.scaleType = ScaleType.valueOf(split[i]);
                    continue block8;
                }
                case 1: {
                    this.units = split[i].charAt(0);
                    continue block8;
                }
                case 2: {
                    this.min = Float.parseFloat(split[i]);
                    continue block8;
                }
                case 3: {
                    this.max = Float.parseFloat(split[i]);
                    continue block8;
                }
                case 4: {
                    this.scale = Float.parseFloat(split[i]);
                    continue block8;
                }
                case 5: {
                    this.ageLeftToRight = Integer.parseInt(split[i]) == 1;
                }
            }
        }
    }

    boolean setLimits(float min, float max) {
        boolean change = (double)Math.abs(this.min - min) > 0.001 || (double)Math.abs(this.max - max) > 0.001;
        this.min = min;
        this.max = max;
        return change;
    }

    public boolean setScale(float scale) {
        boolean change = (double)Math.abs(this.scale - scale) > 0.001;
        this.scale = scale;
        return change;
    }

    public boolean setUnits(char units) {
        boolean change = this.units != units;
        this.units = units;
        return change;
    }

    public static enum ScaleType {
        MD,
        TVD,
        AGE,
        SUBSIDENCE;

    }
}

