/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import jsbugs.BlockProperties;
import jsbugs.ChartBlock;
import jsbugs.ChartPanel;
import jsbugs.ChartProperties;
import jsbugs.FrameJsbugs;
import jsbugs.LocationBlock;
import jsbugs.PanelAgeCurve;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelIGDScheme;
import jsbugs.ProjectBlock;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.SBPanelHdr;
import jsbugs.SchemeBlock;
import jsbugs.WellBlock;
import model2.AgeCurve;
import model2.CompositeStandard;
import model2.IGDScheme;
import model2.InterpHdr;
import model2.Lastval;
import model2.Project;
import model2.SBdb;
import model2.Well;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class Chart {
    float chartWidth = -1.0f;
    float chartHeight = -1.0f;
    ChartProperties chartProperties = new ChartProperties();
    BlockProperties blockProperties = new BlockProperties();
    final float BLANK_SPACE = 10.0f;
    List<SBPanelHdr> headers = new LinkedList<SBPanelHdr>();
    List<ChartBlock> blocks = new LinkedList<ChartBlock>();
    List<SBPanelHdr> footers = new LinkedList<SBPanelHdr>();

    Chart() {
    }

    String getTooltip(Point2D p, float zoom, Mode mode) {
        ChartBlock block = this.getBlock(p);
        if (block != null) {
            int y = (int)p.getY();
            this.removeHeaderFromPoint(p, mode, block);
            return block.getTooltip((float)p.getX(), (float)p.getY(), this.chartProperties, zoom);
        }
        return null;
    }

    Object getObject(Point2D p, float zoom, Mode mode) {
        ChartBlock block = this.getBlock(p);
        if (block != null) {
            this.removeHeaderFromPoint(p, mode, block);
            return block.getObject((float)p.getX(), (float)p.getY(), this.chartProperties, zoom);
        }
        return null;
    }

    private void removeHeaderFromPoint(Point2D p, Mode mode, ChartBlock block) {
        float y;
        float x = (float)p.getX() - this.getBlockOriginX(block);
        switch (mode) {
            case NO_HEADER: {
                y = (float)p.getY();
                break;
            }
            default: {
                y = (float)p.getY() - (this.chartProperties.margin + this.chartProperties.getPanelHeaderHeight() + block.getHeaderHeight());
            }
        }
        p.setLocation(x, y);
    }

    ChartBlock getBlock(Point2D p) {
        if (p == null) {
            return null;
        }
        double x = p.getX() - (double)this.chartProperties.margin;
        double y = 0.0;
        if (p.getY() < (double)this.chartProperties.margin) {
            return null;
        }
        if (p.getX() < (double)this.chartProperties.margin) {
            return null;
        }
        Iterator<ChartBlock> it = this.blocks.iterator();
        float lastwid = 0.0f;
        while (it.hasNext()) {
            ChartBlock block = it.next();
            if (p.getY() > y + (double)block.getHeight() + (double)this.chartProperties.margin + (double)this.chartProperties.getPanelHeaderHeight() + (double)block.getHeaderHeight()) break;
            float wid = block.getWidth() + lastwid;
            if (x >= (double)lastwid && x < (double)wid) {
                return block;
            }
            lastwid = wid;
            if (block.panels.isEmpty()) continue;
            lastwid += 10.0f;
        }
        return null;
    }

    private float getBlockOriginX(ChartBlock block) {
        float xpos = this.chartProperties.margin;
        if (block != null) {
            for (ChartBlock b : this.blocks) {
                if (b == block) break;
                xpos += b.getWidth();
                if (b.panels.isEmpty()) continue;
                xpos += 10.0f;
            }
        }
        return xpos;
    }

    void draw(SBGraphics g, Mode mode) {
        float y;
        g.setColor(Color.BLACK);
        float x = this.chartProperties.margin;
        switch (mode) {
            default: {
                y = this.chartProperties.margin;
                Iterator<SBPanelHdr> it = this.headers.iterator();
                while (it.hasNext()) {
                    y = it.next().draw(g, x, y, this.chartWidth - this.chartProperties.margin * 2.0f, this.chartProperties, this.blockProperties);
                }
                break;
            }
            case NO_HEADER: {
                y = 0.0f;
            }
        }
        float maxHdrHeight = 0.0f;
        for (ChartBlock block : this.blocks) {
            if (!(block.getHeaderHeight() > maxHdrHeight)) continue;
            maxHdrHeight = block.getHeaderHeight();
        }
        float maxY = 0.0f;
        for (ChartBlock block : this.blocks) {
            float ypos = maxHdrHeight > 0.0f && block.getHeaderHeight() == 0.0f ? y + maxHdrHeight : y;
            x = block.draw(g, x, ypos, this.chartProperties, mode);
            if (!block.panels.isEmpty()) {
                x += 10.0f;
            }
            if (!(block.getHeight() > maxY)) continue;
            maxY = block.getHeight();
        }
        y += maxY + this.chartProperties.getPanelHeaderHeight();
        Iterator<SBPanelHdr> iterator = this.footers.iterator();
        while (iterator.hasNext()) {
            y = iterator.next().draw(g, this.chartProperties.margin, y, this.chartWidth - this.chartProperties.margin * 2.0f, this.chartProperties, this.blockProperties);
        }
    }

    public void drawWatermark(SBGraphics g, boolean useAlpha) {
        this.draw(g, Mode.NORMAL);
        if (useAlpha) {
            g.setColor(new Color(192, 192, 192, 100));
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        g.setFontSize(this.chartWidth / 4.0f);
        for (float ypos = this.chartProperties.margin + g.stringHeightSB() * 2.0f; ypos < this.chartHeight; ypos += g.stringHeightSB() * 2.0f) {
            g.drawString("DEMO", this.chartWidth / 2.0f - SBGraphics.stringWidth("DEMO", this.chartWidth / 4.0f) / 2.0f, ypos);
        }
    }

    ChartPanel getSelectedPanel(Point2D p) {
        if (p.getY() > (double)(this.chartHeight - this.chartProperties.margin)) {
            return null;
        }
        if (p.getX() < (double)this.chartProperties.margin) {
            return null;
        }
        Iterator<ChartBlock> it = this.blocks.iterator();
        float width = 0.0f;
        while (it.hasNext()) {
            ChartBlock block = it.next();
            if (p.getX() < (double)(this.chartProperties.margin + width + block.getWidth())) {
                return block.getPanel((float)p.getX() - width - this.chartProperties.margin, (float)p.getY() - this.chartProperties.margin);
            }
            if (block.panels.isEmpty()) continue;
            width += block.getWidth() + 10.0f;
            if (!(p.getX() < (double)(this.chartProperties.margin + width))) continue;
            return null;
        }
        return null;
    }

    Point2D.Float getPanelOrigin(SBPanel panel, boolean excludeHeader, Mode mode, float x) {
        float ypos;
        Iterator<ChartBlock> it = this.blocks.iterator();
        float xpos = this.chartProperties.margin;
        switch (mode) {
            case NO_HEADER: {
                ypos = 0.0f;
                break;
            }
            default: {
                ypos = this.chartProperties.margin;
                for (SBPanelHdr hdr : this.headers) {
                    ypos += hdr.getHeight();
                }
            }
        }
        while (it.hasNext()) {
            ChartBlock block = it.next();
            Point2D.Float point = block.getPanelOrigin(panel, xpos, ypos, mode, x);
            if (point != null) {
                switch (mode) {
                    case NO_HEADER: {
                        return point;
                    }
                }
                if (excludeHeader) {
                    point.setLocation(point.getX(), point.getY() + (double)this.chartProperties.getPanelHeaderHeight());
                }
                return point;
            }
            xpos += block.getWidth() + (block.panels.isEmpty() ? 0.0f : 10.0f);
        }
        return null;
    }

    ChartBlock getSelectedBlock(Point2D p) {
        if (p.getY() > (double)(this.chartHeight - this.chartProperties.margin)) {
            return null;
        }
        Iterator<ChartBlock> it = this.blocks.iterator();
        float width = 0.0f;
        while (it.hasNext()) {
            ChartBlock block = it.next();
            if (p.getX() < (double)(this.chartProperties.margin + width + block.getWidth())) {
                return block;
            }
            width += block.getWidth() + 10.0f;
        }
        return null;
    }

    float getMMwidth() {
        if (this.chartWidth < 0.0f) {
            this.calcChartSize();
        }
        return this.chartWidth;
    }

    float getMMheight() {
        if (this.chartHeight < 0.0f) {
            this.calcChartSize();
        }
        return this.chartHeight;
    }

    float getMMheight(Mode mode) {
        if (this.chartHeight < 0.0f) {
            this.calcChartSize();
        }
        switch (mode) {
            default: {
                return this.chartHeight;
            }
            case NO_HEADER: {
                return this.chartHeight - this.chartProperties.margin - this.chartProperties.getPanelHeaderHeight();
            }
            case HEADER_ONLY: 
        }
        return this.getHeaderHeight() + 0.2f;
    }

    boolean calcChartSize() {
        float origW = this.chartWidth;
        float origH = this.chartHeight;
        float x = this.chartProperties.margin;
        float y = this.chartProperties.margin;
        Iterator<Observable> it = this.headers.iterator();
        while (it.hasNext()) {
            y += it.next().getHeight();
        }
        it = this.blocks.iterator();
        float maxY = 0.0f;
        while (it.hasNext()) {
            if (x > this.chartProperties.margin) {
                x += 10.0f;
            }
            ChartBlock block = (ChartBlock)it.next();
            x += block.getWidth();
            if (!(block.getTotalHeight() > maxY)) continue;
            maxY = block.getTotalHeight();
        }
        y += (maxY += this.chartProperties.getPanelHeaderHeight());
        it = this.footers.iterator();
        while (it.hasNext()) {
            y += ((SBPanelHdr)it.next()).getHeight();
        }
        this.chartWidth = x + this.chartProperties.margin;
        this.chartHeight = y + this.chartProperties.margin;
        return (double)Math.abs(this.chartWidth - origW) > 0.1 || (double)Math.abs(this.chartHeight - origH) > 0.1;
    }

    public float getHeaderHeight() {
        float total = this.chartProperties.margin + this.chartProperties.getPanelHeaderHeight();
        float maxHeader = 0.0f;
        for (ChartBlock block : this.blocks) {
            for (SBPanelHdr hdr : block.headers) {
                if (!(hdr.getHeight() > maxHeader)) continue;
                maxHeader = hdr.getHeight();
            }
        }
        return total + maxHeader;
    }

    SchemeBlock getSchemeBlock() {
        for (ChartBlock block : this.blocks) {
            if (!block.getClass().equals(SchemeBlock.class)) continue;
            return (SchemeBlock)block;
        }
        return null;
    }

    WellBlock getWellBlock() {
        for (ChartBlock block : this.blocks) {
            if (!block.getClass().equals(WellBlock.class)) continue;
            return (WellBlock)block;
        }
        return null;
    }

    LocationBlock getLocationBlock() {
        for (ChartBlock block : this.blocks) {
            if (!block.getClass().equals(LocationBlock.class)) continue;
            return (LocationBlock)block;
        }
        return null;
    }

    SchemeBlock getAddSchemeBlock() {
        SchemeBlock block = this.getSchemeBlock();
        if (block == null) {
            block = new SchemeBlock();
            this.blocks.add(block);
        }
        return block;
    }

    Point2D getSchemeOrigin(IGDScheme scheme) {
        for (ChartBlock block : this.blocks) {
            if (!(block instanceof SchemeBlock)) continue;
            SchemeBlock schemeBlock = (SchemeBlock)block;
            for (SBPanel panel : schemeBlock.panels) {
                PanelIGDScheme schemePanel;
                if (!(panel instanceof PanelIGDScheme) || (schemePanel = (PanelIGDScheme)panel).getScheme() != scheme) continue;
                return schemeBlock.getPanelOrigin(panel);
            }
        }
        return null;
    }

    Point2D getAgeCurveOrigin(AgeCurve curve) {
        for (ChartBlock block : this.blocks) {
            if (!(block instanceof SchemeBlock)) continue;
            SchemeBlock schemeBlock = (SchemeBlock)block;
            for (SBPanel panel : schemeBlock.panels) {
                PanelAgeCurve ageCurvePanel;
                if (!(panel instanceof PanelAgeCurve) || (ageCurvePanel = (PanelAgeCurve)panel).getAgeCurveID() != curve.getCurveID()) continue;
                return schemeBlock.getPanelOrigin(panel);
            }
        }
        return null;
    }

    Point2D getCmpStdOrigin(CompositeStandard cmpStd) {
        for (ChartBlock block : this.blocks) {
            if (!(block instanceof SchemeBlock)) continue;
            SchemeBlock schemeBlock = (SchemeBlock)block;
            for (SBPanel panel : schemeBlock.panels) {
                PanelCompositeStandard schemePanel;
                if (!(panel instanceof PanelCompositeStandard) || (schemePanel = (PanelCompositeStandard)panel).getStd() != cmpStd) continue;
                return schemeBlock.getPanelOrigin(panel);
            }
        }
        return null;
    }

    void setData(SBPanel panel) throws SBException, SQLException, IOException {
        for (ChartBlock block : this.blocks) {
            if (!block.setData(panel, this.chartProperties)) continue;
            return;
        }
    }

    void setData() throws SBException, SQLException, IOException {
        for (ChartBlock block : this.blocks) {
            if (!(block instanceof WellBlock)) continue;
            ((WellBlock)block).setData(this.chartProperties);
        }
    }

    void writeHTML(FileWriter out) throws IOException, SBException {
        for (ChartBlock block : this.blocks) {
            if (!(block instanceof WellBlock)) continue;
            ((WellBlock)block).writeHTML(out, this.chartProperties);
            return;
        }
        throw new SBException("No well block to export");
    }

    void savePreference(SBdb sbdb, String key) throws SQLException {
        assert (key.length() == 6);
        if (key.startsWith("C5")) {
            Lastval.deleteLike((SBdb)sbdb, (String)key.substring(0, 2));
        } else {
            Lastval.deleteLike((SBdb)sbdb, (String)key);
        }
        Lastval.putString((SBdb)sbdb, (String)(key + "CP"), (String)this.chartProperties.getProperties());
        Lastval.putString((SBdb)sbdb, (String)(key + "BP"), (String)this.blocks.get((int)0).prop.getProperties());
        int blockNo = 0;
        for (ChartBlock block : this.blocks) {
            block.savePreference(sbdb, key + blockNo);
            ++blockNo;
        }
    }

    void savePreference(SBdb sbdb, String key, ChartPanel savePanel) throws SQLException {
        block11: {
            int panelNo;
            ChartBlock block;
            block10: {
                block = null;
                int blockNo = 0;
                for (ChartBlock b : this.blocks) {
                    if (b.contains(savePanel)) {
                        block = b;
                        break;
                    }
                    ++blockNo;
                }
                if (block == null) {
                    throw new IllegalStateException("Chart attempting to save preference for not included panel");
                }
                key = key + blockNo;
                assert (key.length() == 7);
                panelNo = 0;
                if (!(savePanel instanceof SBPanel)) break block10;
                for (SBPanel panel : block.panels) {
                    if (panel == savePanel) {
                        String panelKey;
                        String panelNoString = "" + panelNo;
                        if (panelNoString.length() == 1) {
                            panelNoString = "0" + panelNo;
                        }
                        if (Lastval.getString((SBdb)sbdb, (String)(panelKey = key + panelNoString)) == null) {
                            return;
                        }
                        SBPanel.savePreference(sbdb, key, panel, panelNo);
                        sbdb.commit();
                        return;
                    }
                    ++panelNo;
                }
                break block11;
            }
            if (!(savePanel instanceof SBPanelHdr)) break block11;
            for (SBPanelHdr panel : block.headers) {
                if (panel != savePanel) continue;
                String panelNoString = "H" + panelNo;
                String panelKey = key + panelNoString;
                if (Lastval.getString((SBdb)sbdb, (String)panelKey) == null) {
                    return;
                }
                SBPanelHdr.savePreference(sbdb, key, panel, panelNo);
                sbdb.commit();
                return;
            }
        }
    }

    Chart(List<ChartPref> keys, SBdb sbdb, int ID, InterpHdr interp) {
        boolean isProjectBlock = Integer.parseInt("" + keys.get((int)0).key.charAt(1)) == 5;
        Iterator<ChartPref> it = keys.iterator();
        BlockProperties bp = null;
        while (it.hasNext()) {
            ChartPref p = it.next();
            if (p.key.endsWith("BP")) {
                bp = new BlockProperties(p.value);
                it.remove();
                continue;
            }
            if (!p.key.endsWith("CP")) continue;
            this.chartProperties = new ChartProperties(p.value);
            it.remove();
        }
        assert (bp != null && this.chartProperties != null);
        if (this.chartProperties == null) {
            this.chartProperties = new ChartProperties();
        }
        if (bp == null) {
            bp = new BlockProperties();
        }
        for (int i = 0; i < keys.size(); ++i) {
            ChartPref key = keys.get(i);
            String panelKey = key.key.substring(7);
            if (panelKey.length() == 2) {
                String[] s = key.value.split("\\^");
                assert (s.length == 2);
                key.panelType = Integer.parseInt(s[0]);
                key.value = s[1];
                if (key.value.contains("#")) {
                    key.value = key.value.substring(1);
                    String[] t = key.value.split("#");
                    block16: for (int j = 0; j < t.length - 1; ++j) {
                        switch (j) {
                            case 0: {
                                key.identifier = Integer.parseInt(t[j]);
                                continue block16;
                            }
                            case 1: {
                                key.identifier2 = Integer.parseInt(t[j]);
                            }
                        }
                    }
                    key.value = t[t.length - 1];
                }
            }
            key.key = key.key.substring(6);
        }
        LinkedList cBlocks = new LinkedList();
        LinkedList<ChartPref> blockPrefs = new LinkedList<ChartPref>();
        Integer blockNo = null;
        for (ChartPref k : keys) {
            int bNo = Integer.parseInt("" + k.key.charAt(0));
            if (blockNo == null) {
                blockNo = bNo;
            } else if (blockNo != bNo) {
                cBlocks.add(blockPrefs);
                blockPrefs = new LinkedList();
                blockNo = bNo;
            }
            blockPrefs.add(k);
        }
        if (!blockPrefs.isEmpty()) {
            cBlocks.add(blockPrefs);
        }
        Well well = null;
        Project project = null;
        WellInterp wellInterp = null;
        if (ID > -1) {
            try {
                if (isProjectBlock) {
                    project = sbdb.getProject(ID);
                } else {
                    well = sbdb.getAddWell(ID);
                }
                if (well != null) {
                    well.loadInterps();
                    wellInterp = well.getInterp(interp.getInterpID());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        for (LinkedList linkedList : cBlocks) {
            try {
                switch (((ChartPref)linkedList.get((int)0)).panelType) {
                    case 1: 
                    case 3: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 22: 
                    case 23: 
                    case 29: 
                    case 46: 
                    case 47: {
                        WellBlock wellBlock;
                        if (isProjectBlock) {
                            wellBlock = new ProjectBlock(project, sbdb, bp);
                        } else {
                            wellBlock = new WellBlock(well, sbdb, bp);
                            wellBlock.setInterp(wellInterp);
                        }
                        wellBlock.addPanels(linkedList, interp);
                        this.blocks.add(wellBlock);
                        break;
                    }
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 45: 
                    case 48: {
                        SchemeBlock schemeBlock = new SchemeBlock(bp);
                        schemeBlock.setInterp(wellInterp);
                        schemeBlock.addPanels(sbdb, linkedList);
                        this.blocks.add(schemeBlock);
                    }
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, sbdb);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
        }
        if (this.blocks.isEmpty()) {
            if (bp.scaleType == BlockProperties.ScaleType.AGE) {
                this.blocks.add(new SchemeBlock(bp));
            } else {
                this.blocks.add(new WellBlock(well, sbdb, bp));
            }
        }
    }

    public static enum Mode {
        NORMAL,
        HEADER_ONLY,
        NO_HEADER;

    }

    static class ChartPref
    implements Comparable<ChartPref> {
        String key;
        String value;
        int panelType = -1;
        int identifier = -1;
        int identifier2 = -1;

        ChartPref(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(ChartPref o) {
            return this.key.compareTo(o.key);
        }

        public String toString() {
            return this.key + " " + this.value;
        }
    }
}

