/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartPanel;
import jsbugs.ChartProperties;
import jsbugs.PanelTaxon;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.SBPanelHdr;
import model2.SBdb;
import model2.WellInterp;
import util.SBException;

public abstract class ChartBlock
extends Observable
implements Observer {
    float maxHeight = 0.0f;
    protected LinkedList<SBPanel> panels = new LinkedList();
    BlockProperties prop;
    final List<SBPanelHdr> headers = new LinkedList<SBPanelHdr>();
    WellInterp interp = null;

    abstract float draw(SBGraphics var1, float var2, float var3, ChartProperties var4, Chart.Mode var5);

    abstract float getHeight();

    float drawPanels(SBGraphics g, float xpos, float y, ChartProperties p, Chart.Mode mode) {
        for (SBPanel panel : this.panels) {
            float newxpos = panel.draw(g, xpos, y, p, this.prop, mode);
            switch (mode) {
                case NORMAL: 
                case HEADER_ONLY: {
                    panel.drawFrame(g, xpos, y, p, this.prop, panel.getCaption(), panel.getSubCaption());
                    panel.drawSubHeader(g, xpos, y, p, this.prop, panel.getSubHeader());
                    break;
                }
                case NO_HEADER: {
                    panel.drawOutline(g, xpos, y, p, this.prop, mode);
                }
            }
            xpos = newxpos;
        }
        return xpos;
    }

    float getTotalHeight() {
        float hdrHeight = 0.0f;
        for (SBPanelHdr hdr : this.headers) {
            hdrHeight += hdr.getHeight();
        }
        float height = this.getHeight();
        return hdrHeight + height;
    }

    SBPanelHdr getHeaderPanel(float y) {
        float height = 0.0f;
        for (SBPanelHdr panel : this.headers) {
            if (!(y < (height += panel.getHeight()))) continue;
            return panel;
        }
        return null;
    }

    ChartPanel getPanel(float x, float y) {
        float width = 0.0f;
        for (SBPanel panel : this.panels) {
            if (!(x < (width += panel.getWidth(this.prop)))) continue;
            return panel;
        }
        return null;
    }

    void addPanel(SBPanel panel) {
        this.panels.add(panel);
        panel.addObserver(this);
    }

    void removePanel(ChartPanel p) {
        if (p instanceof SBPanel) {
            SBPanel panel = (SBPanel)p;
            this.panels.remove(panel);
            panel.deleteObserver(this);
        } else if (p instanceof SBPanelHdr) {
            this.headers.remove((SBPanelHdr)p);
        }
    }

    void setInterp(WellInterp interp) {
        this.interp = interp;
    }

    float getWidth() {
        this.maxHeight = 0.0f;
        float width = 0.0f;
        for (SBPanel panel : this.panels) {
            width += panel.getWidth(this.prop);
        }
        return width;
    }

    abstract Object getObject(float var1, float var2, ChartProperties var3, float var4);

    abstract String getTooltip(float var1, float var2, ChartProperties var3, float var4);

    abstract Point2D.Float getPanelOrigin(SBPanel var1, float var2, float var3, Chart.Mode var4, float var5);

    @Override
    public void update(Observable o, Object arg) {
        this.setChanged();
        if (arg != null && arg instanceof PanelTaxon) {
            this.notifyObservers(arg);
        } else {
            this.notifyObservers(o);
        }
    }

    float getHeaderHeight() {
        float height = 0.0f;
        for (SBPanelHdr hdr : this.headers) {
            height += hdr.getHeight();
        }
        return height;
    }

    boolean setData(SBPanel panel, ChartProperties cp) throws SBException, SQLException, IOException {
        for (SBPanel p : this.panels) {
            if (p != panel) continue;
            p.setData(cp, null);
            return true;
        }
        return false;
    }

    static float getHeight(BlockProperties bp) {
        bp.height = bp.scaleType == BlockProperties.ScaleType.AGE ? (bp.max - bp.min) * bp.scale : Math.abs(bp.max - bp.min) * 1000.0f / bp.scale;
        return bp.height;
    }

    private float scaleAge(float age) {
        return (age - this.prop.min) * this.prop.scale;
    }

    private float scaleDepth(float depth) {
        return (depth - this.prop.min) * 1000.0f / this.prop.scale;
    }

    float scaleValue(float value, BlockProperties.ScaleType type) throws SBException {
        if (!(type == this.prop.scaleType || type == BlockProperties.ScaleType.MD ^ this.prop.scaleType == BlockProperties.ScaleType.MD && type == BlockProperties.ScaleType.TVD ^ this.prop.scaleType == BlockProperties.ScaleType.TVD)) {
            if (this.interp == null) {
                throw new SBException("Error scaling: no version set");
            }
            if (this.interp.getLOC() == null) {
                throw new SBException("Error scaling: no LOC set");
            }
            switch (type) {
                case AGE: {
                    value = (float)this.interp.getLOC().getDepth((double)value, null, null, true);
                    break;
                }
                case MD: 
                case TVD: {
                    value = (float)this.interp.getLOC().getAge(value, true);
                }
            }
        }
        switch (this.prop.scaleType) {
            case AGE: {
                return this.scaleAge(value);
            }
        }
        return this.scaleDepth(value);
    }

    boolean contains(ChartPanel panel) {
        if (panel instanceof SBPanel) {
            return this.panels.contains((SBPanel)panel);
        }
        if (panel instanceof SBPanelHdr) {
            return this.headers.contains((SBPanelHdr)panel);
        }
        return false;
    }

    void savePreference(SBdb sbdb, String key) throws SQLException {
        assert (key.length() == 7);
        int panelNo = 0;
        for (SBPanel sBPanel : this.panels) {
            SBPanel.savePreference(sbdb, key, sBPanel, panelNo);
            sbdb.commit();
            panelNo += sBPanel.size();
        }
        panelNo = 0;
        for (SBPanelHdr sBPanelHdr : this.headers) {
            SBPanelHdr.savePreference(sbdb, key, sBPanelHdr, panelNo);
            sbdb.commit();
            ++panelNo;
        }
    }
}

