/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartJPanel;
import jsbugs.ChartProperties;
import jsbugs.PanelBiocoms;
import jsbugs.PanelDepth;
import jsbugs.PanelEvents;
import jsbugs.PanelSamples;
import jsbugs.PanelWellHeader;
import jsbugs.PanelWirelineLog;
import jsbugs.PanelZones;
import jsbugs.WellBlock;
import jsbugs.WellInfo;
import model2.EnvScheme;
import model2.Project;
import model2.SBdb;
import model2.Well;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class ChartGen {
    static LinkedList<Integer> dataTypes = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            System.out.println("Running ChartGen on: " + new Date());
            String driverName = null;
            String hostName = null;
            String instanceName = null;
            String instanceLogin = null;
            String password = null;
            String sbugslogin = null;
            String sbugspwd = null;
            String filePath = null;
            String projString = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-showSql")) {
                    SB.showSql = true;
                    continue;
                }
                if (args[i].toLowerCase().startsWith("driver=")) {
                    driverName = args[i].substring("driver=".length());
                    continue;
                }
                if (args[i].toLowerCase().startsWith("host=")) {
                    hostName = args[i].substring("host=".length());
                    continue;
                }
                if (args[i].toLowerCase().startsWith("instance=")) {
                    instanceName = args[i].substring("instance=".length());
                    continue;
                }
                if (args[i].toLowerCase().startsWith("password=")) {
                    password = args[i].substring("password=".length());
                    continue;
                }
                if (args[i].toLowerCase().startsWith("path=")) {
                    filePath = args[i].substring("path=".length());
                    continue;
                }
                if (args[i].toLowerCase().startsWith("instancelogin=")) {
                    instanceLogin = args[i].substring("instancelogin=".length());
                    continue;
                }
                if (args[i].toLowerCase().startsWith("project=")) {
                    projString = args[i].substring("project=".length());
                    continue;
                }
                if (args[i].toLowerCase().startsWith("sbugslogin=")) {
                    sbugslogin = args[i].substring("sbugslogin=".length());
                    continue;
                }
                if (!args[i].toLowerCase().startsWith("sbugspassword=")) continue;
                sbugspwd = args[i].substring("sbugspassword=".length());
            }
            if (driverName == null || hostName == null || instanceName == null || instanceLogin == null || password == null || sbugslogin == null) {
                System.out.println("One or more connection parameters are missing.");
                if (driverName == null) {
                    System.out.println("Check driver name.");
                }
                if (hostName == null) {
                    System.out.println("Check host name.");
                }
                if (instanceName == null) {
                    System.out.println("Check instance name.");
                }
                if (instanceLogin == null) {
                    System.out.println("Check instance login.");
                }
                if (password == null) {
                    System.out.println("Check password.");
                }
                if (sbugslogin == null) {
                    System.out.println("Check StrataBugs login name.");
                }
                System.exit(0);
            }
            if (filePath == null || !new File(filePath).isDirectory()) {
                System.out.println("You must specify an existing directory for generated files using the 'path' parameter.");
                System.exit(0);
            }
            SB.hasGUI = false;
            SBdb db = new SBdb();
            try {
                db.connect(driverName, hostName, instanceName, instanceLogin, password);
                db.getDefaultUser(instanceLogin);
                db.login(sbugslogin, sbugspwd != null ? sbugspwd : password);
            }
            catch (Exception e) {
                System.out.println("Error connecting to database.");
                e.printStackTrace();
                System.exit(-1);
            }
            System.out.println("Connected to database");
            Iterator it = null;
            if (projString != null) {
                System.out.println("Looking for project: " + projString);
                Project project = db.getProjects().getProject(projString);
                if (project != null) {
                    System.out.println("Project is: " + project);
                    project.loadWells(db, null);
                    it = project.getWellIterator();
                } else {
                    System.out.println("Project '" + projString + "' not found.");
                }
            }
            if (it == null) {
                LinkedList<Well> allWells = new LinkedList<Well>();
                String sql = "SELECT well_id from " + db.DBTableName("WELL_IDENT") + " order by well_id";
                Statement stmt = db.getDatabase().createStatement();
                try {
                    ResultSet rs = stmt.executeQuery(db.modQuery(sql));
                    while (rs.next()) {
                        int wellID = rs.getInt("well_id");
                        try {
                            allWells.add(new Well(db, wellID));
                        }
                        catch (SBException sbe) {
                            System.out.println("Exception from loading well with wellID: " + wellID + ", exception is: " + sbe.toString());
                            sbe.printStackTrace();
                        }
                    }
                }
                finally {
                    stmt.close();
                }
                it = allWells.iterator();
            }
            boolean generateAll = false;
            db.commit();
            LinkedList<WellInfo> wells = new LinkedList<WellInfo>();
            while (it.hasNext()) {
                Well well = (Well)it.next();
                String filename = Well.makeCode((String)well.getWellCode());
                File file = new File(filePath + "\\" + filename + ".pdf");
                if (!file.exists()) {
                    // empty if block
                }
                WellInfo info = new WellInfo(well, file, db);
                wells.add(info);
                if (!generateAll) continue;
                info.draw = true;
            }
            dataTypes.add(1);
            dataTypes.add(23);
            dataTypes.add(10);
            dataTypes.add(15);
            dataTypes.add(16);
            dataTypes.add(3);
            if (!generateAll) {
                ChartGen.updateWellInfo(wells, db, 0);
            }
            ChartProperties cp = new ChartProperties();
            cp.setPanelHeaderHeight(80.0f);
            cp.setPanelCaptionHeight(9.0f);
            cp.margin = 3.0f;
            cp.chartGenDate = new Date();
            BlockProperties bp = new BlockProperties();
            Iterator infoIt = wells.iterator();
            int nCreated = 0;
            int nUpdated = 0;
            while (infoIt.hasNext()) {
                WellInfo info = (WellInfo)infoIt.next();
                if (info.draw) {
                    System.out.println("Processing well: " + info.well);
                    try {
                        boolean newchart = info.saveChart(ChartGen.createChart(info.well, db, cp, bp));
                        if (newchart) {
                            ++nCreated;
                        } else {
                            ++nUpdated;
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error saving chart - skipping this chart");
                        e.printStackTrace();
                        continue;
                    }
                }
                info.well = null;
            }
            db.commit();
            db.close();
            System.out.println("Charts created: " + nCreated + " Charts updated: " + nUpdated);
            System.out.println("Chart generation completed successfully.");
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static Chart createChart(Well well, SBdb db, ChartProperties cp, BlockProperties bp) throws SBException, SQLException, IOException {
        Chart chart = new Chart();
        chart.chartProperties = cp;
        WellBlock block = new WellBlock(well, db, bp);
        block.setTopDepth((float)ChartJPanel.getDefaultDepthBound(true, well.getTopSampleDepth(), well.getBaseSampleDepth(), well.getWellUnits()));
        block.setBaseDepth((float)ChartJPanel.getDefaultDepthBound(false, well.getTopSampleDepth(), well.getBaseSampleDepth(), well.getWellUnits()));
        if (Math.abs(well.getBaseSampleDepth() - well.getTopSampleDepth()) < (double)0.0029f) {
            block.setTopDepth(block.getTopDepth() - 5.0f);
            block.setBaseDepth(block.getBaseDepth() + 5.0f);
        }
        block.setScale((float)ChartJPanel.getDefaultScale(well.getTopSampleDepth(), well.getBaseSampleDepth(), well.getWellUnits()));
        well.loadInterps();
        WellInterp interp = well.getAddInterp(db.getInterp(0));
        well.loadInterp(interp);
        block.addPanel(new PanelDepth(db, block));
        for (Integer i : dataTypes) {
            switch (i) {
                case 1: {
                    block.addPanel(new PanelSamples(db, block));
                    break;
                }
                case 23: {
                    block.addPanel(new PanelWirelineLog(block, db, new String[]{"GR"}));
                    break;
                }
                case 3: {
                    block.addPanel(new PanelBiocoms(block, 0, db));
                    break;
                }
                case 15: {
                    Iterator itEnvS = interp.getEnvSchemes().iterator();
                    if (!itEnvS.hasNext()) break;
                    EnvScheme es = (EnvScheme)itEnvS.next();
                    block.addIGDPanel(5, es.getID(), interp, true);
                    break;
                }
                case 10: {
                    block.addPanel(new PanelZones(db, block, 3, interp.getHeader().getInterpID()));
                    break;
                }
                case 16: {
                    block.addPanel(new PanelEvents(block, interp.getHeader().getInterpID(), db));
                }
            }
        }
        chart.blocks.add(block);
        chart.headers.add(new PanelWellHeader(block));
        chart.setData();
        chart.calcChartSize();
        return chart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateWellInfo(LinkedList<WellInfo> wells, SBdb db, int interpID) throws SQLException {
        Statement stmt = db.getDatabase().createStatement();
        String sql = "";
        Iterator it = wells.iterator();
        try {
            while (it.hasNext()) {
                WellInfo well = (WellInfo)it.next();
                if (!well.file.exists()) {
                    well.draw = true;
                    continue;
                }
                String fileUpdate = db.getDBDateSQLString(well.file.lastModified());
                for (int i = 0; i < dataTypes.size(); ++i) {
                    switch (dataTypes.get(i)) {
                        case 1: {
                            sql = "SELECT count(*) as count from " + db.DBTableName("SAMPLES") + " WHERE well_id=" + well.well.getWellID() + " AND updated > " + fileUpdate;
                            break;
                        }
                        case 3: {
                            sql = "SELECT count(*) as count from " + db.DBTableName("BCMMNTS") + " WHERE well_id=" + well.well.getWellID() + " AND interp_id=" + interpID + " AND updated > " + fileUpdate;
                            break;
                        }
                        case 15: {
                            sql = "SELECT count(*) as count from " + db.DBTableName("IGD_ENV") + " WHERE well_id=" + well.well.getWellID() + " AND interp_id=" + interpID + " AND updated > " + fileUpdate;
                            break;
                        }
                        case 23: {
                            sql = "SELECT count(*) as count from " + db.DBTableName("LOG_CURVE") + " WHERE well_id=" + well.well.getWellID() + " AND updated > " + fileUpdate;
                            break;
                        }
                        case 10: {
                            sql = "SELECT count(*) as count from " + db.DBTableName("IGD") + " WHERE well_id=" + well.well.getWellID() + " AND interp_id=" + interpID + " AND igd_type=" + 3 + " AND updated > " + fileUpdate;
                            break;
                        }
                        case 16: {
                            sql = "SELECT count(*) as count from " + db.DBTableName("EVENTS") + " WHERE well_id=" + well.well.getWellID() + " AND interp_id=" + interpID + " AND updated > " + fileUpdate;
                        }
                    }
                    ResultSet rs = stmt.executeQuery(sql);
                    int nUpdated = 0;
                    while (rs.next()) {
                        nUpdated = rs.getInt("count");
                    }
                    if (nUpdated <= 0) continue;
                    well.draw = true;
                    break;
                }
                sql = "SELECT count(*) as count from " + db.DBTableName("WELLS") + " WHERE well_code='" + well.well.getWellCode() + "' AND updated > " + fileUpdate;
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    int n = rs.getInt("count");
                    if (n <= 0) continue;
                    well.draw = true;
                }
            }
        }
        finally {
            stmt.close();
        }
    }
}

