/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.Chart;
import jsbugs.GUI;
import jsbugs.PanelBiocoms;
import jsbugs.PanelEvents;
import jsbugs.PanelSQPicks;
import jsbugs.PanelSamples;
import jsbugs.PanelWirelineLog;
import jsbugs.PanelZones;
import jsbugs.SBGraphics;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.IGDInterval;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.Lastval;
import model2.SBdb;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class ChartJPanel
extends JPanel
implements Printable,
Observer {
    public Chart chart = null;
    public float zoom = 1.0f;
    public static final float pixPerMM = 2.8346457f;
    private boolean rubberBand = false;
    UndoManager undoManager = null;
    UndoableEditSupport undoSupport = null;
    boolean watermark = false;
    private Chart.Mode chartMode = Chart.Mode.NORMAL;
    private static final Color TEXT_COLOUR = new Color(51, 102, 204);
    private PageFormat pf = null;
    private boolean fitToPage = false;

    void setChartMode(Chart.Mode mode) {
        this.chartMode = mode;
    }

    Chart.Mode getMode() {
        return this.chartMode;
    }

    public ChartJPanel(Chart chart) {
        this.setBackground(Color.WHITE);
        this.chart = chart;
    }

    public ChartJPanel(Chart chart, PageFormat pf, boolean shrink) {
        this.setBackground(Color.WHITE);
        this.chart = chart;
        this.pf = pf;
        this.fitToPage = shrink;
        this.zoom = 0.3f;
        this.setSize();
    }

    public void chartProperties() {
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (this.chart != null && obj instanceof SBPanel) {
            SBPanel panel = (SBPanel)obj;
            try {
                this.chart.setData(panel);
            }
            catch (Exception e) {
                SB.showStackError((String)"Error setting panel data", (Exception)e);
            }
        }
        this.repaint();
    }

    public final void setSize() {
        this.setSize(this.zoom);
    }

    public void setSize(float zoom) {
        this.zoom = zoom;
        if (this.chart != null) {
            this.setPreferredSize(new Dimension((int)(this.chart.getMMwidth() * 2.8346457f * zoom), (int)(this.chart.getMMheight(this.chartMode) * 2.8346457f * zoom)));
        }
    }

    Point getPosition(Point2D p) {
        Point p2 = new Point((int)(p.getX() * 2.8346457481384277 * (double)this.zoom), (int)(p.getY() * 2.8346457481384277 * (double)this.zoom));
        return p2;
    }

    Point2D getPoint(Point p) {
        Point2D p2;
        AffineTransform tnf = new AffineTransform();
        tnf.scale(this.zoom * 2.8346457f / 100.0f, this.zoom * 2.8346457f / 100.0f);
        try {
            p2 = tnf.inverseTransform(p, null);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return null;
        }
        Point2D.Float pMM = new Point2D.Float((float)p2.getX() / 100.0f, (float)p2.getY() / 100.0f);
        return pMM;
    }

    public AffineTransform setRubberBandMode(Graphics g) {
        AffineTransform saveTransform = ((Graphics2D)g).getTransform();
        AffineTransform tnf = new AffineTransform();
        tnf.scale(this.zoom * 2.8346457f / 100.0f, this.zoom * 2.8346457f / 100.0f);
        Color bg = this.getBackground();
        ((Graphics2D)g).transform(tnf);
        int origin = 0;
        g.translate(origin, origin);
        Point visibleRectTopLeft = new Point();
        Point visibleRectBottomRight = new Point();
        try {
            Rectangle thisVisibleRect = this.getVisibleRect();
            tnf.inverseTransform(thisVisibleRect.getLocation(), visibleRectTopLeft);
            tnf.inverseTransform(new Point(thisVisibleRect.x + this.getVisibleRect().width, thisVisibleRect.y + thisVisibleRect.height), visibleRectBottomRight);
            Rectangle transformedVisibleRect = new Rectangle(visibleRectTopLeft, new Dimension(visibleRectBottomRight.x - visibleRectTopLeft.x, visibleRectBottomRight.y - visibleRectTopLeft.y));
            transformedVisibleRect.width += origin;
            transformedVisibleRect.height += origin;
            transformedVisibleRect.x -= origin;
            transformedVisibleRect.y -= origin;
            g.setXORMode(bg);
        }
        catch (NoninvertibleTransformException ex) {
            System.out.println("Failed inverse transform");
        }
        this.rubberBand = true;
        return saveTransform;
    }

    public void clearRubberBandMode(Graphics g, AffineTransform saveTransform) {
        ((Graphics2D)g).setTransform(saveTransform);
        g.setPaintMode();
        g.dispose();
        this.rubberBand = false;
    }

    public boolean getRubberBand() {
        return this.rubberBand;
    }

    public String getTooltip(MouseEvent evt) {
        if (this.chart != null) {
            return this.chart.getTooltip(this.getPoint(evt.getPoint()), this.zoom, this.chartMode);
        }
        return null;
    }

    public Object getObject(MouseEvent evt) {
        if (this.chart != null && this.getVisibleRect().contains(evt.getPoint())) {
            return this.chart.getObject(this.getPoint(evt.getPoint()), this.zoom, this.chartMode);
        }
        return null;
    }

    public Object getObject(Point point) {
        if (this.chart != null && this.getVisibleRect().contains(point)) {
            return this.chart.getObject(this.getPoint(point), this.zoom, this.chartMode);
        }
        return null;
    }

    public void drawLine(Graphics g, Point2D from, Point2D to) {
        g.drawLine((int)(from.getX() * 100.0), (int)(from.getY() * 100.0), (int)(to.getX() * 100.0), (int)(to.getY() * 100.0));
    }

    public void drawString(Graphics g, Point2D location, String string) {
        Color color = g.getColor();
        g.setColor(TEXT_COLOUR);
        g.setFont(new Font(this.chart.chartProperties.font, 1, (int)(this.chart.chartProperties.fontSmall * 100.0f / this.zoom * 2.8346457f)));
        g.drawString(string, (int)(location.getX() * 100.0), (int)((location.getY() - 0.75) * 100.0));
        g.setColor(color);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.chart != null) {
            AffineTransform saveTransform = ((Graphics2D)g).getTransform();
            AffineTransform tnf = new AffineTransform();
            tnf.scale(this.zoom * 2.8346457f / 100.0f, this.zoom * 2.8346457f / 100.0f);
            ((Graphics2D)g).transform(tnf);
            int origin = 0;
            g.translate(origin, origin);
            Point visibleRectTopLeft = new Point();
            Point visibleRectBottomRight = new Point();
            try {
                Rectangle thisVisibleRect = this.getVisibleRect();
                tnf.inverseTransform(thisVisibleRect.getLocation(), visibleRectTopLeft);
                tnf.inverseTransform(new Point(thisVisibleRect.x + this.getVisibleRect().width, thisVisibleRect.y + thisVisibleRect.height), visibleRectBottomRight);
                Rectangle transformedVisibleRect = new Rectangle(visibleRectTopLeft, new Dimension(visibleRectBottomRight.x - visibleRectTopLeft.x, visibleRectBottomRight.y - visibleRectTopLeft.y));
                transformedVisibleRect.width += origin;
                transformedVisibleRect.height += origin;
                transformedVisibleRect.x -= origin;
                transformedVisibleRect.y -= origin;
                SBGraphics sbGraphics = new SBGraphics((Graphics2D)g, transformedVisibleRect, true, true);
                if (this.watermark) {
                    this.chart.drawWatermark(sbGraphics, true);
                } else {
                    this.chart.draw(sbGraphics, this.chartMode);
                }
            }
            catch (NoninvertibleTransformException ex) {
                System.out.println("Failed inverse transform");
            }
            ((Graphics2D)g).setTransform(saveTransform);
            if (this.getPf() != null) {
                g.setColor(Color.CYAN);
                float[] dash = new float[]{10.0f};
                ((Graphics2D)g).setStroke(new BasicStroke(2.0f, 0, 0, 1.0f, dash, 10.0f));
                float imageWidth = (float)this.getPf().getImageableWidth() * this.zoom;
                float imageHeight = (float)this.getPf().getImageableHeight() * this.zoom;
                float mmWidth = this.chart.getMMwidth() * 2.8346457f * this.zoom;
                float mmHeight = this.chart.getMMheight() * 2.8346457f * this.zoom;
                if (this.isFitToPage() && (mmWidth > imageWidth || mmHeight > imageHeight)) {
                    g.drawRect((int)this.chart.chartProperties.margin, (int)this.chart.chartProperties.margin, (int)mmWidth, (int)mmHeight);
                } else {
                    float xtrans = this.chart.chartProperties.margin;
                    for (float ytrans = this.chart.chartProperties.margin; ytrans < mmHeight; ytrans += imageHeight) {
                        while (xtrans < mmWidth) {
                            g.drawRect((int)xtrans, (int)ytrans, (int)imageWidth, (int)imageHeight);
                            xtrans += imageWidth;
                        }
                        xtrans = this.chart.chartProperties.margin;
                    }
                }
            }
        }
    }

    public PageFormat getPf() {
        return this.pf;
    }

    public void setPf(PageFormat pf) {
        this.pf = pf;
    }

    public void setFitToPage(boolean fit) {
        this.fitToPage = fit;
    }

    public boolean isFitToPage() {
        return this.fitToPage;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        System.out.println("Printing page number: " + pageIndex);
        float imageWidth = (float)pf.getImageableWidth() / 2.8346457f;
        float imageHeight = (float)pf.getImageableHeight() / 2.8346457f;
        System.out.println(" Imageable Width (mm): " + imageWidth + " Imageable Height (mm): " + imageHeight);
        g.setFont(new Font("Arial", 1, 5));
        g.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        if (this.chart != null) {
            AffineTransform saveTransform = ((Graphics2D)g).getTransform();
            AffineTransform tnf = new AffineTransform();
            System.out.println("Chart width: " + this.chart.getMMwidth() + " Chart height: " + this.chart.getMMheight());
            boolean multiple = false;
            if (this.isFitToPage() && (this.chart.getMMwidth() > imageWidth || this.chart.getMMheight() > imageHeight)) {
                float hFactor;
                float wFactor = this.chart.getMMwidth() / imageWidth;
                float factor = wFactor > (hFactor = this.chart.getMMheight() / imageHeight) ? wFactor : hFactor;
                factor = (float)((double)factor * 1.01);
                System.out.println("Plotting at scale factor " + factor);
                tnf.scale(0.028346457f / factor, 0.028346457f / factor);
            } else {
                multiple = true;
                System.out.println("Plotting at natural scale...");
                tnf.scale(0.028346456587314606, 0.028346456587314606);
            }
            float xtrans = 0.0f;
            float ytrans = 0.0f;
            if (multiple) {
                int pageNo = 0;
                while (pageNo < pageIndex) {
                    if (xtrans + imageWidth < this.chart.getMMwidth()) {
                        xtrans += imageWidth;
                        ++pageNo;
                        continue;
                    }
                    if (ytrans + imageHeight < this.chart.getMMheight()) {
                        ytrans += imageHeight;
                        xtrans = 0.0f;
                        ++pageNo;
                        continue;
                    }
                    return 1;
                }
            } else if (pageIndex >= 1) {
                return 1;
            }
            if (multiple && pageIndex > 0) {
                g.translate((int)(xtrans * -1.0f * 2.8346457f), (int)(ytrans * -1.0f * 2.8346457f));
            }
            ((Graphics2D)g).transform(tnf);
            SBGraphics sbGraphics = new SBGraphics((Graphics2D)g, null, true, true);
            if (this.watermark) {
                this.chart.drawWatermark(sbGraphics, false);
            } else {
                this.chart.draw(sbGraphics, Chart.Mode.NORMAL);
            }
            ((Graphics2D)g).setTransform(saveTransform);
        }
        return 0;
    }

    public void zoom(float zoom, float increment, boolean in) {
        if (in) {
            zoom *= increment;
        } else {
            zoom /= increment;
            increment = 1.0f / increment;
        }
        this.chart.calcChartSize();
        GUI.setScrollPaneSize(this, zoom, increment);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    static void encodePanelTypes(WellBlock block, SBdb sbdb, String key) {
        LinkedList<Integer> dTypes = new LinkedList<Integer>();
        for (SBPanel panel : block.panels) {
            Integer type = null;
            if (panel instanceof PanelEvents) {
                type = 16;
            } else if (panel instanceof PanelSQPicks) {
                type = 14;
            } else if (panel instanceof PanelZones) {
                try {
                    type = IGDIntervalZone.igdType2dType((int)((PanelZones)panel).igdType);
                }
                catch (SBException sbe) {}
            } else if (panel instanceof PanelWirelineLog) {
                type = 23;
            } else if (panel instanceof PanelSamples) {
                type = 1;
            } else if (panel instanceof PanelBiocoms) {
                type = 3;
            }
            if (type == null || dTypes.contains(type)) continue;
            dTypes.add(type);
        }
        String string = new String();
        for (Integer type : dTypes) {
            string = string + type + "|";
        }
        try {
            if (key != null && key.length() > 0 && string != null && string.length() > 0) {
                Lastval.putString((SBdb)sbdb, (String)key, (String)string);
                sbdb.commit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void decodePanelTypes(WellInterp wellInterp, WellBlock block, SBdb sbdb, String key) {
        try {
            String params = Lastval.getString((SBdb)sbdb, (String)key);
            if (params.isEmpty()) {
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            block12: while (tok.hasMoreTokens()) {
                Integer dType = Integer.parseInt(tok.nextToken());
                if (SBdb.isInterpDataType((int)dType) && (wellInterp == null || !wellInterp.hasData(dType == 3 ? 19 : IGDInterval.dType2IGDtype((int)dType)))) continue;
                switch (dType) {
                    case 16: {
                        if (wellInterp == null) break;
                        block.addIGDPanel(20, -1, wellInterp, true);
                        break;
                    }
                    case 11: {
                        if (wellInterp == null) break;
                        for (IGDScheme scheme : wellInterp.getIGDSchemes(IGDInterval.dType2IGDtype((int)dType))) {
                            scheme.loadUnits();
                            block.addIGDPanel(4, scheme.getID(), wellInterp, true);
                        }
                        continue block12;
                    }
                    case 10: 
                    case 12: {
                        if (wellInterp == null) break;
                        block.addIGDPanel(IGDInterval.dType2IGDtype((int)dType), -1, wellInterp, true);
                        break;
                    }
                    case 14: {
                        if (wellInterp == null) break;
                        for (IGDScheme sch : wellInterp.getSequenceSchemes()) {
                            block.addIGDPanel(21, sch.getID(), wellInterp, true);
                        }
                        continue block12;
                    }
                    case 3: {
                        if (wellInterp == null) break;
                        block.addIGDPanel(19, -1, wellInterp, true);
                        break;
                    }
                    case 23: {
                        PanelWirelineLog logPanel = new PanelWirelineLog(block, sbdb);
                        block.addPanel(logPanel);
                        break;
                    }
                    case 1: {
                        block.addSamplesPanel(true);
                    }
                }
            }
        }
        catch (SQLException e) {
            SB.showStackError((String)"Error decoding/adding panels chart", (SQLException)e);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error decoding/adding panels to chart", (Exception)((Object)sbe));
        }
    }

    static double getDefaultScale(double topDepth, double baseDepth, char units) {
        double depthRange = baseDepth - topDepth;
        if (depthRange < 10.0) {
            return units == 'F' ? 60.0 : 50.0;
        }
        if (depthRange < 100.0) {
            return units == 'F' ? 480.0 : 500.0;
        }
        if (depthRange < 1000.0) {
            return units == 'F' ? 1200.0 : 1000.0;
        }
        return units == 'F' ? 6000.0 : 5000.0;
    }

    static double getDefaultDepthBound(boolean isTop, double topDepth, double baseDepth, char units) {
        double depthRange = SB.convFromM((double)(baseDepth - topDepth), (char)units);
        if (depthRange < (double)0.0029f) {
            return topDepth;
        }
        int log = (int)Math.log10(depthRange);
        double mult = Math.pow(10.0, log - 1);
        log *= 10;
        if (isTop) {
            return SB.convToM((float)((int)((double)((int)((SB.convFromM((double)topDepth, (char)units) - (double)log) / mult)) * mult)), (char)units);
        }
        return SB.convToM((double)((double)((int)Math.ceil((SB.convFromM((double)baseDepth, (char)units) + (double)log) / mult)) * mult), (char)units);
    }
}

