/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.Chart;
import jsbugs.ChartBlock;
import jsbugs.ChartJPanel;
import jsbugs.ChartPanel;
import jsbugs.DialogAHDchart;
import jsbugs.DialogBiocom;
import jsbugs.DialogEnv;
import jsbugs.DialogInterval;
import jsbugs.DialogIntervalComment;
import jsbugs.DialogLithPalette;
import jsbugs.DialogOccurrence;
import jsbugs.DialogSQPick;
import jsbugs.DialogSampleLithology;
import jsbugs.DialogWellEvent;
import jsbugs.GUI;
import jsbugs.JPanelCharts;
import jsbugs.LithologyTransferHandler;
import jsbugs.PanelBiocoms;
import jsbugs.PanelCasing;
import jsbugs.PanelCoreImages;
import jsbugs.PanelCores;
import jsbugs.PanelDepth;
import jsbugs.PanelEnv;
import jsbugs.PanelEvents;
import jsbugs.PanelIntLith;
import jsbugs.PanelIntcoms;
import jsbugs.PanelMarkers;
import jsbugs.PanelSQPicks;
import jsbugs.PanelSampleLithology;
import jsbugs.PanelTaxon;
import jsbugs.PanelTaxonGroup;
import jsbugs.PanelWirelineLog;
import jsbugs.PanelZones;
import jsbugs.SBDialog;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.Biocom;
import model2.Discipline;
import model2.EnvScheme;
import model2.IGDIntervalEnv;
import model2.IGDIntervalZone;
import model2.IGDScheme;
import model2.Intcom;
import model2.Lastval;
import model2.Lithology;
import model2.SBdb;
import model2.SQPick;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import util.InvalidFieldException;
import util.SB;
import util.SbugsCompoundEdit;

public class ChartJPanelAHD
extends ChartJPanel {
    private final JPanelCharts parent;
    private final SBdb sbdb;
    private Sample ZoneBndOrigin = null;
    private Double depthBndOrigin = null;
    private Float lithBndOriginDraw = null;
    private Double lithBndOrigin = null;
    private static final Double LITH_BND_DRAG = new Double(0.0);
    private Point2D.Float lastDragPoint;
    private Point2D.Float lastLithMouseLoc;
    private String lastDepthString = null;
    boolean ahdChartPropertiesDecoded = false;
    boolean ahdDepthsSet = false;

    public ChartJPanelAHD(JPanelCharts parent, SBdb sbdb) {
        super((Chart)null);
        this.parent = parent;
        this.sbdb = sbdb;
        this.init();
    }

    private void init() {
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        LithologyTransferHandler lithologyTransferHandler = new LithologyTransferHandler();
        lithologyTransferHandler.undoSupport.addUndoableEditListener(this.undoManager);
        this.setTransferHandler(lithologyTransferHandler);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ChartJPanelAHD.this.mMoved(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ChartJPanelAHD.this.mDragged(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ChartJPanelAHD.this.mReleased(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartJPanelAHD.this.mClicked(evt);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initChart(boolean create) {
        System.out.println("Setting up AHD Chart...");
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.chart == null) {
                SBPanel panel;
                this.chart = new Chart();
                this.chart.chartProperties.setPanelHeaderHeight(90.0f);
                this.chart.chartProperties.setPanelCaptionHeight(9.0f);
                Well well = this.parent.well;
                List<Smpdtl> list = this.parent.parentPanel.tableModelAnalyses.getSmpdtls();
                if (list == null) {
                    return;
                }
                for (Smpdtl smpdtl : list) {
                    smpdtl.load(well.getWellID());
                }
                this.chart.chartProperties.margin = 3.0f;
                ChartBlock block = new WellBlock(well, this.sbdb);
                ((WellBlock)block).interp = this.parent.getInterp();
                ((WellBlock)block).setTopDepth((float)ChartJPanelAHD.getDefaultDepthBound(true, well.getTopSampleDepth(), well.getBaseSampleDepth(), well.getWellUnits()));
                ((WellBlock)block).setBaseDepth((float)ChartJPanelAHD.getDefaultDepthBound(false, well.getTopSampleDepth(), well.getBaseSampleDepth(), well.getWellUnits()));
                if (Math.abs(well.getBaseSampleDepth() - well.getTopSampleDepth()) < (double)0.0029f) {
                    ((WellBlock)block).setTopDepth(((WellBlock)block).getTopDepth() - 5.0f);
                    ((WellBlock)block).setBaseDepth(((WellBlock)block).getBaseDepth() + 5.0f);
                }
                ((WellBlock)block).setScale((float)ChartJPanelAHD.getDefaultScale(well.getTopSampleDepth(), well.getBaseSampleDepth(), well.getWellUnits()));
                PanelDepth depthPanel = new PanelDepth(this.sbdb, (WellBlock)block);
                block.addPanel(depthPanel);
                if (well.getSamples() != null && !well.getSamples().isEmpty()) {
                    ((WellBlock)block).addSamplesPanel(false);
                }
                char currentDiscID = this.parent.parentPanel.getDiscID();
                for (char disc : SBdb.discArr) {
                    if (currentDiscID != '\u0000' && disc != currentDiscID || well.getAnalyses(disc, null, 0).isEmpty()) continue;
                    PanelTaxonGroup panel2 = new PanelTaxonGroup(this.sbdb, (WellBlock)block, Discipline.getDisc((char)disc));
                    panel2.addDefaultPanel(false);
                    block.addPanel(panel2);
                }
                if (well.getCurves().getCurves() != null && !well.getCurves().getCurves().isEmpty()) {
                    panel = new PanelWirelineLog((WellBlock)block, this.sbdb);
                    block.addPanel(panel);
                }
                if (!well.getLithIntervals().isEmpty()) {
                    panel = new PanelIntLith(this.sbdb, (WellBlock)block);
                    block.addPanel(panel);
                }
                if (well.hasSampleLithology()) {
                    PanelSampleLithology psl = new PanelSampleLithology(this.sbdb, (WellBlock)block);
                    block.addPanel(psl);
                }
                if (!well.getCasing().getList().isEmpty()) {
                    panel = new PanelCasing(this.sbdb, (WellBlock)block);
                    block.addPanel(panel);
                }
                if (!well.getCores().getList().isEmpty()) {
                    panel = new PanelCores(this.sbdb, (WellBlock)block);
                    block.addPanel(panel);
                }
                if (!well.getCoreImages().isEmpty()) {
                    PanelCoreImages pci = new PanelCoreImages((WellBlock)block, this.sbdb);
                    block.addPanel(pci);
                }
                if (!well.getMarkers().getList().isEmpty()) {
                    panel = new PanelMarkers((WellBlock)block, this.sbdb);
                    block.addPanel(panel);
                }
                block.addObserver(this);
                this.chart.blocks.add(block);
                if (this.ahdChartPropertiesDecoded) {
                    this.decodeProperties();
                }
            } else {
                WellInterp wellInterp = this.parent.getInterp();
                if (this.ahdChartPropertiesDecoded) {
                    this.decodeProperties();
                }
            }
            if (create) {
                WellInterp wellInterp;
                this.parent.well.addObserver((Observer)this);
                WellBlock wellblock = null;
                for (ChartBlock block : this.chart.blocks) {
                    if (block.getClass() != WellBlock.class) continue;
                    wellblock = (WellBlock)block;
                }
                wellblock.interp = wellInterp = this.parent.getInterp();
                if (wellInterp != null) {
                    int[] igdTypes;
                    block18: for (int i : igdTypes = new int[]{22, 20, 3, 2, 4, 21, 5, 19}) {
                        if (!wellInterp.hasData(i)) continue;
                        switch (i) {
                            case 4: {
                                for (IGDScheme scheme : wellInterp.getIGDSchemes(i)) {
                                    scheme.loadUnits();
                                    wellblock.addIGDPanel(4, scheme.getID(), wellInterp, true);
                                }
                                continue block18;
                            }
                            case 2: 
                            case 3: {
                                wellblock.addIGDPanel(i, -1, wellInterp, true);
                                continue block18;
                            }
                            case 21: {
                                for (IGDScheme sch : wellInterp.getSequenceSchemes()) {
                                    wellblock.addIGDPanel(21, sch.getID(), wellInterp, true);
                                }
                                continue block18;
                            }
                            case 20: {
                                wellblock.addIGDPanel(20, -1, wellInterp, true);
                                continue block18;
                            }
                            case 5: {
                                for (EnvScheme es : wellInterp.getEnvSchemes()) {
                                    wellblock.addIGDPanel(5, es.getID(), wellInterp, true);
                                }
                                continue block18;
                            }
                            case 19: {
                                if (wellblock.hasPanel(19, -1, wellInterp.getHeader().getInterpID(), '\u0000')) continue block18;
                                wellblock.addIGDPanel(19, -1, wellInterp, true);
                                continue block18;
                            }
                            case 22: {
                                wellblock.addIGDPanel(22, -1, wellInterp, true);
                                continue block18;
                            }
                        }
                    }
                    wellInterp.addObserver((Observer)this);
                }
                this.chart.setData();
            }
            if (this.parent.getInterp() != null) {
                this.parent.setJLabelInfoColour(Color.BLACK);
            } else {
                this.parent.setJLabelInfoColour(Color.RED);
                this.parent.setJLabelInfoText("Warning: no version loaded");
            }
            if (this.chart.calcChartSize()) {
                GUI.setScrollPaneSize(this, this.zoom, 1.5f);
                this.parent.setChartSizeLabel();
            }
            this.repaint();
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void mMoved(MouseEvent evt) {
        try {
            Lithology lith;
            String text;
            if (this.parent.getInterp() == null) {
                this.parent.setJLabelInfoColour(Color.RED);
                text = "Warning: no version loaded";
            } else {
                if (this.ZoneBndOrigin == null && this.depthBndOrigin == null) {
                    String tooltip = this.getTooltip(evt);
                    if (tooltip != null && tooltip.startsWith("Bnd: ") || this.getObject(evt) instanceof SQPick) {
                        this.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                }
                text = this.getTooltip(evt);
            }
            this.parent.setJLabelInfoText(text);
            this.setToolTipText(text);
            if (this.parent.parent.getLithPalette() != null && (lith = this.parent.parent.getLithPalette().getSelectedLithology()) != null && !lith.isQual()) {
                Point2D pTemp = this.getPoint(evt.getPoint());
                Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
                ChartPanel pan = this.chart.getSelectedPanel(mmPoint);
                if (this.lastLithMouseLoc != null || pan != null && pan instanceof PanelIntLith) {
                    Graphics g = this.getGraphics();
                    AffineTransform tf = this.setRubberBandMode(g);
                    if (this.lastLithMouseLoc != null) {
                        g.setColor(Color.gray);
                        this.drawLine(g, new Point2D.Float(0.0f, this.lastLithMouseLoc.y), new Point2D.Float(this.getMaximumSize().width, this.lastLithMouseLoc.y));
                        g.setColor(Color.black);
                        this.lastLithMouseLoc = null;
                    }
                    if (pan != null && pan instanceof PanelIntLith) {
                        PanelIntLith panel = (PanelIntLith)pan;
                        Point2D.Float p = this.chart.getPanelOrigin(panel, true, this.getMode(), 0.0f);
                        Point2D.Float target = new Point2D.Float();
                        target.x = p.x;
                        target.y = mmPoint.y;
                        g.setColor(Color.gray);
                        this.drawLine(g, new Point2D.Float(0.0f, mmPoint.y), new Point2D.Float(this.getMaximumSize().width, mmPoint.y));
                        g.setColor(Color.black);
                        this.lastLithMouseLoc = target;
                    }
                    this.clearRubberBandMode(g, tf);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void mDragged(MouseEvent evt) {
        try {
            Point2D pTemp = this.getPoint(evt.getPoint());
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel pan = this.chart.getSelectedPanel(mmPoint);
            if (pan != null && pan instanceof SBPanel) {
                SBPanel panel = (SBPanel)pan;
                Point2D.Float panelOrigin = this.chart.getPanelOrigin(panel, true, this.getMode(), 0.0f);
                if (panel instanceof PanelZones || panel instanceof PanelSQPicks || panel instanceof PanelEnv) {
                    if (this.ZoneBndOrigin == null) {
                        if (panel instanceof PanelZones) {
                            PanelZones p = (PanelZones)panel;
                            this.ZoneBndOrigin = p.getBoundarySample(mmPoint.x - panelOrigin.x, mmPoint.y - panelOrigin.y, this.zoom, this.chart.chartProperties);
                        } else if (panel instanceof PanelSQPicks) {
                            Object o = this.getObject(evt);
                            if (o instanceof SQPick) {
                                SQPick pick = (SQPick)o;
                                this.ZoneBndOrigin = pick.getSample();
                            }
                        } else {
                            PanelEnv p = (PanelEnv)panel;
                            this.ZoneBndOrigin = p.getBoundarySample(mmPoint.y - panelOrigin.y, this.zoom);
                        }
                        if (this.ZoneBndOrigin != null) {
                            this.setCursor(SB.getDragMoveCursor());
                        }
                    } else {
                        Sample sample;
                        Object p;
                        Graphics g = this.getGraphics();
                        AffineTransform tf = this.setRubberBandMode(g);
                        if (panel instanceof PanelZones) {
                            p = (PanelZones)panel;
                            sample = ((PanelZones)p).getSample(mmPoint.x - panelOrigin.x, mmPoint.y - panelOrigin.y, this.zoom, this.chart.chartProperties);
                        } else if (panel instanceof PanelSQPicks) {
                            p = (PanelSQPicks)panel;
                            sample = ((PanelSQPicks)p).getSample(mmPoint.x - panelOrigin.x, mmPoint.y - panelOrigin.y, this.zoom, this.chart.chartProperties);
                        } else {
                            p = (PanelEnv)panel;
                            sample = ((PanelEnv)p).getSample(mmPoint.x - panelOrigin.x, mmPoint.y - panelOrigin.y, this.zoom, this.chart.chartProperties);
                        }
                        if (this.lastDragPoint != null) {
                            this.drawLine(g, this.lastDragPoint, new Point2D.Float(this.lastDragPoint.x + panel.getWidth(this.chart.getWellBlock().prop), this.lastDragPoint.y));
                        }
                        if (sample != null) {
                            p = this.chart.getPanelOrigin(panel, true, this.getMode(), 0.0f);
                            Point2D.Float sampleOrigin = new Point2D.Float();
                            sampleOrigin.x = ((Point2D.Float)p).x;
                            sampleOrigin.y = ((Point2D.Float)p).y + this.chart.getWellBlock().scaleDepth((float)this.chart.getWellBlock().well.getDepth(sample, this.chart.chartProperties.correctDepths, this.chart.chartProperties.correctCuttings));
                            this.drawLine(g, sampleOrigin, new Point2D.Float(sampleOrigin.x + panel.getWidth(this.chart.getWellBlock().prop), sampleOrigin.y));
                            this.lastDragPoint = sampleOrigin;
                        } else {
                            this.lastDragPoint = null;
                        }
                        this.mMoved(evt);
                        String text = sample != null ? sample.toString() : "No sample";
                        this.parent.setJLabelInfoText(text);
                        this.setToolTipText(text);
                        this.clearRubberBandMode(g, tf);
                    }
                } else if (panel instanceof PanelIntLith) {
                    if (this.depthBndOrigin == null) {
                        this.depthBndOrigin = ((PanelIntLith)panel).getBndDepth(mmPoint.y - panelOrigin.y, this.zoom);
                        if (this.depthBndOrigin == null) {
                            if (((PanelIntLith)panel).isWithinInterval(mmPoint.y - panelOrigin.y)) {
                                this.depthBndOrigin = LITH_BND_DRAG;
                            } else {
                                DialogLithPalette lithPalette = this.parent.parent.getLithPalette();
                                if (lithPalette != null && lithPalette.getSelectedLithology() != null && !lithPalette.getSelectedLithology().isQual()) {
                                    this.depthBndOrigin = ((PanelIntLith)panel).getDepth(mmPoint.y - panelOrigin.y);
                                    this.lithBndOriginDraw = Float.valueOf(mmPoint.y);
                                } else {
                                    this.depthBndOrigin = LITH_BND_DRAG;
                                }
                            }
                        }
                    } else if (this.depthBndOrigin != LITH_BND_DRAG) {
                        Graphics g = this.getGraphics();
                        AffineTransform tf = this.setRubberBandMode(g);
                        double depth = SB.round((double)((PanelIntLith)panel).getDepth(mmPoint.y - panelOrigin.y), (int)this.getRounding());
                        String depthString = SB.convFromM((double)depth, (char)this.chart.getWellBlock().prop.units, (char)this.chart.getWellBlock().well.getType()) + (this.chart.getWellBlock().prop.units == 'M' ? "m" : "ft");
                        Point2D.Float p = this.chart.getPanelOrigin(panel, true, this.getMode(), 0.0f);
                        if (this.lithBndOriginDraw != null) {
                            this.drawLine(g, new Point2D.Float(0.0f, this.lithBndOriginDraw.floatValue()), new Point2D.Float(this.getMaximumSize().width, this.lithBndOriginDraw.floatValue()));
                            this.lithBndOrigin = SB.round((double)((PanelIntLith)panel).getDepth(this.lithBndOriginDraw.floatValue() - panelOrigin.y), (int)this.getRounding());
                            this.lithBndOriginDraw = null;
                        }
                        if (this.lastDragPoint != null && this.lastDepthString != null) {
                            this.drawLine(g, this.lastDragPoint, new Point2D.Float(this.lastDragPoint.x + panel.getWidth(this.chart.getWellBlock().prop), this.lastDragPoint.y));
                            if (this.lastDepthString != null) {
                                this.drawString(g, this.lastDragPoint, this.lastDepthString);
                            }
                            g.setColor(Color.gray);
                            this.drawLine(g, new Point2D.Float(0.0f, this.lastDragPoint.y), new Point2D.Float(this.getMaximumSize().width, this.lastDragPoint.y));
                            g.setColor(Color.black);
                        }
                        Point2D.Float target = new Point2D.Float();
                        target.x = p.x;
                        target.y = mmPoint.y;
                        this.drawLine(g, target, new Point2D.Float(target.x + panel.getWidth(this.chart.getWellBlock().prop), target.y));
                        this.drawString(g, target, depthString);
                        g.setColor(Color.gray);
                        this.drawLine(g, new Point2D.Float(0.0f, mmPoint.y), new Point2D.Float(this.getMaximumSize().width, mmPoint.y));
                        g.setColor(Color.black);
                        this.lastDragPoint = target;
                        this.lastDepthString = depthString;
                        this.clearRubberBandMode(g, tf);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mReleased(MouseEvent evt) {
        try {
            if (evt.isPopupTrigger()) {
                this.parent.AHDPopup(evt);
            } else {
                Point2D pTemp = this.getPoint(evt.getPoint());
                Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
                ChartPanel panel = this.chart.getSelectedPanel(mmPoint);
                if (!(panel instanceof SBPanel)) {
                    return;
                }
                Point2D.Float panelOrigin = this.chart.getPanelOrigin((SBPanel)panel, true, this.getMode(), 0.0f);
                if (this.ZoneBndOrigin != null) {
                    if (panel instanceof PanelZones) {
                        PanelZones panelZones = (PanelZones)panel;
                        WellInterp interp = panelZones.block.well.getInterp(panelZones.interpID);
                        Sample newSample = panelZones.getSample((float)(mmPoint.getX() - ((Point2D)panelOrigin).getX()), (float)(mmPoint.getY() - ((Point2D)panelOrigin).getY()), this.zoom, this.chart.chartProperties);
                        if (newSample != null) {
                            this.doEdit(interp.updateIntervalBoundary(this.ZoneBndOrigin, newSample, panelZones.block.well.getWellID(), panelZones.igdType, panelZones.getSchID()));
                        }
                    } else if (panel instanceof PanelSQPicks) {
                        PanelSQPicks pickPanel = (PanelSQPicks)panel;
                        this.doEdit(pickPanel.updatePick(this.ZoneBndOrigin, (float)(mmPoint.getX() - ((Point2D)panelOrigin).getX()), (float)(mmPoint.getY() - ((Point2D)panelOrigin).getY()), this.zoom, this.chart.chartProperties));
                    } else if (panel instanceof PanelEnv) {
                        PanelEnv envPanel = (PanelEnv)panel;
                        WellInterp interp = envPanel.block.well.getInterp(envPanel.interpID);
                        Sample newSample = envPanel.getSample((float)(mmPoint.getX() - ((Point2D)panelOrigin).getX()), (float)(mmPoint.getY() - ((Point2D)panelOrigin).getY()), this.zoom, this.chart.chartProperties);
                        if (newSample != null) {
                            this.doEdit(interp.updateEnvBoundary(this.ZoneBndOrigin, newSample, envPanel.block.well.getWellID()));
                        }
                    } else {
                        System.out.println("No longer in Zones panel");
                    }
                    this.lastDragPoint = null;
                } else if (this.depthBndOrigin != null && this.depthBndOrigin != LITH_BND_DRAG && panel instanceof PanelIntLith) {
                    PanelIntLith lithPanel = (PanelIntLith)panel;
                    double newDepth = SB.round((double)lithPanel.getDepth((float)(mmPoint.getY() - ((Point2D)panelOrigin).getY())), (int)this.getRounding());
                    if (this.lithBndOrigin != null) {
                        double origDepth = this.lithBndOrigin;
                        this.doEdit(lithPanel.block.well.addLithInterval(this.parent.parent.getLithPalette().getSelectedLithology(), origDepth, newDepth));
                    } else {
                        double origDepth = this.depthBndOrigin;
                        SbugsCompoundEdit edit = lithPanel.block.well.updateLithInterval(origDepth, newDepth);
                        edit.doEdits();
                        this.doEdit((UndoableEdit)edit);
                    }
                }
            }
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this.parent, "Can't update: " + ife.getMessage(), "Update Interval", 2);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.parent, "Error updating Interval: " + ex.getMessage(), this.parent.parent.getTitle(), 0);
            this.sbdb.doRollback();
            ex.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.lastDragPoint = null;
            this.ZoneBndOrigin = null;
            this.depthBndOrigin = null;
            this.lithBndOriginDraw = null;
            this.lithBndOrigin = null;
            this.lastLithMouseLoc = null;
            this.repaint();
        }
    }

    private void mClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            try {
                Point2D pTemp = this.getPoint(evt.getPoint());
                Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
                Window dialog = null;
                Object obj = this.getObject(evt);
                ChartPanel panel = this.chart.getSelectedPanel(mmPoint);
                if (panel instanceof PanelZones) {
                    PanelZones zonesPanel = (PanelZones)panel;
                    if (obj instanceof IGDIntervalZone) {
                        IGDIntervalZone zone = (IGDIntervalZone)obj;
                        dialog = new DialogInterval(this.parent.getParentFrame(), true, zone.getIGDType(), this.sbdb, zonesPanel.block.well, zonesPanel.block.well.getInterp(zonesPanel.interpID), this.parent.getUnits(), zone, null, null, null, null);
                    }
                } else if (panel instanceof PanelSQPicks) {
                    PanelSQPicks pickPanel = (PanelSQPicks)panel;
                    if (obj instanceof SQPick) {
                        dialog = new DialogSQPick(this.parent.getParentFrame(), true, this.sbdb, this.sbdb.getIGDScheme(pickPanel.schID), pickPanel.block.well, pickPanel.block.well.getInterp(pickPanel.interpID), this.parent.getUnits(), (SQPick)obj, null, null);
                    }
                } else if (panel instanceof PanelEnv) {
                    PanelEnv envPanel = (PanelEnv)panel;
                    if (obj instanceof IGDIntervalEnv) {
                        dialog = new DialogEnv(this.parent.getParentFrame(), true, this.sbdb, envPanel.block.well, envPanel.block.well.getInterp(envPanel.interpID), this.parent.getUnits(), (IGDIntervalEnv)obj, null, null);
                    }
                } else if (panel instanceof PanelEvents) {
                    PanelEvents panelEvents = (PanelEvents)panel;
                    if (obj instanceof WellEvent) {
                        dialog = new DialogWellEvent(this.parent.getParentFrame(), true, this.sbdb, panelEvents.block.well, panelEvents.block.well.getInterp(panelEvents.interpID), this.parent.getUnits(), (WellEvent)obj, null, null, null);
                    }
                } else if (panel instanceof PanelBiocoms) {
                    PanelBiocoms panelBiocoms = (PanelBiocoms)panel;
                    if (obj instanceof Biocom) {
                        dialog = new DialogBiocom(this.parent.getParentFrame(), true, this.sbdb, panelBiocoms.block.well, panelBiocoms.block.well.getInterp(panelBiocoms.interpID), this.parent.getUnits(), (Biocom)obj, null, null);
                    }
                } else if (panel instanceof PanelIntcoms) {
                    PanelIntcoms panelIntcoms = (PanelIntcoms)panel;
                    if (obj instanceof Intcom) {
                        dialog = new DialogIntervalComment(this.parent.getParentFrame(), true, this.sbdb, panelIntcoms.block.well, panelIntcoms.block.well.getInterp(panelIntcoms.interpID), (Intcom)obj, this.parent.getUnits());
                    }
                } else if (panel instanceof PanelSampleLithology) {
                    PanelSampleLithology psl = (PanelSampleLithology)panel;
                    if (obj instanceof Sample) {
                        dialog = new DialogSampleLithology(this.parent.getParentFrame(), true, this.sbdb, psl.block.well, (Sample)obj);
                    }
                } else if (panel instanceof PanelTaxonGroup && obj instanceof PanelTaxon.PanelTaxonObject) {
                    PanelTaxon.PanelTaxonObject pto = (PanelTaxon.PanelTaxonObject)obj;
                    ArrayList<TaxonOcc> occs = new ArrayList<TaxonOcc>();
                    if (pto.getObject() instanceof Taxon && pto.smpdtl != null) {
                        for (TaxonOcc occ : pto.smpdtl.getOccurUnsorted()) {
                            if (occ.getTaxon() != pto.getObject()) continue;
                            occs.add(occ);
                        }
                    }
                    if (occs.size() == 1) {
                        dialog = new DialogOccurrence(this.parent.getParentFrame(), true, this.sbdb, this.parent.well, pto.smpdtl, (TaxonOcc)occs.get(0), null, false, false, false, false, false);
                    }
                }
                if (dialog != null) {
                    dialog.setLocationRelativeTo(this.parent);
                    ((Dialog)dialog).setVisible(true);
                    if (dialog instanceof DialogOccurrence && ((SBDialog)dialog).isOK()) {
                        this.chart.setData((SBPanel)panel);
                        this.repaint();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void doEdit(UndoableEdit edit) {
        if (edit != null) {
            this.undoManager.addEdit(edit);
            this.undoSupport.postEdit(edit);
            this.parent.setUndoTooltips();
            this.repaint();
        }
    }

    @Override
    public void chartProperties() {
        WellBlock block = this.chart.getWellBlock();
        try {
            DialogAHDchart dialog = new DialogAHDchart(this.parent.getParentFrame(), true, this.sbdb, block, this.chart.chartProperties, this.parent.getInterp());
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.initChart(false);
                this.chart.setData();
                if (!this.ahdDepthsSet && dialog.ahdDepthsSet) {
                    this.ahdDepthsSet = true;
                }
                this.encodeProperties();
            }
            if (this.chart.calcChartSize()) {
                GUI.setScrollPaneSize(this, this.zoom, 1.5f);
            }
            this.repaint();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.parent.parent, e.getMessage(), this.parent.parent.getTitle(), 0);
            e.printStackTrace();
        }
    }

    public void encodeProperties() {
        System.out.println("Encoding Standard chart properties... encodeDepths: " + this.ahdDepthsSet);
        WellBlock block = (WellBlock)this.chart.blocks.get(0);
        String string = new String();
        String[] props = new String[]{"" + block.well.getWellID(), "" + (this.ahdDepthsSet ? block.getTopDepth() : -1.0f), "" + (this.ahdDepthsSet ? block.getBaseDepth() : -1.0f), "" + (this.ahdDepthsSet ? block.getScale() : -1.0f)};
        for (String prop : props) {
            string = string + prop + "|";
        }
        try {
            Lastval.putString((SBdb)this.sbdb, (String)"AHDPREF", (String)string);
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void decodeProperties() {
        System.out.println("Decoding AHD chart properties...");
        try {
            String params = Lastval.getString((SBdb)this.sbdb, (String)"AHDPREF");
            if (params.isEmpty()) {
                System.out.println("params is empty: " + params);
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            int wellID = -1;
            if (tok.hasMoreTokens()) {
                wellID = Integer.parseInt(tok.nextToken());
            }
            float topDepth = -1.0f;
            float baseDepth = -1.0f;
            float scale = -1.0f;
            if (tok.hasMoreTokens()) {
                topDepth = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                baseDepth = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                scale = Float.parseFloat(tok.nextToken());
            }
            if (wellID >= 0 && wellID == this.parent.well.getWellID() && topDepth >= 0.0f && baseDepth >= 0.0f) {
                WellBlock block = (WellBlock)this.chart.blocks.get(0);
                block.setTopDepth(topDepth);
                block.setBaseDepth(baseDepth);
                if (scale >= 0.0f) {
                    block.setScale(scale);
                }
            }
            this.ahdChartPropertiesDecoded = true;
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.parent.parent, ex.getMessage(), this.parent.parent.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    @Override
    public void update(Observable obs, Object obj) {
        if (obs instanceof WellInterp) {
            WellInterp interp = (WellInterp)obs;
            if (obj instanceof Biocom && interp.getComments().size() == 1 || obj instanceof WellEvent && interp.getEvents().size() == 1 || obj instanceof Intcom && interp.getIntcoms().size() == 1 || obj instanceof IGDIntervalEnv && interp.getEnvs().size() == 1 || obj instanceof SQPick && interp.getSQPicks().size() == 1 || obj instanceof IGDIntervalZone && interp.getIGDList(((IGDIntervalZone)obj).getIGDType()).size() == 1) {
                this.initChart(false);
            }
        } else {
            super.update(obs, obj);
        }
    }

    private int getRounding() {
        double depthRes = this.zoom * 2.8346457f / this.chart.getWellBlock().prop.scale * 1000.0f;
        int round = (int)Math.log10(depthRes);
        return round;
    }
}

