/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartBlock;
import jsbugs.ChartJPanel;
import jsbugs.DialogAgeChart;
import jsbugs.FrameJsbugs;
import jsbugs.GUI;
import jsbugs.JPanelCharts;
import jsbugs.PanelAgeScale;
import jsbugs.PanelDepth;
import jsbugs.SchemeBlock;
import jsbugs.WellBlock;
import model2.SBdb;
import model2.Well;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class ChartJPanelAge
extends ChartJPanel {
    JPanelCharts parent;
    SBdb sbdb;
    WellBlock wellBlockTemp;
    static final String NO_LOC_TEXT = "No version or LOC loaded";
    static final String ENCODE_PANELS_KEY = "AGECHTPREF";
    static final int TEMP_ID = 4;

    ChartJPanelAge(JPanelCharts parent, SBdb sbdb) {
        super((Chart)null);
        this.parent = parent;
        this.sbdb = sbdb;
        this.init();
    }

    private void init() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ChartJPanelAge.this.mMoved(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ChartJPanelAge.this.mReleased(evt);
            }
        });
    }

    void initChart() {
        System.out.println("Setting up Chronostrat Chart...");
        Well well = this.parent.well;
        WellInterp wellInterp = this.parent.getInterp();
        if (this.chart == null) {
            if (!this.initChartSaved()) {
                this.chart = new Chart();
                this.chart.chartProperties.setPanelHeaderHeight(90.0f);
                this.chart.chartProperties.setPanelCaptionHeight(9.0f);
                this.chart.chartProperties.margin = 3.0f;
                BlockProperties blockProperties = new BlockProperties(BlockProperties.ScaleType.AGE);
                SchemeBlock sBlock = new SchemeBlock();
                sBlock.prop = blockProperties;
                PanelAgeScale agePanel = new PanelAgeScale(sBlock, true);
                sBlock.addPanel(agePanel);
                this.chart.blocks.add(sBlock);
                this.setWellBlock(well, wellInterp, blockProperties, true);
            }
        } else {
            this.setWellBlock(well, wellInterp, this.getSchemeBlock().prop, true);
        }
        try {
            this.chart.setData();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error setting data in Age Chart", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error setting data in Age Chart", (Exception)((Object)sbe));
        }
        catch (IOException e) {
            SB.showStackError((String)"I/O Error setting data in Age Chart", (Exception)e);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        this.mMoved(null);
        if (this.chart.calcChartSize()) {
            GUI.setScrollPaneSize(this, this.zoom, 1.5f);
            this.parent.setChartSizeLabel();
        }
    }

    private void setWellBlock(Well well, WellInterp wellInterp, BlockProperties bp, boolean decode) {
        if (bp == null) {
            throw new IllegalArgumentException("BlockProperties null in ChartJPanelAge");
        }
        WellBlock block = this.getWellBlock();
        if (block == null) {
            if (wellInterp != null && wellInterp.getLOC() != null) {
                if (this.wellBlockTemp == null) {
                    block = new WellBlock(well, this.sbdb, bp);
                    block.setInterp(wellInterp);
                    if (decode) {
                        block.prop.min = (float)wellInterp.getLOC().getMinAge();
                        block.prop.max = (float)wellInterp.getLOC().getMaxAge();
                        block.prop.scale = SchemeBlock.calcIdealScale(block.prop.min, block.prop.max);
                        PanelDepth depthPanel = new PanelDepth(this.sbdb, block);
                        depthPanel.getProperties().width = 15.0f;
                        depthPanel.getProperties().TD = false;
                        depthPanel.getProperties().seaBed = false;
                        block.addPanel(depthPanel);
                        ChartJPanelAge.decodePanelTypes(wellInterp, block, this.sbdb, ENCODE_PANELS_KEY);
                    }
                } else {
                    this.wellBlockTemp.setInterp(wellInterp);
                    block = this.wellBlockTemp;
                    if ((double)block.prop.min < wellInterp.getLOC().getMinAge()) {
                        block.prop.min = (float)wellInterp.getLOC().getMinAge();
                    }
                    if ((double)block.prop.max > wellInterp.getLOC().getMaxAge()) {
                        block.prop.max = (float)wellInterp.getLOC().getMaxAge();
                    }
                }
            }
        } else {
            if (wellInterp == null || wellInterp.getLOC() == null) {
                this.wellBlockTemp = block;
                this.chart.blocks.remove(block);
                return;
            }
            if (block.getInterp() != wellInterp) {
                block.setInterp(wellInterp);
                if (decode) {
                    block.prop.min = (float)wellInterp.getLOC().getMinAge();
                    block.prop.max = (float)wellInterp.getLOC().getMaxAge();
                }
            }
            if ((double)block.prop.min < wellInterp.getLOC().getMinAge()) {
                block.prop.min = (float)wellInterp.getLOC().getMinAge();
            }
            if ((double)block.prop.max > wellInterp.getLOC().getMaxAge()) {
                block.prop.max = (float)wellInterp.getLOC().getMaxAge();
            }
        }
        if (block != null) {
            block.addObserver(this);
            if (!this.chart.blocks.contains(block)) {
                this.chart.blocks.add(block);
            }
        }
    }

    private boolean initChartSaved() {
        String keybase = WellBlock.getPrefKey(this.parent.well.getWellID(), 4);
        String sql = "SELECT pref_key, pref_value from " + this.sbdb.DBTableName("PREF_USER") + " where user_id=" + this.sbdb.getUser().getUsrID() + " AND pref_key like(" + SB.DBString((String)(keybase + "%")) + ")";
        try {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            LinkedList<Chart.ChartPref> keys = new LinkedList<Chart.ChartPref>();
            while (rs.next()) {
                String key = rs.getString("pref_key");
                String value = rs.getString("pref_value");
                keys.add(new Chart.ChartPref(key, value));
            }
            if (keys.isEmpty()) {
                return false;
            }
            Collections.sort(keys);
            this.chart = new Chart(keys, this.sbdb, this.parent.well.getWellID(), this.parent.getInterp().getHeader());
            this.setWellBlock(this.parent.well, this.parent.getInterp(), this.chart.blocks.get((int)0).prop, false);
            return true;
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("Error loading saved depth/age chart", sqle, this.sbdb);
            return false;
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
            return false;
        }
    }

    @Override
    public void chartProperties() {
        if (this.getWellBlock() == null) {
            JOptionPane.showMessageDialog(this.parent, "You must select a version with an LOC", this.parent.parent.getTitle(), 2);
            return;
        }
        DialogAgeChart dialog = new DialogAgeChart((Frame)this.parent.getParentFrame(), true, this, this.sbdb);
        dialog.setLocationRelativeTo(this.parent);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.initChart();
        }
    }

    WellBlock getWellBlock() {
        if (this.chart != null) {
            for (ChartBlock b : this.chart.blocks) {
                if (!(b instanceof WellBlock)) continue;
                return (WellBlock)b;
            }
        }
        return null;
    }

    SchemeBlock getSchemeBlock() {
        if (this.chart != null) {
            for (ChartBlock b : this.chart.blocks) {
                if (!(b instanceof SchemeBlock)) continue;
                return (SchemeBlock)b;
            }
        }
        return null;
    }

    private void mMoved(MouseEvent evt) {
        try {
            String text = this.parent.getInterp() == null || this.parent.getInterp().getLOC() == null ? NO_LOC_TEXT : (evt != null ? this.getTooltip(evt) : "");
            this.parent.setJLabelInfoText(text);
            this.setToolTipText(text);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void mReleased(MouseEvent evt) {
        try {
            if (evt.isPopupTrigger()) {
                this.parent.AgePopup(evt);
                this.repaint();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

