/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.Chart;
import jsbugs.ChartJPanel;
import jsbugs.ChartPanel;
import jsbugs.DialogWellDepthAge;
import jsbugs.FrameJsbugs;
import jsbugs.GUI;
import jsbugs.JPanelCharts;
import jsbugs.PanelCompositeStandard;
import jsbugs.PanelDepth;
import jsbugs.PanelEventsBase;
import jsbugs.PanelWellDepthAge;
import jsbugs.PanelWellDepthAgeProperties;
import jsbugs.SBPanel;
import jsbugs.SchemeBlock;
import jsbugs.WellBlock;
import model2.InterpHdr;
import model2.Lastval;
import model2.SBdb;
import model2.WellInterp;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class ChartJPanelDepthAge
extends ChartJPanel {
    private JPanelCharts parent;
    private Point2D.Float LOCorigin = null;
    private Point2D.Float dragBaseLOC;
    private Point2D.Float dragTopLOC;
    private Point2D.Float lastDragPoint;
    private SBdb sbdb;
    boolean dialogDepthsSet = false;
    static final String ENCODE_PANELS_KEY = "DACHTPANS";
    static final int TEMP_ID = 2;

    public ChartJPanelDepthAge(JPanelCharts jPanelCharts, SBdb sbdb) {
        super((Chart)null);
        this.parent = jPanelCharts;
        this.sbdb = sbdb;
        this.init();
    }

    private void init() {
        this.undoManager = new UndoManager();
        this.undoSupport = new UndoableEditSupport();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChartJPanelDepthAge.this.mClicked(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ChartJPanelDepthAge.this.mMoved(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ChartJPanelDepthAge.this.mDragged(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ChartJPanelDepthAge.this.mReleased(evt);
            }
        });
    }

    public void initChart() {
        try {
            WellInterp wellInterp = this.parent.getInterp();
            System.out.println("setting up Depth Age Chart...");
            if (this.chart == null) {
                if (!this.initChartSaved()) {
                    this.initChartPref();
                }
                this.chart.chartProperties.margin = 3.0f;
                if (this.chart.getSchemeBlock() == null) {
                    SchemeBlock schemeBlock = new SchemeBlock();
                    schemeBlock.interp = wellInterp;
                    schemeBlock.prop = this.chart.getWellBlock().prop;
                    this.chart.blocks.add(0, schemeBlock);
                }
            } else {
                WellBlock block = this.chart.getWellBlock();
                for (SBPanel o : block.panels) {
                    if (!(o instanceof PanelWellDepthAge)) continue;
                    PanelWellDepthAge wellPanel = (PanelWellDepthAge)o;
                    if (wellInterp == null || wellPanel.getProperties().interp == wellInterp.getHeader()) continue;
                    wellPanel.getProperties().interp = wellInterp.getHeader();
                    wellInterp.addObserver((Observer)this);
                    if (wellInterp.getLOC() == null) continue;
                    wellInterp.getLOC().addObserver((Observer)this);
                    if (wellInterp.getLOC().getStdIDPref() > 0) {
                        wellPanel.getProperties().setCmpStd(this.sbdb.getCompositeStandard(wellInterp.getLOC().getStdIDPref()), this.sbdb);
                    }
                    wellPanel.getProperties().setSBlockAgeRange((float)wellInterp.getLOC().getMinAge(), (float)wellInterp.getLOC().getMaxAge());
                }
                SchemeBlock sBlock = this.chart.getSchemeBlock();
                sBlock.interp = wellInterp;
                if (wellInterp != null) {
                    this.parent.setJLabelInfoColour(Color.BLACK);
                    this.parent.setJLabelInfoText("");
                } else {
                    this.parent.setJLabelInfoColour(Color.RED);
                    this.parent.setJLabelInfoText("Warning: no version loaded");
                }
            }
            if (this.chart.calcChartSize()) {
                GUI.setScrollPaneSize(this, this.zoom, 1.5f);
                this.parent.setChartSizeLabel();
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error initialising Depth/Age Chart", (Exception)((Object)sbe));
        }
        catch (IOException e) {
            SB.showStackError((String)"I/O Error initialising Depth/Age Chart", (Exception)e);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error initialising Depth/Age Chart", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void initChartPref() throws SQLException, SBException, IOException {
        WellInterp wellInterp = this.parent.getInterp();
        this.chart = new Chart();
        this.chart.chartProperties.setPanelHeaderHeight(70.0f);
        WellBlock block = new WellBlock(this.parent.well, this.sbdb);
        block.setTopDepth((float)ChartJPanelDepthAge.getDefaultDepthBound(true, this.parent.well.getTopSampleDepth(), this.parent.well.getBaseSampleDepth(), this.parent.well.getWellUnits()));
        block.setBaseDepth((float)ChartJPanelDepthAge.getDefaultDepthBound(false, this.parent.well.getTopSampleDepth(), this.parent.well.getBaseSampleDepth(), this.parent.well.getWellUnits()));
        block.setScale((float)ChartJPanelDepthAge.getDefaultScale(this.parent.well.getTopSampleDepth(), this.parent.well.getBaseSampleDepth(), this.parent.well.getWellUnits()));
        block.prop.units = this.parent.getUnits();
        PanelDepth depthPanel = new PanelDepth(this.sbdb, block);
        block.addPanel(depthPanel);
        PanelWellDepthAgeProperties prop = new PanelWellDepthAgeProperties(this.sbdb, false);
        InterpHdr interpHdr = prop.interp = wellInterp != null ? wellInterp.getHeader() : null;
        if (wellInterp != null) {
            wellInterp.addObserver((Observer)this);
            this.parent.setJLabelInfoColour(Color.BLACK);
            this.parent.setJLabelInfoText("");
            if (wellInterp.getLOC() != null) {
                wellInterp.getLOC().addObserver((Observer)this);
                if (wellInterp.getLOC().getStdIDPref() > 0) {
                    prop.setCmpStd(this.sbdb.getCompositeStandard(wellInterp.getLOC().getStdIDPref()), this.sbdb);
                }
                prop.setSBlockAgeRange((float)wellInterp.getLOC().getMinAge(), (float)wellInterp.getLOC().getMaxAge());
            } else {
                prop.setCmpStd(this.parent.parent.getCompositeStandard(), this.sbdb);
                if (prop.getCmpStd() != null) {
                    float minAge = (float)prop.getCmpStd().getMinAge();
                    float maxAge = (float)prop.getCmpStd().getMaxAge();
                    prop.setSBlockAgeRange(minAge, maxAge);
                }
            }
            if (prop.getCmpStd() != null) {
                prop.getCmpStd().loadEvents();
                prop.getCmpStd().addObserver((Observer)this);
            }
        } else {
            this.parent.setJLabelInfoColour(Color.red);
            this.parent.setJLabelInfoText("Warning: no version loaded");
        }
        PanelEventsBase pcs = null;
        for (SBPanel sbp : prop.sBlock.panels) {
            if (!(sbp instanceof PanelCompositeStandard)) continue;
            pcs = (PanelCompositeStandard)sbp;
            break;
        }
        if (pcs == null) {
            pcs = new PanelCompositeStandard(prop.getCmpStd(), this.sbdb, prop.sBlock);
            prop.sBlock.addPanel(pcs);
        }
        pcs.getProperties().filterWell = block.well;
        this.chart.chartProperties.setPanelSubHeaderHeight(prop.sBlock.getWidth());
        PanelWellDepthAge wellPanel = new PanelWellDepthAge(this.sbdb, block, prop);
        block.addPanel(wellPanel);
        try {
            String params = Lastval.getString((SBdb)this.sbdb, (String)"DACHTPREF");
            if (!params.isEmpty()) {
                int wellID;
                StringTokenizer tok = new StringTokenizer(params, "|");
                boolean thisWell = false;
                if (tok.hasMoreTokens() && (wellID = Integer.parseInt(tok.nextToken())) == this.parent.well.getWellID()) {
                    thisWell = true;
                }
                if (tok.hasMoreTokens()) {
                    float topDepth = Float.parseFloat(tok.nextToken());
                    if (thisWell && topDepth >= 0.0f) {
                        block.setTopDepth(topDepth);
                    }
                }
                if (tok.hasMoreTokens()) {
                    float baseDepth = Float.parseFloat(tok.nextToken());
                    if (thisWell && baseDepth >= 0.0f) {
                        block.setBaseDepth(baseDepth);
                    }
                }
                if (tok.hasMoreTokens()) {
                    float scale = Float.parseFloat(tok.nextToken());
                    if (thisWell) {
                        block.setScale(scale);
                    }
                }
                if (tok.hasMoreTokens()) {
                    char units = tok.nextToken().charAt(0);
                    if (thisWell) {
                        block.prop.units = units;
                    }
                }
                if (tok.hasMoreTokens()) {
                    tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    tok.nextToken();
                }
                ChartJPanelDepthAge.decodePanelTypes(wellInterp, block, this.sbdb, ENCODE_PANELS_KEY);
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        block.setData(this.chart.chartProperties);
        block.addObserver(this);
        this.chart.blocks.add(block);
    }

    private boolean initChartSaved() {
        if (this.parent.getInterp() == null) {
            return false;
        }
        String keybase = WellBlock.getPrefKey(this.parent.well.getWellID(), 2);
        String sql = "SELECT pref_key, pref_value from " + this.sbdb.DBTableName("PREF_USER") + " where user_id=" + this.sbdb.getUser().getUsrID() + " AND pref_key like(" + SB.DBString((String)(keybase + "%")) + ")";
        try {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            LinkedList<Chart.ChartPref> keys = new LinkedList<Chart.ChartPref>();
            while (rs.next()) {
                String key = rs.getString("pref_key");
                String value = rs.getString("pref_value");
                keys.add(new Chart.ChartPref(key, value));
            }
            if (keys.isEmpty()) {
                return false;
            }
            Collections.sort(keys);
            this.chart = new Chart(keys, this.sbdb, this.parent.well.getWellID(), this.parent.getInterp().getHeader());
            WellBlock block = this.chart.getWellBlock();
            if (block == null) {
                block = new WellBlock(this.parent.well, this.sbdb);
                this.chart.blocks.add(block);
            }
            boolean hasDAPanel = false;
            for (SBPanel panel : block.panels) {
                if (!(panel instanceof PanelWellDepthAge)) continue;
                hasDAPanel = true;
                break;
            }
            if (!hasDAPanel) {
                block.addPanel(new PanelWellDepthAge(this.sbdb, block, new PanelWellDepthAgeProperties(this.sbdb, false)));
            }
            block.addObserver(this);
            this.chart.setData();
            return true;
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("Error loading saved depth/age chart", sqle, this.sbdb);
            return false;
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error loading saved depth/age chart", (Exception)((Object)sbe));
            return false;
        }
        catch (IOException e) {
            SB.showStackError((String)"I/O Error loading saved depth/age chart", (Exception)e);
            return false;
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
            return false;
        }
    }

    public void encode() {
        String string = new String();
        String[] props = new String[]{"" + this.parent.well.getWellID(), "" + (this.dialogDepthsSet ? this.getBlock().getTopDepth() : -1.0f), "" + (this.dialogDepthsSet ? this.getBlock().getBaseDepth() : -1.0f), "" + this.getBlock().getScale(), "" + this.getBlock().prop.units, "", "", "", ""};
        for (String prop : props) {
            string = string + prop + "|";
        }
        try {
            Lastval.putString((SBdb)this.sbdb, (String)"DACHTPREF", (String)string);
            this.sbdb.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void mMoved(MouseEvent evt) {
        String text;
        if (this.parent.getInterp() == null) {
            this.parent.getJLabelInfo().setForeground(Color.red);
            text = "Warning: no version loaded";
        } else {
            this.parent.getJLabelInfo().setForeground(Color.BLACK);
            if (this.LOCorigin == null) {
                try {
                    Point2D pTemp = this.getPoint(evt.getPoint());
                    Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
                    ChartPanel panel = this.chart.getSelectedPanel(mmPoint);
                    if (panel != null && panel instanceof PanelWellDepthAge) {
                        Point2D.Float panelOrigin = this.chart.getPanelOrigin((SBPanel)panel, true, this.getMode(), 0.0f);
                        PanelWellDepthAge wellPanel = (PanelWellDepthAge)panel;
                        if (wellPanel.interactive() && wellPanel.getLOCorigin(mmPoint.x - panelOrigin.x, mmPoint.y - panelOrigin.y, this.zoom) != null) {
                            this.setCursor(Cursor.getPredefinedCursor(12));
                        } else {
                            this.setCursor(Cursor.getDefaultCursor());
                        }
                    }
                }
                catch (RuntimeException re) {
                    re.printStackTrace();
                }
            }
            text = this.getTooltip(evt);
        }
        this.parent.setJLabelInfoText(text);
        this.setToolTipText(text);
    }

    private void mDragged(MouseEvent evt) {
        try {
            Point2D pTemp = this.getPoint(evt.getPoint());
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            if (this.LOCorigin == null) {
                ChartPanel panel = this.chart.getSelectedPanel(mmPoint);
                if (panel != null && panel.getClass() == PanelWellDepthAge.class) {
                    Point2D.Float panelOrigin = this.chart.getPanelOrigin((SBPanel)panel, true, this.getMode(), 0.0f);
                    PanelWellDepthAge wellPanel = (PanelWellDepthAge)panel;
                    if (!wellPanel.interactive()) {
                        return;
                    }
                    this.LOCorigin = wellPanel.getLOCorigin(mmPoint.x - panelOrigin.x, mmPoint.y - panelOrigin.y, this.zoom);
                    if (this.LOCorigin != null) {
                        this.setCursor(SB.getDragMoveCursor());
                        this.dragTopLOC = wellPanel.getNeighbourPoint(this.LOCorigin.x, this.LOCorigin.y, true);
                        if (this.dragTopLOC != null) {
                            this.dragTopLOC = new Point2D.Float(this.dragTopLOC.x + panelOrigin.x, this.dragTopLOC.y + panelOrigin.y);
                        }
                        this.dragBaseLOC = wellPanel.getNeighbourPoint(this.LOCorigin.x, this.LOCorigin.y, false);
                        if (this.dragBaseLOC != null) {
                            this.dragBaseLOC = new Point2D.Float(this.dragBaseLOC.x + panelOrigin.x, this.dragBaseLOC.y + panelOrigin.y);
                        }
                    }
                }
            } else {
                Graphics g = this.getGraphics();
                AffineTransform tf = this.setRubberBandMode(g);
                if (this.dragBaseLOC != null && mmPoint.y > this.dragBaseLOC.y) {
                    mmPoint.y = this.dragBaseLOC.y;
                }
                if (this.dragTopLOC != null && mmPoint.y < this.dragTopLOC.y) {
                    mmPoint.y = this.dragTopLOC.y;
                }
                if (this.lastDragPoint != null) {
                    if (this.dragTopLOC != null) {
                        this.drawLine(g, this.dragTopLOC, this.lastDragPoint);
                    }
                    if (this.dragBaseLOC != null) {
                        this.drawLine(g, this.dragBaseLOC, this.lastDragPoint);
                    }
                    g.setColor(Color.gray);
                    this.drawLine(g, new Point2D.Float(this.lastDragPoint.x, 0.0f), new Point2D.Float(this.lastDragPoint.x, this.getMaximumSize().height));
                    this.drawLine(g, new Point2D.Float(0.0f, this.lastDragPoint.y), new Point2D.Float(this.getMaximumSize().width, this.lastDragPoint.y));
                    g.setColor(Color.black);
                }
                if (this.dragTopLOC != null) {
                    this.drawLine(g, this.dragTopLOC, mmPoint);
                }
                if (this.dragBaseLOC != null) {
                    this.drawLine(g, this.dragBaseLOC, mmPoint);
                }
                g.setColor(Color.gray);
                this.drawLine(g, new Point2D.Float(mmPoint.x, 0.0f), new Point2D.Float(mmPoint.x, this.getMaximumSize().height));
                this.drawLine(g, new Point2D.Float(0.0f, mmPoint.y), new Point2D.Float(this.getMaximumSize().width, mmPoint.y));
                g.setColor(Color.black);
                this.clearRubberBandMode(g, tf);
                this.parent.getJLabelInfo().setText(this.getTooltip(evt));
                this.lastDragPoint = mmPoint;
            }
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.parent.DepthAgePopup(evt);
            this.repaint();
        } else if (this.LOCorigin != null) {
            Point2D pTemp = this.getPoint(evt.getPoint());
            Point2D.Float mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
            ChartPanel panel = this.chart.getSelectedPanel(mmPoint);
            int bnd = -1;
            if (panel != null && panel instanceof PanelWellDepthAge) {
                PanelWellDepthAge wellPanel = (PanelWellDepthAge)panel;
                Point2D.Float panelOrigin = this.chart.getPanelOrigin((SBPanel)panel, true, this.getMode(), 0.0f);
                if (this.dragBaseLOC != null && mmPoint.y > this.dragBaseLOC.y) {
                    mmPoint.y = this.dragBaseLOC.y;
                    bnd = 4;
                }
                if (this.dragTopLOC != null && mmPoint.y < this.dragTopLOC.y) {
                    mmPoint.y = this.dragTopLOC.y;
                }
                Point2D.Float newPoint = new Point2D.Float((float)(mmPoint.getX() - ((Point2D)panelOrigin).getX()), (float)(mmPoint.getY() - ((Point2D)panelOrigin).getY()));
                try {
                    this.doEdit(wellPanel.updateLOCNode(this.LOCorigin, newPoint, bnd));
                }
                catch (InvalidFieldException ife) {
                    JOptionPane.showMessageDialog(this, ife.getMessage(), "Update node", 2);
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error updating node", sql, this.sbdb);
                }
                catch (SBException sbe) {
                    SB.showStackError((String)"Error", (Exception)((Object)sbe));
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                    this.lastDragPoint = null;
                    this.LOCorigin = null;
                }
            } else {
                System.out.println("No longer in well Depth Panel");
                this.setCursor(Cursor.getDefaultCursor());
                this.lastDragPoint = null;
                this.LOCorigin = null;
                this.repaint();
            }
        }
    }

    private void mClicked(MouseEvent evt) {
    }

    void UpdateLOCNodeBnd(int style, Point popupPoint) {
        try {
            Point2D mmPoint = this.getPoint(popupPoint);
            ChartPanel panel = this.chart.getSelectedPanel(mmPoint);
            if (panel != null && panel.getClass() == PanelWellDepthAge.class) {
                Point2D.Float panelOrigin = this.chart.getPanelOrigin((SBPanel)panel, true, this.getMode(), 0.0f);
                PanelWellDepthAge wellPanel = (PanelWellDepthAge)panel;
                UndoableEdit edit = wellPanel.updateLOCNodeBnd((float)(mmPoint.getX() - ((Point2D)panelOrigin).getX()), (float)(mmPoint.getY() - ((Point2D)panelOrigin).getY()), style, this.zoom);
                if (edit != null) {
                    this.doEdit(edit);
                }
                this.sbdb.commit();
            } else {
                JOptionPane.showMessageDialog(this.parent.parent, "No LOC panel selected", this.parent.parent.getTitle(), 1);
            }
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(null, ife.getMessage(), "Warning", 2);
        }
        catch (SBException e) {
            JOptionPane.showMessageDialog(this.parent.parent, "Warning: " + e.getMessage(), this.parent.parent.getTitle(), 2);
            this.sbdb.doRollback();
            e.printStackTrace();
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    void addDeleteLOCNode(boolean add, Point popupPoint) {
        try {
            Point2D mmPoint = this.getPoint(popupPoint);
            ChartPanel panel = this.chart.getSelectedPanel(mmPoint);
            if (panel == null || !(panel instanceof PanelWellDepthAge)) {
                JOptionPane.showMessageDialog(this.parent.parent, "No LOC panel selected", this.parent.parent.getTitle(), 1);
            }
            Point2D.Float panelOrigin = this.chart.getPanelOrigin((SBPanel)panel, true, this.getMode(), 0.0f);
            PanelWellDepthAge wellPanel = (PanelWellDepthAge)panel;
            UndoableEdit edit = add ? wellPanel.addLOCnode((float)(mmPoint.getX() - ((Point2D)panelOrigin).getX()), (float)(mmPoint.getY() - ((Point2D)panelOrigin).getY()), this.zoom) : wellPanel.deleteLOCnode((float)(mmPoint.getX() - ((Point2D)panelOrigin).getX()), (float)(mmPoint.getY() - ((Point2D)panelOrigin).getY()), this.zoom);
            this.doEdit(edit);
            this.sbdb.commit();
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(null, "Cannot " + (add ? "add" : "delete") + " node: " + ife.getMessage(), this.parent.parent.getTitle(), 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error " + (add ? "adding" : "deleting") + " node", sql, this.sbdb);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
    }

    private void doEdit(UndoableEdit edit) {
        this.undoManager.addEdit(edit);
        this.undoSupport.postEdit(edit);
        this.parent.setUndoTooltips();
        this.repaint();
    }

    @Override
    public void chartProperties() {
        if (this.getBlock() == null || this.getPanelProperties() == null) {
            System.out.println("In ChartJPanelDepthAge.chartProperties, getBlock()=" + this.getBlock() + ", getPanelProperties()=" + this.getPanelProperties() + " Reinitialising...");
            this.initChart();
            System.out.println("Reinitialised. In ChartJPanelDepthAge.chartProperties, getBlock()=" + this.getBlock() + ", getPanelProperties()=" + this.getPanelProperties());
        }
        DialogWellDepthAge dialog = new DialogWellDepthAge((Frame)this.parent.getParentFrame(), true, this.sbdb, this);
        dialog.setLocationRelativeTo(this.parent);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.initChart();
            this.repaint();
        }
    }

    public WellBlock getBlock() {
        if (this.chart != null) {
            return this.chart.getWellBlock();
        }
        return null;
    }

    SchemeBlock getSchemeBlock() {
        if (this.chart != null) {
            return this.chart.getSchemeBlock();
        }
        return null;
    }

    PanelWellDepthAge getPanelWellDepthAge() {
        if (this.getBlock() != null) {
            for (SBPanel p : this.getBlock().panels) {
                if (!(p instanceof PanelWellDepthAge)) continue;
                PanelWellDepthAge panel = (PanelWellDepthAge)p;
                return panel;
            }
        }
        return null;
    }

    public PanelWellDepthAgeProperties getPanelProperties() {
        if (this.getPanelWellDepthAge() != null) {
            return this.getPanelWellDepthAge().getProperties();
        }
        System.out.println("getPanelWellDepthAge null in ChartJPanelDepthAge");
        return null;
    }
}

