/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Observer;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import jsbugs.BlockProperties;
import jsbugs.Chart;
import jsbugs.ChartBlock;
import jsbugs.ChartJPanel;
import jsbugs.DialogTVDOffsetChart;
import jsbugs.FrameJsbugs;
import jsbugs.GUI;
import jsbugs.JPanelCharts;
import jsbugs.PanelBiozones;
import jsbugs.PanelDepth;
import jsbugs.PanelEvents;
import jsbugs.PanelWellVS;
import jsbugs.PanelZones;
import jsbugs.SBPanel;
import jsbugs.WellBlock;
import model2.Lastval;
import model2.SBdb;
import model2.Well;
import model2.WellEvent;
import model2.WellInterp;
import util.SB;
import util.SBException;

public class ChartJPanelTVDOffset
extends ChartJPanel {
    private JPanelCharts parent;
    private Point2D.Float lastDragPoint;
    boolean predictPointDraggable = false;
    private Point2D.Float offsetPredictPoint = null;
    private SBdb sbdb;
    public static float extraVS = 200.0f;
    static final String PREF_KEY = "TV";
    static final String MBPREF_KEY = "TVDMBPANS";
    static final String PANPREF_KEY = "TVDVSPANS";
    static final int TEMP_ID = 3;

    public ChartJPanelTVDOffset(JPanelCharts jPanelCharts, SBdb sbdb) {
        super((Chart)null);
        this.parent = jPanelCharts;
        this.sbdb = sbdb;
        this.init();
    }

    private void init() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ChartJPanelTVDOffset.this.mMoved(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ChartJPanelTVDOffset.this.mDragged(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ChartJPanelTVDOffset.this.mReleased(evt);
            }
        });
    }

    public void initChart() {
        System.out.println("Setting up TVDOffset Chart...");
        WellInterp wellInterp = this.parent.getInterp();
        try {
            if (this.chart == null) {
                if (!this.initChartSaved()) {
                    this.chart = new Chart();
                    this.chart.chartProperties.setPanelHeaderHeight(30.0f);
                    this.chart.chartProperties.margin = 3.0f;
                    Well well = this.parent.well;
                    BlockProperties bp = new BlockProperties(BlockProperties.ScaleType.TVD);
                    double topTVD = well.getTVDlist(false).getTopTVD();
                    double baseTVD = well.getTVDlist(false).getBaseTVD();
                    bp.scale = (float)ChartJPanelTVDOffset.getDefaultScale(topTVD, baseTVD, this.parent.getUnits());
                    bp.min = (float)ChartJPanelTVDOffset.getDefaultDepthBound(true, topTVD, baseTVD, this.parent.getUnits());
                    bp.max = (float)ChartJPanelTVDOffset.getDefaultDepthBound(false, topTVD, baseTVD, this.parent.getUnits());
                    WellBlock motherBlock = new WellBlock(null, this.sbdb);
                    motherBlock.prop = bp;
                    motherBlock.prop.units = this.parent.getUnits();
                    this.chart.blocks.add(motherBlock);
                    WellBlock block = new WellBlock(well, this.sbdb);
                    block.prop = bp;
                    block.prop.units = this.parent.getUnits();
                    block.addWellNamePanel();
                    motherBlock.addWellNamePanel();
                    PanelDepth depthPanel = new PanelDepth(this.sbdb, block);
                    block.addPanel(depthPanel);
                    PanelWellVS wellPanel = new PanelWellVS(this.sbdb, block, wellInterp != null ? wellInterp.getHeader().getInterpID() : -1);
                    Point2D.Float defaultVSRange = PanelWellVS.calcDefaultVSRange(block);
                    wellPanel.getProps().minVS = defaultVSRange.x;
                    wellPanel.getProps().maxVS = defaultVSRange.y + extraVS;
                    if (wellInterp != null) {
                        wellPanel.setInterp(wellInterp);
                        wellInterp.addObserver((Observer)this);
                    }
                    wellPanel.tvdList.addObserver((Observer)this);
                    block.addPanel(wellPanel);
                    ChartJPanelTVDOffset.decodePanelTypes(wellInterp, block, this.sbdb, PANPREF_KEY);
                    this.decodeProperties();
                    if (motherBlock.well != null) {
                        motherBlock.addWellNamePanel();
                        if (wellPanel.tvdList.getSize() != 0) {
                            ChartJPanelTVDOffset.decodePanelTypes(wellInterp, motherBlock, this.sbdb, MBPREF_KEY);
                        }
                    }
                    if (!motherBlock.panels.isEmpty()) {
                        this.chart.chartProperties.setPanelHeaderHeight(90.0f);
                    }
                    this.chart.blocks.add(block);
                }
            } else {
                PanelWellVS panelVS = this.getTVDPanelVS();
                WellBlock block = (WellBlock)this.chart.blocks.get(1);
                if (wellInterp != null) {
                    panelVS.setInterp(wellInterp);
                }
                panelVS.setHorzScale(block.getScale());
            }
            this.parent.setJLabelInfoColour(Color.BLACK);
            if (this.getTVDPanelVS().tvdList.getSize() == 0) {
                this.parent.setJLabelInfoText("No deviation survey loaded");
            }
            this.chart.setData();
            if (this.chart.calcChartSize()) {
                this.parent.setChartSizeLabel();
                GUI.setScrollPaneSize(this, this.zoom, 1.5f);
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean initChartSaved() {
        String keybase = WellBlock.getPrefKey(this.parent.well.getWellID(), 3);
        String sql = "SELECT pref_key, pref_value from " + this.sbdb.DBTableName("PREF_USER") + " where user_id=" + this.sbdb.getUser().getUsrID() + " AND pref_key like(" + SB.DBString((String)(keybase + "%")) + ")";
        try {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            LinkedList<Chart.ChartPref> keys = new LinkedList<Chart.ChartPref>();
            while (rs.next()) {
                String key = rs.getString("pref_key");
                String value = rs.getString("pref_value");
                keys.add(new Chart.ChartPref(key, value));
            }
            if (keys.isEmpty()) {
                return false;
            }
            Collections.sort(keys);
            this.chart = new Chart(keys, this.sbdb, this.parent.well.getWellID(), this.parent.getInterp().getHeader());
            if (this.chart.blocks.size() > 1) {
                WellBlock motherBlock = this.chart.getWellBlock();
                ChartBlock block = (WellBlock)this.chart.blocks.get(1);
                PanelWellVS panel = null;
                for (SBPanel p : ((WellBlock)block).panels) {
                    if (!(p instanceof PanelWellVS)) continue;
                    panel = (PanelWellVS)p;
                }
                if (panel != null) {
                    int motherID = panel.getProperties().getMotherID();
                    motherBlock.well = this.sbdb.getAddWell(motherID);
                }
            } else if (this.chart.blocks.isEmpty()) {
                WellBlock block = new WellBlock(this.parent.well, this.sbdb);
                block.addPanel(new PanelWellVS(this.sbdb, block, this.parent.getInterp() != null ? this.parent.getInterp().getHeader().getInterpID() : -1));
                this.chart.blocks.add(block);
            }
            for (ChartBlock block : this.chart.blocks) {
                if (block instanceof WellBlock) {
                    ((WellBlock)block).addWellNamePanel();
                }
                block.addObserver(this);
            }
            return this.getTVDPanelVS() != null;
        }
        catch (SQLException sqle) {
            FrameJsbugs.showStackError("Error loading saved TVD/offset chart", sqle, this.sbdb);
            return false;
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error loading saved TVD/offset chart", (Exception)((Object)sbe));
            return false;
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
            return false;
        }
    }

    private void mMoved(MouseEvent evt) {
        try {
            String string;
            Point2D.Float cursorLoc = (Point2D.Float)this.getPoint(evt.getPoint());
            PanelWellVS vspanel = this.getTVDPanelVS();
            Point2D.Float panelOrigin = this.chart.getPanelOrigin(vspanel, true, this.getMode(), 0.0f);
            this.parent.setJLabelInfoColour(Color.BLACK);
            if (vspanel.tvdList.getSize() == 0) {
                string = "No deviation survey loaded";
            } else {
                string = this.getTooltip(evt);
                if (string != null && string.startsWith("PanelWellVS")) {
                    double dd;
                    string = "TVD: " + SB.getDepthString((double)vspanel.getTVDfromPoint(cursorLoc.y - panelOrigin.y), (char)vspanel.block.well.getWellUnits(), (int)2);
                    float vs = vspanel.getVSfromPoint(cursorLoc.x);
                    if (vs >= 0.0f) {
                        string = string + "   VS: " + SB.getDepthString((double)vs, (char)vspanel.block.well.getWellUnits(), (int)2);
                    }
                    if ((dd = vspanel.calcDDepth(cursorLoc, this.zoom, this.chart.chartProperties, this.getMode())) > 0.0) {
                        string = string + "   DD: " + SB.getDepthString((double)dd, (char)vspanel.block.well.getWellUnits(), (int)2);
                        if (vspanel.getProps().drawEvents && vspanel.getInterp() != null && vspanel.getInterp().getEvents() != null) {
                            for (WellEvent e : vspanel.getInterp().getEventsByDepth()) {
                                if (!(dd < e.getSample().getDepth() + (double)(2.0f / this.zoom)) || !(dd > e.getSample().getDepth() - (double)(2.0f / this.zoom))) continue;
                                string = string + "  Event: " + e.toString(true, true, false);
                                break;
                            }
                        }
                    }
                }
            }
            this.parent.setJLabelInfoText(string);
            if (vspanel.predictPoint != null && !this.getRubberBand()) {
                float cursorY = cursorLoc.y - panelOrigin.y;
                if (cursorY <= vspanel.predictPoint.y + 2.0f && cursorY >= vspanel.predictPoint.y - 2.0f && cursorLoc.x <= vspanel.predictPoint.x + 2.0f && cursorLoc.x >= vspanel.predictPoint.x - 2.0f) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    this.predictPointDraggable = true;
                } else {
                    this.setCursor(Cursor.getDefaultCursor());
                    this.predictPointDraggable = false;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void mDragged(MouseEvent evt) {
        try {
            if (this.predictPointDraggable) {
                Point2D.Float mmPoint;
                PanelWellVS vspanel = this.getTVDPanelVS();
                Point2D.Float p1 = vspanel.lastNodePoint;
                Point2D pTemp = this.getPoint(evt.getPoint());
                this.offsetPredictPoint = mmPoint = new Point2D.Float((float)pTemp.getX(), (float)pTemp.getY());
                Graphics g = this.getGraphics();
                AffineTransform tf = this.setRubberBandMode(g);
                this.setCursor(Cursor.getPredefinedCursor(12));
                if (this.lastDragPoint != null) {
                    this.drawLine(g, p1, this.lastDragPoint);
                }
                this.drawLine(g, p1, mmPoint);
                this.lastDragPoint = mmPoint;
                this.mMoved(evt);
                this.clearRubberBandMode(g, tf);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mReleased(MouseEvent evt) {
        try {
            if (evt.isPopupTrigger()) {
                this.parent.TVDOffsetPopup(evt);
            } else if (this.offsetPredictPoint != null) {
                Point evtPoint = evt.getPoint();
                Point2D.Float mmPoint = (Point2D.Float)this.getPoint(evtPoint);
                PanelWellVS panelvs = this.getTVDPanelVS();
                Point2D.Float panelOrigin = this.chart.getPanelOrigin(panelvs, true, this.getMode(), 0.0f);
                mmPoint.setLocation(mmPoint.x, mmPoint.y - panelOrigin.y);
                if (!panelvs.setPredictPoint(mmPoint)) {
                    JOptionPane.showMessageDialog(this, "Vertical section must be greater than last point on deviation survey", this.parent.parent.getTitle(), 0);
                }
                this.repaint();
                this.offsetPredictPoint = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.repaint();
        }
    }

    private PanelWellVS getTVDPanelVS() {
        if (this.chart.blocks.size() > 1) {
            WellBlock block = (WellBlock)this.chart.blocks.get(1);
            for (SBPanel panel : block.panels) {
                if (!(panel instanceof PanelWellVS)) continue;
                PanelWellVS panelVS = (PanelWellVS)panel;
                return panelVS;
            }
        }
        return null;
    }

    @Override
    public void chartProperties() {
        WellBlock block = (WellBlock)this.chart.blocks.get(1);
        WellBlock motherBlock = (WellBlock)this.chart.blocks.get(0);
        PanelWellVS panelVS = this.getTVDPanelVS();
        try {
            DialogTVDOffsetChart dialog = new DialogTVDOffsetChart(this.parent.getParentFrame(), this.parent.parentPanel, true, this.sbdb, this.chart, block, motherBlock);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.initChart();
                this.encodeProperties();
                ChartJPanelTVDOffset.encodePanelTypes(block, this.sbdb, PANPREF_KEY);
                ChartJPanelTVDOffset.encodePanelTypes(motherBlock, this.sbdb, MBPREF_KEY);
                this.repaint();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.parent.parent, e.getMessage(), this.parent.parent.getTitle(), 0);
            e.printStackTrace();
        }
    }

    public void encodeProperties() {
        System.out.println("Encoding chart properties...");
        String string = new String();
        String[] props = new String[1];
        WellBlock motherBlock = (WellBlock)this.chart.blocks.get(0);
        props[0] = "" + (motherBlock.well != null ? motherBlock.well.getWellID() : -1);
        for (String prop : props) {
            string = string + prop + "|";
        }
        try {
            Lastval.putString((SBdb)this.sbdb, (String)PREF_KEY, (String)string);
            this.sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void encodeMotherborePanels() {
        String string = new String();
        if (!((WellBlock)this.chart.blocks.get((int)0)).panels.isEmpty()) {
            for (SBPanel panel : ((WellBlock)this.chart.blocks.get((int)0)).panels) {
                int igdtype = -1;
                int schid = -1;
                int interpid = -1;
                if (panel instanceof PanelZones) {
                    PanelZones panelZones = (PanelZones)panel;
                    igdtype = panelZones.igdType;
                    interpid = panelZones.interpID;
                    if (panelZones instanceof PanelBiozones) {
                        schid = ((PanelBiozones)panelZones).schID;
                    }
                    string = string + igdtype + "^" + schid + "^" + interpid;
                } else if (panel instanceof PanelEvents) {
                    PanelEvents panelEvents = (PanelEvents)panel;
                    igdtype = 20;
                    string = string + igdtype + "^" + schid + "^" + panelEvents.interpID;
                }
                string = string + "|";
            }
        }
        try {
            Lastval.putString((SBdb)this.sbdb, (String)MBPREF_KEY, (String)string);
            this.sbdb.commit();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Exception : " + e.getMessage(), this.parent.parent.getTitle(), 1);
            e.printStackTrace();
        }
    }

    public void decodeProperties() {
        System.out.println("Decoding TVDOffset chart properties...");
        try {
            String params = Lastval.getString((SBdb)this.sbdb, (String)PREF_KEY);
            if (params.isEmpty()) {
                System.out.println("params is empty: " + params);
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            if (tok.hasMoreTokens()) {
                int tokval = Integer.parseInt(tok.nextToken());
                if (tokval >= 0) {
                    Well motherWell = this.sbdb.getProject(0).getWell(this.sbdb, tokval);
                    motherWell.loadInterps();
                    ((WellBlock)this.chart.blocks.get((int)0)).well = motherWell;
                } else {
                    ((WellBlock)this.chart.blocks.get((int)0)).well = null;
                }
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.parent.parent, ex.getMessage(), this.parent.parent.getTitle(), 0);
            ex.printStackTrace();
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog(this.parent.parent, sbe.getMessage(), this.parent.parent.getTitle(), 0);
            sbe.printStackTrace();
        }
    }

    public void decodeMotherborePanels() {
        System.out.println("Decoding TVDOffset chart motherbore panels...");
        WellBlock block = (WellBlock)this.chart.blocks.get(0);
        try {
            String params = Lastval.getString((SBdb)this.sbdb, (String)MBPREF_KEY);
            StringTokenizer tok = new StringTokenizer(params, "|");
            while (tok.hasMoreTokens()) {
                String paneltoken = tok.nextToken();
                StringTokenizer paneltok = new StringTokenizer(paneltoken, "^");
                int igdtype = -1;
                int schid = -1;
                WellInterp interp = null;
                if (paneltok.hasMoreTokens()) {
                    igdtype = Integer.parseInt(paneltok.nextToken());
                }
                if (paneltok.hasMoreTokens()) {
                    schid = Integer.parseInt(paneltok.nextToken());
                }
                if (paneltok.hasMoreTokens()) {
                    String token = paneltok.nextToken();
                    block.well.loadInterps();
                    interp = block.well.getInterp(Integer.parseInt(token));
                }
                if (igdtype < 0 || interp == null) continue;
                block.addIGDPanel(igdtype, schid, interp, false);
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.parent.parent, ex.getMessage(), this.parent.parent.getTitle(), 0);
            ex.printStackTrace();
        }
        catch (SBException sbe) {
            JOptionPane.showMessageDialog(this.parent.parent, sbe.getMessage(), this.parent.parent.getTitle(), 0);
            sbe.printStackTrace();
        }
    }
}

