/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.Date;
import java.util.StringTokenizer;
import model2.Lastval;
import model2.SBdb;
import util.AgeFormat;

public class ChartProperties {
    float margin = 0.0f;
    float panelCaptionHeight = 10.0f;
    private float panelHeaderHeight = 150.0f;
    float panelSubHeaderHeight = this.panelHeaderHeight - this.panelCaptionHeight;
    String font = "Arial";
    float fontHeader = 5.0f;
    float fontPanel = 4.0f;
    float fontSmall = 3.0f;
    float fontTiny = 2.0f;
    static final float linePanelFrame = 0.35f;
    static final float linePanelInternal = 0.2f;
    static final float linePanelThinInternal = 0.1f;
    boolean correctCuttings = false;
    boolean correctDepths = true;
    AgeFormat ageFormat = AgeFormat.MA;
    Date chartGenDate = null;

    public ChartProperties() {
    }

    public ChartProperties(ChartProperties rhs) {
        this.copy(rhs);
    }

    final void copy(ChartProperties rhs) {
        this.fontHeader = rhs.fontHeader;
        this.fontPanel = rhs.fontPanel;
        this.fontSmall = rhs.fontSmall;
        this.fontTiny = rhs.fontTiny;
        this.panelHeaderHeight = rhs.panelHeaderHeight;
        this.panelCaptionHeight = rhs.panelCaptionHeight;
        this.panelSubHeaderHeight = rhs.panelSubHeaderHeight;
        this.panelCaptionHeight = rhs.panelCaptionHeight;
        this.margin = rhs.margin;
        this.correctCuttings = rhs.correctCuttings;
        this.correctDepths = rhs.correctDepths;
        this.font = rhs.font;
    }

    public ChartProperties(SBdb sbdb, String decodeString, int margin) {
        this.margin = margin;
        try {
            String params = Lastval.getString((SBdb)sbdb, (String)decodeString);
            if (params.isEmpty()) {
                this.setPanelHeaderHeight(90.0f);
                this.setPanelCaptionHeight(this.fontHeader * 2.0f);
                return;
            }
            StringTokenizer tok = new StringTokenizer(params, "|");
            if (tok.hasMoreTokens()) {
                this.fontHeader = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.fontPanel = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.fontSmall = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.fontTiny = Float.parseFloat(tok.nextToken());
            }
            if (tok.hasMoreTokens()) {
                this.setPanelSubHeaderHeight(Float.parseFloat(tok.nextToken()));
            }
            if (tok.hasMoreTokens()) {
                this.setPanelCaptionHeight(Float.parseFloat(tok.nextToken()));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void encode(SBdb sbdb, String encodeString) {
        String string = new String();
        String[] props = new String[]{"" + this.fontHeader, "" + this.fontPanel, "" + this.fontSmall, "" + this.fontTiny, "" + this.panelSubHeaderHeight, "" + this.panelCaptionHeight};
        for (String prop : props) {
            string = string + prop + "|";
        }
        try {
            Lastval.putString((SBdb)sbdb, (String)encodeString, (String)string);
            sbdb.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void setSubHeaderHeight() {
        this.panelSubHeaderHeight = this.panelHeaderHeight - this.panelCaptionHeight;
    }

    float getPanelHeaderHeight() {
        return this.panelHeaderHeight;
    }

    boolean setPanelCaptionHeight(float panelCaptionHeight) {
        boolean changed = (double)Math.abs(this.panelCaptionHeight - panelCaptionHeight) > 0.001;
        this.panelCaptionHeight = panelCaptionHeight;
        this.setSubHeaderHeight();
        return changed;
    }

    void setPanelHeaderHeight(float panelHeaderHeight) {
        this.panelHeaderHeight = panelHeaderHeight;
        this.setSubHeaderHeight();
    }

    boolean setPanelSubHeaderHeight(float panelSubHeaderHeight) {
        boolean changed = (double)Math.abs(this.panelSubHeaderHeight - panelSubHeaderHeight) > 0.001;
        this.panelSubHeaderHeight = panelSubHeaderHeight;
        this.panelHeaderHeight = panelSubHeaderHeight + this.panelCaptionHeight;
        return changed;
    }

    void setMargin(float margin) {
        this.margin = margin;
    }

    public boolean setFontSizes(float header, float panel, float small, float tiny) {
        boolean change = false;
        if (this.fontHeader != header) {
            change = true;
            this.fontHeader = header;
        }
        if (this.fontPanel != panel) {
            change = true;
            this.fontPanel = panel;
        }
        if (this.fontSmall != small) {
            change = true;
            this.fontSmall = small;
        }
        if (this.fontTiny != tiny) {
            change = true;
            this.fontTiny = tiny;
        }
        return change;
    }

    float getBlockTop() {
        return this.panelHeaderHeight + this.margin;
    }

    String getProperties() {
        String string = new String();
        String[] props = new String[]{this.font, "" + this.fontHeader, "" + this.fontPanel, "" + this.fontSmall, "" + this.fontTiny, "" + (this.correctDepths ? 1 : 0), "" + (this.correctCuttings ? 1 : 0), "" + this.panelCaptionHeight, "" + this.panelHeaderHeight, "" + this.margin};
        for (String prop : props) {
            string = string + prop + "|";
        }
        return string;
    }

    public ChartProperties(String props) {
        String[] split = props.split("\\|");
        block12: for (int i = 0; i < split.length; ++i) {
            switch (i) {
                case 0: {
                    this.font = split[i];
                    continue block12;
                }
                case 1: {
                    this.fontHeader = Float.parseFloat(split[i]);
                    continue block12;
                }
                case 2: {
                    this.fontPanel = Float.parseFloat(split[i]);
                    continue block12;
                }
                case 3: {
                    this.fontSmall = Float.parseFloat(split[i]);
                    continue block12;
                }
                case 4: {
                    this.fontTiny = Float.parseFloat(split[i]);
                    continue block12;
                }
                case 5: {
                    this.correctDepths = Integer.parseInt(split[i]) == 1;
                    continue block12;
                }
                case 6: {
                    this.correctCuttings = Integer.parseInt(split[i]) == 1;
                    continue block12;
                }
                case 7: {
                    this.panelCaptionHeight = Float.parseFloat(split[i]);
                    continue block12;
                }
                case 8: {
                    this.panelHeaderHeight = Float.parseFloat(split[i]);
                    continue block12;
                }
                case 9: {
                    this.margin = Float.parseFloat(split[i]);
                }
            }
        }
        this.setSubHeaderHeight();
    }

    public float getFontSize(FontSize fontSize) {
        switch (fontSize) {
            case PANEL: {
                return this.fontPanel;
            }
            case SMALL: {
                return this.fontSmall;
            }
            case TINY: {
                return this.fontTiny;
            }
        }
        assert (false);
        return 0.0f;
    }

    boolean setFont(String font) {
        if (font.equalsIgnoreCase(this.font)) {
            return false;
        }
        this.font = font;
        return true;
    }

    boolean setCorrections(boolean correctDepths, boolean correctCuttings) {
        boolean changed = this.correctCuttings != correctCuttings || this.correctDepths != correctDepths;
        this.correctDepths = correctDepths;
        this.correctCuttings = correctCuttings;
        return changed;
    }

    boolean setAgeFormat(AgeFormat format) {
        boolean changed = this.ageFormat != format;
        this.ageFormat = format;
        return changed;
    }

    public static enum FontSize {
        PANEL,
        SMALL,
        TINY;

    }
}

