/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import jsbugs.Jsbugs;
import util.SB;

public class ConnectionParameters {
    static final String cryptKey = "SBPREFPW";
    String name;
    String driverName;
    String hostName;
    String sbchartODBC;
    String instanceName;
    String UID;
    String pwd;
    String sbUID;
    String sbPwd;
    boolean isSingle = false;
    boolean isDefault = false;
    boolean SQLServerIntegratedSecurity = false;
    String oldName = null;

    public static List<ConnectionParameters> getConnections() {
        LinkedList<ConnectionParameters> connections = new LinkedList<ConnectionParameters>();
        Preferences rootPref = Preferences.userNodeForPackage(Jsbugs.class).node("v2.0");
        try {
            String[] sbConnections;
            String defaultConnection = rootPref.get("sbdsn", null);
            for (String s : sbConnections = rootPref.childrenNames()) {
                ConnectionParameters parms = new ConnectionParameters();
                parms.name = s;
                Preferences pref = rootPref.node(s);
                parms.UID = pref.get("uid", null);
                String pwd = pref.get("pwd", null);
                try {
                    parms.pwd = pwd != null ? SB.crypt((boolean)false, (String)cryptKey, (String)pwd) : null;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                parms.hostName = pref.get("host", null);
                parms.sbchartODBC = pref.get("sbchartodbc", null);
                parms.driverName = pref.get("driver", null);
                parms.instanceName = pref.get("instance", null);
                parms.isSingle = pref.getBoolean("issingle", false);
                parms.SQLServerIntegratedSecurity = pref.getBoolean("sqlintsec", false);
                parms.sbUID = pref.get("sbuid", null);
                String sbPwd = pref.get("sbpwd", null);
                try {
                    parms.sbPwd = sbPwd != null ? SB.crypt((boolean)false, (String)cryptKey, (String)sbPwd) : null;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (s.equalsIgnoreCase(defaultConnection)) {
                    parms.isDefault = true;
                }
                connections.add(parms);
            }
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
        return connections;
    }

    public void clear() {
        Preferences rootPref = Preferences.userNodeForPackage(Jsbugs.class).node("v2.0");
        if (rootPref != null) {
            try {
                if (rootPref.nodeExists(this.name)) {
                    Preferences node = rootPref.node(this.name);
                    node.removeNode();
                }
            }
            catch (BackingStoreException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void putSilent(boolean silent) {
        Preferences rootPref = Preferences.userNodeForPackage(Jsbugs.class).node("v2.0");
        rootPref.putBoolean("silent", silent);
    }

    public static void putSilentSBLogin(boolean silent) {
        Preferences rootPref = Preferences.userNodeForPackage(Jsbugs.class).node("v2.0");
        rootPref.putBoolean("silentsblogin", silent);
    }

    public void putSBLogin() throws BackingStoreException {
        Preferences rootPref = Preferences.userNodeForPackage(Jsbugs.class).node("v2.0");
        Preferences pref = rootPref.node(this.name);
        if (this.sbUID != null && this.sbUID.length() > 0) {
            pref.put("sbuid", this.sbUID);
        } else {
            pref.remove("sbuid");
        }
        if (this.sbPwd != null && this.sbPwd.length() > 0) {
            pref.put("sbpwd", SB.crypt((boolean)true, (String)cryptKey, (String)this.sbPwd));
        } else {
            pref.remove("sbpwd");
        }
        pref.flush();
    }

    public void put(boolean storeUID) throws BackingStoreException {
        Preferences rootPref = Preferences.userNodeForPackage(Jsbugs.class).node("v2.0");
        rootPref.put("sbdsn", this.name);
        if (this.oldName != null) {
            rootPref.node(this.oldName).removeNode();
            this.oldName = null;
        }
        Preferences pref = rootPref.node(this.name);
        if (this.driverName != null && this.driverName.length() > 0) {
            pref.put("driver", this.driverName);
        } else {
            pref.remove("driver");
        }
        if (this.hostName != null && this.hostName.length() > 0) {
            pref.put("host", this.hostName);
        } else {
            pref.remove("host");
        }
        if (this.sbchartODBC != null && this.sbchartODBC.length() > 0) {
            pref.put("sbchartodbc", this.sbchartODBC);
        } else {
            pref.remove("sbchartodbc");
        }
        if (this.instanceName != null && this.instanceName.length() > 0) {
            pref.put("instance", this.instanceName);
        } else {
            pref.remove("instance");
        }
        if (storeUID) {
            if (this.UID != null && this.UID.length() > 0) {
                pref.put("uid", this.UID);
            } else {
                pref.remove("uid");
            }
            if (this.pwd != null && this.pwd.length() > 0) {
                pref.put("pwd", SB.crypt((boolean)true, (String)cryptKey, (String)this.pwd));
            } else {
                pref.remove("pwd");
            }
        } else {
            pref.remove("uid");
            pref.remove("pwd");
        }
        if (this.isSingle) {
            pref.putBoolean("issingle", true);
        } else {
            pref.putBoolean("issingle", false);
        }
        pref.putBoolean("sqlintsec", this.SQLServerIntegratedSecurity);
        pref.flush();
    }

    public String toString() {
        return this.name;
    }
}

