/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.ChartProperties;
import jsbugs.DialogChartFont;
import jsbugs.DialogPanelBiocoms;
import jsbugs.DialogPanelChromalog;
import jsbugs.DialogPanelDepth;
import jsbugs.DialogPanelEnv;
import jsbugs.DialogPanelEvents;
import jsbugs.DialogPanelIntLith;
import jsbugs.DialogPanelIntcoms;
import jsbugs.DialogPanelSamples;
import jsbugs.DialogPanelTaxonGroup;
import jsbugs.DialogPanelZones;
import jsbugs.DialogSelectIGDPanel;
import jsbugs.DialogWirelineLogPanel;
import jsbugs.FrameJsbugs;
import jsbugs.PanelBiocoms;
import jsbugs.PanelChromalog;
import jsbugs.PanelCoreImages;
import jsbugs.PanelDepth;
import jsbugs.PanelEnv;
import jsbugs.PanelEvents;
import jsbugs.PanelEventsBase;
import jsbugs.PanelIntLith;
import jsbugs.PanelIntcoms;
import jsbugs.PanelSQPicks;
import jsbugs.PanelSamples;
import jsbugs.PanelTaxonGroup;
import jsbugs.PanelWirelineLog;
import jsbugs.PanelZones;
import jsbugs.SBDialog;
import jsbugs.SBPanel;
import jsbugs.SBPanelHdr;
import jsbugs.SbugsFocusTraversalPolicy;
import jsbugs.WellBlock;
import model2.SBdb;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsInputVerifier;

public class DialogAHDchart
extends SBDialog {
    private static final int DEPTHLEN = 8;
    private final WellBlock block;
    private char units;
    private final SBdb db;
    private final DefaultComboBoxModel scaleModel = new DefaultComboBoxModel();
    private final DefaultListModel panelModel = new DefaultListModel();
    private final ChartProperties cp;
    private final WellInterp wellInterp;
    private final JFrame parent;
    SbugsFocusTraversalPolicy focusPolicy = null;
    boolean ahdDepthsSet = false;
    private ButtonGroup buttonGroupAgeAxis;
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonAddPanel;
    private JButton jButtonCancel;
    private JButton jButtonFonts;
    private JButton jButtonHelp;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonOK;
    private JButton jButtonProperties;
    private JButton jButtonRemovePanel;
    private JComboBox jComboBoxVerticalScale;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JList jListPanels;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField jTextFieldBaseDepth;
    private JTextField jTextFieldTopDepth;

    public DialogAHDchart(JFrame parent, boolean modal, SBdb db, WellBlock block, ChartProperties cp, WellInterp wellInterp) throws SQLException {
        super((Frame)parent, modal);
        this.parent = parent;
        this.block = block;
        this.db = db;
        this.cp = cp;
        this.wellInterp = wellInterp;
        this.initComponents();
        this.init();
        this.initFocus();
    }

    private void init() throws SQLException {
        this.jTextFieldTopDepth.setText(SB.floatString((float)SB.convFromM((float)this.block.getTopDepth(), (char)this.block.prop.units, (char)this.block.well.getType()), (int)2));
        this.jTextFieldBaseDepth.setText(SB.floatString((float)SB.convFromM((float)this.block.getBaseDepth(), (char)this.block.prop.units, (char)this.block.well.getType()), (int)2));
        ((JTextField)this.jComboBoxVerticalScale.getEditor().getEditorComponent()).setInputVerifier((InputVerifier)new SbugsInputVerifier(1.0f, 100000.0f, (float)((int)this.block.getScale())));
        this.db.getChartScales(this.scaleModel);
        String sScale = Integer.toString((int)this.block.getScale());
        if (this.scaleModel.getIndexOf(sScale) < 0) {
            this.scaleModel.addElement(sScale);
        }
        this.scaleModel.setSelectedItem(sScale);
        if (this.block.prop.units == 'F') {
            this.jRadioButtonFeet.setSelected(true);
        } else {
            this.jRadioButtonMetres.setSelected(true);
        }
        this.units = this.block.prop.units;
        this.setTitle("Along Hole Depth Chart Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.refreshPanelList();
        this.enablePanelProperties();
    }

    private void initFocus() {
        LinkedList<Component> focusOrder = new LinkedList<Component>();
        focusOrder.add(this.jTextFieldTopDepth);
        focusOrder.add(this.jTextFieldBaseDepth);
        focusOrder.add(this.jComboBoxVerticalScale);
        focusOrder.add(this.jRadioButtonMetres);
        focusOrder.add(this.jRadioButtonFeet);
        focusOrder.add(this.jButtonFonts);
        focusOrder.add(this.jListPanels);
        focusOrder.add(this.jButtonAddPanel);
        focusOrder.add(this.jButtonRemovePanel);
        focusOrder.add(this.jButtonMoveUp);
        focusOrder.add(this.jButtonMoveDown);
        focusOrder.add(this.jButtonProperties);
        focusOrder.add(this.jButtonOK);
        focusOrder.add(this.jButtonHelp);
        focusOrder.add(this.jButtonCancel);
        this.focusPolicy = new SbugsFocusTraversalPolicy(focusOrder);
        this.setFocusTraversalPolicy(this.focusPolicy);
    }

    private void refreshPanelList() {
        if (!this.panelModel.isEmpty()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (SBPanel panel : this.block.panels) {
                if (this.panelModel.contains(panel)) continue;
                try {
                    this.block.setData(panel, this.cp);
                }
                catch (SBException sbe) {
                    SB.showStackError((String)"Error", (Exception)((Object)sbe));
                }
                catch (IOException e) {
                    SB.showStackError((String)"I/O Error", (Exception)e);
                }
                catch (SQLException sql) {
                    FrameJsbugs.showStackError("SQL Error", sql, this.db);
                }
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.panelModel.clear();
        for (SBPanel panel : this.block.panels) {
            this.panelModel.addElement(panel);
        }
        for (SBPanelHdr hdr : this.block.headers) {
            this.panelModel.addElement(hdr);
        }
        this.jListPanels.repaint();
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupAgeAxis = new ButtonGroup();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jComboBoxVerticalScale = new JComboBox();
        this.jTextFieldTopDepth = new JTextField();
        this.jTextFieldBaseDepth = new JTextField();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListPanels = new JList();
        this.jLabel4 = new JLabel();
        this.jButtonRemovePanel = new JButton();
        this.jButtonFonts = new JButton();
        this.jButtonAddPanel = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jButtonProperties = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(465, 420));
        this.setModal(true);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAHDchart.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAHDchart.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Top depth:");
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Base depth:");
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("Scale:");
        this.jComboBoxVerticalScale.setEditable(true);
        this.jComboBoxVerticalScale.setModel(this.scaleModel);
        this.jTextFieldTopDepth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogAHDchart.this.jTextFieldTopDepthKeyTyped(evt);
            }
        });
        this.jTextFieldBaseDepth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogAHDchart.this.jTextFieldBaseDepthKeyTyped(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Depth units", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setSelected(true);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAHDchart.this.jRadioButtonMetresActionPerformed(evt);
            }
        });
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jRadioButtonFeet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAHDchart.this.jRadioButtonFeetActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonMetres).addPreferredGap(1).add((Component)this.jRadioButtonFeet).addContainerGap(22, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonMetres).add((Component)this.jRadioButtonFeet)));
        this.jListPanels.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.jListPanels.setModel(this.panelModel);
        this.jListPanels.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogAHDchart.this.jListPanelsMouseClicked(evt);
            }
        });
        this.jListPanels.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DialogAHDchart.this.jListPanelsKeyReleased(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListPanels);
        this.jLabel4.setText("Panels:");
        this.jButtonRemovePanel.setText("Remove");
        this.jButtonRemovePanel.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonRemovePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAHDchart.this.jButtonRemovePanelActionPerformed(evt);
            }
        });
        this.jButtonFonts.setText("Options...");
        this.jButtonFonts.setToolTipText("Chart display options, including fonts and core corrections");
        this.jButtonFonts.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonFonts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAHDchart.this.jButtonFontsActionPerformed(evt);
            }
        });
        this.jButtonAddPanel.setText("Add...");
        this.jButtonAddPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAHDchart.this.jButtonAddPanelActionPerformed(evt);
            }
        });
        this.jButtonMoveUp.setText("Move up");
        this.jButtonMoveUp.setToolTipText("Panel moves left in chart");
        this.jButtonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAHDchart.this.jButtonMoveUpActionPerformed(evt);
            }
        });
        this.jButtonMoveDown.setText("Move down");
        this.jButtonMoveDown.setToolTipText("Panel moves right in chart");
        this.jButtonMoveDown.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAHDchart.this.jButtonMoveDownActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAHDchart.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonProperties.setText("Properties..");
        this.jButtonProperties.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAHDchart.this.jButtonPropertiesActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jLabel1).add(2, (Component)this.jLabel2).add(2, (Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jTextFieldTopDepth).add(1, (Component)this.jTextFieldBaseDepth, -2, 106, -2)).add(2, (Component)this.jComboBoxVerticalScale, -2, 106, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonFonts, -2, 75, -2).addContainerGap()))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).add(410, 410, 410)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator2).add((Component)this.jSeparator1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).add(6, 6, 6).add((Component)this.jButtonCancel)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonMoveDown, -2, 79, -2).add((Component)this.jButtonMoveUp, -2, 79, -2).add((Component)this.jButtonRemovePanel, -2, 79, -2).add((Component)this.jButtonAddPanel, -2, 79, -2).add((Component)this.jButtonProperties, -2, 79, -2)))).addContainerGap()))));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldTopDepth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldBaseDepth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jComboBoxVerticalScale, -2, -1, -2).add((Component)this.jButtonFonts))).add((Component)this.jPanel1, -2, -1, -2)).addPreferredGap(1).add((Component)this.jSeparator2, -2, 7, -2).addPreferredGap(0).add((Component)this.jLabel4).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAddPanel).addPreferredGap(0).add((Component)this.jButtonRemovePanel).addPreferredGap(0).add((Component)this.jButtonMoveUp).addPreferredGap(0).add((Component)this.jButtonMoveDown).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonProperties)).add((Component)this.jScrollPane1, -1, 191, Short.MAX_VALUE)).add(18, 18, 18).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        boolean change = false;
        assert (this.units == (this.jRadioButtonFeet.isSelected() ? (char)'F' : 'M'));
        if (this.block.prop.setUnits(this.units)) {
            change = true;
        }
        float topDepth = (float)SB.convToM((double)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)this.units, (char)this.block.well.getType());
        float baseDepth = (float)SB.convToM((double)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)this.units, (char)this.block.well.getType());
        float scale = Float.parseFloat("" + this.jComboBoxVerticalScale.getSelectedItem());
        if (topDepth > baseDepth) {
            if (this.block.well.getType() == 'W') {
                JOptionPane.showMessageDialog(this, "Top depth is greater than base depth", this.getTitle(), 2);
            } else {
                JOptionPane.showMessageDialog(this, "Top depth is less than base depth", this.getTitle(), 2);
            }
            return;
        }
        if ((double)Math.abs(this.block.getTopDepth() - topDepth) > 0.001 || (double)Math.abs(this.block.getBaseDepth() - baseDepth) > 0.001) {
            this.ahdDepthsSet = true;
        }
        if (this.block.prop.setLimits(topDepth, baseDepth)) {
            change = true;
        }
        if (scale == 0.0f) {
            scale = baseDepth - topDepth;
        }
        if (this.block.prop.setScale(scale)) {
            change = true;
        }
        if (change) {
            this.setOK();
        } else {
            this.dispose();
        }
    }

    private void jTextFieldTopDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTopDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBaseDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        this.setUnits();
    }

    private void jButtonRemovePanelActionPerformed(ActionEvent evt) {
        Object[] panels;
        if (this.jListPanels.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No panel selected", this.getTitle(), 1);
            return;
        }
        for (Object o : panels = this.jListPanels.getSelectedValues()) {
            if (o instanceof SBPanel) {
                SBPanel panel = (SBPanel)o;
                this.block.panels.remove(panel);
                this.panelModel.removeElement(panel);
                this.block.removedPanels.add(panel);
                continue;
            }
            if (!(o instanceof SBPanelHdr)) continue;
            SBPanelHdr hdr = (SBPanelHdr)o;
            this.block.headers.remove(hdr);
            this.panelModel.removeElement(hdr);
        }
        this.jListPanels.updateUI();
    }

    private void jButtonFontsActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        DialogChartFont dialog = new DialogChartFont(this, true, this.cp);
        dialog.setLocationRelativeTo(this);
        this.setCursor(Cursor.getDefaultCursor());
        dialog.setVisible(true);
        if (dialog.isOK()) {
            try {
                this.block.setData(this.cp);
            }
            catch (SBException sbe) {
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (IOException e) {
                SB.showStackError((String)"I/O Error", (Exception)e);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
        } else {
            System.out.println("no changes to chartproperts");
        }
    }

    private void jButtonAddPanelActionPerformed(ActionEvent evt) {
        DialogSelectIGDPanel dialog = new DialogSelectIGDPanel(this, true, this.db, this.block, null, "Select panels", this.wellInterp);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.refreshPanelList();
        }
    }

    private void jButtonMoveUpActionPerformed(ActionEvent evt) {
        this.getOnePanel(this.jListPanels.getSelectedIndices().length);
        this.movePanel(true, this.jListPanels.getSelectedIndex());
    }

    private void jButtonMoveDownActionPerformed(ActionEvent evt) {
        this.getOnePanel(this.jListPanels.getSelectedIndices().length);
        this.movePanel(false, this.jListPanels.getSelectedIndex());
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogahdchart.html");
    }

    private void jButtonPropertiesActionPerformed(ActionEvent evt) {
        if (this.jListPanels.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "No panel selected", this.getTitle(), 1);
            return;
        }
        if (this.jListPanels.getSelectedValues().length > 1) {
            JOptionPane.showMessageDialog(this, "Select one panel", this.getTitle(), 1);
            return;
        }
        Object panel = this.jListPanels.getSelectedValue();
        SBDialog dialog = null;
        if (panel instanceof PanelWirelineLog) {
            PanelWirelineLog logPanel = (PanelWirelineLog)panel;
            dialog = new DialogWirelineLogPanel(this, true, logPanel, this.block, this.db);
        } else if (panel instanceof PanelTaxonGroup) {
            PanelTaxonGroup taxonPanel = (PanelTaxonGroup)panel;
            dialog = new DialogPanelTaxonGroup((Dialog)this, true, taxonPanel);
        } else if (panel instanceof PanelEnv) {
            PanelEnv envPanel = (PanelEnv)panel;
            dialog = new DialogPanelEnv(this, true, envPanel, this.db, this.block);
        } else if (panel instanceof PanelEvents) {
            PanelEvents panelEvents = (PanelEvents)panel;
            dialog = new DialogPanelEvents((Dialog)this, true, (PanelEventsBase)panelEvents, this.db);
        } else if (panel instanceof PanelBiocoms) {
            PanelBiocoms panelBiocoms = (PanelBiocoms)panel;
            dialog = new DialogPanelBiocoms((Dialog)this, true, panelBiocoms, this.db);
        } else if (panel instanceof PanelIntcoms) {
            PanelIntcoms panelIntcoms = (PanelIntcoms)panel;
            dialog = new DialogPanelIntcoms((Dialog)this, true, panelIntcoms);
        } else if (panel instanceof PanelIntLith) {
            PanelIntLith panelIntLith = (PanelIntLith)panel;
            dialog = new DialogPanelIntLith((Dialog)this, true, panelIntLith);
        } else if (panel instanceof PanelDepth) {
            PanelDepth panelDepth = (PanelDepth)panel;
            dialog = new DialogPanelDepth((Frame)this.parent, true, panelDepth);
        } else if (panel instanceof PanelZones) {
            dialog = new DialogPanelZones((Dialog)this, true, (PanelZones)panel, this.db);
        } else if (panel instanceof PanelSamples) {
            dialog = new DialogPanelSamples((Dialog)this, true, (PanelSamples)panel, this.db);
        } else if (panel instanceof PanelChromalog) {
            dialog = new DialogPanelChromalog(this, true, (PanelChromalog)panel);
        }
        if (dialog != null) {
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                try {
                    this.block.setData((SBPanel)panel, this.cp);
                }
                catch (Exception e) {
                    SB.showStackError((String)"Error setting panel data: ", (Exception)e);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "No options available for this panel", this.getTitle(), 1);
        }
    }

    private void jListPanelsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonPropertiesActionPerformed(null);
        } else {
            this.enablePanelProperties();
        }
    }

    private void jListPanelsKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40) {
            this.enablePanelProperties();
        }
    }

    private void enablePanelProperties() {
        Object panel = this.jListPanels.getSelectedValue();
        if (panel instanceof PanelWirelineLog || panel instanceof PanelZones || panel instanceof PanelTaxonGroup || panel instanceof PanelEnv || panel instanceof PanelEvents || panel instanceof PanelBiocoms || panel instanceof PanelIntcoms || panel instanceof PanelIntLith || panel instanceof PanelDepth || panel instanceof PanelSamples || panel instanceof PanelSQPicks || panel instanceof PanelChromalog || panel instanceof PanelCoreImages) {
            this.jButtonProperties.setEnabled(true);
        } else {
            this.jButtonProperties.setEnabled(false);
        }
        this.jButtonMoveDown.setEnabled(!(panel instanceof SBPanelHdr));
        this.jButtonMoveUp.setEnabled(!(panel instanceof SBPanelHdr));
    }

    private void setUnits() {
        if (this.jRadioButtonFeet.isSelected() && this.units != 'F') {
            this.units = (char)70;
            try {
                this.jTextFieldTopDepth.setText("" + SB.convFromM((double)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText("" + SB.convFromM((double)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
        } else {
            this.units = (char)77;
            try {
                this.jTextFieldTopDepth.setText("" + SB.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldTopDepth.setText("0.0");
            }
            try {
                this.jTextFieldBaseDepth.setText("" + SB.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)'F'));
            }
            catch (Exception e) {
                this.jTextFieldBaseDepth.setText("0.0");
            }
        }
    }

    private void movePanel(boolean up, int index) {
        if (index == this.block.panels.size() - 1 && !up) {
            JOptionPane.showMessageDialog(this, "Can't move down", this.getTitle(), 2);
            return;
        }
        if (index == 0 && up) {
            JOptionPane.showMessageDialog(this, "Can't move up", this.getTitle(), 2);
            return;
        }
        SBPanel panel = (SBPanel)this.block.panels.get(index);
        this.block.panels.remove(panel);
        this.block.panels.add(up ? index - 1 : index + 1, panel);
        this.refreshPanelList();
        this.jListPanels.setSelectedIndex(up ? index - 1 : index + 1);
    }

    private void getOnePanel(int len) {
        if (len != 1) {
            JOptionPane.showMessageDialog(this, len > 1 ? "Select one panel" : "Select a panel", this.getTitle(), 2);
        }
    }
}

