/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.AbnSchemeTableModel;
import jsbugs.DialogAbnSchemeUsage;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.AbnScheme;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsTable;
import util.TableSorter;

public class DialogAbnScheme
extends SBDialog {
    private final AbnSchemeTableModel model = new AbnSchemeTableModel();
    private final SBdb db;
    AbnScheme origScheme = null;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonInsert;
    private JButton jButtonOK;
    private JButton jButtonRemove;
    private JButton jButtonShowWells;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JTable jTableAbn;
    private JTextField jTextFieldName;

    public DialogAbnScheme(JDialog parent, boolean modal, SBdb db, AbnScheme scheme) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.db = db;
        this.model.scheme = new AbnScheme(scheme);
        if (scheme != null && scheme.getDatabase() == db) {
            this.origScheme = scheme;
        }
        this.init();
    }

    private void init() {
        this.model.parent = this;
        SB.setTableHeaderBold((JTable)this.jTableAbn);
        TableColumnModel columnModel = this.jTableAbn.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(AbnSchemeTableModel.titles[i]);
            columnModel.getColumn(i).setWidth(AbnSchemeTableModel.widths[i]);
        }
        this.jTextFieldName.setText(this.model.scheme.getName());
        this.model.fireTableDataChanged();
        if (this.origScheme != null) {
            this.setTitle("Abundance Scheme : Edit");
        } else {
            this.setTitle("Abundance Scheme : Add");
            this.jButtonShowWells.setEnabled(false);
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jTableAbn = new SbugsTable(new TableSorter((TableModel)this.model));
        this.jButtonAdd = new JButton();
        this.jButtonInsert = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonShowWells = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 300));
        this.setModal(true);
        this.jLabel1.setText("Name :");
        this.jTextFieldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogAbnScheme.this.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jTableAbn.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableAbn);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnScheme.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonInsert.setText("Insert");
        this.jButtonInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnScheme.this.jButtonInsertActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnScheme.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnScheme.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnScheme.this.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnScheme.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonShowWells.setText("Show wells...");
        this.jButtonShowWells.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowWells.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnScheme.this.jButtonShowWellsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldName, -1, 329, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 367, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonHelp, -2, 85, -2).add((Component)this.jButtonCancel, -1, 85, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, 85, Short.MAX_VALUE).add(2, (Component)this.jButtonInsert, -1, 85, Short.MAX_VALUE).add(2, (Component)this.jButtonRemove, -1, 85, Short.MAX_VALUE).add(2, (Component)this.jButtonShowWells).add(2, (Component)this.jButtonAdd, -1, 85, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldName, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonInsert).addPreferredGap(0).add((Component)this.jButtonRemove).add(18, 18, 18).add((Component)this.jButtonShowWells).addPreferredGap(0, 54, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 257, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableAbn.isEditing()) {
            this.jTableAbn.getCellEditor().stopCellEditing();
        }
        try {
            this.model.scheme.setName(this.jTextFieldName.getText().trim());
            if (this.model.scheme.getName().length() == 0) {
                JOptionPane.showMessageDialog(this, "Name is blank", this.getTitle(), 2);
                return;
            }
            try {
                this.model.scheme.checkAndSort();
            }
            catch (InvalidFieldException ife) {
                JOptionPane.showMessageDialog(this, ife.getMessage(), this.getTitle(), 2);
                return;
            }
            if (!this.model.scheme.checkNameUnique(this.db, this.origScheme != null ? this.origScheme.getID() : 0)) {
                JOptionPane.showMessageDialog(this, "Scheme name is already in use", this.getTitle(), 2);
                return;
            }
            if (this.origScheme != null) {
                int occurrences = this.origScheme.getNoccs();
                if (occurrences > 0 && JOptionPane.showConfirmDialog(this, "This scheme is linked to " + occurrences + " analysis suites. Are you sure you want to edit it?", "Warning", 0, 3) != 0) {
                    return;
                }
                Set abrChanges = this.origScheme.getAbrChanges(this.model.scheme);
                if (abrChanges.size() > 0) {
                    int total = 0;
                    for (String abr : abrChanges) {
                        total += this.origScheme.getAbrOccs(abr);
                    }
                    if (total > 0) {
                        JOptionPane.showMessageDialog(this, "You cannot make these changes to abbreviations in the scheme because they are recorded a total of " + total + " times in sample analyses.\nYou must reassign those analyses to a different scheme if you wish to change this scheme.\n" + "Use 'Show wells' to explore these analyses and make changes", "Warning", 2);
                        return;
                    }
                }
                this.origScheme.update(this.model.scheme);
            } else {
                this.db.addAbnScheme(this.model.scheme);
                this.origScheme = this.model.scheme;
            }
            this.db.commit();
            this.setOK();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error saving scheme", (Exception)((Object)sbe));
        }
        catch (SQLException ex) {
            FrameJsbugs.showStackError("SQL Error saving scheme", ex, this.db);
            this.db.doRollback();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        if (this.model.scheme.getNClasses() == 12) {
            JOptionPane.showMessageDialog(this, "You have reached the maximum number of classes.", this.getTitle(), 2);
            return;
        }
        try {
            int item = this.model.scheme.getNClasses();
            this.model.scheme.insertRow(item);
            this.model.fireTableDataChanged();
            this.jTableAbn.setRowSelectionInterval(item, item);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)25, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonInsertActionPerformed(ActionEvent evt) {
        if (this.jTableAbn.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row to insert above", "Warning", 2);
            return;
        }
        if (this.model.scheme.getNClasses() == 12) {
            JOptionPane.showMessageDialog(this, "You have reached the maximum number of classes.", this.getTitle(), 2);
            return;
        }
        try {
            this.model.scheme.insertRow(this.jTableAbn.getSelectedRow());
            this.jTableAbn.updateUI();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        if (this.jTableAbn.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Select a row", "Warning", 2);
            return;
        }
        try {
            int[] selection = this.jTableAbn.getSelectedRows();
            for (int i = selection.length - 1; i >= 0; --i) {
                this.model.scheme.deleteRow(selection[i]);
            }
            this.jTableAbn.updateUI();
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogabnscheme.html");
    }

    private void jButtonShowWellsActionPerformed(ActionEvent evt) {
        try {
            DialogAbnSchemeUsage dialog = new DialogAbnSchemeUsage(this, true, this.db, this.origScheme);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error opening dialog", sql, this.db);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }
}

