/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jsbugs.DialogEditAbundance;
import jsbugs.FrameJsbugs;
import model2.AbnScheme;
import model2.SBdb;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogAbnSchemeUsage
extends JDialog {
    List occs = new LinkedList();
    DefaultListModel occList = new DefaultListModel();
    AbnScheme abnScheme;
    SBdb db;
    private JButton jButtonClose;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JLabel jLabel1;
    private JList jListWellDis;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldName;

    public DialogAbnSchemeUsage(JDialog parent, boolean modal, SBdb db, AbnScheme scheme) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.db = db;
        this.abnScheme = scheme;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.setTitle("Abundance Scheme Usage");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.occs = this.abnScheme.getOccs();
        this.occList.clear();
        Iterator it = this.occs.iterator();
        this.jTextFieldName.setText(this.abnScheme.getName());
        while (it.hasNext()) {
            String strg = (String)it.next();
            String[] tokens = strg.split("\\|");
            this.occList.addElement(tokens[0] + " (" + tokens[2] + ") " + SBdb.getDiscAbr((char)tokens[3].charAt(0)) + " " + tokens[4] + " (" + tokens[5] + ")");
        }
        this.jListWellDis.updateUI();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jListWellDis = new JList();
        this.jButtonEdit = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 300));
        this.jLabel1.setText("Abundance scheme:");
        this.jTextFieldName.setBackground(new Color(255, 255, 204));
        this.jTextFieldName.setEditable(false);
        this.jListWellDis.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.jListWellDis.setModel(this.occList);
        this.jListWellDis.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogAbnSchemeUsage.this.jListWellDisMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListWellDis);
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnSchemeUsage.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnSchemeUsage.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnSchemeUsage.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 380, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldName, -1, 279, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonClose, this.jButtonEdit, this.jButtonHelp}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldName, -2, -1, -2)).addPreferredGap(1).add((Component)this.jScrollPane1, -1, 227, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonClose).add((Component)this.jButtonEdit).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonEditActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int index = this.jListWellDis.getSelectedIndex();
            if (index < 0) {
                JOptionPane.showMessageDialog(this, "Select a well/discipline/analyst/number", "Warning", 2);
                return;
            }
            String strg = (String)this.occs.get(index);
            String[] tokens = strg.split("\\|()");
            int wellID = Integer.parseInt(tokens[1]);
            char discID = tokens[3].charAt(0);
            String analyst = tokens[4];
            int analyNo = Integer.parseInt(tokens[5]);
            Well well = this.db.getAddWell(wellID);
            DialogEditAbundance dialog = new DialogEditAbundance(this, true, this.db, well, discID, analyst, analyNo);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
        }
        catch (SBException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error", 0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jListWellDisMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogabnschemeusage.html");
    }
}

