/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import jsbugs.DialogAbnScheme;
import jsbugs.DialogAbnSchemeUsage;
import jsbugs.DialogMergeAbn;
import jsbugs.FrameJsbugs;
import model2.AbnScheme;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogAbnSchemes
extends JDialog
implements Observer {
    private final SBdb db;
    private final DefaultListModel abnModel = new DefaultListModel();
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonFindMatch;
    private JButton jButtonHelp;
    private JButton jButtonShowUsage;
    private JList jListAbn;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public DialogAbnSchemes(Frame parent, boolean modal, SBdb db) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    public DialogAbnSchemes(JDialog parent, boolean modal, SBdb db) throws SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Abundance Schemes");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jListAbn.setSelectionMode(0);
        List abnSchemes = this.db.getAbnSchemes();
        for (AbnScheme abn : abnSchemes) {
            this.abnModel.addElement(abn);
            abn.addObserver((Observer)this);
        }
        this.jListAbn.updateUI();
    }

    @Override
    public void update(Observable obs, Object data) {
        if (obs.getClass() == AbnScheme.class) {
            this.jListAbn.repaint();
        }
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonShowUsage = new JButton();
        this.jButtonFindMatch = new JButton();
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jListAbn = new JList();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(410, 300));
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnSchemes.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnSchemes.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnSchemes.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonShowUsage.setText("Show wells...");
        this.jButtonShowUsage.setToolTipText("List the well analysis suites hat have been assigned to the selected scheme");
        this.jButtonShowUsage.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonShowUsage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnSchemes.this.jButtonShowUsageActionPerformed(evt);
            }
        });
        this.jButtonFindMatch.setText("Find similar");
        this.jButtonFindMatch.setToolTipText("Find schemes where the abbreviations and minimum values match the selected scheme");
        this.jButtonFindMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnSchemes.this.jButtonFindMatchActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnSchemes.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jListAbn.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        this.jListAbn.setModel(this.abnModel);
        this.jListAbn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogAbnSchemes.this.jListAbnMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListAbn);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAbnSchemes.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 295, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jSeparator1).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonShowUsage, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonFindMatch, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 278, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonShowUsage).addPreferredGap(0).add((Component)this.jButtonFindMatch).addPreferredGap(0, 71, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonShowUsageActionPerformed(ActionEvent evt) {
        int index = this.jListAbn.getSelectedIndex();
        if (index < 0) {
            JOptionPane.showMessageDialog(this, "Select a scheme", "Warning", 2);
            return;
        }
        try {
            DialogAbnSchemeUsage dialog = new DialogAbnSchemeUsage(this, true, this.db, (AbnScheme)this.abnModel.getElementAt(index));
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error opening dialog", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error opening dialog", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonFindMatchActionPerformed(ActionEvent evt) {
        try {
            int index = this.jListAbn.getSelectedIndex();
            if (index < 0) {
                JOptionPane.showMessageDialog(this, "Select a scheme", "Warning", 2);
                return;
            }
            AbnScheme scheme = (AbnScheme)this.abnModel.getElementAt(index);
            Enumeration it = this.abnModel.elements();
            LinkedList<AbnScheme> matches = new LinkedList<AbnScheme>();
            while (it.hasMoreElements()) {
                AbnScheme matcher = (AbnScheme)it.nextElement();
                if (scheme == matcher || !scheme.match(matcher)) continue;
                matches.add(matcher);
            }
            if (matches.size() > 0) {
                DialogMergeAbn dialog = new DialogMergeAbn(this, true, this.db, scheme, matches);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK) {
                    for (AbnScheme donor : matches) {
                        if (this.db.getAbnSchemes().contains(donor)) continue;
                        this.abnModel.removeElement(donor);
                    }
                    this.jListAbn.updateUI();
                }
            } else {
                JOptionPane.showMessageDialog(this, "There are no similar schemes to: " + scheme, this.getTitle(), 1);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        try {
            List abnSchemes = this.db.getAbnSchemes();
            for (AbnScheme abn : abnSchemes) {
                this.abnModel.addElement(abn);
                abn.deleteObserver((Observer)this);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogAbnScheme dialog = new DialogAbnScheme(this, true, this.db, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            this.abnModel.addElement(dialog.origScheme);
            dialog.origScheme.addObserver((Observer)this);
            this.jListAbn.updateUI();
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jListAbn.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a scheme to edit", this.getTitle(), 2);
            return;
        }
        AbnScheme scheme = (AbnScheme)this.jListAbn.getSelectedValue();
        DialogAbnScheme dialog = new DialogAbnScheme(this, true, this.db, scheme);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK()) {
            // empty if block
        }
    }

    private void jListAbnMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListAbn.getSelectedValue() == null) {
            JOptionPane.showMessageDialog(this, "Select a scheme", this.getTitle(), 2);
            return;
        }
        AbnScheme scheme = (AbnScheme)this.jListAbn.getSelectedValue();
        try {
            if (scheme.getNoccs() > 0) {
                if (JOptionPane.showConfirmDialog(this, "Scheme is in use and cannot be deleted without reassigning existing wells.\nDo you want to check if semi-quantitaive data are used in those wells?", "Abundance Schemes", 0, 2) != 0) {
                    return;
                }
                List wells = scheme.getWellUsage();
                if (wells.size() > 0) {
                    String msg = "Data are used in these wells: ";
                    Iterator it = wells.iterator();
                    while (it.hasNext()) {
                        msg = msg + "\n" + it.next();
                    }
                    JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
                    return;
                }
                JOptionPane.showMessageDialog(this, "Semi-quantitiave data are not used in any assigned wells.", this.getTitle(), 2);
            }
            if (JOptionPane.showConfirmDialog(this, "Are you sure you want to delete scheme: " + scheme.getName() + "?", "Abundance Schemes", 0, 3) == 0) {
                this.db.deleteAbnScheme(scheme);
                this.db.commit();
                this.abnModel.removeElement(scheme);
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
            this.db.doRollback();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogabnschemes.html");
    }
}

