/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.ChartJPanel;
import jsbugs.ChartJPanelAge;
import jsbugs.DialogChartFont;
import jsbugs.FrameJsbugs;
import jsbugs.JPanelSchemeBlock;
import jsbugs.JPanelWellBlock;
import jsbugs.SBDialog;
import jsbugs.SchemeBlock;
import jsbugs.WellBlock;
import model2.SBdb;
import util.SB;
import util.SbugsInputVerifier;

public class DialogAgeChart
extends SBDialog {
    private ChartJPanelAge chartJPanel;
    DefaultComboBoxModel scaleModel = new DefaultComboBoxModel();
    DefaultComboBoxModel interpModel = new DefaultComboBoxModel();
    SBdb sbdb;
    JPanelSchemeBlock jPanelSchemeBlock;
    JPanelWellBlock jPanelWellBlock;
    char units;
    private double minAge;
    private double maxAge;
    private static final int DEPTHLEN = 8;
    private JButton jButtonCancel;
    private JButton jButtonFonts;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JComboBox jComboBoxScale;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabelBaseDepth;
    private JLabel jLabelLOCMaxAge;
    private JLabel jLabelLOCMinAge;
    private JLabel jLabelMaxAge;
    private JLabel jLabelMinAge;
    private JLabel jLabelTopDepth;
    private JSeparator jSeparator2;
    private JTabbedPane jTabbedPane1;
    private JTextField jTextFieldBaseDepth;
    private JTextField jTextFieldDepthScale;
    private JTextField jTextFieldMaxAge;
    private JTextField jTextFieldMinAge;
    private JTextField jTextFieldTopDepth;

    public DialogAgeChart(Frame parent, boolean modal, ChartJPanelAge chartJPanel, SBdb sbdb) {
        super(parent, modal);
        this.chartJPanel = chartJPanel;
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Age Chart Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        WellBlock wellBlock = this.chartJPanel.getWellBlock();
        this.units = wellBlock.prop.units;
        System.out.println("Block.min is " + wellBlock.prop.min + " Ma");
        System.out.println("Block.max is " + wellBlock.prop.max + " Ma");
        System.out.println("Block.getTopDepth is: " + wellBlock.getTopDepth());
        System.out.println("Block.getBaseDepth is: " + wellBlock.getBaseDepth());
        this.jLabelLOCMinAge.setText("(min: " + SB.round((double)wellBlock.interp.getLOC().getMinAge(), (int)2) + ")");
        this.jLabelLOCMaxAge.setText("(max: " + SB.round((double)wellBlock.interp.getLOC().getMaxAge(), (int)2) + ")");
        this.jTextFieldTopDepth.setText("" + SB.round((double)SB.convFromM((double)wellBlock.getTopDepth(), (char)this.units), (int)2));
        this.jTextFieldBaseDepth.setText("" + SB.round((double)SB.convFromM((double)wellBlock.getBaseDepth(), (char)this.units), (int)2));
        this.updateAges();
        String unitString = this.units == 'F' ? "ft" : "m";
        this.jLabelBaseDepth.setText(unitString);
        this.jLabelTopDepth.setText(unitString);
        this.jTextFieldDepthScale.setText("" + SB.round((double)wellBlock.getScale(), (int)0));
        ((JTextField)this.jComboBoxScale.getEditor().getEditorComponent()).setInputVerifier((InputVerifier)new SbugsInputVerifier((float)((double)0.1f / this.chartJPanel.chart.chartProperties.ageFormat.getMultiplyer()), (float)(1000.0 / this.chartJPanel.chart.chartProperties.ageFormat.getMultiplyer()), wellBlock.prop.scale));
        SchemeBlock.fillScaleCombo(this.scaleModel);
        if (this.scaleModel.getIndexOf(Float.valueOf(wellBlock.prop.scale)) >= 0) {
            this.scaleModel.setSelectedItem(Float.valueOf(wellBlock.prop.scale));
        } else {
            this.scaleModel.addElement(Float.valueOf(wellBlock.prop.scale));
            this.scaleModel.setSelectedItem(Float.valueOf(wellBlock.prop.scale));
        }
        this.jPanelWellBlock = new JPanelWellBlock(this.chartJPanel.getWellBlock(), this.sbdb, this, this.chartJPanel.chart.chartProperties);
        this.jTabbedPane1.insertTab(this.chartJPanel.getWellBlock().well.getWellName(), null, this.jPanelWellBlock, null, 0);
        this.jPanelSchemeBlock = new JPanelSchemeBlock(this.chartJPanel.getSchemeBlock(), this.sbdb, this);
        this.jTabbedPane1.insertTab("Scheme Block", null, this.jPanelSchemeBlock, null, 1);
    }

    private void initComponents() {
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldTopDepth = new JTextField();
        this.jTextFieldBaseDepth = new JTextField();
        this.jLabelTopDepth = new JLabel();
        this.jLabelBaseDepth = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBoxScale = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabelMinAge = new JLabel();
        this.jLabelMaxAge = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jTextFieldMinAge = new JTextField();
        this.jTextFieldMaxAge = new JTextField();
        this.jTextFieldDepthScale = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jButtonFonts = new JButton();
        this.jLabelLOCMinAge = new JLabel();
        this.jLabelLOCMaxAge = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 400));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeChart.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeChart.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeChart.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Top depth:");
        this.jLabel2.setText("Base depth:");
        this.jTextFieldTopDepth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DialogAgeChart.this.jTextFieldTopDepthFocusLost(evt);
            }
        });
        this.jTextFieldTopDepth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogAgeChart.this.jTextFieldTopDepthKeyTyped(evt);
            }
        });
        this.jTextFieldBaseDepth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DialogAgeChart.this.jTextFieldBaseDepthFocusLost(evt);
            }
        });
        this.jTextFieldBaseDepth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogAgeChart.this.jTextFieldBaseDepthKeyTyped(evt);
            }
        });
        this.jLabelTopDepth.setText("m");
        this.jLabelBaseDepth.setText("m");
        this.jLabel5.setText("Scale:");
        this.jComboBoxScale.setEditable(true);
        this.jComboBoxScale.setModel(this.scaleModel);
        this.jLabel6.setText("mm/Ma");
        this.jLabelMinAge.setText("Ma");
        this.jLabelMaxAge.setText("Ma");
        this.jTextFieldMinAge.setEditable(false);
        this.jTextFieldMinAge.setBackground(new Color(255, 255, 204));
        this.jTextFieldMinAge.setToolTipText("Age at top depth");
        this.jTextFieldMaxAge.setEditable(false);
        this.jTextFieldMaxAge.setBackground(new Color(255, 255, 204));
        this.jTextFieldMaxAge.setToolTipText("Age at base depth");
        this.jTextFieldDepthScale.setEditable(false);
        this.jTextFieldDepthScale.setBackground(new Color(255, 255, 204));
        this.jTextFieldDepthScale.setToolTipText("Age scale");
        this.jButtonFonts.setText("Options...");
        this.jButtonFonts.setToolTipText("Chart display options, including fonts and core corrections");
        this.jButtonFonts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeChart.this.jButtonFontsActionPerformed(evt);
            }
        });
        this.jLabelLOCMinAge.setForeground(new Color(153, 153, 153));
        this.jLabelLOCMinAge.setText("(min: )");
        this.jLabelLOCMaxAge.setForeground(new Color(153, 153, 153));
        this.jLabelLOCMaxAge.setText("(max: )");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 199, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jSeparator2).addComponent(this.jTabbedPane1)).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldTopDepth, -1, 91, Short.MAX_VALUE).addComponent(this.jTextFieldBaseDepth).addComponent(this.jComboBoxScale, 0, 1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelTopDepth).addComponent(this.jLabelBaseDepth).addComponent(this.jLabel6)).addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldMinAge, -2, 82, -2).addComponent(this.jTextFieldMaxAge, -2, 82, -2).addComponent(this.jTextFieldDepthScale, GroupLayout.Alignment.TRAILING, -2, 82, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelMaxAge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelLOCMaxAge)).addGroup(layout.createSequentialGroup().addComponent(this.jLabelMinAge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelLOCMinAge))).addGap(41, 65, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonFonts).addContainerGap()))))));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.linkSize(0, this.jComboBoxScale, this.jTextFieldBaseDepth, this.jTextFieldDepthScale, this.jTextFieldMaxAge, this.jTextFieldMinAge, this.jTextFieldTopDepth);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldTopDepth, -2, -1, -2).addComponent(this.jLabelTopDepth).addComponent(this.jTextFieldMinAge, -2, -1, -2).addComponent(this.jLabelMinAge).addComponent(this.jLabelLOCMinAge)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldBaseDepth, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jLabelBaseDepth).addComponent(this.jLabelMaxAge).addComponent(this.jTextFieldMaxAge, -2, -1, -2).addComponent(this.jLabelLOCMaxAge)).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxScale, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.jLabel6).addComponent(this.jTextFieldDepthScale, -2, -1, -2).addComponent(this.jButtonFonts)).addGap(18, 18, 18).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -1, 236, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.jPanelWellBlock.cancel();
        this.jPanelSchemeBlock.cancel();
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        float baseDepth;
        this.updateAges();
        if (Float.parseFloat(this.jTextFieldMinAge.getText()) < 0.0f) {
            JOptionPane.showMessageDialog(this, "Minimum age cannot be less than 0.", this.getTitle(), 2);
            return;
        }
        if (Float.parseFloat(this.jTextFieldMaxAge.getText()) < 0.0f) {
            JOptionPane.showMessageDialog(this, "Maximum age cannot be less than 0.", this.getTitle(), 2);
            return;
        }
        float topDepth = (float)SB.convToM((double)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)this.units, (char)this.chartJPanel.getWellBlock().well.getType());
        if (topDepth > (baseDepth = (float)SB.convToM((double)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)this.units, (char)this.chartJPanel.getWellBlock().well.getType()))) {
            JOptionPane.showMessageDialog(this, "Top depth must be less than base depth", this.getTitle(), 2);
            return;
        }
        float scale = Float.parseFloat("" + this.jComboBoxScale.getSelectedItem());
        System.out.println("setting scale to " + scale);
        WellBlock block = this.chartJPanel.getWellBlock();
        if (block != null) {
            Point2D depthRange = block.interp.getLOC().getDepthRange(this.minAge, this.maxAge);
            block.setDepthRange(depthRange.getX(), depthRange.getY());
            block.setScale(scale);
        }
        this.jPanelSchemeBlock.confirm();
        this.jPanelWellBlock.confirm();
        ChartJPanel.encodePanelTypes(block, this.sbdb, "AGECHTPREF");
        try {
            String prefKey = this.chartJPanel.chart.getWellBlock().getPrefKey(4);
            this.chartJPanel.chart.savePreference(this.sbdb, prefKey);
            this.sbdb.commit();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        this.setOK();
    }

    private void jTextFieldTopDepthFocusLost(FocusEvent evt) {
        this.updateAges();
    }

    private void jTextFieldBaseDepthFocusLost(FocusEvent evt) {
        this.updateAges();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("agechart.html");
    }

    private void jButtonFontsActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        DialogChartFont dialog = new DialogChartFont(this, true, this.chartJPanel.chart.chartProperties);
        dialog.setLocationRelativeTo(this);
        this.setCursor(Cursor.getDefaultCursor());
        dialog.setVisible(true);
    }

    private void jTextFieldTopDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTopDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBaseDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void updateAges() {
        double topDepth = SB.convToM((double)Float.parseFloat(this.jTextFieldTopDepth.getText()), (char)this.units, (char)this.chartJPanel.getWellBlock().well.getType());
        double baseDepth = SB.convToM((double)Float.parseFloat(this.jTextFieldBaseDepth.getText()), (char)this.units, (char)this.chartJPanel.getWellBlock().well.getType());
        Point2D ageRange = this.chartJPanel.getWellBlock().interp.getLOC().getAgeRange(topDepth, baseDepth);
        this.minAge = ageRange.getX();
        this.maxAge = ageRange.getY();
        this.jTextFieldMinAge.setText("" + SB.round((double)ageRange.getX(), (int)2));
        this.jTextFieldMaxAge.setText("" + SB.round((double)ageRange.getY(), (int)2));
    }
}

