/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.DialogAgeCurveProperties;
import jsbugs.DialogSelectIGDScheme;
import jsbugs.TableModelAgeCurve;
import model2.AgeCurve;
import model2.SBdb;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogAgeCurve
extends JDialog {
    TableModelAgeCurve model = new TableModelAgeCurve();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    SBdb db;
    int schID = -1;
    boolean isOK = false;
    Color newColour = null;
    Integer newStyle = null;
    Float newLineWidth = null;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonOK;
    private JButton jButtonScheme;
    private JButton jButtonStyle;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTableCurve;
    private JTextField jTextFieldScheme;
    private JTextField jTextFieldTitle;
    private JTextField jTextFieldUnits;

    public DialogAgeCurve(Dialog parent, boolean modal, AgeCurve curve, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init(curve);
    }

    private void init(AgeCurve curve) {
        this.setTitle("Edit Age Curve : " + curve.getTitle());
        this.getRootPane().setDefaultButton(this.jButtonOK);
        SB.setTableHeaderBold((JTable)this.jTableCurve);
        TableColumnModel columnModel = this.jTableCurve.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelAgeCurve.titles[i]);
            columnModel.getColumn(i).setWidth(TableModelAgeCurve.widths[i]);
        }
        this.model.curve = curve;
        this.jTableCurve.updateUI();
        if (curve != null) {
            try {
                this.jTextFieldTitle.setText(curve.getTitle());
                this.jTextFieldUnits.setText(curve.getUnits());
                this.jTextFieldScheme.setText(this.db.getIGDScheme(curve.getSchID()).toString());
                this.schID = curve.getSchID();
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCurve = new JTable();
        this.jButtonDelete = new JButton();
        this.jButtonStyle = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jTextFieldTitle = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldUnits = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jButtonScheme = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jTableCurve.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCurve);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurve.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonStyle.setText("Style...");
        this.jButtonStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurve.this.jButtonStyleActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurve.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jTextFieldTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogAgeCurve.this.jTextFieldTitleKeyTyped(evt);
            }
        });
        this.jLabel1.setText("Title:");
        this.jLabel2.setText("Units:");
        this.jTextFieldUnits.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogAgeCurve.this.jTextFieldUnitsKeyTyped(evt);
            }
        });
        this.jLabel3.setText("Scheme:");
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jTextFieldScheme.setEditable(false);
        this.jButtonScheme.setText("...");
        this.jButtonScheme.setToolTipText("Select a scheme");
        this.jButtonScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurve.this.jButtonSchemeActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldTitle, -1, 260, Short.MAX_VALUE).addComponent(this.jTextFieldUnits, -2, 140, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldScheme, -1, 225, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonScheme, -2, 29, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldTitle, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldUnits, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldScheme, -2, -1, -2).addComponent(this.jButtonScheme)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurve.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 226, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 10, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonStyle, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCancel, -1, -1, Short.MAX_VALUE)).addComponent(this.jButtonOK, -1, 69, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonStyle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 105, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 209, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableCurve.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 1);
            return;
        }
        int count = this.jTableCurve.getSelectedRowCount();
        int option = JOptionPane.showConfirmDialog(this, "Really delete " + (count == 1 ? "this " : "these ") + count + " row" + (count == 1 ? "?" : "s?") + " You cannot undo this action.", this.getTitle(), 0, 3);
        if (option == 0) {
            LinkedList toDelete = new LinkedList();
            try {
                for (int row : this.jTableCurve.getSelectedRows()) {
                    toDelete.add(this.model.curve.getTrace().get(row));
                }
                for (AgeCurve.AgeCurveValue cv : toDelete) {
                    this.model.curve.deleteRow(this.db, cv);
                }
                for (AgeCurve.AgeCurveValue cv : toDelete) {
                    this.model.curve.getTrace().remove(cv);
                }
                this.db.commit();
                this.sorter.reallocateIndexes();
                this.model.fireTableDataChanged();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Error deleting value: " + e.getMessage(), this.getTitle(), 0);
                this.db.doRollback();
            }
        }
    }

    private void jButtonStyleActionPerformed(ActionEvent evt) {
        DialogAgeCurveProperties dialog = new DialogAgeCurveProperties((Dialog)this, true, this.model.curve);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.newColour = dialog.colour;
            this.newLineWidth = Float.valueOf(dialog.lineWidth);
            this.newStyle = dialog.style;
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String title = this.jTextFieldTitle.getText();
        if (title.trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "You must enter a title", this.getTitle(), 1);
            this.jTextFieldTitle.requestFocusInWindow();
            return;
        }
        String units = this.jTextFieldUnits.getText();
        if (units.trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "You must enter units", this.getTitle(), 1);
            this.jTextFieldUnits.requestFocusInWindow();
            return;
        }
        if (this.model.curve != null) {
            try {
                this.model.curve.setTitle(title);
                this.model.curve.setUnits(units);
                this.model.curve.setSchID(this.schID);
                if (this.newColour != null) {
                    this.model.curve.setColour(this.newColour);
                }
                if (this.newLineWidth != null) {
                    this.model.curve.setLineWidth(this.newLineWidth.floatValue());
                }
                if (this.newStyle != null) {
                    this.model.curve.setStyle(this.newStyle.intValue());
                }
                this.model.curve.updateAttributes(this.db);
            }
            catch (SQLException sql) {
                System.out.println(sql.getMessage());
                sql.printStackTrace();
            }
            catch (SBException sbe) {
                sbe.printStackTrace();
            }
        }
        this.isOK = true;
        this.dispose();
    }

    private void jButtonSchemeActionPerformed(ActionEvent evt) {
        try {
            DialogSelectIGDScheme dialog = new DialogSelectIGDScheme((Dialog)this, true, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.scheme != null) {
                this.schID = dialog.scheme.getID();
                this.jTextFieldScheme.setText(dialog.scheme.toString());
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
    }

    private void jTextFieldTitleKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldTitle, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldUnitsKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldUnits, (int)25, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

