/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import model2.AgeCurve;
import org.jdesktop.layout.GroupLayout;

public class DialogAgeCurveProperties
extends JDialog {
    DefaultComboBoxModel styleModel = new DefaultComboBoxModel();
    AgeCurve ageCurve;
    int style;
    Color colour;
    float lineWidth;
    boolean isOK;
    private JButton jButtonCancel;
    private JButton jButtonColour;
    private JButton jButtonOK;
    private JComboBox jComboBoxStyle;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerWidth;
    private JTextField jTextFieldColour;

    public DialogAgeCurveProperties(Dialog parent, boolean modal, AgeCurve ageCurve) {
        super(parent, modal);
        this.ageCurve = ageCurve;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Age Curve Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.initStyleCombo();
        if (this.ageCurve != null) {
            this.jSpinnerWidth.setValue(Float.valueOf(this.ageCurve.getLineWidth()));
            this.jTextFieldColour.setBackground(this.ageCurve.getColour());
        }
    }

    private void initStyleCombo() {
        this.styleModel.removeAllElements();
        for (String strg : AgeCurve.styles) {
            this.styleModel.addElement(strg);
        }
        if (this.ageCurve != null) {
            this.styleModel.setSelectedItem(AgeCurve.styles[this.ageCurve.getStyle()]);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldColour = new JTextField();
        this.jButtonColour = new JButton();
        this.jLabel2 = new JLabel();
        this.jSpinnerWidth = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jComboBoxStyle = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Colour:");
        this.jTextFieldColour.setBackground(new Color(240, 240, 240));
        this.jButtonColour.setText("...");
        this.jButtonColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurveProperties.this.jButtonColourActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Line width:");
        this.jSpinnerWidth.setModel(new SpinnerNumberModel(Float.valueOf(0.1f), Float.valueOf(0.1f), Float.valueOf(1.0f), Float.valueOf(0.1f)));
        this.jLabel3.setText("Style:");
        this.jComboBoxStyle.setModel(this.styleModel);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurveProperties.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurveProperties.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jSeparator1, -1, 166, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel3).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jComboBoxStyle, 0, 110, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jSpinnerWidth, -2, 78, -2).add((Component)this.jTextFieldColour, -1, 78, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButtonColour, -2, 26, -2)))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK, -2, 78, -2).addPreferredGap(0).add((Component)this.jButtonCancel, -2, 73, -2))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonColour).add((Component)this.jTextFieldColour, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jSpinnerWidth, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxStyle, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 4, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonColourActionPerformed(ActionEvent evt) {
        Color col = this.jTextFieldColour.getBackground();
        if ((col = JColorChooser.showDialog(this, "Line Colour", col)) != null) {
            this.jTextFieldColour.setBackground(col);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.colour = this.jTextFieldColour.getBackground();
        this.lineWidth = ((Float)this.jSpinnerWidth.getValue()).floatValue();
        this.style = this.jComboBoxStyle.getSelectedIndex();
        this.isOK = true;
        this.dispose();
    }
}

