/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogAgeCurveProperties;
import jsbugs.DialogFilePreview;
import jsbugs.DialogSelectIGDScheme;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class DialogAgeCurveReader
extends JDialog {
    Color colour = Color.BLACK;
    int style = 0;
    float lineWidth = 0.1f;
    String title;
    String units;
    String filePath;
    int schID = -1;
    boolean isOK = false;
    SBdb db;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonProps;
    private JButton jButtonScheme;
    private JButton jButtonView;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JSeparator jSeparator1;
    private JTextField jTextFieldFilename;
    private JTextField jTextFieldScheme;
    private JTextField jTextFieldTitle;
    private JTextField jTextFieldUnits;

    public DialogAgeCurveReader(Dialog parent, boolean modal, SBdb db, String filePath) {
        super(parent, modal);
        this.filePath = filePath;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Age Curve Reader");
        this.getRootPane().setDefaultButton(this.jButtonScheme);
        this.jTextFieldFilename.setText(this.filePath);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldFilename = new JTextField();
        this.jButtonView = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldScheme = new JTextField();
        this.jButtonScheme = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldTitle = new JTextField();
        this.jTextFieldUnits = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonProps = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Filename:");
        this.jTextFieldFilename.setBackground(new Color(240, 240, 240));
        this.jTextFieldFilename.setEditable(false);
        this.jButtonView.setText("View...");
        this.jButtonView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurveReader.this.jButtonViewActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Scheme:");
        this.jTextFieldScheme.setBackground(new Color(255, 255, 204));
        this.jTextFieldScheme.setEditable(false);
        this.jButtonScheme.setText("...");
        this.jButtonScheme.setToolTipText("Select scheme from a list");
        this.jButtonScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurveReader.this.jButtonSchemeActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Title:");
        this.jLabel4.setText("Units:");
        this.jTextFieldTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogAgeCurveReader.this.jTextFieldTitleKeyTyped(evt);
            }
        });
        this.jTextFieldUnits.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogAgeCurveReader.this.jTextFieldUnitsKeyTyped(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurveReader.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurveReader.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurveReader.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonProps.setText("Style properties...");
        this.jButtonProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurveReader.this.jButtonPropsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 481, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel4).add((Component)this.jLabel3).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jTextFieldTitle, -1, 315, Short.MAX_VALUE).add((Component)this.jTextFieldScheme, -1, 315, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButtonScheme, -2, 30, -2).addPreferredGap(0, 9, Short.MAX_VALUE)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldFilename, -1, 354, Short.MAX_VALUE).addPreferredGap(0))).add((Component)this.jButtonView)).add((Component)this.jTextFieldUnits, -2, 198, -2).add((Component)this.jButtonProps))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldFilename, -2, -1, -2).add((Component)this.jButtonView).add((Component)this.jLabel1)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldScheme, -2, -1, -2).add((Component)this.jButtonScheme)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldTitle, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldUnits, -2, -1, -2)).addPreferredGap(0).add((Component)this.jButtonProps).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).add(16, 16, 16)));
        this.pack();
    }

    private void jTextFieldTitleKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldTitle, (int)80, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldUnitsKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldUnits, (int)25, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonPropsActionPerformed(ActionEvent evt) {
        DialogAgeCurveProperties dialog = new DialogAgeCurveProperties((Dialog)this, true, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.colour = dialog.colour;
            this.style = dialog.style;
            this.lineWidth = dialog.lineWidth;
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.schID < 0) {
            JOptionPane.showMessageDialog(this, "You must select a scheme", "Select a scheme", 1);
            return;
        }
        this.title = this.jTextFieldTitle.getText();
        if (this.title.trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a title", "Title", 1);
            this.jTextFieldTitle.requestFocusInWindow();
            return;
        }
        this.units = this.jTextFieldUnits.getText();
        if (this.units.trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter units", "Units", 1);
            this.jTextFieldUnits.requestFocusInWindow();
            return;
        }
        this.isOK = true;
        this.dispose();
    }

    private void jButtonViewActionPerformed(ActionEvent evt) {
        DialogFilePreview dialog = new DialogFilePreview(this, false, this.filePath);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jButtonSchemeActionPerformed(ActionEvent evt) {
        try {
            DialogSelectIGDScheme dialog = new DialogSelectIGDScheme((Dialog)this, true, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.scheme != null) {
                this.schID = dialog.scheme.getID();
                this.jTextFieldScheme.setText(dialog.scheme.toString());
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtoaddagecurves.html");
    }
}

