/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import jsbugs.DialogAgeCurve;
import jsbugs.DialogAgeCurveReader;
import jsbugs.DialogFilePreview;
import jsbugs.DialogTSCAgeCurveReader;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelAgeCurves;
import model2.AgeCurve;
import model2.Lastval;
import model2.SBdb;
import model2.TSCreatorReader;
import util.SbugsFileFilter;
import util.TableSorter;

public class DialogAgeCurves
extends JDialog {
    SBdb db;
    TableModelAgeCurves model;
    TableSorter sorter;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonRead;
    private JScrollPane jScrollPane1;
    private JTable jTableAgeCurves;

    public DialogAgeCurves(Frame parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.model = new TableModelAgeCurves(this.db);
        this.sorter = new TableSorter((TableModel)this.model);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Age Curves");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        try {
            this.model.setAgeCurves();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.model.setupTable(this.jTableAgeCurves);
        this.sorter.reallocateIndexes();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableAgeCurves = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonRead = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(550, 200));
        this.jTableAgeCurves.setModel((TableModel)this.sorter);
        this.jTableAgeCurves.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogAgeCurves.this.jTableAgeCurvesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableAgeCurves);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurves.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.setToolTipText("Add new curve from file");
        this.jButtonRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurves.this.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected curve from database");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurves.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurves.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAgeCurves.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 581, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonDelete, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE).addComponent(this.jButtonRead, -1, 75, Short.MAX_VALUE).addComponent(this.jButtonEdit, -2, 75, -2).addComponent(this.jButtonClose, GroupLayout.Alignment.LEADING, -1, 75, Short.MAX_VALUE)).addComponent(this.jButtonHelp)).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonHelp);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 213, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonRead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 80, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonReadActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.db, (String)"WINAGECURV", (String)"UNXAGECURV"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter("csv", "General CSV files");
        jFileChooser.addChoosableFileFilter((FileFilter)filter);
        filter = new SbugsFileFilter("txt", "Timescale Creator files");
        jFileChooser.addChoosableFileFilter((FileFilter)filter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                Lastval.putString((SBdb)this.db, (String)"WINAGECURV", (String)"UNXAGECURV", (String)file.getPath());
                this.db.commit();
                System.out.println("Fie Name selected: " + file.getName());
                if (file.getName().toLowerCase().endsWith(".txt")) {
                    TSCreatorReader tscReader = new TSCreatorReader(this.db, file.getPath());
                    DialogTSCAgeCurveReader dialog = new DialogTSCAgeCurveReader((Dialog)this, true, this.db, tscReader);
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                    if (dialog.isOK) {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        AgeCurve curve = new AgeCurve(dialog.curve, dialog.units, dialog.colour, dialog.style, dialog.lineWidth, dialog.schID);
                        this.db.addAgeCurve(curve);
                        this.db.commit();
                        this.model.fireTableDataChanged();
                    }
                } else {
                    DialogAgeCurveReader dialog = new DialogAgeCurveReader((Dialog)this, true, this.db, file.getPath());
                    dialog.setLocationRelativeTo(this);
                    dialog.setVisible(true);
                    if (dialog.isOK) {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        AgeCurve curve = new AgeCurve(file, dialog.title, dialog.units, dialog.colour, dialog.style, dialog.lineWidth, dialog.schID);
                        this.db.addAgeCurve(curve);
                        this.db.commit();
                        this.model.fireTableDataChanged();
                    }
                }
            }
            catch (Exception eio) {
                this.db.doRollback();
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
                DialogFilePreview dialog = new DialogFilePreview(this, true, file.getPath());
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableAgeCurves.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No curves selected", this.getTitle(), 1);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int[] selection = this.jTableAgeCurves.getSelectedRows();
            LinkedList<AgeCurve> toDelete = new LinkedList<AgeCurve>();
            for (int i = 0; i < selection.length; ++i) {
                toDelete.add(this.model.ageCurves.get(this.sorter.getIndexOf(selection[i])));
            }
            int opt = JOptionPane.showConfirmDialog(this, "Really delete " + (toDelete.size() == 1 ? "this curve?" : "these curves?"), this.getTitle(), 0, 3);
            if (opt != 0) {
                return;
            }
            for (AgeCurve ageCurve : toDelete) {
                ageCurve.delete(this.db);
                this.model.ageCurves.remove(ageCurve);
            }
            this.db.commit();
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (Exception eio) {
            this.db.doRollback();
            eio.printStackTrace();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableAgeCurves.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No curve selected", this.getTitle(), 1);
            return;
        }
        if (this.jTableAgeCurves.getSelectedRowCount() > 1) {
            JOptionPane.showMessageDialog(this, "Select one curve to edit", this.getTitle(), 1);
            return;
        }
        AgeCurve curve = this.model.ageCurves.get(this.jTableAgeCurves.getSelectedRow());
        DialogAgeCurve dialog = new DialogAgeCurve((Dialog)this, true, curve, this.db);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.model.fireTableDataChanged();
        }
    }

    private void jTableAgeCurvesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtoaddagecurves.html");
    }
}

