/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jsbugs.AnalystHeaderTableModel;
import jsbugs.DialogAbnSchemes;
import jsbugs.DialogAnalystHeader;
import jsbugs.FrameJsbugs;
import model2.AnalystHeader;
import model2.SBdb;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogAnalystHeaders
extends JDialog {
    private final AnalystHeaderTableModel model;
    private final TableSorter sorter;
    private final boolean toSelect;
    private final Well well;
    AnalystHeader selection = null;
    private JButton jButtonAbnSchemes;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator2;
    private JTable jTableAnalystHeader;

    public DialogAnalystHeaders(Frame parent, boolean modal, SBdb db, Well well, boolean toSelect) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.model = new AnalystHeaderTableModel(db);
        this.sorter = new TableSorter((TableModel)this.model);
        this.toSelect = toSelect;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.setTitle("Analysis Suites : " + this.well.getWellName());
        this.model.setupTable(this.jTableAnalystHeader);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableAnalystHeader);
        this.model.hdrs = this.well.getAnalystHeaders();
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.sorter.sortByColumn(1);
        if (this.toSelect) {
            this.jButtonClose.setText("Cancel");
        } else {
            this.jButtonOK.setVisible(false);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableAnalystHeader = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jButtonAbnSchemes = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(600, 300));
        this.jTableAnalystHeader.setModel((TableModel)this.sorter);
        this.jTableAnalystHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogAnalystHeaders.this.jTableAnalystHeaderMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableAnalystHeader);
        this.jButtonClose.setText("Close");
        this.jButtonClose.setPreferredSize(new Dimension(97, 23));
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAnalystHeaders.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAnalystHeaders.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAnalystHeaders.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setPreferredSize(new Dimension(97, 23));
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAnalystHeaders.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jSeparator2.setPreferredSize(new Dimension(97, 2));
        this.jButtonAbnSchemes.setText("Abn.Schemes...");
        this.jButtonAbnSchemes.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonAbnSchemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAnalystHeaders.this.jButtonAbnSchemesActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.setPreferredSize(new Dimension(97, 23));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAnalystHeaders.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.setPreferredSize(new Dimension(97, 23));
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAnalystHeaders.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 590, Short.MAX_VALUE).add(10, 10, 10).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonClose, -1, 97, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, 97, Short.MAX_VALUE).add(1, (Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator2, -1, 97, Short.MAX_VALUE).add((Component)this.jButtonAdd, -1, 97, Short.MAX_VALUE).add((Component)this.jButtonEdit, -1, 97, Short.MAX_VALUE).add((Component)this.jButtonDelete, -1, 97, Short.MAX_VALUE).add(1, (Component)this.jButtonAbnSchemes, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 349, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete, -2, -1, -2).addPreferredGap(0).add((Component)this.jSeparator2, -2, 5, -2).addPreferredGap(0).add((Component)this.jButtonAbnSchemes).addPreferredGap(0, 147, Short.MAX_VALUE).add((Component)this.jButtonOK, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonHelp, -2, 23, -2).addPreferredGap(0).add((Component)this.jButtonClose, -2, -1, -2))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonHelp, this.jButtonOK}, 2);
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogAnalystHeader dialog = new DialogAnalystHeader(this, true, this.model.db, this.well, null);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.hdrs = this.well.getAnalystHeaders();
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                int index = this.sorter.getIndexOf(this.model.hdrs.indexOf(dialog.hdr));
                this.jTableAnalystHeader.setRowSelectionInterval(index, index);
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.model.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableAnalystHeader.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row only from table", this.getTitle(), 1);
            return;
        }
        AnalystHeader hdr = this.model.hdrs.get(this.sorter.getIndexOf(this.jTableAnalystHeader.getSelectedRow()));
        try {
            DialogAnalystHeader dialog = new DialogAnalystHeader(this, true, this.model.db, this.well, hdr);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.sorter.reallocateIndexes();
                int index = this.sorter.getIndexOf(this.model.hdrs.indexOf(dialog.hdr));
                this.jTableAnalystHeader.setRowSelectionInterval(index, index);
                this.sorter.fireTableDataChanged();
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.model.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableAnalystHeader.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row only from table", this.getTitle(), 1);
            return;
        }
        AnalystHeader hdr = this.model.hdrs.get(this.sorter.getIndexOf(this.jTableAnalystHeader.getSelectedRow()));
        try {
            String msg;
            int option;
            if (this.model.db.restrictedToDiscID(hdr.getDiscipline())) {
                JOptionPane.showMessageDialog(this, "You can only add/edit data within your own discipline. See Config Personnel from the Control panel");
                return;
            }
            int nAnalyses = this.well.getAnalysesOccs(hdr);
            if (nAnalyses > 0 && (option = JOptionPane.showConfirmDialog(this, msg = "There " + (nAnalyses == 1 ? "is " : "are ") + nAnalyses + " analy" + (nAnalyses == 1 ? "sis" : "ses") + " in this suite." + "\nDo you want to delete " + (nAnalyses == 1 ? "it?" : "them all?"), this.getTitle(), 0, 3)) != 0) {
                return;
            }
            this.well.deleteAnalyses(hdr);
            this.model.db.commit();
            this.model.hdrs = this.well.getAnalystHeaders();
            this.sorter.reallocateIndexes();
            this.model.fireTableDataChanged();
        }
        catch (SBException sbe) {
            this.model.db.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            this.model.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.model.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jTableAnalystHeaderMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (this.toSelect) {
                this.jButtonOKActionPerformed(null);
            } else {
                this.jButtonEditActionPerformed(null);
            }
        }
    }

    private void jButtonAbnSchemesActionPerformed(ActionEvent evt) {
        try {
            DialogAbnSchemes dialog = new DialogAbnSchemes(this, true, this.model.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error loading abundance schemes", sql, this.model.db);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTableAnalystHeader.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one entry. Add a new analysis suite if list is empty", this.getTitle(), 1);
            return;
        }
        this.selection = this.model.hdrs.get(this.sorter.getIndexOf(this.jTableAnalystHeader.getSelectedRow()));
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialoganalystheaders.html");
    }
}

