/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import jsbugs.DialogSelectAnalyst;
import jsbugs.DialogSelectSample;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import jsbugs.SbugsFocusTraversalPolicy;
import model2.AnalystHeader;
import model2.Biocom;
import model2.Discipline;
import model2.SBdb;
import model2.Sample;
import model2.Well;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class DialogBiocom
extends SBDialog {
    private final Well well;
    private final WellInterp wellInterp;
    private final char units;
    private final SBdb db;
    private Biocom biocom;
    private Sample topSample;
    private Sample baseSample;
    private final DefaultComboBoxModel comboModelDiscipline = new DefaultComboBoxModel<Discipline>(Discipline.values());
    private final DefaultComboBoxModel comboModelAnalyst = new DefaultComboBoxModel();
    private static String lastAnalystAbr = null;
    private static Discipline lastDisc = null;
    private static final int MAXLEN = 240;
    private static final int DSLEN = 50;
    final UndoableEditSupport undoSupport = new UndoableEditSupport();
    WellInterp.BiocomEdit edit = null;
    private JButton jButtonAnalyst;
    private JButton jButtonBaseSample;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonTopSample;
    private JComboBox jComboBoxAnalyst;
    private JComboBox jComboBoxDisc;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPaneComment;
    private JTextArea jTextAreaComment;
    private JTextField jTextFieldBaseSample;
    private JTextField jTextFieldDataSource;
    private JTextField jTextFieldTopSample;

    public DialogBiocom(Frame parent, boolean modal, SBdb db, Well well, WellInterp wellInterp, char units, Biocom biocom, Sample topSample, Sample baseSample) throws SQLException, SBException {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.biocom = biocom;
        this.topSample = topSample;
        if (baseSample != topSample) {
            this.baseSample = baseSample;
        }
        this.well = well;
        this.wellInterp = wellInterp;
        this.units = units;
        this.init();
    }

    private void init() throws SQLException, SBException {
        this.fillAnalystCombo();
        if (this.biocom == null) {
            this.setTitle("Biostratigraphic Comment : Add - " + this.wellInterp.getHeader().toString());
            if (lastAnalystAbr != null) {
                this.comboModelAnalyst.setSelectedItem(lastAnalystAbr);
            }
            if (lastDisc != null) {
                this.jComboBoxDisc.setSelectedItem(lastDisc);
            } else {
                this.jComboBoxDisc.setSelectedItem(this.db.getUser().getDiscipline());
            }
        } else {
            this.setTitle("Biostratigraphic Comment : Edit - " + this.wellInterp.getHeader().toString());
            this.topSample = this.biocom.getTopSample();
            this.baseSample = this.biocom.getBaseSample();
            if (this.comboModelAnalyst.getIndexOf(this.biocom.getAnalystString()) < 0) {
                this.comboModelAnalyst.addElement(this.biocom.getAnalystString());
            }
            this.jComboBoxAnalyst.setSelectedItem(this.biocom.getAnalystString());
            this.jComboBoxDisc.setSelectedItem(Discipline.getDisc((char)this.biocom.getDiscID()));
            this.jTextFieldDataSource.setText(this.biocom.getSource());
            this.jTextAreaComment.setText(this.biocom.getText());
            this.jTextAreaComment.setCaretPosition(this.biocom.getText().length());
        }
        if (this.topSample != null) {
            this.jTextFieldTopSample.setText(this.topSample.toString(this.units));
        }
        if (this.baseSample != null) {
            this.jTextFieldBaseSample.setText(this.baseSample.toString(this.units));
        }
        this.jTextAreaComment.requestFocusInWindow();
        this.initFocus();
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initFocus() {
        LinkedList<Component> focusOrder = new LinkedList<Component>();
        focusOrder.add(this.jTextAreaComment);
        focusOrder.add(this.jButtonOK);
        focusOrder.add(this.jButtonHelp);
        focusOrder.add(this.jButtonCancel);
        focusOrder.add(this.jComboBoxDisc);
        focusOrder.add(this.jComboBoxAnalyst);
        focusOrder.add(this.jButtonAnalyst);
        focusOrder.add(this.jButtonTopSample);
        focusOrder.add(this.jButtonBaseSample);
        focusOrder.add(this.jTextFieldDataSource);
        SbugsFocusTraversalPolicy focusPolicy = new SbugsFocusTraversalPolicy(focusOrder);
        this.setFocusTraversalPolicy(focusPolicy);
    }

    private void fillAnalystCombo() throws SQLException, SBException {
        Iterator itr = this.well.getAnalystHeaderIterator();
        this.comboModelAnalyst.removeAllElements();
        this.comboModelAnalyst.addElement("");
        while (itr.hasNext()) {
            AnalystHeader hdr = (AnalystHeader)itr.next();
            String abr = hdr.getAnalyst();
            if (this.comboModelAnalyst.getIndexOf(abr) >= 0) continue;
            this.comboModelAnalyst.addElement(abr);
        }
        if (lastAnalystAbr != null && this.comboModelAnalyst.getIndexOf(lastAnalystAbr) < 0) {
            this.comboModelAnalyst.addElement(lastAnalystAbr);
        }
        this.jComboBoxAnalyst.repaint();
        this.jComboBoxAnalyst.setSelectedIndex(0);
    }

    private void initComponents() {
        this.jScrollPaneComment = new JScrollPane();
        this.jTextAreaComment = new JTextArea();
        this.jComboBoxAnalyst = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBoxDisc = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jTextFieldTopSample = new JTextField();
        this.jTextFieldBaseSample = new JTextField();
        this.jButtonBaseSample = new JButton();
        this.jButtonTopSample = new JButton();
        this.jButtonAnalyst = new JButton();
        this.jLabel5 = new JLabel();
        this.jTextFieldDataSource = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(425, 350));
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setFont(new Font("Tahoma", 0, 13));
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(5);
        this.jTextAreaComment.setWrapStyleWord(true);
        this.jTextAreaComment.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogBiocom.this.jTextAreaCommentKeyTyped(evt);
            }
        });
        this.jScrollPaneComment.setViewportView(this.jTextAreaComment);
        this.jComboBoxAnalyst.setModel(this.comboModelAnalyst);
        this.jLabel2.setText("Analyst:");
        this.jComboBoxDisc.setModel(this.comboModelDiscipline);
        this.jLabel3.setText("To sample:");
        this.jLabel4.setText("From sample:");
        this.jTextFieldTopSample.setEditable(false);
        this.jTextFieldTopSample.setBackground(new Color(255, 255, 204));
        this.jTextFieldBaseSample.setEditable(false);
        this.jTextFieldBaseSample.setBackground(new Color(255, 255, 204));
        this.jButtonBaseSample.setText("...");
        this.jButtonBaseSample.setToolTipText("Select base sample");
        this.jButtonBaseSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogBiocom.this.jButtonBaseSampleActionPerformed(evt);
            }
        });
        this.jButtonTopSample.setText("...");
        this.jButtonTopSample.setToolTipText("Select top sample");
        this.jButtonTopSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogBiocom.this.jButtonTopSampleActionPerformed(evt);
            }
        });
        this.jButtonAnalyst.setText("...");
        this.jButtonAnalyst.setToolTipText("Select analyst");
        this.jButtonAnalyst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogBiocom.this.jButtonAnalystActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Data source:");
        this.jTextFieldDataSource.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogBiocom.this.jTextFieldDataSourceKeyTyped(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogBiocom.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.setToolTipText("Press using CTRL + ENTER keys");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogBiocom.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogBiocom.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel).add(11, 11, 11)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jComboBoxAnalyst, -2, 73, -2).addPreferredGap(0).add((Component)this.jButtonAnalyst, -2, 27, -2)).add((Component)this.jComboBoxDisc, -2, 150, -2)).add(16, 16, 16).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel3).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldTopSample, -1, 161, Short.MAX_VALUE).add((Component)this.jTextFieldBaseSample)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButtonBaseSample, -2, 28, -2).add((Component)this.jButtonTopSample, -2, 28, -2)).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jTextFieldDataSource, -2, 164, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPaneComment).addContainerGap()))));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldTopSample, -2, -1, -2).add((Component)this.jLabel4).add((Component)this.jComboBoxDisc, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldBaseSample, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jComboBoxAnalyst, -2, -1, -2).add((Component)this.jButtonAnalyst)))).add((GroupLayout.Group)layout.createSequentialGroup().add(1, 1, 1).add((Component)this.jButtonTopSample).addPreferredGap(0).add((Component)this.jButtonBaseSample))).add(17, 17, 17).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.jTextFieldDataSource, -2, -1, -2)).addPreferredGap(1).add((Component)this.jScrollPaneComment, -1, 166, Short.MAX_VALUE).add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonAnalystActionPerformed(ActionEvent evt) {
        DialogSelectAnalyst dialog;
        try {
            dialog = new DialogSelectAnalyst(this, true, this.db);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
            return;
        }
        dialog.setVisible(true);
        if (dialog.selectedUser != null) {
            if (this.comboModelAnalyst.getIndexOf(dialog.selectedUser.getAbr()) < 0) {
                int pos;
                for (pos = 0; pos < this.comboModelAnalyst.getSize(); ++pos) {
                    String abr = (String)this.comboModelAnalyst.getElementAt(pos);
                    if (dialog.selectedUser.getAbr().compareTo(abr) < 0) break;
                }
                this.comboModelAnalyst.insertElementAt(dialog.selectedUser.getAbr(), pos);
                this.jComboBoxAnalyst.repaint();
            }
            this.jComboBoxAnalyst.setSelectedItem(dialog.selectedUser.getAbr());
        }
    }

    private void jButtonBaseSampleActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSample dialog = new DialogSelectSample(this, true, this.db, this.well, this.baseSample != null ? this.baseSample : this.topSample, this.units, false);
            dialog.setLocation(this.jButtonBaseSample.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.baseSample = dialog.selection;
                this.jTextFieldBaseSample.setText(this.baseSample.toString(this.units));
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonTopSampleActionPerformed(ActionEvent evt) {
        try {
            DialogSelectSample dialog = new DialogSelectSample(this, true, this.db, this.well, this.topSample != null ? this.topSample : this.baseSample, this.units, false);
            dialog.setLocation(this.jButtonTopSample.getLocationOnScreen());
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.topSample = dialog.selection;
                this.jTextFieldTopSample.setText(this.topSample.toString(this.units));
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int analyst;
        if (this.topSample == null) {
            JOptionPane.showMessageDialog(this, "Select a top sample", this.getTitle(), 2);
            return;
        }
        String analy = (String)this.jComboBoxAnalyst.getSelectedItem();
        if (analy == null || analy.length() == 0) {
            JOptionPane.showMessageDialog(this, "Select an analyst", this.getTitle(), 2);
            return;
        }
        try {
            analyst = this.db.getUserID(analy);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error getting analyst", sql, this.db);
            return;
        }
        String dataSource = this.jTextFieldDataSource.getText();
        String comment = this.jTextAreaComment.getText();
        if (comment.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a comment", this.getTitle(), 2);
            return;
        }
        if (comment.length() > 240) {
            JOptionPane.showMessageDialog(this, "Comment is too long to store in database. The total length must be 240 characters or less.", this.getTitle(), 1);
            return;
        }
        Discipline discID = (Discipline)this.jComboBoxDisc.getSelectedItem();
        try {
            if (this.biocom == null) {
                if (!comment.trim().isEmpty()) {
                    this.edit = this.wellInterp.addBiocom(new Biocom.Builder(this.db, discID, analyst, this.topSample, comment).source(dataSource).baseSample(this.baseSample), this.well.getWellID());
                }
            } else {
                this.edit = comment.trim().isEmpty() && JOptionPane.showConfirmDialog(this, "Delete this comment?", this.getTitle(), 0) == 0 ? this.wellInterp.deleteBiocom(this.biocom, this.well.getWellID()) : this.wellInterp.updateBiocom(this.biocom, new Biocom.Builder(this.db, discID, analyst, this.topSample, comment).source(dataSource).baseSample(this.baseSample), this.well.getWellID());
            }
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        if (this.edit != null) {
            this.undoSupport.postEdit((UndoableEdit)this.edit);
        }
        lastAnalystAbr = this.jComboBoxAnalyst.getSelectedItem().toString();
        lastDisc = (Discipline)this.jComboBoxDisc.getSelectedItem();
        this.setOK();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogbiocom.html");
    }

    private void jTextAreaCommentKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaComment, (int)240, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldDataSourceKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldDataSource, (int)50, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    void addText(String text) {
        if (text.trim().length() == 0) {
            return;
        }
        String existingText = this.jTextAreaComment.getText();
        if (existingText.length() > 0) {
            existingText = existingText + ", ";
        }
        if ((existingText = existingText + text).length() > 240) {
            existingText = existingText.substring(0, 239);
        }
        this.jTextAreaComment.setText(existingText);
        this.jTextAreaComment.repaint();
    }

    void setAnalyst(String analyst) {
        this.jComboBoxAnalyst.setSelectedItem(analyst);
    }

    void setDiscipline(Discipline disc) {
        this.jComboBoxDisc.setSelectedItem(disc);
    }
}

