/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogFilePreview;
import jsbugs.DialogSelectAnalyst;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import model2.Userdef;
import org.jdesktop.layout.GroupLayout;

public class DialogBugWareReader
extends JDialog {
    SBdb db;
    String fileName;
    boolean isOK;
    boolean ignoreSemiQuant;
    boolean useBioStratComments;
    boolean useSampleTops;
    char units;
    char discID;
    Userdef analyst = null;
    private ButtonGroup buttonGroupComments;
    private ButtonGroup buttonGroupDisc;
    private ButtonGroup buttonGroupSamples;
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonPreview;
    private JButton jButtonSelectAnalyst;
    private JCheckBox jCheckBoxIgnoreSemiQuant;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JRadioButton jRadioButtonAnalysisComments;
    private JRadioButton jRadioButtonBase;
    private JRadioButton jRadioButtonBiostratComments;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMacro;
    private JRadioButton jRadioButtonMetres;
    private JRadioButton jRadioButtonMicro;
    private JRadioButton jRadioButtonNanno;
    private JRadioButton jRadioButtonPaly;
    private JRadioButton jRadioButtonTop;
    private JSeparator jSeparator1;
    private JTextField jTextFieldDbAnalyst;
    private JTextField jTextFieldFileAnalyst;

    public DialogBugWareReader(Frame parent, boolean modal, SBdb db, String fileName) {
        super(parent, modal);
        this.db = db;
        this.fileName = fileName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("BugWare File Import Parameters");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (this.db.useSampleTops()) {
            this.jRadioButtonTop.setSelected(true);
        } else {
            this.jRadioButtonBase.setSelected(true);
        }
        if (this.fileName != null && this.fileName.toLowerCase().endsWith("def")) {
            this.jRadioButtonMicro.setSelected(true);
        } else if (this.fileName != null && this.fileName.toLowerCase().endsWith("den")) {
            this.jRadioButtonNanno.setSelected(true);
        }
        try {
            String buff;
            BufferedReader in = new BufferedReader(new FileReader(this.fileName));
            while ((buff = in.readLine()) != null) {
                if (!buff.toUpperCase().startsWith("PALEONTOLOGIST:")) continue;
                this.jTextFieldFileAnalyst.setText(buff.substring(buff.indexOf(58) + 1).trim());
                break;
            }
            in.close();
        }
        catch (Exception eio) {
            JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage(), this.getTitle(), 0);
            eio.printStackTrace();
        }
    }

    private void initComponents() {
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupDisc = new ButtonGroup();
        this.buttonGroupComments = new ButtonGroup();
        this.buttonGroupSamples = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMicro = new JRadioButton();
        this.jRadioButtonNanno = new JRadioButton();
        this.jRadioButtonPaly = new JRadioButton();
        this.jRadioButtonMacro = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jPanel5 = new JPanel();
        this.jRadioButtonAnalysisComments = new JRadioButton();
        this.jRadioButtonBiostratComments = new JRadioButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonPreview = new JButton();
        this.jCheckBoxIgnoreSemiQuant = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.jPanel3 = new JPanel();
        this.jTextFieldFileAnalyst = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jButtonSelectAnalyst = new JButton();
        this.jTextFieldDbAnalyst = new JTextField();
        this.jPanel4 = new JPanel();
        this.jRadioButtonTop = new JRadioButton();
        this.jRadioButtonBase = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Discipline", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupDisc.add(this.jRadioButtonMicro);
        this.jRadioButtonMicro.setText("Micropalaeontology");
        this.buttonGroupDisc.add(this.jRadioButtonNanno);
        this.jRadioButtonNanno.setText("Nannopalaeontology");
        this.buttonGroupDisc.add(this.jRadioButtonPaly);
        this.jRadioButtonPaly.setText("Palynology");
        this.buttonGroupDisc.add(this.jRadioButtonMacro);
        this.jRadioButtonMacro.setText("Macropalaeontology");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonMicro).add((Component)this.jRadioButtonNanno).add((Component)this.jRadioButtonPaly).add((Component)this.jRadioButtonMacro)).addContainerGap(36, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonMicro).addPreferredGap(1).add((Component)this.jRadioButtonNanno).addPreferredGap(1).add((Component)this.jRadioButtonPaly).addPreferredGap(0, 2, Short.MAX_VALUE).add((Component)this.jRadioButtonMacro)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Depth units", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jRadioButtonMetres).add((Component)this.jRadioButtonFeet)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jRadioButtonMetres).addPreferredGap(1).add((Component)this.jRadioButtonFeet).addContainerGap(51, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Comments destination", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupComments.add(this.jRadioButtonAnalysisComments);
        this.jRadioButtonAnalysisComments.setText("Sample analyses");
        this.buttonGroupComments.add(this.jRadioButtonBiostratComments);
        this.jRadioButtonBiostratComments.setText("Biostratigraphic comments");
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((Component)this.jRadioButtonAnalysisComments).add((Component)this.jRadioButtonBiostratComments)).addContainerGap(99, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonAnalysisComments).addPreferredGap(1).add((Component)this.jRadioButtonBiostratComments).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogBugWareReader.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogBugWareReader.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogBugWareReader.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonPreview.setText("Preview...");
        this.jButtonPreview.setToolTipText("Preview file contents in separate window");
        this.jButtonPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogBugWareReader.this.jButtonPreviewActionPerformed(evt);
            }
        });
        this.jCheckBoxIgnoreSemiQuant.setText("Ignore semi-quantitative abundances");
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Analyst", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jTextFieldFileAnalyst.setBackground(new Color(255, 255, 204));
        this.jTextFieldFileAnalyst.setEditable(false);
        this.jLabel1.setText("Analyst name in file header:");
        this.jLabel2.setText("Database analyst:");
        this.jButtonSelectAnalyst.setText("...");
        this.jButtonSelectAnalyst.setToolTipText("Select analyst");
        this.jButtonSelectAnalyst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogBugWareReader.this.jButtonSelectAnalystActionPerformed(evt);
            }
        });
        this.jTextFieldDbAnalyst.setEditable(false);
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(2).add((Component)this.jTextFieldFileAnalyst, -1, 236, Short.MAX_VALUE).add(1, (Component)this.jLabel1).add(1, (GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jTextFieldDbAnalyst, -1, 108, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonSelectAnalyst, -2, 30, -2))).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldFileAnalyst, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jButtonSelectAnalyst).add((Component)this.jTextFieldDbAnalyst, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Samples with single depths", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupSamples.add(this.jRadioButtonTop);
        this.jRadioButtonTop.setText("Use as top depth");
        this.buttonGroupSamples.add(this.jRadioButtonBase);
        this.jRadioButtonBase.setText("Use as base depth");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jRadioButtonTop).add((Component)this.jRadioButtonBase)).addContainerGap(135, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonTop).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonBase).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jCheckBoxIgnoreSemiQuant)).add((GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jSeparator1, -1, 264, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).add(6, 6, 6).add((Component)this.jButtonPreview).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2)).add(1, (Component)this.jPanel5, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((Component)this.jPanel5, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2).add(11, 11, 11).add((Component)this.jPanel3, -2, -1, -2).addPreferredGap(1).add((Component)this.jCheckBoxIgnoreSemiQuant).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK).add((Component)this.jButtonPreview)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonPreviewActionPerformed(ActionEvent evt) {
        DialogFilePreview dialog = new DialogFilePreview(this, false, this.fileName);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jButtonSelectAnalystActionPerformed(ActionEvent evt) {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst(this, true, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.analyst = dialog.selectedUser;
            if (this.analyst != null) {
                this.jTextFieldDbAnalyst.setText(this.analyst.getAbr());
            }
        }
        catch (SQLException sql) {
            JOptionPane.showMessageDialog(this, "Error opening Analyst dialog:/n" + sql, this.getTitle(), 0);
            sql.printStackTrace();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroupUnits.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select units used in file", this.getTitle(), 2);
            return;
        }
        if (this.buttonGroupDisc.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select discipline used in file", this.getTitle(), 2);
            return;
        }
        if (this.buttonGroupComments.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select comments destination", this.getTitle(), 2);
            return;
        }
        if (this.analyst == null) {
            JOptionPane.showMessageDialog(this, "Select an analyst", this.getTitle(), 2);
            return;
        }
        this.ignoreSemiQuant = this.jCheckBoxIgnoreSemiQuant.isSelected();
        this.useBioStratComments = this.jRadioButtonBiostratComments.isSelected();
        this.useSampleTops = this.jRadioButtonTop.isSelected();
        this.units = (char)(this.jRadioButtonMetres.isSelected() ? 77 : 70);
        if (this.jRadioButtonMicro.isSelected()) {
            this.discID = (char)77;
        } else if (this.jRadioButtonMacro.isSelected()) {
            this.discID = (char)65;
        } else if (this.jRadioButtonNanno.isSelected()) {
            this.discID = (char)78;
        } else if (this.jRadioButtonPaly.isSelected()) {
            this.discID = (char)80;
        }
        this.isOK = true;
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogbugwarereader.html");
    }
}

