/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import jsbugs.FrameJsbugs;
import model2.AbnScheme;
import model2.Categories;
import model2.Category;
import model2.Lastval;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.Taxon;
import model2.TaxonOcc;
import model2.TxGroup;
import model2.TxGroupSet;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class DialogCSVExport
extends JDialog {
    SBdb db;
    Well well;
    char units;
    char discID;
    int analystID;
    int analyNo;
    List<Smpdtl> selectedAnalyses;
    static String SORTFDO_STRING = "First Downhole Occurrence";
    static String SORTLDO_STRING = "Last Downhole Occurrence";
    static String SORTALPHA_STRING = "Alphabetic";
    private ButtonGroup buttonGroupCols;
    private ButtonGroup buttonGroupData;
    private ButtonGroup buttonGroupFormat;
    private ButtonGroup buttonGroupQuant;
    private ButtonGroup buttonGroupRowPref;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonSave;
    private JButton jButtonSelectFile;
    private JCheckBox jCheckBoxAlphaCodes;
    private JCheckBox jCheckBoxAnalyStatus;
    private JCheckBox jCheckBoxAnalyst;
    private JCheckBox jCheckBoxCombineAnalyses;
    private JCheckBox jCheckBoxDepthRange;
    private JCheckBox jCheckBoxIncludeGroupInfo;
    private JCheckBox jCheckBoxPrepared;
    private JCheckBox jCheckBoxQual;
    private JCheckBox jCheckBoxSampleType;
    private JCheckBox jCheckBoxShowTotals;
    private JCheckBox jCheckBoxSubCategories;
    private JCheckBox jCheckBoxTextLabel;
    private JCheckBox jCheckBoxUseAuthor;
    private JComboBox jComboBoxPercentWhich;
    private JComboBox jComboBoxSort;
    private JComboBox jComboBoxWhichData;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JRadioButton jRadioButtonByGroup;
    private JRadioButton jRadioButtonCategory;
    private JRadioButton jRadioButtonDisc;
    private JRadioButton jRadioButtonGroup;
    private JRadioButton jRadioButtonIndividual;
    private JRadioButton jRadioButtonOccurrenceRows;
    private JRadioButton jRadioButtonPercent;
    private JRadioButton jRadioButtonPercentCategory;
    private JRadioButton jRadioButtonPercentDisc;
    private JRadioButton jRadioButtonPercentGroup;
    private JRadioButton jRadioButtonPercentRw;
    private JRadioButton jRadioButtonPercentSet;
    private JRadioButton jRadioButtonQuant;
    private JRadioButton jRadioButtonRichness;
    private JRadioButton jRadioButtonRowTaxa;
    private JRadioButton jRadioButtonSampleRows;
    private JRadioButton jRadioButtonSemiQuant;
    private JRadioButton jRadioButtonSet;
    private JRadioButton jRadioButtonTotal;
    private JTextField jTextFieldFileName;

    public DialogCSVExport(Frame parent, boolean modal, SBdb db, List<Smpdtl> selectedAnalyses, Well well, char units, char discID, int analystID, int analyNo, String filename) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.well = well;
        this.units = units;
        this.discID = discID;
        this.analyNo = analyNo;
        this.analystID = analystID;
        this.selectedAnalyses = selectedAnalyses;
        this.initComponents();
        this.init(filename);
    }

    private void init(String filename) throws SQLException {
        this.setTitle("CSV File Export Options");
        this.jTextFieldFileName.setText(filename);
        this.getRootPane().setDefaultButton(this.jButtonSave);
        this.jComboBoxPercentWhich.removeAllItems();
        this.jComboBoxWhichData.removeAllItems();
        this.jComboBoxSort.removeAllItems();
        this.jComboBoxSort.addItem(SORTALPHA_STRING);
        this.jComboBoxSort.addItem(SORTFDO_STRING);
        this.jComboBoxSort.addItem(SORTLDO_STRING);
        this.loadDefaults();
    }

    private void initComponents() {
        this.buttonGroupData = new ButtonGroup();
        this.buttonGroupCols = new ButtonGroup();
        this.buttonGroupRowPref = new ButtonGroup();
        this.buttonGroupFormat = new ButtonGroup();
        this.buttonGroupQuant = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldFileName = new JTextField();
        this.jButtonSelectFile = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonDisc = new JRadioButton();
        this.jRadioButtonCategory = new JRadioButton();
        this.jComboBoxWhichData = new JComboBox();
        this.jRadioButtonGroup = new JRadioButton();
        this.jRadioButtonSet = new JRadioButton();
        this.jCheckBoxSubCategories = new JCheckBox();
        this.jCheckBoxPrepared = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jRadioButtonIndividual = new JRadioButton();
        this.jRadioButtonByGroup = new JRadioButton();
        this.jRadioButtonTotal = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.jRadioButtonSampleRows = new JRadioButton();
        this.jRadioButtonRowTaxa = new JRadioButton();
        this.jRadioButtonOccurrenceRows = new JRadioButton();
        this.jCheckBoxCombineAnalyses = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jRadioButtonQuant = new JRadioButton();
        this.jRadioButtonPercent = new JRadioButton();
        this.jRadioButtonSemiQuant = new JRadioButton();
        this.jRadioButtonRichness = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jComboBoxSort = new JComboBox();
        this.jPanel6 = new JPanel();
        this.jRadioButtonPercentDisc = new JRadioButton();
        this.jRadioButtonPercentCategory = new JRadioButton();
        this.jRadioButtonPercentGroup = new JRadioButton();
        this.jRadioButtonPercentSet = new JRadioButton();
        this.jComboBoxPercentWhich = new JComboBox();
        this.jRadioButtonPercentRw = new JRadioButton();
        this.jButtonCancel = new JButton();
        this.jButtonSave = new JButton();
        this.jButtonHelp = new JButton();
        this.jPanel5 = new JPanel();
        this.jCheckBoxUseAuthor = new JCheckBox();
        this.jCheckBoxShowTotals = new JCheckBox();
        this.jCheckBoxIncludeGroupInfo = new JCheckBox();
        this.jCheckBoxQual = new JCheckBox();
        this.jCheckBoxDepthRange = new JCheckBox();
        this.jCheckBoxTextLabel = new JCheckBox();
        this.jCheckBoxAnalyst = new JCheckBox();
        this.jCheckBoxSampleType = new JCheckBox();
        this.jCheckBoxAnalyStatus = new JCheckBox();
        this.jCheckBoxAlphaCodes = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("File:");
        this.jTextFieldFileName.setEditable(false);
        this.jTextFieldFileName.setBackground(new Color(255, 255, 204));
        this.jButtonSelectFile.setText("...");
        this.jButtonSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jButtonSelectFileActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Data to export", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupData.add(this.jRadioButtonDisc);
        this.jRadioButtonDisc.setText("Discipline");
        this.jRadioButtonDisc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonDiscActionPerformed(evt);
            }
        });
        this.buttonGroupData.add(this.jRadioButtonCategory);
        this.jRadioButtonCategory.setText("Category:");
        this.jRadioButtonCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonCategoryActionPerformed(evt);
            }
        });
        this.jComboBoxWhichData.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.buttonGroupData.add(this.jRadioButtonGroup);
        this.jRadioButtonGroup.setText("Group:");
        this.jRadioButtonGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonGroupActionPerformed(evt);
            }
        });
        this.buttonGroupData.add(this.jRadioButtonSet);
        this.jRadioButtonSet.setText("Group set:");
        this.jRadioButtonSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonSetActionPerformed(evt);
            }
        });
        this.jCheckBoxSubCategories.setText("Include sub-category taxa");
        this.jCheckBoxPrepared.setText("Include 'Prepared' analyses");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonDisc).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonGroup).addPreferredGap(1).add((Component)this.jRadioButtonSet).addPreferredGap(1).add((Component)this.jRadioButtonCategory)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jCheckBoxSubCategories, -2, 184, -2).add((Component)this.jComboBoxWhichData, -2, 175, -2))).add((Component)this.jCheckBoxPrepared)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonDisc).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonGroup).add((Component)this.jRadioButtonSet).add((Component)this.jRadioButtonCategory)).addPreferredGap(1).add((Component)this.jComboBoxWhichData, -2, -1, -2).addPreferredGap(0).add((Component)this.jCheckBoxSubCategories, -2, 30, -2).addPreferredGap(0, 28, Short.MAX_VALUE).add((Component)this.jCheckBoxPrepared).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Data columns", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupCols.add(this.jRadioButtonIndividual);
        this.jRadioButtonIndividual.setText("Individual taxa");
        this.jRadioButtonIndividual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonIndividualActionPerformed(evt);
            }
        });
        this.buttonGroupCols.add(this.jRadioButtonByGroup);
        this.jRadioButtonByGroup.setText("Group");
        this.jRadioButtonByGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonByGroupActionPerformed(evt);
            }
        });
        this.buttonGroupCols.add(this.jRadioButtonTotal);
        this.jRadioButtonTotal.setText("Total");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jRadioButtonIndividual).add((Component)this.jRadioButtonByGroup).add((Component)this.jRadioButtonTotal)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jRadioButtonIndividual).addPreferredGap(1).add((Component)this.jRadioButtonByGroup).addPreferredGap(1).add((Component)this.jRadioButtonTotal)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Column and row preference", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupRowPref.add(this.jRadioButtonSampleRows);
        this.jRadioButtonSampleRows.setText("Matrix - samples are columns");
        this.buttonGroupRowPref.add(this.jRadioButtonRowTaxa);
        this.jRadioButtonRowTaxa.setText("Matrix - taxa/titles are columns");
        this.jRadioButtonRowTaxa.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                DialogCSVExport.this.jRadioButtonRowTaxaItemStateChanged(evt);
            }
        });
        this.buttonGroupRowPref.add(this.jRadioButtonOccurrenceRows);
        this.jRadioButtonOccurrenceRows.setText("Occurrences on separate rows");
        this.jCheckBoxCombineAnalyses.setText("Combine sample analyses on same rows");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jRadioButtonOccurrenceRows).add((Component)this.jRadioButtonRowTaxa).add((Component)this.jRadioButtonSampleRows).add((Component)this.jCheckBoxCombineAnalyses)).addContainerGap(26, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jRadioButtonRowTaxa).addPreferredGap(0).add((Component)this.jCheckBoxCombineAnalyses).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jRadioButtonSampleRows).addPreferredGap(1).add((Component)this.jRadioButtonOccurrenceRows).addContainerGap()));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Output data format", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupFormat.add(this.jRadioButtonQuant);
        this.jRadioButtonQuant.setText("Quantitative - absolute abundance");
        this.jRadioButtonQuant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonQuantActionPerformed(evt);
            }
        });
        this.buttonGroupFormat.add(this.jRadioButtonPercent);
        this.jRadioButtonPercent.setText("Quantitative - % of:");
        this.jRadioButtonPercent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonPercentActionPerformed(evt);
            }
        });
        this.buttonGroupFormat.add(this.jRadioButtonSemiQuant);
        this.jRadioButtonSemiQuant.setText("Semi-quantitative");
        this.jRadioButtonSemiQuant.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonSemiQuantActionPerformed(evt);
            }
        });
        this.buttonGroupFormat.add(this.jRadioButtonRichness);
        this.jRadioButtonRichness.setText("Richness");
        this.jRadioButtonRichness.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonRichnessActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Sort order:");
        this.jComboBoxSort.setModel(new DefaultComboBoxModel<String>(new String[]{"First DownHole Occurrence", "Last Downhole Occurrence"}));
        this.jPanel6.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.buttonGroupQuant.add(this.jRadioButtonPercentDisc);
        this.jRadioButtonPercentDisc.setText("Discipline");
        this.jRadioButtonPercentDisc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonPercentDiscActionPerformed(evt);
            }
        });
        this.buttonGroupQuant.add(this.jRadioButtonPercentCategory);
        this.jRadioButtonPercentCategory.setText("Category:");
        this.jRadioButtonPercentCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonPercentCategoryActionPerformed(evt);
            }
        });
        this.buttonGroupQuant.add(this.jRadioButtonPercentGroup);
        this.jRadioButtonPercentGroup.setText("Group:");
        this.jRadioButtonPercentGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonPercentGroupActionPerformed(evt);
            }
        });
        this.buttonGroupQuant.add(this.jRadioButtonPercentSet);
        this.jRadioButtonPercentSet.setText("Group set:");
        this.jRadioButtonPercentSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonPercentSetActionPerformed(evt);
            }
        });
        this.jComboBoxPercentWhich.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout jPanel6Layout = new GroupLayout((Container)this.jPanel6);
        this.jPanel6.setLayout((LayoutManager)jPanel6Layout);
        jPanel6Layout.setHorizontalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((Component)this.jRadioButtonPercentDisc).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().add((Component)this.jRadioButtonPercentGroup).addPreferredGap(0, 4, Short.MAX_VALUE).add((Component)this.jRadioButtonPercentSet).addPreferredGap(1).add((Component)this.jRadioButtonPercentCategory))).addContainerGap()).add(2, (GroupLayout.Group)jPanel6Layout.createSequentialGroup().add(19, 19, 19).add((Component)this.jComboBoxPercentWhich, 0, 192, Short.MAX_VALUE).add(18, 18, 18)));
        jPanel6Layout.setVerticalGroup((GroupLayout.Group)jPanel6Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel6Layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jRadioButtonPercentDisc).addPreferredGap(1).add((GroupLayout.Group)jPanel6Layout.createParallelGroup(3).add((Component)this.jRadioButtonPercentGroup).add((Component)this.jRadioButtonPercentCategory).add((Component)this.jRadioButtonPercentSet)).addPreferredGap(0).add((Component)this.jComboBoxPercentWhich, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.buttonGroupFormat.add(this.jRadioButtonPercentRw);
        this.jRadioButtonPercentRw.setText("% Reworking");
        this.jRadioButtonPercentRw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jRadioButtonPercentRwActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((Component)this.jRadioButtonQuant).add((Component)this.jRadioButtonPercent).add((Component)this.jRadioButtonSemiQuant).add((Component)this.jComboBoxSort, 0, -1, Short.MAX_VALUE).add((Component)this.jLabel2).add((Component)this.jRadioButtonRichness).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().add(21, 21, 21).add((Component)this.jPanel6, -2, -1, -2)).add((Component)this.jRadioButtonPercentRw)).addContainerGap()));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonQuant).addPreferredGap(1).add((Component)this.jRadioButtonPercent).addPreferredGap(1).add((Component)this.jPanel6, -2, -1, -2).add(18, 18, 18).add((Component)this.jRadioButtonSemiQuant).addPreferredGap(0).add((Component)this.jRadioButtonRichness).addPreferredGap(0).add((Component)this.jRadioButtonPercentRw).addPreferredGap(1).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jComboBoxSort, -2, -1, -2).addContainerGap(26, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Close");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jButtonSaveActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVExport.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, "Include", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jCheckBoxUseAuthor.setText("Author and year in taxon name");
        this.jCheckBoxShowTotals.setText("Total count column when outputting % data");
        this.jCheckBoxIncludeGroupInfo.setText("Group and set name in titles");
        this.jCheckBoxQual.setText("Qualifiers (Rw, Cv, ?)");
        this.jCheckBoxDepthRange.setText("Sample depth range");
        this.jCheckBoxTextLabel.setText("Sample label");
        this.jCheckBoxAnalyst.setText("Analyst");
        this.jCheckBoxSampleType.setText("Sample type");
        this.jCheckBoxAnalyStatus.setText("Sample status (Prepared/Barren/Analysed)");
        this.jCheckBoxAlphaCodes.setText("Species codes");
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((Component)this.jCheckBoxUseAuthor, -2, 187, -2).add((Component)this.jCheckBoxQual).add((Component)this.jCheckBoxDepthRange).add((Component)this.jCheckBoxTextLabel).add((Component)this.jCheckBoxSampleType).add((Component)this.jCheckBoxAnalyst).add((Component)this.jCheckBoxAnalyStatus).add((Component)this.jCheckBoxShowTotals).add((Component)this.jCheckBoxAlphaCodes).add((Component)this.jCheckBoxIncludeGroupInfo)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel5Layout.createSequentialGroup().add((Component)this.jCheckBoxUseAuthor).addPreferredGap(0).add((Component)this.jCheckBoxAlphaCodes).addPreferredGap(0).add((Component)this.jCheckBoxShowTotals).add(3, 3, 3).add((Component)this.jCheckBoxIncludeGroupInfo).addPreferredGap(1).add((Component)this.jCheckBoxQual).addPreferredGap(1).add((Component)this.jCheckBoxDepthRange).addPreferredGap(1).add((Component)this.jCheckBoxTextLabel).addPreferredGap(1).add((Component)this.jCheckBoxSampleType).addPreferredGap(1).add((Component)this.jCheckBoxAnalyst).addPreferredGap(1).add((Component)this.jCheckBoxAnalyStatus).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldFileName, -2, 1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonSelectFile, -2, 30, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel4, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jPanel5, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonSave).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(1, (Component)this.jPanel2, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonSave}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldFileName, -2, -1, -2).add((Component)this.jButtonSelectFile)).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add(11, 11, 11).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel5, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2))).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonSave).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogcsvexportoptions.html");
    }

    private void jRadioButtonDiscActionPerformed(ActionEvent evt) {
        this.jComboBoxWhichData.removeAllItems();
        this.jComboBoxWhichData.setEnabled(false);
        this.jRadioButtonByGroup.setEnabled(false);
        if (this.jRadioButtonByGroup.isSelected()) {
            this.jRadioButtonIndividual.setSelected(true);
        }
    }

    private void jRadioButtonGroupActionPerformed(ActionEvent evt) {
        try {
            this.jComboBoxWhichData.removeAllItems();
            this.jComboBoxWhichData.setEnabled(true);
            if (this.jRadioButtonByGroup.isSelected()) {
                this.jRadioButtonIndividual.setSelected(true);
            }
            this.jRadioButtonByGroup.setEnabled(false);
            LinkedList groups = new LinkedList(this.db.getTxGroups());
            Collections.sort(groups);
            for (TxGroup group : groups) {
                this.jComboBoxWhichData.addItem(group);
            }
        }
        catch (SQLException se) {
            JOptionPane.showMessageDialog(null, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
        }
    }

    private void jRadioButtonSetActionPerformed(ActionEvent evt) {
        if (this.jRadioButtonSet.isSelected()) {
            this.jRadioButtonByGroup.setEnabled(true);
        } else {
            this.jRadioButtonByGroup.setEnabled(false);
            if (this.jRadioButtonByGroup.isSelected()) {
                this.jRadioButtonByGroup.setSelected(false);
            }
        }
        try {
            this.jComboBoxWhichData.removeAllItems();
            this.jComboBoxWhichData.setEnabled(true);
            for (TxGroupSet set : this.db.getTxGroupSetsSorted()) {
                this.jComboBoxWhichData.addItem(set);
            }
        }
        catch (SQLException se) {
            JOptionPane.showMessageDialog(null, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
        }
    }

    private void jRadioButtonCategoryActionPerformed(ActionEvent evt) {
        if (this.jRadioButtonByGroup.isSelected()) {
            this.jRadioButtonIndividual.setSelected(true);
        }
        this.jRadioButtonByGroup.setEnabled(false);
        this.jComboBoxWhichData.removeAllItems();
        this.jComboBoxWhichData.setEnabled(true);
        try {
            this.db.fillCatCombo(this.jComboBoxWhichData, false, null);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jRadioButtonPercentDiscActionPerformed(ActionEvent evt) {
        this.jComboBoxPercentWhich.removeAllItems();
        this.jComboBoxPercentWhich.setEnabled(false);
    }

    private void jRadioButtonPercentCategoryActionPerformed(ActionEvent evt) {
        this.jComboBoxPercentWhich.removeAllItems();
        this.jComboBoxPercentWhich.setEnabled(true);
        try {
            this.db.fillCatCombo(this.jComboBoxPercentWhich, false, null);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jRadioButtonPercentGroupActionPerformed(ActionEvent evt) {
        try {
            this.jComboBoxPercentWhich.removeAllItems();
            this.jComboBoxPercentWhich.setEnabled(true);
            LinkedList groups = new LinkedList(this.db.getTxGroups());
            Collections.sort(groups);
            for (TxGroup group : groups) {
                this.jComboBoxPercentWhich.addItem(group);
            }
        }
        catch (SQLException se) {
            JOptionPane.showMessageDialog(null, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
        }
    }

    private void jRadioButtonPercentSetActionPerformed(ActionEvent evt) {
        try {
            this.jComboBoxPercentWhich.removeAllItems();
            this.jComboBoxPercentWhich.setEnabled(true);
            for (TxGroupSet set : this.db.getTxGroupSetsSorted()) {
                this.jComboBoxPercentWhich.addItem(set);
            }
        }
        catch (SQLException se) {
            JOptionPane.showMessageDialog(null, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
        }
    }

    private void jRadioButtonPercentActionPerformed(ActionEvent evt) {
        this.jCheckBoxShowTotals.setEnabled(true);
        this.setPercentOptions(true);
    }

    private void jRadioButtonRichnessActionPerformed(ActionEvent evt) {
        this.jCheckBoxShowTotals.setEnabled(false);
        this.setPercentOptions(false);
    }

    private void jRadioButtonByGroupActionPerformed(ActionEvent evt) {
        this.setOptionsForTotal();
    }

    private void jRadioButtonIndividualActionPerformed(ActionEvent evt) {
        this.jRadioButtonRichness.setEnabled(false);
        this.jRadioButtonRichness.setSelected(false);
        this.jRadioButtonSemiQuant.setEnabled(true);
        this.jCheckBoxQual.setEnabled(true);
        this.jCheckBoxUseAuthor.setEnabled(true);
        this.jCheckBoxAlphaCodes.setEnabled(true);
        if (this.jRadioButtonSet.isSelected()) {
            this.jCheckBoxIncludeGroupInfo.setEnabled(true);
        } else {
            this.jCheckBoxIncludeGroupInfo.setEnabled(false);
        }
    }

    private void jRadioButtonSemiQuantActionPerformed(ActionEvent evt) {
        this.jCheckBoxShowTotals.setEnabled(false);
        this.setPercentOptions(false);
    }

    private void jRadioButtonQuantActionPerformed(ActionEvent evt) {
        this.jCheckBoxShowTotals.setEnabled(false);
        this.setPercentOptions(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveActionPerformed(ActionEvent evt) {
        if (this.buttonGroupData.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select discipline/category/group/group set", "Warning", 2);
            return;
        }
        if (this.buttonGroupCols.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select individual/total", "Warning", 2);
            return;
        }
        if (this.buttonGroupRowPref.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select which order you prefer for the output file, row/columns/occurrences", "Warning", 2);
            return;
        }
        if (this.buttonGroupFormat.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select absolute/percentage/semi-quantitative/diversity option", "Warning", 2);
            return;
        }
        if (this.jRadioButtonPercent.isSelected() && this.buttonGroupQuant.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select option for basis for calculating percentage", "Warning", 2);
            return;
        }
        String fileName = this.jTextFieldFileName.getText();
        File test = new File(fileName);
        if (test.exists()) {
            int option = JOptionPane.showConfirmDialog(this, "Overwrite file '" + fileName + "?", this.getTitle(), 1, 3);
            if (option == 2 || option == -1) {
                return;
            }
            if (option == 1) {
                this.jButtonSelectFileActionPerformed(null);
                fileName = this.jTextFieldFileName.getText();
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String catMnem = null;
            TxGroup group = null;
            TxGroupSet set = null;
            if (this.jRadioButtonGroup.isSelected()) {
                group = (TxGroup)this.jComboBoxWhichData.getSelectedItem();
            } else if (this.jRadioButtonCategory.isSelected()) {
                catMnem = Categories.getCatmnem((JComboBox)this.jComboBoxWhichData);
            } else if (this.jRadioButtonSet.isSelected()) {
                set = (TxGroupSet)this.jComboBoxWhichData.getSelectedItem();
                set.getGroups();
            }
            FileWriter out = new FileWriter(fileName);
            LinkedList taxa = new LinkedList();
            this.well.fillTaxonList(taxa, this.discID, this.analystID, this.analyNo);
            if (!this.jRadioButtonDisc.isSelected()) {
                this.filterTaxa(taxa, group, catMnem, set, this.jCheckBoxSubCategories.isSelected());
            }
            this.filterTaxaFromSamples(taxa);
            LinkedList totalTaxa = new LinkedList();
            TxGroup percentGroup = null;
            String percentCatMnem = null;
            TxGroupSet percentSet = null;
            if (this.jRadioButtonPercent.isSelected()) {
                this.well.fillTaxonList(totalTaxa, this.discID, this.analystID, this.analyNo);
                if (this.jRadioButtonPercentGroup.isSelected()) {
                    percentGroup = (TxGroup)this.jComboBoxPercentWhich.getSelectedItem();
                } else if (this.jRadioButtonPercentCategory.isSelected()) {
                    percentCatMnem = ((Category)this.jComboBoxWhichData.getSelectedItem()).getMnem();
                } else if (this.jRadioButtonPercentSet.isSelected()) {
                    percentSet = (TxGroupSet)this.jComboBoxPercentWhich.getSelectedItem();
                }
                if (!this.jRadioButtonPercentDisc.isSelected()) {
                    this.filterTaxa(totalTaxa, percentGroup, percentCatMnem, percentSet, this.jCheckBoxSubCategories.isSelected());
                }
            }
            Taxon.sort(taxa, (Taxon.SortOrder)Taxon.SortOrder.SORT_GENUS);
            if (this.jComboBoxSort.getSelectedItem().equals(SORTFDO_STRING)) {
                this.well.sortTaxonList(taxa, this.discID, 0);
            } else if (this.jComboBoxSort.getSelectedItem().equals(SORTLDO_STRING)) {
                this.well.sortTaxonList(taxa, this.discID, 1);
            }
            out.write("Sample data for well: " + this.well.getWellName());
            if (catMnem != null) {
                out.write(", Category " + catMnem);
            } else if (group != null) {
                out.write(", Group: " + group.getName());
            } else if (set != null) {
                out.write(", Group Set: " + set.getName());
            }
            if (this.jRadioButtonPercent.isSelected()) {
                out.write(", Percentage of taxa within/against " + (this.jRadioButtonPercentDisc.isSelected() ? SBdb.getDiscNoun((char)this.discID) : this.jComboBoxPercentWhich.getSelectedItem()));
            } else if (this.jRadioButtonRichness.isSelected()) {
                out.write(", Diversity");
            } else if (this.jRadioButtonPercentRw.isSelected()) {
                out.write(", % Reworking");
            }
            out.write(",\n");
            int nColumns = 0;
            boolean useCoreCorrections = false;
            boolean useCuttingCorrections = false;
            boolean askCores = false;
            boolean askCuttings = false;
            for (Sample sample : this.well.getSamples()) {
                int option;
                if (sample.getType().equals("CO") && !askCores) {
                    askCores = true;
                    if (this.well.getCoreShift().getSize() <= 0) continue;
                    option = JOptionPane.showConfirmDialog(this, "Do you want to output core-corrected depths for Core samples?", this.getTitle(), 1, 3);
                    if (option == 2) {
                        this.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    if (option != 0) continue;
                    useCoreCorrections = true;
                    continue;
                }
                if (!sample.getType().equals("CU") || askCuttings) continue;
                askCuttings = true;
                if (this.well.getCoreShift().getSize() <= 0) continue;
                option = JOptionPane.showConfirmDialog(this, "Do you want to output core-corrected depths for Cuttings?", this.getTitle(), 1, 3);
                if (option == 2) {
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                if (option != 0) continue;
                useCuttingCorrections = true;
            }
            boolean multipleSuiteNos = this.hasMultipleSuiteNos();
            if (this.jRadioButtonSampleRows.isSelected()) {
                AbnScheme abn;
                Smpdtl smpdtl;
                int i;
                Iterator en;
                out.write("Samples");
                if (this.jCheckBoxDepthRange.isSelected()) {
                    en = this.well.getSamples().iterator();
                    out.write(",top");
                    out.write(",");
                    if (this.jCheckBoxIncludeGroupInfo.isSelected() && set != null) {
                        out.write(",");
                        if (this.jRadioButtonIndividual.isSelected()) {
                            out.write(",");
                        }
                    }
                    while (en.hasNext()) {
                        Sample sample = (Sample)en.next();
                        for (i = 0; i < sample.getAnalyses().size(); ++i) {
                            smpdtl = (Smpdtl)sample.getAnalyses().get(i);
                            if (!this.includeAnalysis(smpdtl)) continue;
                            try {
                                if (sample.hasTopDepth()) {
                                    out.write(SB.floatString((double)this.well.getSampleTopDepth(sample, this.units, useCoreCorrections, useCuttingCorrections), (int)2));
                                }
                                out.write(",");
                                continue;
                            }
                            catch (SBException se) {
                                out.write("null,");
                            }
                        }
                    }
                    out.write(10);
                }
                en = this.well.getSamples().iterator();
                out.write(",");
                if (this.jCheckBoxDepthRange.isSelected()) {
                    out.write("base");
                } else {
                    out.write("depth");
                }
                out.write(",");
                if (this.jCheckBoxIncludeGroupInfo.isSelected() && set != null) {
                    out.write(",");
                    if (this.jRadioButtonIndividual.isSelected()) {
                        out.write(",");
                        ++nColumns;
                    }
                    ++nColumns;
                }
                nColumns += 2;
                while (en.hasNext()) {
                    Sample sample = (Sample)en.next();
                    for (i = 0; i < sample.getAnalyses().size(); ++i) {
                        smpdtl = (Smpdtl)sample.getAnalyses().get(i);
                        if (this.includeAnalysis(smpdtl)) {
                            try {
                                String sampString = "";
                                if (this.jCheckBoxDepthRange.isSelected()) {
                                    if (this.db.useSampleTops() && sample.hasTopDepth()) {
                                        sampString = sampString + this.well.getSampleTopDepth(sample, this.units, useCoreCorrections, useCuttingCorrections);
                                    } else if (!this.db.useSampleTops() && sample.hasBaseDepth()) {
                                        sampString = sampString + this.well.getSampleBaseDepth(sample, this.units, useCoreCorrections, useCuttingCorrections);
                                    }
                                } else {
                                    sampString = sampString + this.well.getDepth(sample, this.units, useCoreCorrections, useCuttingCorrections);
                                }
                                out.write(sampString + ",");
                            }
                            catch (SBException se) {
                                out.write("null,");
                            }
                        }
                        ++nColumns;
                    }
                }
                out.write(10);
                if (this.jCheckBoxSampleType.isSelected()) {
                    en = this.well.getSamples().iterator();
                    out.write(",type");
                    out.write(",");
                    if (this.jCheckBoxIncludeGroupInfo.isSelected() && set != null) {
                        out.write(",");
                        if (this.jRadioButtonIndividual.isSelected()) {
                            out.write(",");
                        }
                    }
                    while (en.hasNext()) {
                        Sample sample = (Sample)en.next();
                        for (i = 0; i < sample.getAnalyses().size(); ++i) {
                            smpdtl = (Smpdtl)sample.getAnalyses().get(i);
                            if (!this.includeAnalysis(smpdtl)) continue;
                            out.write(sample.getType() + ",");
                        }
                    }
                    out.write(10);
                }
                if (this.jCheckBoxTextLabel.isSelected()) {
                    en = this.well.getSamples().iterator();
                    out.write(",label");
                    out.write(",");
                    if (this.jCheckBoxIncludeGroupInfo.isSelected() && set != null) {
                        out.write(",");
                        if (this.jRadioButtonIndividual.isSelected()) {
                            out.write(",");
                        }
                    }
                    while (en.hasNext()) {
                        Sample sample = (Sample)en.next();
                        for (i = 0; i < sample.getAnalyses().size(); ++i) {
                            smpdtl = (Smpdtl)sample.getAnalyses().get(i);
                            if (!this.includeAnalysis(smpdtl)) continue;
                            out.write(sample.getLabel() + ",");
                        }
                    }
                    out.write(10);
                }
                if (this.jCheckBoxAnalyst.isSelected()) {
                    en = this.well.getSamples().iterator();
                    out.write(",analyst");
                    out.write(",");
                    if (this.jCheckBoxIncludeGroupInfo.isSelected() && set != null) {
                        out.write(",");
                        if (this.jRadioButtonIndividual.isSelected()) {
                            out.write(",");
                        }
                    }
                    while (en.hasNext()) {
                        Sample sample = (Sample)en.next();
                        for (i = 0; i < sample.getAnalyses().size(); ++i) {
                            smpdtl = (Smpdtl)sample.getAnalyses().get(i);
                            if (!this.includeAnalysis(smpdtl)) continue;
                            out.write(smpdtl.getAnalyst() + (multipleSuiteNos ? "/" + smpdtl.getAnalyNo() : "") + ",");
                        }
                    }
                    out.write(10);
                }
                if (this.jCheckBoxAnalyStatus.isSelected()) {
                    en = this.well.getSamples().iterator();
                    out.write(",status");
                    out.write(",");
                    if (this.jCheckBoxIncludeGroupInfo.isSelected() && set != null) {
                        out.write(",");
                        if (this.jRadioButtonIndividual.isSelected()) {
                            out.write(",");
                        }
                    }
                    while (en.hasNext()) {
                        Sample sample = (Sample)en.next();
                        for (i = 0; i < sample.getAnalyses().size(); ++i) {
                            smpdtl = (Smpdtl)sample.getAnalyses().get(i);
                            if (!this.includeAnalysis(smpdtl)) continue;
                            out.write(smpdtl.getAnalysisType().getString() + ",");
                        }
                    }
                    out.write(10);
                }
                if (this.jRadioButtonIndividual.isSelected()) {
                    for (Taxon taxon : taxa) {
                        out.write(taxon.toQuotedString(this.jCheckBoxUseAuthor.isSelected()) + "," + taxon.getCatMnem() + ",");
                        if (this.jCheckBoxAlphaCodes.isSelected()) {
                            out.write((taxon.getAlphaCode() != null ? taxon.getAlphaCode() : "") + ",");
                        }
                        if (this.jCheckBoxIncludeGroupInfo.isSelected() && set != null) {
                            out.write(set.getName() + ",");
                            String groupName = "";
                            for (TxGroup setGroup : set.getGroups()) {
                                if (!setGroup.isMember(taxon.getSpecID())) continue;
                                if (groupName.length() > 0) {
                                    groupName = groupName + " + ";
                                }
                                groupName = groupName + setGroup.getName();
                            }
                            out.write(groupName + ",");
                        }
                        for (Sample sample : this.well.getSamples()) {
                            for (int i2 = 0; i2 < sample.getAnalyses().size(); ++i2) {
                                Smpdtl smpdtl2 = (Smpdtl)sample.getAnalyses().get(i2);
                                AbnScheme abn2 = this.db.getAbnScheme(smpdtl2.getHeader().getAbnSchID(), true);
                                if (!this.includeAnalysis(smpdtl2)) continue;
                                float sampleTotal = this.getSampleTotal(sample, smpdtl2.getDiscID(), smpdtl2.getAnalyst(), totalTaxa, abn2);
                                this.writeOccurrence(out, abn2, sample, smpdtl2.getDiscID(), smpdtl2.getAnalyst(), taxon, sampleTotal, smpdtl2.getAnalyNo());
                                out.write(",");
                            }
                        }
                        out.write(10);
                    }
                } else if (this.jRadioButtonTotal.isSelected()) {
                    this.writeAggTitle(out);
                    out.write(",,");
                    for (Sample sample : this.well.getSamples()) {
                        for (i = 0; i < sample.getAnalyses().size(); ++i) {
                            smpdtl = (Smpdtl)sample.getAnalyses().get(i);
                            if (!this.includeAnalysis(smpdtl)) continue;
                            abn = this.db.getAbnScheme(smpdtl.getHeader().getAbnSchID(), true);
                            float sampleTotal = this.getSampleTotal(sample, smpdtl.getDiscID(), smpdtl.getAnalyst(), totalTaxa, abn);
                            this.writeAggregate(out, sample, smpdtl, taxa, null, abn, sampleTotal, this.jRadioButtonPercent.isSelected(), this.jRadioButtonRichness.isSelected(), this.jRadioButtonPercentRw.isSelected(), false);
                            out.write(",");
                        }
                    }
                    out.write(10);
                } else {
                    float sampleTotal;
                    if (this.jRadioButtonPercent.isSelected() && this.jCheckBoxShowTotals.isSelected()) {
                        out.write("Total,,");
                        if (this.jCheckBoxIncludeGroupInfo.isSelected()) {
                            out.write(",");
                        }
                        for (Sample sample : this.well.getSamples()) {
                            for (i = 0; i < sample.getAnalyses().size(); ++i) {
                                smpdtl = (Smpdtl)sample.getAnalyses().get(i);
                                if (!this.includeAnalysis(smpdtl)) continue;
                                abn = this.db.getAbnScheme(smpdtl.getHeader().getAbnSchID(), true);
                                sampleTotal = this.getSampleTotal(sample, smpdtl.getDiscID(), smpdtl.getAnalyst(), totalTaxa, abn);
                                out.write("" + sampleTotal + ",");
                            }
                        }
                        out.write("\n");
                    }
                    for (TxGroup setGroup : set.getGroups()) {
                        out.write(setGroup.getName());
                        out.write(",,");
                        if (this.jCheckBoxIncludeGroupInfo.isSelected()) {
                            out.write(set.getName() + ",");
                        }
                        for (Sample sample : this.well.getSamples()) {
                            for (int i3 = 0; i3 < sample.getAnalyses().size(); ++i3) {
                                Smpdtl smpdtl3 = (Smpdtl)sample.getAnalyses().get(i3);
                                if (!this.includeAnalysis(smpdtl3)) continue;
                                AbnScheme abn3 = this.db.getAbnScheme(smpdtl3.getHeader().getAbnSchID(), true);
                                sampleTotal = this.getSampleTotal(sample, smpdtl3.getDiscID(), smpdtl3.getAnalyst(), totalTaxa, abn3);
                                this.writeAggregate(out, sample, smpdtl3, taxa, setGroup, abn3, sampleTotal, this.jRadioButtonPercent.isSelected(), this.jRadioButtonRichness.isSelected(), this.jRadioButtonPercentRw.isSelected(), false);
                                out.write(",");
                            }
                        }
                        out.write("\n");
                    }
                }
            } else if (this.jRadioButtonRowTaxa.isSelected()) {
                if (this.jCheckBoxDepthRange.isSelected()) {
                    out.write("top,base,");
                    nColumns += 2;
                } else {
                    out.write("depth,");
                    ++nColumns;
                }
                if (this.jCheckBoxSampleType.isSelected()) {
                    out.write("type,");
                    ++nColumns;
                }
                if (this.jCheckBoxAnalyst.isSelected()) {
                    out.write("analyst,");
                    ++nColumns;
                }
                if (this.jCheckBoxTextLabel.isSelected()) {
                    out.write("label,");
                    ++nColumns;
                }
                if (this.jCheckBoxAnalyStatus.isSelected()) {
                    out.write("status,");
                    ++nColumns;
                }
                if (this.jRadioButtonPercent.isSelected() && this.jCheckBoxShowTotals.isSelected()) {
                    out.write("Total,");
                    ++nColumns;
                }
                int firstTaxonColumn = nColumns;
                if (this.jRadioButtonIndividual.isSelected()) {
                    for (Taxon taxon : taxa) {
                        out.write(taxon.toQuotedString(this.jCheckBoxUseAuthor.isSelected()) + ",");
                        ++nColumns;
                    }
                    out.write(10);
                    for (int i = 0; i < firstTaxonColumn; ++i) {
                        out.write(",");
                    }
                    for (Taxon taxon : taxa) {
                        out.write(taxon.getCatMnem() + ",");
                    }
                    out.write(10);
                    if (this.jCheckBoxAlphaCodes.isSelected()) {
                        for (int i = 0; i < firstTaxonColumn; ++i) {
                            out.write(",");
                        }
                        for (Taxon taxon : taxa) {
                            out.write((taxon.getAlphaCode() != null ? taxon.getAlphaCode() : "") + ",");
                        }
                        out.write(10);
                    }
                    if (this.jCheckBoxIncludeGroupInfo.isSelected() && set != null) {
                        int i;
                        for (i = 0; i < firstTaxonColumn; ++i) {
                            out.write(",");
                        }
                        Iterator it = taxa.iterator();
                        while (it.hasNext()) {
                            it.next();
                            out.write(set.getName() + ",");
                        }
                        out.write(10);
                        for (i = 0; i < firstTaxonColumn; ++i) {
                            out.write(",");
                        }
                        for (Taxon taxon : taxa) {
                            String groupName = "";
                            for (TxGroup setGroup : set.getGroups()) {
                                if (!setGroup.isMember(taxon.getSpecID())) continue;
                                if (groupName.length() > 0) {
                                    groupName = groupName + " + ";
                                }
                                groupName = groupName + setGroup.getName();
                            }
                            out.write(groupName + ",");
                        }
                        out.write(10);
                    }
                } else if (this.jRadioButtonTotal.isSelected()) {
                    this.writeAggTitle(out);
                    out.write(10);
                } else {
                    for (TxGroup setGroup : set.getGroups()) {
                        out.write(setGroup.getName() + ',');
                    }
                    out.write(10);
                }
                for (Sample sample : this.well.getSamples()) {
                    float sampleTotal;
                    System.out.println("Processing sample: " + sample);
                    if (this.jCheckBoxCombineAnalyses.isSelected()) {
                        if (!this.includeSample(sample)) continue;
                        this.writeSampleLabel(out, sample, null, useCoreCorrections, useCuttingCorrections, multipleSuiteNos);
                        sampleTotal = 0.0f;
                        if (!totalTaxa.isEmpty()) {
                            for (int i = 0; i < sample.getAnalyses().size(); ++i) {
                                Smpdtl smpdtl = (Smpdtl)sample.getAnalyses().get(i);
                                if (!this.includeAnalysis(smpdtl)) continue;
                                AbnScheme abn = this.db.getAbnScheme(smpdtl.getHeader().getAbnSchID(), true);
                                sampleTotal += (float)this.getSampleTotal(sample, smpdtl.getDiscID(), smpdtl.getAnalyst(), totalTaxa, abn);
                            }
                            System.out.println("Sample total is: " + sampleTotal);
                        }
                        if (this.jRadioButtonIndividual.isSelected()) {
                            if (this.jRadioButtonPercent.isSelected() && this.jCheckBoxShowTotals.isSelected()) {
                                out.write("" + sampleTotal + ",");
                            }
                            for (Taxon taxon : taxa) {
                                boolean hasOutput = false;
                                for (Smpdtl smpdtl : sample.getAnalyses()) {
                                    if (!this.includeAnalysis(smpdtl)) continue;
                                    AbnScheme abn = this.db.getAbnScheme(smpdtl.getHeader().getAbnSchID(), true);
                                    if (!smpdtl.hasSpecies(taxon.getSpecID())) continue;
                                    if (hasOutput) {
                                        throw new SBException("Cannot combine analyses: taxon: " + taxon + " occurs in > 1 analysis in sample: " + sample);
                                    }
                                    this.writeOccurrence(out, abn, sample, smpdtl.getDiscID(), smpdtl.getAnalyst(), taxon, sampleTotal, smpdtl.getAnalyNo());
                                    hasOutput = true;
                                }
                                out.write(",");
                            }
                        } else if (this.jRadioButtonTotal.isSelected()) {
                            this.writeAggregate(out, sample, null, taxa, null, null, sampleTotal, this.jRadioButtonPercent.isSelected(), this.jRadioButtonRichness.isSelected(), this.jRadioButtonPercentRw.isSelected(), true);
                            out.write(",");
                        } else {
                            Iterator it = set.getGroups().iterator();
                            boolean first = true;
                            while (it.hasNext()) {
                                TxGroup setGroup = (TxGroup)it.next();
                                this.writeAggregate(out, sample, null, taxa, setGroup, null, sampleTotal, this.jRadioButtonPercent.isSelected(), this.jRadioButtonRichness.isSelected(), this.jRadioButtonPercentRw.isSelected(), first);
                                first = false;
                                out.write(",");
                            }
                        }
                        out.write(10);
                        continue;
                    }
                    for (int i = 0; i < sample.getAnalyses().size(); ++i) {
                        Smpdtl smpdtl = (Smpdtl)sample.getAnalyses().get(i);
                        if (!this.includeAnalysis(smpdtl)) continue;
                        this.writeSampleLabel(out, sample, smpdtl, useCoreCorrections, useCuttingCorrections, multipleSuiteNos);
                        AbnScheme abn = this.db.getAbnScheme(smpdtl.getHeader().getAbnSchID(), true);
                        sampleTotal = this.getSampleTotal(sample, smpdtl.getDiscID(), smpdtl.getAnalyst(), totalTaxa, abn);
                        if (this.jRadioButtonIndividual.isSelected()) {
                            if (this.jRadioButtonPercent.isSelected() && this.jCheckBoxShowTotals.isSelected()) {
                                out.write("" + sampleTotal + ",");
                            }
                            for (Taxon taxon : taxa) {
                                this.writeOccurrence(out, abn, sample, smpdtl.getDiscID(), smpdtl.getAnalyst(), taxon, sampleTotal, smpdtl.getAnalyNo());
                                out.write(",");
                            }
                        } else if (this.jRadioButtonTotal.isSelected()) {
                            this.writeAggregate(out, sample, smpdtl, taxa, null, abn, sampleTotal, this.jRadioButtonPercent.isSelected(), this.jRadioButtonRichness.isSelected(), this.jRadioButtonPercentRw.isSelected(), true);
                        } else {
                            Iterator it = set.getGroups().iterator();
                            boolean first = true;
                            while (it.hasNext()) {
                                TxGroup setGroup = (TxGroup)it.next();
                                this.writeAggregate(out, sample, smpdtl, taxa, setGroup, abn, sampleTotal, this.jRadioButtonPercent.isSelected(), this.jRadioButtonRichness.isSelected(), this.jRadioButtonPercentRw.isSelected(), first);
                                first = false;
                                out.write(",");
                            }
                        }
                        out.write(10);
                    }
                }
                out.write(10);
            } else {
                for (Sample sample : this.well.getSamples()) {
                    for (int i = 0; i < sample.getAnalyses().size(); ++i) {
                        Smpdtl smpdtl = (Smpdtl)sample.getAnalyses().get(i);
                        if (!this.includeAnalysis(smpdtl)) continue;
                        AbnScheme abn = this.db.getAbnScheme(smpdtl.getHeader().getAbnSchID(), true);
                        float sampleTotal = this.getSampleTotal(sample, smpdtl.getDiscID(), smpdtl.getAnalyst(), totalTaxa, abn);
                        if (this.jRadioButtonIndividual.isSelected()) {
                            for (Taxon taxon : taxa) {
                                if (!smpdtl.hasSpecies(taxon.getSpecID())) continue;
                                this.writeSampleLabel(out, sample, smpdtl, useCoreCorrections, useCuttingCorrections, multipleSuiteNos);
                                out.write(taxon.toQuotedString(this.jCheckBoxUseAuthor.isSelected()) + ",");
                                if (this.jCheckBoxAlphaCodes.isSelected()) {
                                    out.write((taxon.getAlphaCode() != null ? taxon.getAlphaCode() : "") + ",");
                                }
                                this.writeOccurrence(out, abn, sample, smpdtl.getDiscID(), smpdtl.getAnalyst(), taxon, sampleTotal, smpdtl.getAnalyNo());
                                out.write("\n");
                            }
                            continue;
                        }
                        if (this.jRadioButtonTotal.isSelected()) {
                            this.writeSampleLabel(out, sample, smpdtl, useCoreCorrections, useCuttingCorrections, multipleSuiteNos);
                            this.writeAggTitle(out);
                            out.write(44);
                            this.writeAggregate(out, sample, smpdtl, taxa, null, abn, sampleTotal, this.jRadioButtonPercent.isSelected(), this.jRadioButtonRichness.isSelected(), this.jRadioButtonPercentRw.isSelected(), true);
                            continue;
                        }
                        Iterator it = set.getGroups().iterator();
                        boolean first = true;
                        while (it.hasNext()) {
                            this.writeSampleLabel(out, sample, smpdtl, useCoreCorrections, useCuttingCorrections, multipleSuiteNos);
                            TxGroup setGroup = (TxGroup)it.next();
                            out.write(setGroup.getName() + ',');
                            this.writeAggregate(out, sample, smpdtl, taxa, setGroup, abn, sampleTotal, this.jRadioButtonPercent.isSelected(), this.jRadioButtonRichness.isSelected(), this.jRadioButtonPercentRw.isSelected(), first);
                            first = false;
                            out.write("\n");
                        }
                    }
                }
                out.write(10);
            }
            out.close();
            if (nColumns > 256 && JOptionPane.showConfirmDialog(this, "Warning, you have output " + nColumns + " columns of data (typical spreadsheet limit is 256).\nIs this OK?", "Warning", 0) != 0) {
                return;
            }
            this.saveDefaults();
            this.db.getDatabase().commit();
            JOptionPane.showMessageDialog(this, "File '" + fileName + "' saved.", this.getTitle(), 1);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "File error: " + ex.getMessage());
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage());
        }
        catch (SQLException se) {
            JOptionPane.showMessageDialog(null, "Error: " + se.getMessage() + "\nSQL: " + SB.sql, "SQL Error", 0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonSelectFileActionPerformed(ActionEvent evt) {
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.db, (String)"WINCSVFILE", (String)"UNXCSVFILE"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (setDir == null || !setDir.exists()) {
            setDir = new File(".");
        }
        JFileChooser jFileChooser1 = new JFileChooser();
        String fileName = this.jTextFieldFileName.getText();
        if (fileName != null && fileName.length() > 0) {
            jFileChooser1.setCurrentDirectory(new File(fileName));
        } else {
            jFileChooser1.setCurrentDirectory(setDir);
        }
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("csv");
        filter.setDescription("CSV files");
        jFileChooser1.setFileFilter((FileFilter)filter);
        if (0 == jFileChooser1.showSaveDialog(this)) {
            fileName = jFileChooser1.getSelectedFile().getPath();
            if (fileName.indexOf(".csv") < 0 && fileName.indexOf(".CSV") < 0) {
                fileName = fileName + ".csv";
            }
            this.jTextFieldFileName.setText(fileName);
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jRadioButtonPercentRwActionPerformed(ActionEvent evt) {
        this.setPercentOptions(false);
        this.jRadioButtonTotal.setSelected(true);
        this.jRadioButtonIndividual.setEnabled(false);
        this.jRadioButtonGroup.setEnabled(false);
    }

    private void jRadioButtonRowTaxaItemStateChanged(ItemEvent evt) {
        this.jCheckBoxCombineAnalyses.setEnabled(this.jRadioButtonRowTaxa.isSelected());
    }

    void setOptionsForTotal() {
        this.jRadioButtonRichness.setEnabled(true);
        this.jRadioButtonPercentRw.setEnabled(true);
        this.jRadioButtonSemiQuant.setEnabled(false);
        this.jRadioButtonSemiQuant.setSelected(false);
        this.jCheckBoxQual.setEnabled(false);
        this.jCheckBoxUseAuthor.setEnabled(false);
        this.jCheckBoxAlphaCodes.setEnabled(false);
        this.jCheckBoxIncludeGroupInfo.setEnabled(false);
    }

    void saveDefaults() throws SQLException {
        String defString = "";
        defString = this.jRadioButtonDisc.isSelected() ? defString + "DIS" : (this.jRadioButtonCategory.isSelected() ? defString + "CAT" : (this.jRadioButtonGroup.isSelected() ? defString + "GRP" : (this.jRadioButtonSet.isSelected() ? defString + "SET" : defString + "---")));
        defString = defString + "|";
        defString = this.jComboBoxWhichData.getSelectedItem() != null ? defString + this.jComboBoxWhichData.getSelectedItem() : defString + "---";
        defString = defString + "|";
        defString = this.jRadioButtonIndividual.isSelected() ? defString + "IND" : (this.jRadioButtonByGroup.isSelected() ? defString + "GRP" : (this.jRadioButtonTotal.isSelected() ? defString + "TOT" : defString + "---"));
        defString = defString + "|";
        defString = this.jRadioButtonQuant.isSelected() ? defString + "QNT" : (this.jRadioButtonSemiQuant.isSelected() ? defString + "SQT" : (this.jRadioButtonRichness.isSelected() ? defString + "DIV" : (this.jRadioButtonPercentRw.isSelected() ? defString + "PRW" : (this.jRadioButtonPercent.isSelected() ? defString + "PCT" : defString + "---"))));
        defString = defString + "|";
        defString = this.jRadioButtonPercentDisc.isSelected() ? defString + "PDS" : (this.jRadioButtonPercentCategory.isSelected() ? defString + "PCA" : (this.jRadioButtonPercentGroup.isSelected() ? defString + "PGP" : (this.jRadioButtonPercentSet.isSelected() ? defString + "PST" : defString + "---")));
        defString = defString + "|";
        defString = this.jComboBoxPercentWhich.getSelectedItem() != null ? defString + this.jComboBoxPercentWhich.getSelectedItem() : defString + "---";
        defString = defString + "|";
        defString = defString + this.jCheckBoxUseAuthor.isSelected() + "|";
        defString = defString + this.jCheckBoxShowTotals.isSelected() + "|";
        defString = defString + this.jCheckBoxQual.isSelected() + "|";
        defString = defString + this.jCheckBoxIncludeGroupInfo.isSelected() + "|";
        String sort = (String)this.jComboBoxSort.getSelectedItem();
        if (sort != null) {
            if (sort.equals(SORTALPHA_STRING)) {
                defString = defString + "STA";
            } else if (sort.equals(SORTFDO_STRING)) {
                defString = defString + "SFD";
            } else if (sort.equals(SORTLDO_STRING)) {
                defString = defString + "SLD";
            }
        } else {
            defString = defString + "|";
        }
        defString = defString + "|";
        defString = defString + this.jCheckBoxDepthRange.isSelected() + "|";
        defString = defString + this.jCheckBoxTextLabel.isSelected() + "|";
        defString = defString + this.jCheckBoxAnalyst.isSelected() + "|";
        defString = defString + this.jCheckBoxSampleType.isSelected() + "|";
        defString = defString + "|";
        defString = this.jRadioButtonSampleRows.isSelected() ? defString + "RWS" : (this.jRadioButtonRowTaxa.isSelected() ? defString + "RWT" : (this.jRadioButtonOccurrenceRows.isSelected() ? defString + "RWO" : defString + "---"));
        defString = defString + "|";
        defString = defString + this.jCheckBoxPrepared.isSelected() + "|";
        defString = defString + this.jCheckBoxAnalyStatus.isSelected() + "|";
        defString = defString + this.jCheckBoxAlphaCodes.isSelected() + "|";
        defString = defString + this.jCheckBoxCombineAnalyses.isSelected() + "|";
        Lastval.putString((SBdb)this.db, (String)"CSVOPT", (String)defString);
        Lastval.putString((SBdb)this.db, (String)"WINCSVFILE", (String)"UNXCSVFILE", (String)this.jTextFieldFileName.getText());
    }

    void loadDefaults() throws SQLException {
        String defString = Lastval.getString((SBdb)this.db, (String)"CSVOPT");
        if (defString != null && defString.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(defString, "|");
            try {
                int i;
                int itemCount;
                String tok = tokens.nextToken();
                if (tok.equals("DIS")) {
                    this.jRadioButtonDisc.setSelected(true);
                    this.jRadioButtonDiscActionPerformed(null);
                } else if (tok.equals("CAT")) {
                    this.jRadioButtonCategory.setSelected(true);
                    this.jRadioButtonCategoryActionPerformed(null);
                } else if (tok.equals("GRP")) {
                    this.jRadioButtonGroup.setSelected(true);
                    this.jRadioButtonGroupActionPerformed(null);
                } else if (tok.equals("SET")) {
                    this.jRadioButtonSet.setSelected(true);
                    this.jRadioButtonSetActionPerformed(null);
                }
                tok = tokens.nextToken();
                if (!tok.equals("---")) {
                    itemCount = this.jComboBoxWhichData.getItemCount();
                    for (i = 0; i < itemCount; ++i) {
                        if (!this.jComboBoxWhichData.getItemAt(i).toString().equals(tok)) continue;
                        this.jComboBoxWhichData.setSelectedIndex(i);
                        break;
                    }
                }
                if ((tok = tokens.nextToken()).equals("IND")) {
                    this.jRadioButtonIndividual.setSelected(true);
                } else if (tok.equals("GRP")) {
                    this.jRadioButtonGroup.setSelected(true);
                } else if (tok.equals("TOT")) {
                    this.jRadioButtonTotal.setSelected(true);
                }
                tok = tokens.nextToken();
                if (tok.equals("QNT")) {
                    this.jRadioButtonQuant.setSelected(true);
                    this.setPercentOptions(false);
                } else if (tok.equals("SQT")) {
                    this.jRadioButtonSemiQuant.setSelected(true);
                    this.setPercentOptions(false);
                } else if (tok.equals("DIV")) {
                    this.jRadioButtonRichness.setSelected(true);
                    this.setPercentOptions(false);
                } else if (tok.equals("PRW")) {
                    this.jRadioButtonPercentRw.setSelected(true);
                    this.setPercentOptions(false);
                } else if (tok.equals("PCT")) {
                    this.jRadioButtonPercent.setSelected(true);
                    this.setPercentOptions(true);
                } else if (tok.equals("SQT")) {
                    this.jRadioButtonSemiQuant.setSelected(true);
                    this.setPercentOptions(false);
                }
                tok = tokens.nextToken();
                if (tok.equals("PDS")) {
                    this.jRadioButtonPercentDisc.setSelected(true);
                    this.jRadioButtonPercentDiscActionPerformed(null);
                } else if (tok.equals("PCA")) {
                    this.jRadioButtonPercentCategory.setSelected(true);
                    this.jRadioButtonPercentCategoryActionPerformed(null);
                } else if (tok.equals("PGP")) {
                    this.jRadioButtonPercentGroup.setSelected(true);
                    this.jRadioButtonPercentGroupActionPerformed(null);
                } else if (tok.equals("PST")) {
                    this.jRadioButtonPercentSet.setSelected(true);
                    this.jRadioButtonPercentSetActionPerformed(null);
                }
                tok = tokens.nextToken();
                if (!tok.equals("---")) {
                    itemCount = this.jComboBoxPercentWhich.getItemCount();
                    for (i = 0; i < itemCount; ++i) {
                        if (!this.jComboBoxPercentWhich.getItemAt(i).toString().equals(tok)) continue;
                        this.jComboBoxPercentWhich.setSelectedIndex(i);
                        break;
                    }
                }
                tok = tokens.nextToken();
                this.jCheckBoxUseAuthor.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                this.jCheckBoxShowTotals.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                this.jCheckBoxQual.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                this.jCheckBoxIncludeGroupInfo.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                if (tok.equals("STA")) {
                    this.jComboBoxSort.setSelectedItem(SORTALPHA_STRING);
                } else if (tok.equals("SFD")) {
                    this.jComboBoxSort.setSelectedItem(SORTFDO_STRING);
                } else if (tok.equals("SLD")) {
                    this.jComboBoxSort.setSelectedItem(SORTLDO_STRING);
                }
                tok = tokens.nextToken();
                this.jCheckBoxDepthRange.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                this.jCheckBoxTextLabel.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                this.jCheckBoxAnalyst.setSelected(Boolean.valueOf(tok));
                tok = tokens.nextToken();
                this.jCheckBoxSampleType.setSelected(Boolean.valueOf(tok));
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    if (tok.equals("RWS")) {
                        this.jRadioButtonSampleRows.setSelected(true);
                    } else if (tok.equals("RWT")) {
                        this.jRadioButtonRowTaxa.setSelected(true);
                    } else if (tok.equals("RWO")) {
                        this.jRadioButtonOccurrenceRows.setSelected(true);
                    }
                }
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    this.jCheckBoxPrepared.setSelected(Boolean.valueOf(tok));
                }
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    this.jCheckBoxAnalyStatus.setSelected(Boolean.valueOf(tok));
                }
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    this.jCheckBoxAlphaCodes.setSelected(Boolean.valueOf(tok));
                }
                if (tokens.hasMoreTokens()) {
                    tok = tokens.nextToken();
                    this.jCheckBoxCombineAnalyses.setSelected(Boolean.valueOf(tok));
                }
            }
            catch (NoSuchElementException ex) {
                ex.printStackTrace();
            }
        }
    }

    void setPercentOptions(boolean enabled) {
        this.jRadioButtonPercentCategory.setEnabled(enabled);
        this.jRadioButtonPercentSet.setEnabled(enabled);
        this.jRadioButtonPercentDisc.setEnabled(enabled);
        this.jRadioButtonPercentGroup.setEnabled(enabled);
        this.jComboBoxPercentWhich.setEnabled(enabled);
        this.jRadioButtonIndividual.setEnabled(true);
        this.jRadioButtonGroup.setEnabled(true);
    }

    void writeSampleLabel(FileWriter out, Sample sample, Smpdtl smpdtl, boolean useCoreCorrections, boolean useCuttingCorrections, boolean hasMultipleSuiteNos) throws IOException, SBException, SQLException, IOException {
        Smpdtl d;
        int i;
        if (this.jCheckBoxDepthRange.isSelected()) {
            try {
                if (sample.hasTopDepth()) {
                    out.write(SB.floatString((double)this.well.getSampleTopDepth(sample, this.units, useCoreCorrections, useCuttingCorrections), (int)2));
                }
                out.write(",");
                if (sample.hasBaseDepth()) {
                    out.write(SB.floatString((double)this.well.getSampleBaseDepth(sample, this.units, useCoreCorrections, useCuttingCorrections), (int)2));
                }
                out.write(",");
            }
            catch (SBException se) {
                out.write("null,null,");
            }
        } else {
            try {
                out.write(SB.floatString((double)this.well.getDepth(sample, this.units, useCoreCorrections, useCuttingCorrections), (int)2) + ",");
            }
            catch (SBException se) {
                out.write("null,");
            }
        }
        if (this.jCheckBoxSampleType.isSelected()) {
            out.write(sample.getType() + ",");
        }
        if (this.jCheckBoxAnalyst.isSelected()) {
            if (smpdtl != null) {
                out.write(smpdtl.getAnalyst() + (hasMultipleSuiteNos ? "/" + smpdtl.getAnalyNo() : "") + ",");
            } else {
                boolean first = true;
                for (i = 0; i < sample.getAnalyses().size(); ++i) {
                    d = (Smpdtl)sample.getAnalyses().get(i);
                    if (!this.includeAnalysis(d)) continue;
                    if (!first) {
                        out.write("+");
                    }
                    out.write(d.getAnalyst() + (hasMultipleSuiteNos ? "/" + d.getAnalyNo() : ""));
                    first = false;
                }
                out.write(",");
            }
        }
        if (this.jCheckBoxTextLabel.isSelected()) {
            out.write(sample.getLabel() + ",");
        }
        if (this.jCheckBoxAnalyStatus.isSelected()) {
            if (smpdtl != null) {
                out.write(smpdtl.getAnalysisType().getString() + ",");
            } else {
                boolean first = true;
                for (i = 0; i < sample.getAnalyses().size(); ++i) {
                    d = (Smpdtl)sample.getAnalyses().get(i);
                    if (!this.includeAnalysis(d)) continue;
                    if (!first) {
                        out.write("+");
                    }
                    out.write(d.getAnalysisType().getString());
                    first = false;
                }
                out.write(",");
            }
        }
    }

    private boolean hasMultipleSuiteNos() throws SQLException, SBException {
        Iterator en = this.well.getSamples().iterator();
        Integer analyNumber = null;
        while (en.hasNext()) {
            Sample sample = (Sample)en.next();
            for (int i = 0; i < sample.getAnalyses().size(); ++i) {
                Smpdtl smpdtl = (Smpdtl)sample.getAnalyses().get(i);
                if (this.discID != '\u0000' && smpdtl.getDiscID() != this.discID) continue;
                if (analyNumber == null) {
                    analyNumber = smpdtl.getAnalyNo();
                    continue;
                }
                if (analyNumber.intValue() == smpdtl.getAnalyNo()) continue;
                return true;
            }
        }
        return false;
    }

    void filterTaxa(List taxa, TxGroup group, String catMnem, TxGroupSet set, boolean includeSubCat) throws SQLException, SBException {
        Iterator it = taxa.iterator();
        if (set != null) {
            set.getGroups();
        }
        while (it.hasNext()) {
            Taxon taxon = (Taxon)it.next();
            boolean keep = false;
            if (catMnem != null) {
                if (includeSubCat && taxon.getCatMnem().startsWith(catMnem)) {
                    keep = true;
                } else if (!includeSubCat && taxon.getCatMnem().equals(catMnem)) {
                    keep = true;
                }
            } else if (group != null && group.isMember(taxon.getSpecID())) {
                keep = true;
            } else if (set != null && set.isMember(taxon.getSpecID())) {
                keep = true;
            }
            if (keep) continue;
            it.remove();
        }
    }

    void filterTaxaFromSamples(List taxa) throws SQLException, SBException {
        if (this.selectedAnalyses == null) {
            return;
        }
        Iterator it = taxa.iterator();
        while (it.hasNext()) {
            Taxon taxon = (Taxon)it.next();
            boolean keep = false;
            block1: for (Sample sample : this.well.getSamples()) {
                for (Smpdtl smpdtl : sample.getAnalyses()) {
                    if (!this.includeAnalysis(smpdtl) || !smpdtl.hasSpecies(taxon.getSpecID())) continue;
                    keep = true;
                    break block1;
                }
            }
            if (keep) continue;
            it.remove();
        }
    }

    void writeAggTitle(FileWriter out) throws IOException {
        if (this.jRadioButtonPercent.isSelected()) {
            out.write("Percent");
        } else if (this.jRadioButtonRichness.isSelected()) {
            out.write("Diversity");
        } else if (this.jRadioButtonPercentRw.isSelected()) {
            out.write("% Reworking");
        } else {
            out.write("Count");
        }
    }

    void writeOccurrence(FileWriter out, AbnScheme abn, Sample sample, char discID, String analyst, Taxon taxon, float sampleTotal, int suiteNo) throws IOException, SQLException, SBException {
        Smpdtl smpdtl = sample.getSmpdtl(discID, analyst, suiteNo);
        Iterator it2 = smpdtl.getOccur().iterator();
        int fssTotal = 0;
        String qualifiers = "";
        String subjAbund = "";
        boolean doesOccur = false;
        while (it2.hasNext()) {
            TaxonOcc fss = (TaxonOcc)it2.next();
            if (fss.getTaxon() == null || taxon != fss.getTaxon()) continue;
            fssTotal += fss.getDerivedCount(abn);
            if (subjAbund.length() == 0) {
                subjAbund = fss.getSubAbund(abn);
            }
            qualifiers = qualifiers + fss.getAllQualifiers();
            doesOccur = true;
        }
        if (!doesOccur) {
            return;
        }
        boolean writeOutsideCount = false;
        if (this.jRadioButtonQuant.isSelected()) {
            if (fssTotal == 0) {
                writeOutsideCount = true;
            } else {
                out.write("" + fssTotal);
            }
        } else if (this.jRadioButtonPercent.isSelected()) {
            if (fssTotal > 0) {
                float percent = sampleTotal == 0.0f && fssTotal == 0 ? 0.0f : (float)fssTotal * 100.0f / sampleTotal;
                if (sampleTotal == 0.0f) {
                    out.write("Error");
                } else {
                    out.write("" + percent);
                }
            }
        } else {
            out.write(subjAbund);
        }
        if (this.jCheckBoxQual.isSelected() && qualifiers.length() > 0) {
            out.write(" " + qualifiers);
        }
        if (writeOutsideCount) {
            out.write("+");
        }
    }

    int getSampleTotal(Sample sample, char discID, String analyst, List taxa, AbnScheme abn) throws SQLException, SBException {
        Smpdtl smpdtl = sample.getAnySmpdtl(discID, analyst);
        Iterator it2 = smpdtl.getOccur().iterator();
        int listTotal = 0;
        while (it2.hasNext()) {
            TaxonOcc fss = (TaxonOcc)it2.next();
            if (fss.getTaxon() == null || !taxa.contains(fss.getTaxon())) continue;
            listTotal += fss.getDerivedCount(abn);
        }
        return listTotal;
    }

    void writeAggregate(FileWriter out, Sample sample, Smpdtl smpdtl, List taxa, TxGroup group, AbnScheme abn, float sampleTotal, boolean isPercent, boolean isDiversity, boolean isPercentRw, boolean precedeTotal) throws IOException, SQLException, SBException {
        boolean useAllAnalyses;
        int listTotal = 0;
        int listDiversity = 0;
        int listRw = 0;
        int i = 0;
        boolean bl = useAllAnalyses = smpdtl == null;
        while (i < sample.getAnalyses().size()) {
            if (useAllAnalyses) {
                smpdtl = (Smpdtl)sample.getAnalyses().get(i);
                ++i;
                if (!this.includeAnalysis(smpdtl)) continue;
                abn = this.db.getAbnScheme(smpdtl.getHeader().getAbnSchID(), true);
            } else {
                i = sample.getAnalyses().size();
            }
            for (TaxonOcc fss : smpdtl.getOccur()) {
                if (fss.getTaxon() == null) continue;
                if (group != null) {
                    if (!group.isMember(fss.getTaxon().getSpecID())) continue;
                    listTotal += fss.getDerivedCount(abn);
                    ++listDiversity;
                    if (!fss.getReworked()) continue;
                    listRw += fss.getDerivedCount(abn);
                    continue;
                }
                if (!taxa.contains(fss.getTaxon())) continue;
                listTotal += fss.getDerivedCount(abn);
                ++listDiversity;
                if (!fss.getReworked()) continue;
                listRw += fss.getDerivedCount(abn);
            }
        }
        if (isDiversity) {
            out.write("" + listDiversity);
        } else if (isPercent) {
            float perCent = 0.0f;
            if (sampleTotal > 0.0f) {
                perCent = (float)listTotal * 100.0f / sampleTotal;
            }
            if (precedeTotal && this.jCheckBoxShowTotals.isSelected()) {
                out.write("" + sampleTotal + ",");
            }
            if (sampleTotal == 0.0f && listTotal > 0) {
                out.write("Error");
            } else {
                out.write(SB.floatString((float)perCent, (int)3));
            }
        } else if (isPercentRw) {
            float perCentRw = 0.0f;
            if (listTotal > 0) {
                perCentRw = (float)listRw * 100.0f / (float)listTotal;
            }
            if (listTotal == 0 && listRw > 0) {
                out.write("Error");
            } else {
                out.write(SB.floatString((float)perCentRw, (int)3));
            }
        } else {
            out.write("" + listTotal);
        }
    }

    private boolean includeAnalysis(Smpdtl smpdtl) {
        if (this.selectedAnalyses != null) {
            return this.selectedAnalyses.contains(smpdtl);
        }
        if (!(this.discID != '\u0000' && smpdtl.getDiscID() != this.discID || this.analystID != 0 && smpdtl.getHeader().getAnalystUsrid() != this.analystID || this.analyNo != 0 && smpdtl.getAnalyNo() != this.analyNo)) {
            if (this.jCheckBoxPrepared.isSelected()) {
                return true;
            }
            if (smpdtl.getBarren()) {
                return true;
            }
            if (smpdtl.isAnalysed()) {
                return true;
            }
        }
        return false;
    }

    private boolean includeSample(Sample sample) {
        boolean hasSelectedAnalysis = false;
        for (int i = 0; i < sample.getAnalyses().size(); ++i) {
            Smpdtl smpdtl = (Smpdtl)sample.getAnalyses().get(i);
            if (!this.includeAnalysis(smpdtl)) continue;
            hasSelectedAnalysis = true;
        }
        return hasSelectedAnalysis;
    }
}

