/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import jsbugs.BackgroundRenderer;
import jsbugs.CellBackground;
import jsbugs.FrameJsbugs;
import jsbugs.GreyRenderer;
import jsbugs.SBDialog;
import jsbugs.TableModelCSVImport;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.GridReader;
import util.SB;
import util.SBException;

public class DialogCSVImport
extends SBDialog {
    boolean isBiocom = false;
    private final String fileName;
    int startRow = 1;
    private static final String[] colLabels = new String[]{"TOP", "BASE", "TYPE", "ANALYST", "LABEL", "COMMENTS", ""};
    final int[] colStart = new int[]{-1, -1, -1, -1, -1, -1, -1};
    static final int TOP = 0;
    static final int BASE = 1;
    static final int TYPE = 2;
    static final int ANALYST = 3;
    static final int LABEL = 4;
    static final int COMMENTS = 5;
    static final int TAXA = 6;
    int titleRow;
    int catRow;
    int colTaxaEnd = -1;
    String delim = null;
    private final Color[] colColour = new Color[7];
    private final JSpinner[] spinners = new JSpinner[6];
    private final JCheckBox[] checkBoxes = new JCheckBox[6];
    private final SpinnerNumberModel rowModel = new SpinnerNumberModel(0, 0, 20, 1);
    private final SpinnerNumberModel titleModel = new SpinnerNumberModel(0, 0, 20, 1);
    private final TableModelCSVImport csvModel = new TableModelCSVImport();
    private final SBdb db;
    private ButtonGroup buttonGroupComments;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxAnalyst;
    private JCheckBox jCheckBoxComments;
    private JCheckBox jCheckBoxDepthBase;
    private JCheckBox jCheckBoxDepthTop;
    private JCheckBox jCheckBoxLabel;
    private JCheckBox jCheckBoxTaxa;
    private JCheckBox jCheckBoxType;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JRadioButton jRadioButtonBioComments;
    private JRadioButton jRadioButtonCommentsSamples;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinnerAnalyst;
    private JSpinner jSpinnerBase;
    private JSpinner jSpinnerCategories;
    private JSpinner jSpinnerComments;
    private JSpinner jSpinnerLabel;
    private JSpinner jSpinnerRow;
    private JSpinner jSpinnerTaxa;
    private JSpinner jSpinnerTaxaEnd;
    private JSpinner jSpinnerTitles;
    private JSpinner jSpinnerTop;
    private JSpinner jSpinnerType;
    private JTable jTableFile;
    private JTextField jTextFieldFile;

    public DialogCSVImport(Frame parent, boolean modal, SBdb db, String fileName, boolean isDiatomFile) throws IOException {
        super(parent, modal);
        this.fileName = fileName;
        this.db = db;
        this.initComponents();
        this.init();
        if (!isDiatomFile) {
            this.scanFields();
        }
        this.csvModel.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        this.setUpColorRenderer(this.jTableFile);
        this.setTitle("CSV File Import Parameters");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        float factor = 1.0f / (float)this.colColour.length;
        for (int i = 0; i < this.colColour.length; ++i) {
            this.colColour[i] = new Color(Color.HSBtoRGB((float)i * factor, 0.4f, 0.9f));
        }
        this.spinners[0] = this.jSpinnerTop;
        this.spinners[1] = this.jSpinnerBase;
        this.spinners[2] = this.jSpinnerType;
        this.spinners[3] = this.jSpinnerAnalyst;
        this.spinners[4] = this.jSpinnerLabel;
        this.spinners[5] = this.jSpinnerComments;
        this.checkBoxes[0] = this.jCheckBoxDepthTop;
        this.checkBoxes[1] = this.jCheckBoxDepthBase;
        this.checkBoxes[2] = this.jCheckBoxType;
        this.checkBoxes[3] = this.jCheckBoxAnalyst;
        this.checkBoxes[4] = this.jCheckBoxLabel;
        this.checkBoxes[5] = this.jCheckBoxComments;
        this.jTextFieldFile.setText(this.fileName);
        int nRows = 0;
        int nCols = 0;
        GridReader in = null;
        try {
            in = SB.getGridReader((String)this.fileName);
            while (in.nextRow()) {
                ++nRows;
                int cols = 0;
                while (in.getNextCell() != null) {
                    ++cols;
                }
                if (cols <= nCols) continue;
                nCols = cols;
            }
            in.rewind();
            this.csvModel.setSize(nRows, nCols);
            TableColumn firstColumn = this.jTableFile.getColumnModel().getColumn(0);
            firstColumn.setHeaderValue(" ");
            firstColumn.setPreferredWidth(30);
            GreyRenderer renderer = new GreyRenderer(false);
            renderer.setCursor(Cursor.getPredefinedCursor(12));
            firstColumn.setCellRenderer(renderer);
            for (int i = 1; i <= nCols; ++i) {
                this.jTableFile.getColumnModel().getColumn(i).setHeaderValue("" + i);
            }
            int row = 0;
            while (in.nextRow()) {
                String strg;
                int col = 0;
                while ((strg = in.getNextCell()) != null) {
                    CellBackground cell = new CellBackground();
                    cell.data = strg;
                    cell.colour = Color.white;
                    this.csvModel.setValueAt(cell, row, col);
                    ++col;
                }
                ++row;
            }
        }
        catch (SBException eio) {
            JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage() + "\n" + (eio.getCause() != null ? eio.getCause().toString() : ""));
            eio.printStackTrace();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    final void scanFields() {
        int i;
        this.titleRow = 0;
        int temp = this.scanColumn(0, this.jCheckBoxDepthTop, this.jSpinnerTop, null);
        if (temp > 0) {
            this.titleRow = temp;
        }
        if ((temp = this.scanColumn(1, this.jCheckBoxDepthBase, this.jSpinnerBase, null)) > 0) {
            this.titleRow = temp;
        }
        if (this.colStart[0] < 0 && this.colStart[1] < 0) {
            if (this.db.useSampleTops()) {
                temp = this.scanColumn(0, this.jCheckBoxDepthTop, this.jSpinnerTop, "DEPTH");
                if (temp > 0) {
                    this.titleRow = temp;
                }
            } else {
                temp = this.scanColumn(1, this.jCheckBoxDepthBase, this.jSpinnerBase, "DEPTH");
                if (temp > 0) {
                    this.titleRow = temp;
                }
            }
        }
        if ((temp = this.scanColumn(2, this.jCheckBoxType, this.jSpinnerType, null)) > 0) {
            this.titleRow = temp;
        }
        if ((temp = this.scanColumn(3, this.jCheckBoxAnalyst, this.jSpinnerAnalyst, null)) > 0) {
            this.titleRow = temp;
        }
        this.scanColumn(4, this.jCheckBoxLabel, this.jSpinnerLabel, null);
        this.scanColumn(5, this.jCheckBoxComments, this.jSpinnerComments, "NOTES");
        this.colStart[6] = -1;
        int taxaColumnStart = -1;
        for (i = 0; i < this.colStart.length; ++i) {
            if (this.colStart[i] <= this.colStart[6]) continue;
            taxaColumnStart = this.colStart[i] + 1;
        }
        if (taxaColumnStart < this.csvModel.columnCount) {
            this.colStart[6] = taxaColumnStart;
        }
        if (this.colStart[6] >= 0) {
            this.jCheckBoxTaxa.setSelected(true);
            this.jCheckBoxTaxa.setBackground(this.colColour[6]);
            this.jSpinnerTaxa.setValue(this.colStart[6] + 1);
            this.colTaxaEnd = this.csvModel.columnCount - 1;
            this.jSpinnerTaxaEnd.setValue(this.colTaxaEnd + 1);
            for (i = 0; i < this.spinners.length; ++i) {
                this.spinners[i].setModel(new SpinnerNumberModel(this.colStart[i] + 1, 0, this.colStart[6], 1));
                if (this.colStart[i] >= 0) continue;
                this.spinners[i].setEnabled(false);
            }
        } else {
            this.jSpinnerTaxa.setEnabled(false);
            this.jSpinnerTaxaEnd.setEnabled(false);
        }
        this.scanFirstRow();
        if (this.startRow > 0) {
            this.jSpinnerRow.setModel(new SpinnerNumberModel(this.startRow, 1, this.csvModel.rowCount, 1));
        }
        if (this.titleRow == 0) {
            if (this.startRow > 0) {
                this.titleRow = this.startRow - 2;
                this.catRow = this.titleRow + 1;
            } else {
                this.titleRow = 1;
                this.catRow = 0;
            }
        } else if (this.startRow - this.titleRow > 1) {
            this.catRow = this.titleRow + 1;
        }
        if (this.titleRow <= 0) {
            this.titleRow = 1;
        }
        this.jSpinnerTitles.setModel(new SpinnerNumberModel(this.titleRow, 1, Math.max(this.csvModel.rowCount, this.titleRow), 1));
        this.jSpinnerCategories.setModel(new SpinnerNumberModel(this.catRow, 0, Math.max(this.csvModel.rowCount, this.catRow), 1));
        this.reColour();
    }

    void scanFirstRow() {
        int column = this.db.useSampleTops() ? this.colStart[0] : this.colStart[1];
        if (column < 0) {
            column = 0;
        }
        CellBackground[][] data = this.csvModel.data;
        for (int row = this.startRow - 1; row < this.csvModel.rowCount; ++row) {
            String strg;
            if (data[row][column] == null || (strg = data[row][column].data) == null || strg.trim().length() <= 0) continue;
            try {
                if (strg.contains("-")) {
                    StringTokenizer tok = new StringTokenizer(strg, "-");
                    if (tok.countTokens() != 2) continue;
                    strg = tok.nextToken();
                }
                Float.parseFloat(strg);
                this.startRow = row + 1;
                break;
            }
            catch (NumberFormatException ne) {
                // empty catch block
            }
        }
    }

    int scanColumn(int index, JCheckBox jCheckBox, JSpinner spinner, String override) {
        CellBackground[][] data = this.csvModel.data;
        int sRow = 0;
        int sCol = 0;
        boolean found = false;
        for (int iRow = 0; iRow < this.csvModel.rowCount; ++iRow) {
            for (int iCol = 0; iCol < this.csvModel.columnCount; ++iCol) {
                int charIndex;
                CellBackground cell = data[iRow][iCol];
                if (cell == null) continue;
                String strg = cell.data;
                String columnLabel = colLabels[index];
                if (override != null) {
                    columnLabel = override;
                }
                if (strg == null || (charIndex = strg.toUpperCase().indexOf(columnLabel)) < 0 || charIndex != 0 && strg.charAt(charIndex - 1) != ' ' || strg.length() != columnLabel.length() + charIndex && strg.charAt(columnLabel.length() + charIndex) != ' ') continue;
                sRow = iRow + 1;
                sCol = iCol;
                found = true;
                break;
            }
            if (found) break;
        }
        if (found) {
            jCheckBox.setSelected(true);
            this.colStart[index] = sCol;
            spinner.setValue(sCol + 1);
            jCheckBox.setBackground(this.colColour[index]);
            return sRow;
        }
        jCheckBox.setSelected(false);
        jCheckBox.setBackground(this.jPanel1.getBackground());
        return 0;
    }

    void colourGrid(Color colour, int startRow, int endRow, int startColumn, int endColumn) {
        CellBackground[][] data = this.csvModel.data;
        for (int iRow = startRow - 1; iRow < endRow; ++iRow) {
            for (int iCol = startColumn; iCol <= endColumn; ++iCol) {
                if (data[iRow][iCol] == null) {
                    data[iRow][iCol] = new CellBackground();
                }
                data[iRow][iCol].colour = colour;
            }
        }
    }

    void reColour() {
        CellBackground[][] data = this.csvModel.data;
        for (int iRow = 0; iRow < this.csvModel.rowCount; ++iRow) {
            for (int iCol = 0; iCol < this.csvModel.columnCount; ++iCol) {
                if (data[iRow][iCol] == null) continue;
                data[iRow][iCol].colour = Color.white;
            }
        }
        for (int i = 0; i < colLabels.length - 1; ++i) {
            if (this.colStart[i] < 0) continue;
            this.colourGrid(this.colColour[i], this.startRow, this.csvModel.rowCount, this.colStart[i], this.colStart[i]);
        }
        if (this.colStart[6] >= 0) {
            this.colourGrid(this.colColour[6], this.titleRow, this.titleRow, this.colStart[6], this.colTaxaEnd);
        }
        this.jTableFile.updateUI();
    }

    private void setUpColorRenderer(JTable table) {
        table.setDefaultRenderer(CellBackground.class, new BackgroundRenderer(false));
    }

    void actionCheckBox(int index) {
        if (this.checkBoxes[index].isSelected()) {
            this.checkBoxes[index].setBackground(this.colColour[index]);
            this.scanColumn(index, this.checkBoxes[index], this.spinners[index], null);
            this.reColour();
            this.spinners[index].setEnabled(true);
        } else {
            this.colStart[index] = -1;
            this.checkBoxes[index].setBackground(this.getBackground());
            this.spinners[index].setValue(0);
            this.spinners[index].setEnabled(false);
            this.reColour();
        }
    }

    void actionSpinner(int index) {
        int oldValue = this.colStart[index];
        int newValue = (Integer)this.spinners[index].getValue() - 1;
        if (newValue == -1) {
            this.checkBoxes[index].setBackground(this.getBackground());
            this.checkBoxes[index].setSelected(false);
            this.colStart[index] = newValue;
            this.spinners[index].setEnabled(false);
        } else {
            boolean ascending = false;
            if (newValue > oldValue) {
                ascending = true;
            }
            boolean valueChanged = false;
            for (int i = 0; i < this.colStart.length; ++i) {
                if (i == index || this.colStart[i] != newValue) continue;
                newValue = ascending ? ++newValue : --newValue;
                valueChanged = true;
                break;
            }
            if (valueChanged) {
                if (this.colStart[6] >= 0 && newValue >= this.colStart[6]) {
                    this.colStart[index] = -1;
                    this.checkBoxes[index].setSelected(false);
                    this.checkBoxes[index].setBackground(this.getBackground());
                    JOptionPane.showMessageDialog(this, "No space for data column before start of the taxa column", "CSV Import", 1);
                    this.spinners[index].setValue(0);
                    this.spinners[index].setEnabled(false);
                } else {
                    this.spinners[index].setValue(newValue + 1);
                }
            } else {
                this.colStart[index] = newValue;
                this.checkBoxes[index].setSelected(true);
                this.checkBoxes[index].setBackground(this.colColour[index]);
            }
        }
        this.reColour();
    }

    private void initComponents() {
        this.buttonGroupComments = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTableFile = new JTable();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldFile = new JTextField();
        this.jPanel1 = new JPanel();
        this.jRadioButtonBioComments = new JRadioButton();
        this.jRadioButtonCommentsSamples = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jSpinnerTop = new JSpinner();
        this.jCheckBoxDepthTop = new JCheckBox();
        this.jSpinnerBase = new JSpinner();
        this.jCheckBoxDepthBase = new JCheckBox();
        this.jSpinnerType = new JSpinner();
        this.jCheckBoxType = new JCheckBox();
        this.jSpinnerAnalyst = new JSpinner();
        this.jCheckBoxAnalyst = new JCheckBox();
        this.jSpinnerLabel = new JSpinner();
        this.jCheckBoxLabel = new JCheckBox();
        this.jSpinnerComments = new JSpinner();
        this.jCheckBoxComments = new JCheckBox();
        this.jCheckBoxTaxa = new JCheckBox();
        this.jSpinnerTaxa = new JSpinner();
        this.jSpinnerTaxaEnd = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jSpinnerTitles = new JSpinner();
        this.jLabel6 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jSpinnerRow = new JSpinner();
        this.jSpinnerCategories = new JSpinner();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(650, 540));
        this.jTableFile.setModel(this.csvModel);
        this.jTableFile.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.jTableFile);
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVImport.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMargin(new Insets(2, 12, 2, 12));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVImport.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVImport.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel1.setText("File:");
        this.jTextFieldFile.setBackground(new Color(255, 255, 204));
        this.jTextFieldFile.setEditable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Comments", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupComments.add(this.jRadioButtonBioComments);
        this.jRadioButtonBioComments.setText("Biostrat. comments");
        this.buttonGroupComments.add(this.jRadioButtonCommentsSamples);
        this.jRadioButtonCommentsSamples.setText("Sample analyses");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonBioComments).add((Component)this.jRadioButtonCommentsSamples)).addContainerGap(59, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.jRadioButtonBioComments).addPreferredGap(0).add((Component)this.jRadioButtonCommentsSamples).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Columns", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jSpinnerTop.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogCSVImport.this.jSpinnerTopStateChanged(evt);
            }
        });
        this.jCheckBoxDepthTop.setText("Top depth");
        this.jCheckBoxDepthTop.setHorizontalAlignment(11);
        this.jCheckBoxDepthTop.setHorizontalTextPosition(10);
        this.jCheckBoxDepthTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVImport.this.jCheckBoxDepthTopActionPerformed(evt);
            }
        });
        this.jSpinnerBase.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogCSVImport.this.jSpinnerBaseStateChanged(evt);
            }
        });
        this.jCheckBoxDepthBase.setText("Base depth");
        this.jCheckBoxDepthBase.setHorizontalAlignment(11);
        this.jCheckBoxDepthBase.setHorizontalTextPosition(10);
        this.jCheckBoxDepthBase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVImport.this.jCheckBoxDepthBaseActionPerformed(evt);
            }
        });
        this.jSpinnerType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogCSVImport.this.jSpinnerTypeStateChanged(evt);
            }
        });
        this.jCheckBoxType.setText("Sample type");
        this.jCheckBoxType.setHorizontalAlignment(11);
        this.jCheckBoxType.setHorizontalTextPosition(10);
        this.jCheckBoxType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVImport.this.jCheckBoxTypeActionPerformed(evt);
            }
        });
        this.jSpinnerAnalyst.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogCSVImport.this.jSpinnerAnalystStateChanged(evt);
            }
        });
        this.jCheckBoxAnalyst.setText("Analyst");
        this.jCheckBoxAnalyst.setHorizontalAlignment(11);
        this.jCheckBoxAnalyst.setHorizontalTextPosition(10);
        this.jCheckBoxAnalyst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVImport.this.jCheckBoxAnalystActionPerformed(evt);
            }
        });
        this.jSpinnerLabel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogCSVImport.this.jSpinnerLabelStateChanged(evt);
            }
        });
        this.jCheckBoxLabel.setText("Label");
        this.jCheckBoxLabel.setHorizontalAlignment(11);
        this.jCheckBoxLabel.setHorizontalTextPosition(10);
        this.jCheckBoxLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVImport.this.jCheckBoxLabelActionPerformed(evt);
            }
        });
        this.jSpinnerComments.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogCSVImport.this.jSpinnerCommentsStateChanged(evt);
            }
        });
        this.jCheckBoxComments.setText("Comments");
        this.jCheckBoxComments.setHorizontalAlignment(11);
        this.jCheckBoxComments.setHorizontalTextPosition(10);
        this.jCheckBoxComments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVImport.this.jCheckBoxCommentsActionPerformed(evt);
            }
        });
        this.jCheckBoxTaxa.setText("Taxa");
        this.jCheckBoxTaxa.setHorizontalTextPosition(10);
        this.jCheckBoxTaxa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCSVImport.this.jCheckBoxTaxaActionPerformed(evt);
            }
        });
        this.jSpinnerTaxa.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogCSVImport.this.jSpinnerTaxaStateChanged(evt);
            }
        });
        this.jSpinnerTaxaEnd.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogCSVImport.this.jSpinnerTaxaEndStateChanged(evt);
            }
        });
        this.jLabel4.setText("to:");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jCheckBoxTaxa).addPreferredGap(0).add((Component)this.jSpinnerTaxa, -2, 44, -2)).add((Component)this.jCheckBoxDepthTop).add((Component)this.jCheckBoxDepthBase).add((Component)this.jCheckBoxType).add((Component)this.jCheckBoxAnalyst).add((Component)this.jCheckBoxLabel).add((Component)this.jCheckBoxComments)).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jSpinnerBase, -1, 65, Short.MAX_VALUE).add((Component)this.jSpinnerTop, -1, 65, Short.MAX_VALUE).add((Component)this.jSpinnerType, -1, 65, Short.MAX_VALUE).add((Component)this.jSpinnerAnalyst, -1, 65, Short.MAX_VALUE).add((Component)this.jSpinnerLabel, -1, 65, Short.MAX_VALUE).add((Component)this.jSpinnerComments, -1, 65, Short.MAX_VALUE))).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(7, 7, 7).add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jSpinnerTaxaEnd, -1, 50, Short.MAX_VALUE)))));
        jPanel2Layout.linkSize(new Component[]{this.jSpinnerAnalyst, this.jSpinnerBase, this.jSpinnerComments, this.jSpinnerLabel, this.jSpinnerTop, this.jSpinnerType}, 1);
        jPanel2Layout.linkSize(new Component[]{this.jCheckBoxAnalyst, this.jCheckBoxComments, this.jCheckBoxDepthBase, this.jCheckBoxDepthTop, this.jCheckBoxLabel, this.jCheckBoxType}, 1);
        jPanel2Layout.linkSize(new Component[]{this.jSpinnerTaxa, this.jSpinnerTaxaEnd}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jSpinnerTop, -2, -1, -2).add((Component)this.jCheckBoxDepthTop)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jSpinnerBase, -2, -1, -2).add((Component)this.jCheckBoxDepthBase)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jSpinnerType, -2, -1, -2).add((Component)this.jCheckBoxType)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jSpinnerAnalyst, -2, -1, -2).add((Component)this.jCheckBoxAnalyst)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jSpinnerLabel, -2, -1, -2).add((Component)this.jCheckBoxLabel)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jSpinnerComments, -2, -1, -2).add((Component)this.jCheckBoxComments)).add(3, 3, 3).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jCheckBoxTaxa).add((Component)this.jSpinnerTaxa, -2, -1, -2).add((Component)this.jSpinnerTaxaEnd, -2, -1, -2).add((Component)this.jLabel4)).addContainerGap(9, Short.MAX_VALUE)));
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText("Column titles at row:");
        this.jSpinnerTitles.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogCSVImport.this.jSpinnerTitlesStateChanged(evt);
            }
        });
        this.jLabel6.setText("Taxon categories at row:");
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("Data starts at row:");
        this.jSpinnerRow.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogCSVImport.this.jSpinnerRowStateChanged(evt);
            }
        });
        this.jSpinnerCategories.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                DialogCSVImport.this.jSpinnerCategoriesStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldFile, -1, 461, Short.MAX_VALUE)).add((Component)this.jScrollPane1, -1, 485, Short.MAX_VALUE)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(14, 14, 14).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jSpinnerRow)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel6).add(3, 3, 3).add((Component)this.jSpinnerCategories, -2, 61, -2)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add(4, 4, 4).add((Component)this.jLabel5).addPreferredGap(0).add((Component)this.jSpinnerTitles, -2, 60, -2))).add(3, 3, 3)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp, -2, 53, -2).addPreferredGap(0).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE)).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.jPanel2, -2, -1, -2)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldFile, -2, -1, -2).add((Component)this.jLabel1)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jSpinnerTitles, -2, -1, -2).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jSpinnerRow, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jSpinnerCategories, -2, -1, -2)).add(18, 18, 18).add((Component)this.jPanel2, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0, 29, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK))).add((Component)this.jScrollPane1, -1, 443, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogcsvimport.html");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.titleRow <= 0 || this.startRow <= 0) {
            JOptionPane.showMessageDialog(this, "No title/data row selected", "CSV Import", 2);
            return;
        }
        if (this.titleRow >= this.startRow) {
            JOptionPane.showMessageDialog(this, "Title row must be less than start of data", "CSV Import", 2);
            return;
        }
        if (this.colStart[0] < 0 && this.colStart[1] < 0) {
            JOptionPane.showMessageDialog(this, "No depth column selected", "CSV Import", 2);
            return;
        }
        if (this.colStart[3] < 0) {
            // empty if block
        }
        if (this.colStart[5] >= 0) {
            if (this.buttonGroupComments.getSelection() == null) {
                JOptionPane.showMessageDialog(this, "Select destination for commments", this.getTitle(), 2);
                return;
            }
            if (this.jRadioButtonBioComments.isSelected()) {
                this.isBiocom = true;
            }
        }
        this.setOK();
    }

    private void jCheckBoxDepthTopActionPerformed(ActionEvent evt) {
        this.actionCheckBox(0);
    }

    private void jCheckBoxDepthBaseActionPerformed(ActionEvent evt) {
        this.actionCheckBox(1);
    }

    private void jCheckBoxTypeActionPerformed(ActionEvent evt) {
        this.actionCheckBox(2);
    }

    private void jCheckBoxAnalystActionPerformed(ActionEvent evt) {
        this.actionCheckBox(3);
    }

    private void jCheckBoxLabelActionPerformed(ActionEvent evt) {
        this.actionCheckBox(4);
    }

    private void jCheckBoxCommentsActionPerformed(ActionEvent evt) {
        this.actionCheckBox(5);
    }

    private void jCheckBoxTaxaActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxTaxa.isSelected()) {
            int taxaColumn = -1;
            for (int i = 0; i < this.colStart.length - 1; ++i) {
                if (this.colStart[i] <= taxaColumn - 1) continue;
                taxaColumn = this.colStart[i] + 1;
            }
            if (taxaColumn < this.csvModel.columnCount) {
                this.colStart[6] = taxaColumn;
                this.jSpinnerTaxa.setEnabled(true);
                this.jSpinnerTaxa.setValue(this.colStart[6] + 1);
                this.colTaxaEnd = this.csvModel.columnCount - 1;
                this.jSpinnerTaxaEnd.setEnabled(true);
                this.jSpinnerTaxaEnd.setValue(this.colTaxaEnd + 1);
            }
            this.jCheckBoxTaxa.setBackground(this.colColour[6]);
        } else {
            this.jSpinnerTaxa.setEnabled(false);
            this.jSpinnerTaxa.setValue(0);
            this.colStart[6] = -1;
            this.jCheckBoxTaxa.setBackground(this.getBackground());
            this.jSpinnerTaxaEnd.setEnabled(false);
            this.jSpinnerTaxaEnd.setValue(0);
            this.colTaxaEnd = -1;
        }
        this.reColour();
    }

    private void jSpinnerTopStateChanged(ChangeEvent evt) {
        this.actionSpinner(0);
    }

    private void jSpinnerBaseStateChanged(ChangeEvent evt) {
        this.actionSpinner(1);
    }

    private void jSpinnerTypeStateChanged(ChangeEvent evt) {
        this.actionSpinner(2);
    }

    private void jSpinnerAnalystStateChanged(ChangeEvent evt) {
        this.actionSpinner(3);
    }

    private void jSpinnerLabelStateChanged(ChangeEvent evt) {
        this.actionSpinner(4);
    }

    private void jSpinnerCommentsStateChanged(ChangeEvent evt) {
        this.actionSpinner(5);
    }

    private void jSpinnerRowStateChanged(ChangeEvent evt) {
        int value;
        this.startRow = value = ((Integer)this.jSpinnerRow.getValue()).intValue();
        this.reColour();
    }

    private void jSpinnerTaxaStateChanged(ChangeEvent evt) {
        int oldValue = this.colStart[6];
        int newValue = (Integer)this.jSpinnerTaxa.getValue() - 1;
        if (newValue == -1) {
            this.jCheckBoxTaxa.setBackground(this.getBackground());
            this.jCheckBoxTaxa.setSelected(false);
            this.colStart[6] = newValue;
            this.colTaxaEnd = -1;
            this.jSpinnerTaxa.setEnabled(false);
            this.jSpinnerTaxaEnd.setEnabled(false);
            this.jSpinnerTaxaEnd.setValue(0);
        } else {
            boolean ascending = false;
            if (newValue > oldValue) {
                ascending = true;
            }
            boolean valueChanged = false;
            for (int i = 0; i < this.colStart.length - 1; ++i) {
                if (this.colStart[i] < newValue) continue;
                if (ascending) {
                    ++newValue;
                    valueChanged = true;
                    break;
                }
                ++newValue;
                valueChanged = true;
                break;
            }
            if (valueChanged) {
                this.jSpinnerTaxa.setValue(newValue + 1);
            } else {
                this.colStart[6] = newValue;
                this.jCheckBoxTaxa.setSelected(true);
                this.jCheckBoxTaxa.setBackground(this.colColour[6]);
            }
        }
        if (this.colStart[6] > this.colTaxaEnd) {
            this.colTaxaEnd = this.colStart[6];
            this.jSpinnerTaxaEnd.setValue(this.colTaxaEnd + 1);
        }
        this.reColour();
    }

    private void jSpinnerTaxaEndStateChanged(ChangeEvent evt) {
        int oldValue = this.colTaxaEnd;
        int newValue = (Integer)this.jSpinnerTaxaEnd.getValue() - 1;
        if (newValue < this.colStart[6]) {
            this.jCheckBoxTaxa.setBackground(this.getBackground());
            this.jCheckBoxTaxa.setSelected(false);
            this.colStart[6] = -1;
            this.colTaxaEnd = -1;
            this.jSpinnerTaxa.setEnabled(false);
            this.jSpinnerTaxaEnd.setEnabled(false);
        } else {
            boolean ascending = false;
            if (newValue > oldValue) {
                ascending = true;
            }
            boolean valueChanged = false;
            if (this.colStart[6] > newValue) {
                if (ascending) {
                    ++newValue;
                    valueChanged = true;
                } else {
                    ++newValue;
                    valueChanged = true;
                }
            }
            if (valueChanged) {
                this.jSpinnerTaxaEnd.setValue(newValue + 1);
            } else {
                this.colTaxaEnd = newValue;
            }
        }
        this.reColour();
    }

    private void jSpinnerTitlesStateChanged(ChangeEvent evt) {
        int value;
        this.titleRow = value = ((Integer)this.jSpinnerTitles.getValue()).intValue();
        this.reColour();
    }

    private void jSpinnerCategoriesStateChanged(ChangeEvent evt) {
        int value;
        this.catRow = value = ((Integer)this.jSpinnerCategories.getValue()).intValue();
    }
}

