/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogCasingPoint;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelCasing;
import model2.CasingPoint;
import model2.Well;
import org.jdesktop.layout.GroupLayout;

public class DialogCasing
extends JDialog
implements Observer {
    Well well;
    TableModelCasing model = new TableModelCasing();
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JScrollPane jScrollPane1;
    private JTable jTableCasing;

    public DialogCasing(Frame parent, boolean modal, Well well) throws SQLException {
        super(parent, modal);
        this.well = well;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        Font font = this.jTableCasing.getTableHeader().getFont();
        font = new Font(font.getName(), 1, font.getSize());
        this.jTableCasing.getTableHeader().setFont(font);
        TableColumnModel columnModel = this.jTableCasing.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelCasing.titles[i]);
            columnModel.getColumn(i).setWidth(TableModelCasing.widths[i]);
        }
        this.setTitle("Casing: " + this.well.getWellName());
        this.model.casing = this.well.getCasing(true);
        this.model.units = this.well.getWellUnits();
        this.buttonGroupUnits.setSelected(this.model.units == 'F' ? this.jRadioButtonFeet.getModel() : this.jRadioButtonMetres.getModel(), true);
        this.jTableCasing.repaint();
        this.setObserver();
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    @Override
    public void update(Observable obs, Object obj) {
        try {
            if (obs == this.well.getCasing()) {
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in update method: " + e);
            e.printStackTrace();
        }
    }

    Well getWell() {
        return this.well;
    }

    private void initComponents() {
        this.jButtonEdit = new JButton();
        this.buttonGroupUnits = new ButtonGroup();
        this.jButtonClose = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonAdd = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCasing = new JTable();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jButtonEdit.setText("Edit...");
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(257, 189));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCasing.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCasing.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.setMaximumSize(new Dimension(59, 23));
        this.jButtonHelp.setMinimumSize(new Dimension(59, 23));
        this.jButtonHelp.setPreferredSize(new Dimension(59, 23));
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCasing.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.setPreferredSize(new Dimension(93, 23));
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCasing.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jTableCasing.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCasing);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Depth units", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCasing.this.jRadioButtonMetresActionPerformed(evt);
            }
        });
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jRadioButtonFeet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCasing.this.jRadioButtonFeetActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonMetres).addPreferredGap(0).add((Component)this.jRadioButtonFeet).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonMetres, -2, 16, -2).add((Component)this.jRadioButtonFeet, -2, 16, -2)).add(0, 1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 167, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAdd, -2, 64, -2)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 181, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableCasing.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 1);
            return;
        }
        try {
            LinkedList<CasingPoint> toDelete = new LinkedList<CasingPoint>();
            for (int row : this.jTableCasing.getSelectedRows()) {
                CasingPoint casing = this.model.casing.getCasingPoint(row);
                toDelete.add(casing);
            }
            if (toDelete.size() > 0) {
                String msg = "Really delete " + (toDelete.size() == 1 ? "this casing point?" : "these " + toDelete.size() + " casing points?");
                int option = JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3);
                if (option != 0) {
                    return;
                }
                for (CasingPoint casing : toDelete) {
                    this.model.casing.delete(this.well.getWellID(), casing);
                }
                this.well.getDataModel().commit();
                this.jTableCasing.clearSelection();
                this.model.casing.notifyObservers();
                this.model.fireTableDataChanged();
                this.well.setDataChanged();
                this.well.notifyObservers(toDelete.get(0));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error deleting casing point: " + e.getMessage(), this.getTitle(), 0);
            this.well.getDataModel().doRollback();
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogCasingPoint dialog = new DialogCasingPoint(this, true, this.well, this.model.units);
            dialog.setLocation(this.getLocation().x + 25, this.getLocation().y + 25);
            dialog.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error starting casing point dialog: " + ex.getMessage(), this.getTitle(), 0);
            ex.printStackTrace();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogcasing.html");
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        this.setModelUnits('M');
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        this.setModelUnits('F');
    }

    void setObserver() throws SQLException {
        this.model.casing = this.well.getCasing();
        this.model.casing.addObserver((Observer)this);
    }

    private void setModelUnits(char c) {
        if (this.model.units != c) {
            this.model.units = c;
            this.model.fireTableDataChanged();
        }
    }
}

