/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jsbugs.DialogCategory;
import jsbugs.FrameJsbugs;
import jsbugs.FrameTaxaDB;
import jsbugs.TableModelCategories;
import model2.Category;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.ColorEditor;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogCategories
extends JDialog {
    private final SBdb db;
    private final TableModelCategories model = new TableModelCategories();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    Frame parent;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JScrollPane jScrollPane1;
    private JTable jTableCats;

    public DialogCategories(Frame parent, boolean modal, SBdb db) throws SQLException {
        super(parent, modal);
        this.db = db;
        this.parent = parent;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        this.model.setCats(this.db);
        this.model.setupTable(this.jTableCats);
        this.jTableCats.setSelectionMode(0);
        ColorEditor.setUpColorEditor((JTable)this.jTableCats);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableCats);
        this.sorter.reallocateIndexes();
        this.setTitle("Categories");
        this.getRootPane().setDefaultButton(this.jButtonAdd);
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCats = new JTable();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(332, 300));
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCategories.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCategories.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCategories.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCategories.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCategories.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jTableCats.setModel((TableModel)this.sorter);
        this.jTableCats.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogCategories.this.jTableCatsMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableCats);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 434, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jButtonAdd).add(2, (Component)this.jButtonEdit).add(2, (Component)this.jButtonDelete).add(2, (GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonClose, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 533, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, 400, Short.MAX_VALUE).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableCats.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "Select a category", this.getTitle(), 2);
            return;
        }
        Category cat = this.model.catList.get(this.sorter.getIndexOf(this.jTableCats.getSelectedRow()));
        DialogCategory dialog = new DialogCategory(this, true, this.db, cat);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.changedMnem && this.parent instanceof FrameTaxaDB) {
            FrameTaxaDB frameTaxa = (FrameTaxaDB)this.parent;
            FrameJsbugs frame = frameTaxa.parent;
            try {
                frame.connect(true, true);
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogCategory dialog = new DialogCategory(this, true, this.db, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.catAdded != null) {
            this.model.catList.add(dialog.catAdded);
            Collections.sort(this.model.catList);
            this.model.fireTableDataChanged();
            this.sorter.reallocateIndexes();
            int index = this.model.catList.indexOf(dialog.catAdded);
            this.jTableCats.setRowSelectionInterval(this.sorter.getIndexOf(index), this.sorter.getIndexOf(index));
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogmanagecategories.html");
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableCats.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "Select a category", this.getTitle(), 2);
            return;
        }
        Category cat = this.model.catList.get(this.sorter.getIndexOf(this.jTableCats.getSelectedRow()));
        try {
            if (cat.getNGenera() == 0) {
                this.db.deleteCategory(cat);
                this.db.commit();
                this.model.catList.remove(cat);
                this.model.fireTableDataChanged();
            } else {
                JOptionPane.showMessageDialog(this, "You cannot delete a category with related genera.", this.getTitle(), 2);
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jTableCatsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }
}

