/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.FrameJsbugs;
import model2.Category;
import model2.Discipline;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class DialogCategory
extends JDialog {
    private static final int NAMELEN = 30;
    private static final int ABBLEN = 5;
    private final SBdb db;
    Category original = null;
    Category catAdded = null;
    DefaultComboBoxModel model = new DefaultComboBoxModel<Discipline>(Discipline.values());
    boolean changedMnem = false;
    private JButton jButtonCancel;
    private JButton jButtonColour;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JComboBox jComboBoxDiscipline;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JTextField jTextFieldAbb;
    private JTextField jTextFieldColour;
    private JTextField jTextFieldName;

    public DialogCategory(JDialog parent, boolean modal, SBdb db, Category cat) {
        super((Dialog)parent, modal);
        this.db = db;
        this.initComponents();
        this.init(cat, null, null, null);
    }

    public DialogCategory(JDialog parent, boolean modal, SBdb db, String name, String abr, Discipline discID) {
        super((Dialog)parent, modal);
        this.db = db;
        this.initComponents();
        this.init(null, name, abr, discID);
    }

    private void init(Category cat, String name, String abr, Discipline discID) {
        if (cat == null) {
            this.setTitle("Category : Add");
            if (name != null) {
                this.jTextFieldName.setText(name);
            }
            if (abr != null) {
                this.jTextFieldAbb.setText(abr);
            }
            if (discID != null) {
                this.jComboBoxDiscipline.setSelectedItem(discID);
            }
        } else {
            this.setTitle("Category : Edit");
            this.original = cat;
            this.jTextFieldAbb.setText(cat.getMnem());
            this.jTextFieldName.setText(cat.getName());
            this.jComboBoxDiscipline.setSelectedItem(cat.getDisc());
            this.jTextFieldColour.setBackground(cat.getColour());
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBoxDiscipline = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jTextFieldAbb = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel6 = new JLabel();
        this.jTextFieldColour = new JTextField();
        this.jButtonColour = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Discipline:");
        this.jComboBoxDiscipline.setModel(this.model);
        this.jLabel2.setText("Category name:");
        this.jLabel3.setText("Abbreviation:");
        this.jTextFieldName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogCategory.this.jTextFieldNameKeyTyped(evt);
            }
        });
        this.jTextFieldAbb.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogCategory.this.jTextFieldAbbKeyTyped(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCategory.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCategory.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Colour:");
        this.jTextFieldColour.setBackground(new Color(0, 0, 0));
        this.jTextFieldColour.setEditable(false);
        this.jTextFieldColour.setToolTipText("Colour displayed on multi-analyst sample charts");
        this.jButtonColour.setText("...");
        this.jButtonColour.setToolTipText("Open colour chooser");
        this.jButtonColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCategory.this.jButtonColourActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jSeparator1, -1, 330, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldName, -1, 248, Short.MAX_VALUE).add((Component)this.jComboBoxDiscipline, 0, 248, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldAbb, -1, 81, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.jTextFieldColour, -2, 81, -2).addPreferredGap(0).add((Component)this.jButtonColour, -2, 31, -2))))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxDiscipline, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldAbb, -2, -1, -2).add((Component)this.jButtonColour).add((Component)this.jTextFieldColour, -2, -1, -2).add((Component)this.jLabel6)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 5, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTextFieldAbbKeyTyped(KeyEvent evt) {
        if (SB.uCaseField((JTextField)this.jTextFieldAbb, (int)5, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldName, (int)30, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String description;
        String abr = this.jTextFieldAbb.getText();
        if (abr.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Abbreviation blank", this.getTitle(), 1);
            return;
        }
        if (abr.length() < 2) {
            JOptionPane.showMessageDialog(this, "Abbreviation must be at least 2 characters", this.getTitle(), 1);
            return;
        }
        if (this.original != null && !this.original.getMnem().equals(abr)) {
            String msg = "Changing the category abbreviation is not advised.\nYou should use existing categories if possible, or create a new category.\nAfter this operation the control panel and all open modules will be closed.\nYou should not continue if other users are currently logged in to your database.\nDo you want to continue?";
            if (JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0) != 0) {
                return;
            }
            this.changedMnem = true;
        }
        if ((description = this.jTextFieldName.getText()).length() == 0) {
            JOptionPane.showMessageDialog(this, "Name blank", this.getTitle(), 1);
            return;
        }
        try {
            Category higher;
            Category cat = this.db.getCategory(abr);
            if (cat != null && cat != this.original) {
                JOptionPane.showMessageDialog(this, "Category already exists", this.getTitle(), 1);
                return;
            }
            if (abr.length() > 2 && (higher = this.db.getCategory(abr.substring(0, 2))) == null) {
                JOptionPane.showMessageDialog(this, "Categories with more than two characters must be sub-categories.\nEnter a higher level category.", this.getTitle(), 1);
                return;
            }
            Discipline discID = (Discipline)this.jComboBoxDiscipline.getSelectedItem();
            if (this.original != null) {
                this.db.updateCategory(this.original, abr, discID, description, this.jTextFieldColour.getBackground());
            } else {
                this.catAdded = this.db.addCategory(abr, discID, description, this.jTextFieldColour.getBackground());
            }
            this.db.commit();
            this.dispose();
        }
        catch (SQLException se) {
            this.db.doRollback();
            FrameJsbugs.showStackError("Error saving cateogry", se, this.db);
        }
    }

    private void jButtonColourActionPerformed(ActionEvent evt) {
        Color colour = JColorChooser.showDialog(this, "Colour : Select", this.jTextFieldColour.getBackground());
        if (colour != null) {
            this.jTextFieldColour.setBackground(colour);
        }
    }
}

