/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import jsbugs.ChartProperties;
import jsbugs.SBDialog;
import util.AgeFormat;
import util.SB;

public class DialogChartFont
extends SBDialog {
    private final ChartProperties cp;
    private ButtonGroup AgeFormat;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxCorrectCuttings;
    private JCheckBox jCheckBoxCorrectDepth;
    private JComboBox jComboBoxFont;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JRadioButton jRadioButtonAFKA;
    private JRadioButton jRadioButtonAFMA;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSpinner jSpinnerHeader;
    private JSpinner jSpinnerPanel;
    private JSpinner jSpinnerSmall;
    private JSpinner jSpinnerTiny;
    private JTextField jTextFieldCaption;
    private JTextField jTextFieldsubHeader;

    public DialogChartFont(JDialog parent, boolean modal, ChartProperties cp) {
        super((Dialog)parent, modal);
        this.cp = cp;
        this.initComponents();
        this.init();
    }

    private void init() {
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontFamilies = env.getAvailableFontFamilyNames();
        this.jComboBoxFont.setModel(new DefaultComboBoxModel<String>(fontFamilies));
        this.jComboBoxFont.setSelectedItem(this.cp.font);
        this.jSpinnerHeader.setValue((int)this.cp.fontHeader);
        this.jSpinnerPanel.setValue((int)this.cp.fontPanel);
        this.jSpinnerSmall.setValue((int)this.cp.fontSmall);
        this.jSpinnerTiny.setValue((int)this.cp.fontTiny);
        this.jCheckBoxCorrectCuttings.setSelected(this.cp.correctCuttings);
        this.jCheckBoxCorrectDepth.setSelected(this.cp.correctDepths);
        switch (this.cp.ageFormat) {
            case MA: {
                this.jRadioButtonAFMA.setSelected(true);
                break;
            }
            case KA: {
                this.jRadioButtonAFKA.setSelected(true);
            }
        }
        this.jTextFieldsubHeader.setText("" + this.cp.panelSubHeaderHeight);
        this.jTextFieldCaption.setText("" + this.cp.panelCaptionHeight);
        this.setTitle("Chart Properties");
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.AgeFormat = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSpinnerHeader = new JSpinner();
        this.jSpinnerPanel = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jSpinnerTiny = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jSpinnerSmall = new JSpinner();
        this.jLabel5 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jComboBoxFont = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel10 = new JLabel();
        this.jTextFieldsubHeader = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.jCheckBoxCorrectDepth = new JCheckBox();
        this.jCheckBoxCorrectCuttings = new JCheckBox();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.jLabel11 = new JLabel();
        this.jRadioButtonAFMA = new JRadioButton();
        this.jRadioButtonAFKA = new JRadioButton();
        this.jLabel12 = new JLabel();
        this.jTextFieldCaption = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Font face name:");
        this.jLabel2.setText("Header font size:");
        this.jSpinnerHeader.setModel(new SpinnerNumberModel(5, 2, 15, 1));
        this.jSpinnerPanel.setModel(new SpinnerNumberModel(4, 1, 15, 1));
        this.jLabel3.setText("Regular panel font size:");
        this.jSpinnerTiny.setModel(new SpinnerNumberModel(2, 1, 4, 1));
        this.jLabel4.setText("Tiny panel font size:");
        this.jSpinnerSmall.setModel(new SpinnerNumberModel(3, 1, 10, 1));
        this.jLabel5.setText("Small panel font size:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogChartFont.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogChartFont.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jComboBoxFont.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel6.setText("mm");
        this.jLabel7.setText("mm");
        this.jLabel8.setText("mm");
        this.jLabel9.setText("mm");
        this.jLabel10.setText("Sub-header height:");
        this.jTextFieldsubHeader.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogChartFont.this.jTextFieldsubHeaderKeyTyped(evt);
            }
        });
        this.jCheckBoxCorrectDepth.setText("Use corrected depths");
        this.jCheckBoxCorrectCuttings.setText("Correct cuttings");
        this.jLabel11.setText("Display ages in:");
        this.AgeFormat.add(this.jRadioButtonAFMA);
        this.jRadioButtonAFMA.setText("Ma");
        this.AgeFormat.add(this.jRadioButtonAFKA);
        this.jRadioButtonAFKA.setText("Ka");
        this.jLabel12.setText("Caption height:");
        this.jTextFieldCaption.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogChartFont.this.jTextFieldCaptionKeyTyped(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator3).addComponent(this.jSeparator2, GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1).addComponent(this.jComboBoxFont, GroupLayout.Alignment.TRAILING, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldsubHeader)).addComponent(this.jSeparator4).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldCaption)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxCorrectCuttings).addComponent(this.jCheckBoxCorrectDepth).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel4))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel3))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSpinnerHeader, GroupLayout.Alignment.TRAILING, -2, 44, -2).addComponent(this.jSpinnerPanel, GroupLayout.Alignment.TRAILING, -2, 44, -2).addComponent(this.jSpinnerSmall, GroupLayout.Alignment.TRAILING, -2, 44, -2).addComponent(this.jSpinnerTiny, GroupLayout.Alignment.TRAILING, -2, 44, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel8).addComponent(this.jLabel7).addComponent(this.jLabel6))).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonAFMA).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonAFKA))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxFont, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerHeader, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerPanel, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerSmall, -2, -1, -2).addComponent(this.jLabel8).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinnerTiny, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.jTextFieldsubHeader, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel12).addComponent(this.jTextFieldCaption, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxCorrectDepth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxCorrectCuttings).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator3, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jRadioButtonAFMA).addComponent(this.jRadioButtonAFKA)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator4, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        boolean hasChanged = false;
        if (this.cp.setFont((String)this.jComboBoxFont.getSelectedItem())) {
            hasChanged = true;
        }
        if (this.cp.setFontSizes(((Integer)this.jSpinnerHeader.getValue()).intValue(), ((Integer)this.jSpinnerPanel.getValue()).intValue(), ((Integer)this.jSpinnerSmall.getValue()).intValue(), ((Integer)this.jSpinnerTiny.getValue()).intValue())) {
            hasChanged = true;
        }
        if (this.cp.setPanelCaptionHeight(Float.parseFloat(this.jTextFieldCaption.getText()))) {
            hasChanged = true;
        }
        if (this.cp.setPanelSubHeaderHeight(Float.parseFloat(this.jTextFieldsubHeader.getText()))) {
            hasChanged = true;
        }
        if (this.cp.setCorrections(this.jCheckBoxCorrectDepth.isSelected(), this.jCheckBoxCorrectCuttings.isSelected())) {
            hasChanged = true;
        }
        if (this.cp.setAgeFormat(this.jRadioButtonAFMA.isSelected() ? util.AgeFormat.MA : util.AgeFormat.KA)) {
            hasChanged = true;
        }
        if (hasChanged) {
            this.setOK();
        } else {
            this.dispose();
        }
    }

    private void jTextFieldsubHeaderKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldsubHeader, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldCaptionKeyTyped(KeyEvent evt) {
    }
}

