/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import util.SB;

public class DialogChartScales
extends JDialog {
    private final SBdb sbdb;
    private final DefaultListModel model = new DefaultListModel();
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JList jListScales;
    private JScrollPane jScrollPane1;

    public DialogChartScales(Frame parent, boolean modal, SBdb sbdb) throws SQLException {
        super(parent, modal);
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException {
        List scales = this.sbdb.getChartScales();
        for (Object o : scales) {
            this.model.addElement(o);
        }
        this.setTitle("Default Depth Scales");
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListScales = new JList();
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.jListScales.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jListScales);
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogChartScales.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogChartScales.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogChartScales.this.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 119, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonDelete, GroupLayout.Alignment.TRAILING, -1, 65, Short.MAX_VALUE).addComponent(this.jButtonAdd, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 206, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jListScales.getSelectedIndex() < 0) {
            return;
        }
        int scale = (Integer)this.model.get(this.jListScales.getSelectedIndex());
        try {
            this.sbdb.deleteChartScale(scale);
            this.sbdb.commit();
            this.model.remove(this.jListScales.getSelectedIndex());
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        String input = JOptionPane.showInputDialog(this, (Object)"New scale:");
        try {
            int scale = Integer.parseInt(input);
            if (scale < 1 || scale > 100000) {
                throw new NumberFormatException();
            }
            for (int i = 0; i < this.model.getSize(); ++i) {
                if ((Integer)this.model.get(i) == scale) {
                    return;
                }
                if ((Integer)this.model.get(i) <= scale) continue;
                this.sbdb.addChartScale(scale);
                this.sbdb.commit();
                this.model.add(i, scale);
                return;
            }
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, "'" + input + "' is not a vaid scale.\nPlease enter an integer between 1 and 100000.", this.getTitle(), 2);
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.sbdb);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

