/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.DialogFilePreview;
import jsbugs.DialogSelectAnalyst;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import model2.Userdef;

public class DialogChecklistReader
extends JDialog {
    SBdb db;
    String fileName;
    Userdef analyst = null;
    boolean isOK = false;
    char units;
    char discID;
    String sampleType = "";
    boolean isType2 = false;
    boolean useSampleTops;
    private ButtonGroup buttonGroupDepths;
    private ButtonGroup buttonGroupDisc;
    private ButtonGroup buttonGroupUnits;
    private JButton jButtonAnalyst;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonPreview;
    private JComboBox jComboBoxSampleType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JRadioButton jRadioButtonBases;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMacro;
    private JRadioButton jRadioButtonMetres;
    private JRadioButton jRadioButtonMicro;
    private JRadioButton jRadioButtonNanno;
    private JRadioButton jRadioButtonPaly;
    private JRadioButton jRadioButtonTops;
    private JTextField jTextFieldAbn;
    private JTextField jTextFieldAnalyst;
    private JTextField jTextFieldTitle;

    public DialogChecklistReader(Frame parent, boolean modal, SBdb db, String fileName) {
        super(parent, modal);
        this.db = db;
        this.fileName = fileName;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Checklist File Import Parameters");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (this.db.useSampleTops()) {
            this.jRadioButtonTops.setSelected(true);
        } else {
            this.jRadioButtonBases.setSelected(true);
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.fileName));
            String buff = in.readLine();
            if (buff.substring(0, 3).equals("REM")) {
                this.isType2 = true;
                while ((buff = in.readLine()) != null) {
                    if (buff.trim().startsWith("Report Title")) {
                        this.jTextFieldTitle.setText(buff.substring(buff.indexOf(61) + 1).trim());
                    }
                    if (!buff.trim().startsWith("Abund Format")) continue;
                    this.jTextFieldAbn.setText(buff.substring(buff.indexOf(61) + 1).trim());
                }
            } else {
                this.jTextFieldTitle.setText(in.readLine());
                this.jTextFieldAbn.setText(in.readLine());
            }
            in.close();
        }
        catch (Exception eio) {
            JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
            eio.printStackTrace();
        }
    }

    private void initComponents() {
        this.buttonGroupDisc = new ButtonGroup();
        this.buttonGroupUnits = new ButtonGroup();
        this.buttonGroupDepths = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMicro = new JRadioButton();
        this.jRadioButtonNanno = new JRadioButton();
        this.jRadioButtonPaly = new JRadioButton();
        this.jRadioButtonMacro = new JRadioButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.jTextFieldAnalyst = new JTextField();
        this.jButtonAnalyst = new JButton();
        this.jPanel3 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldTitle = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldAbn = new JTextField();
        this.jPanel4 = new JPanel();
        this.jComboBoxSampleType = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jRadioButtonTops = new JRadioButton();
        this.jRadioButtonBases = new JRadioButton();
        this.jLabel4 = new JLabel();
        this.jButtonPreview = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Discipline", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupDisc.add(this.jRadioButtonMicro);
        this.jRadioButtonMicro.setText("Micropalaeontology");
        this.buttonGroupDisc.add(this.jRadioButtonNanno);
        this.jRadioButtonNanno.setText("Nannopalaeontology");
        this.buttonGroupDisc.add(this.jRadioButtonPaly);
        this.jRadioButtonPaly.setText("Palynology");
        this.buttonGroupDisc.add(this.jRadioButtonMacro);
        this.jRadioButtonMacro.setText("Macropalaeontology");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonMicro).addComponent(this.jRadioButtonNanno).addComponent(this.jRadioButtonPaly).addComponent(this.jRadioButtonMacro)).addContainerGap(23, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButtonMicro).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonNanno).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonPaly).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonMacro).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogChecklistReader.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogChecklistReader.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogChecklistReader.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Analyst", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jTextFieldAnalyst.setBackground(new Color(255, 255, 204));
        this.jTextFieldAnalyst.setEditable(false);
        this.jTextFieldAnalyst.setText("<select>");
        this.jButtonAnalyst.setText("...");
        this.jButtonAnalyst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogChecklistReader.this.jButtonAnalystActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldAnalyst, -1, 213, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAnalyst, -2, 28, -2).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldAnalyst, -2, -1, -2).addComponent(this.jButtonAnalyst)).addContainerGap(15, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(null, "Units", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.buttonGroupUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonMetres).addComponent(this.jRadioButtonFeet)).addContainerGap(89, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jRadioButtonMetres).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonFeet)));
        this.jLabel1.setText("Report title:");
        this.jTextFieldTitle.setBackground(new Color(255, 255, 204));
        this.jTextFieldTitle.setEditable(false);
        this.jLabel2.setText("Abundance format:");
        this.jTextFieldAbn.setBackground(new Color(255, 255, 204));
        this.jTextFieldAbn.setEditable(false);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Samples", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.jComboBoxSampleType.setModel(new DefaultComboBoxModel<String>(new String[]{"CU", "CO", "SC", "LOG", "OC"}));
        this.jLabel3.setText("Samples with single depths:");
        this.buttonGroupDepths.add(this.jRadioButtonTops);
        this.jRadioButtonTops.setText("Depths are tops");
        this.buttonGroupDepths.add(this.jRadioButtonBases);
        this.jRadioButtonBases.setText("Depths are bases");
        this.jLabel4.setText("Default sample type:");
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap(16, Short.MAX_VALUE).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxSampleType, -2, 61, -2).addComponent(this.jRadioButtonBases).addComponent(this.jRadioButtonTops))));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonTops).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonBases).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxSampleType, -2, -1, -2).addComponent(this.jLabel4)).addGap(33, 33, 33)));
        this.jButtonPreview.setText("Preview...");
        this.jButtonPreview.setToolTipText("Preview file contents in separate window");
        this.jButtonPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogChecklistReader.this.jButtonPreviewActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldTitle, -1, 348, Short.MAX_VALUE).addComponent(this.jTextFieldAbn, -1, 348, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE)))).addGap(10, 10, 10)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPreview).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addContainerGap()))));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldAbn, -2, -1, -2).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -2, 142, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonPreview).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonAnalystActionPerformed(ActionEvent evt) {
        try {
            DialogSelectAnalyst dialog = new DialogSelectAnalyst(this, true, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.analyst = dialog.selectedUser;
            if (this.analyst != null) {
                this.jTextFieldAnalyst.setText(this.analyst.getAbr());
            }
        }
        catch (SQLException sql) {
            JOptionPane.showMessageDialog(this, "Error opening Analyst dialog:/n" + sql, this.getTitle(), 0);
            sql.printStackTrace();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroupUnits.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select units used in file", this.getTitle(), 2);
            return;
        }
        if (this.buttonGroupDisc.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select discipline used in file", this.getTitle(), 2);
            return;
        }
        if (this.analyst == null) {
            JOptionPane.showMessageDialog(this, "Select an analyst", this.getTitle(), 2);
            return;
        }
        this.units = (char)(this.jRadioButtonMetres.isSelected() ? 77 : 70);
        if (this.jRadioButtonMicro.isSelected()) {
            this.discID = (char)77;
        } else if (this.jRadioButtonMacro.isSelected()) {
            this.discID = (char)65;
        } else if (this.jRadioButtonNanno.isSelected()) {
            this.discID = (char)78;
        } else if (this.jRadioButtonPaly.isSelected()) {
            this.discID = (char)80;
        }
        this.sampleType = (String)this.jComboBoxSampleType.getSelectedItem();
        this.useSampleTops = this.jRadioButtonTops.isSelected();
        this.isOK = true;
        this.dispose();
    }

    private void jButtonPreviewActionPerformed(ActionEvent evt) {
        DialogFilePreview dialog = new DialogFilePreview(this, false, this.fileName);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogchecklistimport.html");
    }
}

