/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jsbugs.DialogCmpStdEvent;
import jsbugs.DialogCmpStdUnits;
import jsbugs.DialogSelectGroup;
import jsbugs.FrameJsbugs;
import jsbugs.JPanelCmpStdHeader;
import jsbugs.SBDialog;
import jsbugs.TableModelCmpStd;
import model2.Audit;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.EventCompareCSU;
import model2.LOC;
import model2.SBdb;
import model2.Taxon;
import model2.TxGroup;
import model2.WellEvent;
import model2.WellInterp;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsTable;
import util.TableSorter;

public class DialogCmpStd
extends SBDialog {
    private final SBdb db;
    private final TableModelCmpStd model = new TableModelCmpStd();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    private final JPanelCmpStdHeader panelHdr = new JPanelCmpStdHeader(this.model);
    private final CompositeStandard cmpStd;
    CompositeStandard cmpStdAdded = null;
    private ButtonGroup buttonGroup1;
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonInsertGroup;
    private JButton jButtonModify;
    private JButton jButtonOK;
    private JButton jButtonSaveAsGroup;
    private JPanel jPanelHeader;
    private JScrollPane jScrollPane1;
    private JTable jTableCmpStd;

    public DialogCmpStd(Frame parent, boolean modal, SBdb db, CompositeStandard std) throws SQLException, SBException {
        super(parent, modal);
        if (std != null) {
            std.loadEvents();
        }
        this.cmpStd = std;
        this.db = db;
        this.initComponents();
        this.init();
    }

    public DialogCmpStd(JDialog parent, boolean modal, SBdb db, CompositeStandard std) throws SQLException, SBException {
        super((Dialog)parent, modal);
        if (std != null) {
            std.loadEvents();
        }
        this.cmpStd = std;
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, SBException {
        assert (this.db.isConnected());
        this.model.setupTable(this.jTableCmpStd);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableCmpStd);
        this.jTableCmpStd.getTableHeader().addMouseMotionListener((MouseMotionListener)this.sorter.createColumnHeaderToolTips(TableModelCmpStd.tooltips, this.jTableCmpStd));
        this.jPanelHeader.setLayout(new BorderLayout());
        this.jPanelHeader.add((Component)this.panelHdr, "North");
        if (this.cmpStd != null) {
            this.cmpStd.loadEvents();
            for (CompositeStandardEvent event : this.cmpStd.getEvents()) {
                CompositeStandardEvent.Builder copy = CompositeStandardEvent.Builder.copyOf((CompositeStandardEvent)event);
                if (this.cmpStd.getDatabase().isConnected()) {
                    copy.event(event.getEvent());
                } else {
                    if (event.getEvent().getLink() == null) {
                        throw new IllegalStateException("Unlinked event in workspace composite: " + event.getEvent());
                    }
                    copy.event(event.getEvent().getLink());
                    copy.audit(new Audit(this.db, this.cmpStd.getDatabase(), event.getAudit()));
                }
                this.model.cmpStd.add(copy);
            }
            this.setTitle("Composite Standard : Edit");
            this.model.updateFields(this.cmpStd.getName(), this.cmpStd.getMinAge(), this.cmpStd.getMaxAge(), this.cmpStd.getTopCSU(), this.cmpStd.getBaseCSU(), this.cmpStd.isAgeScale());
            this.panelHdr.setFields();
        } else {
            this.setTitle("Composite Standard : Add");
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCmpStd = new SbugsTable(this.sorter);
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonInsertGroup = new JButton();
        this.jButtonSaveAsGroup = new JButton();
        this.jPanelHeader = new JPanel();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(585, 400));
        this.jTableCmpStd.setModel((TableModel)this.sorter);
        this.jTableCmpStd.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogCmpStd.this.jTableCmpStdMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableCmpStd);
        this.jButtonAdd.setText("Add event...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCmpStd.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCmpStd.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit event...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCmpStd.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCmpStd.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCmpStd.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCmpStd.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonModify.setText("Modify...");
        this.jButtonModify.setToolTipText("Adjust all CSU values");
        this.jButtonModify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCmpStd.this.jButtonModifyActionPerformed(evt);
            }
        });
        this.jButtonInsertGroup.setText("Insert group...");
        this.jButtonInsertGroup.setToolTipText("Insert a top/base event for all the taxa in a group");
        this.jButtonInsertGroup.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonInsertGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCmpStd.this.jButtonInsertGroupActionPerformed(evt);
            }
        });
        this.jButtonSaveAsGroup.setText("Save as group...");
        this.jButtonSaveAsGroup.setToolTipText("Create a group from selected event linked taxa");
        this.jButtonSaveAsGroup.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonSaveAsGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCmpStd.this.jButtonSaveAsGroupActionPerformed(evt);
            }
        });
        GroupLayout jPanelHeaderLayout = new GroupLayout((Container)this.jPanelHeader);
        this.jPanelHeader.setLayout((LayoutManager)jPanelHeaderLayout);
        jPanelHeaderLayout.setHorizontalGroup((GroupLayout.Group)jPanelHeaderLayout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        jPanelHeaderLayout.setVerticalGroup((GroupLayout.Group)jPanelHeaderLayout.createParallelGroup(1).add(0, 100, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 491, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonOK, -2, 95, -2)).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jButtonAdd, 0, 0, Short.MAX_VALUE).add(2, (Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonModify, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonInsertGroup, -2, 95, -2)).add((Component)this.jButtonSaveAsGroup, -2, 110, -2)).addContainerGap()).add(2, (Component)this.jPanelHeader, -1, -1, Short.MAX_VALUE));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonCancel, this.jButtonDelete, this.jButtonEdit, this.jButtonHelp, this.jButtonInsertGroup, this.jButtonModify, this.jButtonOK, this.jButtonSaveAsGroup}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanelHeader, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).add(18, 18, 18).add((Component)this.jButtonModify).addPreferredGap(0).add((Component)this.jButtonInsertGroup).addPreferredGap(0).add((Component)this.jButtonSaveAsGroup).addPreferredGap(0, 72, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((Component)this.jScrollPane1, -1, 333, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if ((this.cmpStd == null && !this.model.cmpStd.isEmpty() || this.cmpStd != null && !this.cmpStd.equalsCompositeEvents(this.model.cmpStd)) && JOptionPane.showConfirmDialog(this, "Discard changes to event list?", this.getTitle(), 0) != 0) {
            return;
        }
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogcmpstd.html");
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        try {
            this.panelHdr.validateFields(this.db, this.cmpStd);
            this.model.validateCSU();
        }
        catch (InvalidFieldException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
            return;
        }
        boolean isAgeScale = this.panelHdr.isAgeScale();
        try {
            if (this.cmpStd != null) {
                if (this.cmpStd.getDatabase() != this.db && !this.cmpStd.getDatabase().isConnected()) {
                    this.cmpStdAdded = this.db.addCompositeStandard(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, isAgeScale, this.model.cmpStd, new Audit(this.db, this.cmpStd.getDatabase(), this.cmpStd.getAudit()));
                } else {
                    this.cmpStd.update(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, isAgeScale, this.model.cmpStd);
                }
            } else {
                this.cmpStdAdded = this.db.addCompositeStandard(this.model.stdName, this.model.minAge, this.model.maxAge, this.model.topCSU, this.model.baseCSU, isAgeScale, this.model.cmpStd, null);
            }
            this.db.commit();
            if (this.cmpStd != null) {
                this.cmpStd.notifyObservers();
            }
            this.setOK();
        }
        catch (IllegalStateException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
        }
        catch (InvalidFieldException ife) {
            JOptionPane.showMessageDialog(this, ife.getMessage(), this.getTitle(), 2);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogCmpStdEvent dialog = new DialogCmpStdEvent(this, true, this.db, null, this.panelHdr.isAgeScale());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.cmpStd.add(dialog.builder);
                Collections.sort(this.model.cmpStd, new EventCompareCSU(false));
                this.sorter.fireTableDataChanged();
                this.sorter.reallocateIndexes();
                int index = this.sorter.getIndexOf(this.model.cmpStd.indexOf(dialog.builder));
                this.jTableCmpStd.getSelectionModel().setSelectionInterval(index, index);
            }
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableCmpStd.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(this, "Select one row to edit", this.getTitle(), 2);
            return;
        }
        int selectedRow = this.jTableCmpStd.getSelectedRow();
        CompositeStandardEvent.Builder toEdit = this.model.cmpStd.get(this.sorter.getIndexOf(selectedRow));
        try {
            int index;
            DialogCmpStdEvent dialog = new DialogCmpStdEvent(this, true, this.db, toEdit, this.panelHdr.isAgeScale());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                Collections.sort(this.model.cmpStd, new EventCompareCSU(false));
                this.sorter.fireTableDataChanged();
                this.sorter.reallocateIndexes();
                index = this.sorter.getIndexOf(this.model.cmpStd.indexOf(dialog.builder));
            } else {
                index = selectedRow;
            }
            this.jTableCmpStd.getSelectionModel().setSelectionInterval(index, index);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jTableCmpStdMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] selection = this.jTableCmpStd.getSelectedRows();
        if (selection.length == 0) {
            JOptionPane.showMessageDialog(this, "No row(s) selected", this.getTitle(), 2);
            return;
        }
        LinkedList<CompositeStandardEvent.Builder> toRemove = new LinkedList<CompositeStandardEvent.Builder>();
        for (int i = 0; i < selection.length; ++i) {
            toRemove.add(this.model.cmpStd.get(this.sorter.getIndexOf(selection[i])));
        }
        for (CompositeStandardEvent.Builder event : toRemove) {
            this.model.cmpStd.remove(event);
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        DialogCmpStdUnits dialog = new DialogCmpStdUnits(this, true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK) {
            String topString = this.panelHdr.getTopCSUString();
            String baseString = this.panelHdr.getBaseCSUString();
            if (!topString.isEmpty() && !baseString.isEmpty()) {
                double top = Double.parseDouble(topString);
                top = dialog.reFactor(top);
                double base = Double.parseDouble(baseString);
                base = dialog.reFactor(base);
                this.model.updateFields(this.model.stdName, this.model.minAge, this.model.maxAge, top, base, this.model.isAgeScale);
                this.panelHdr.setFields();
            }
            for (CompositeStandardEvent.Builder event : this.model.cmpStd) {
                event.csu(dialog.reFactor(event.getCSU()));
            }
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonInsertGroupActionPerformed(ActionEvent evt) {
        try {
            DialogSelectGroup dialog = new DialogSelectGroup(this, true, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                TxGroup group = dialog.selection;
                LinkedList<Taxon> taxa = new LinkedList<Taxon>(this.db.getTxGroupTaxa(group));
                int nAdded = this.model.importTaxa(taxa, this.db);
                this.sorter.reallocateIndexes();
                this.sorter.fireTableDataChanged();
                if (nAdded > 0) {
                    JOptionPane.showMessageDialog(this, "Number of events added: " + nAdded, this.getTitle(), 1);
                } else {
                    JOptionPane.showMessageDialog(this, "No new events added.", this.getTitle(), 1);
                }
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSaveAsGroupActionPerformed(ActionEvent evt) {
        try {
            boolean restrict = false;
            int[] selection = this.jTableCmpStd.getSelectedRows();
            if (this.jTableCmpStd.getSelectedRowCount() > 0 && this.jTableCmpStd.getSelectedRowCount() < this.jTableCmpStd.getRowCount()) {
                int opt = JOptionPane.showConfirmDialog(this, "Restrict to selected events only?", this.getTitle(), 1, 3);
                if (opt == 2 || opt == -1) {
                    return;
                }
                if (opt == 0) {
                    restrict = true;
                }
            }
            DialogSelectGroup dialog = new DialogSelectGroup(this, true, this.db);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                TxGroup group = dialog.selection;
                LinkedList<Taxon> toAdd = new LinkedList<Taxon>();
                for (int i = 0; i < this.model.getRowCount(); ++i) {
                    Taxon taxon;
                    CompositeStandardEvent.Builder ev = this.model.cmpStd.get(i);
                    if (restrict) {
                        boolean selected = false;
                        for (int ind = 0; ind < selection.length; ++ind) {
                            if (i != this.sorter.getIndexOf(selection[ind])) continue;
                            selected = true;
                            break;
                        }
                        if (!selected) continue;
                    }
                    if ((taxon = ev.getEvent().getTaxon()) == null || toAdd.contains(taxon) || group.isMember(taxon.getSpecID())) continue;
                    toAdd.add(taxon);
                }
                if (toAdd.isEmpty()) {
                    JOptionPane.showMessageDialog(this, "No new taxa added to group: " + group.toString(), this.getTitle(), 1);
                } else {
                    group.addTaxa(toAdd);
                    group.notifyObservers();
                    this.db.commit();
                    JOptionPane.showMessageDialog(this, "Number of taxa added: " + toAdd.size(), this.getTitle(), 1);
                }
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.toString(), (Exception)ex);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    void loadWellEvents(WellInterp interp) throws SQLException {
        this.panelHdr.setNameField(interp.getHeader().toString());
        LOC loc = interp.getLOC();
        Double minAge = null;
        Double maxAge = null;
        for (WellEvent event : interp.getEvents()) {
            double csu = 0.0;
            if (loc != null) {
                csu = loc.getAge(event.getSample().getDepth(), false);
                if (minAge == null || csu < minAge) {
                    minAge = csu;
                }
                if (maxAge == null || csu > maxAge) {
                    maxAge = csu;
                }
            }
            if (csu <= 0.0) {
                csu = event.getSample().getDepth();
            }
            CompositeStandardEvent.Builder csEvent = new CompositeStandardEvent.Builder().event(event.getEvent()).csu(csu).type(event.getTypeObj());
            this.model.cmpStd.add(csEvent);
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        if (minAge != null) {
            this.model.minAge = SB.round((double)minAge, (int)2);
        }
        if (maxAge != null) {
            this.model.maxAge = SB.round((double)maxAge, (int)2);
        }
        this.panelHdr.setFields();
    }
}

