/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jsbugs.DialogSelectEvent;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.CompositeStandard;
import model2.CompositeStandardEvent;
import model2.SBEvent;
import model2.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;

public class DialogCmpStdEvent
extends SBDialog {
    private static final int NAMELEN = 100;
    private static final int CSULEN = 6;
    private final SBdb db;
    private final CompositeStandard cmpStd;
    final CompositeStandardEvent cmpStdEvent;
    final CompositeStandardEvent.Builder builder;
    private ButtonGroup buttonGroupType;
    private JButton jButtonCancel;
    private JButton jButtonEvent;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JLabel jLabel2;
    private JLabel jLabelCSUAge;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonBase;
    private JRadioButton jRadioButtonSingle;
    private JRadioButton jRadioButtonTop;
    private JTextField jTextFieldCSU;
    private JTextField jTextFieldEventName;

    public DialogCmpStdEvent(JDialog parent, boolean modal, SBdb db, CompositeStandardEvent.Builder builder, boolean isAgeScale) {
        super((Dialog)parent, modal);
        this.db = db;
        this.cmpStd = null;
        this.cmpStdEvent = null;
        if (builder == null) {
            this.setTitle("Event : Add");
            this.builder = new CompositeStandardEvent.Builder();
        } else {
            this.setTitle("Event : Edit");
            this.builder = builder;
        }
        this.initComponents();
        this.init(isAgeScale);
    }

    public DialogCmpStdEvent(JFrame parent, boolean modal, SBdb db, CompositeStandard cmpStd, CompositeStandardEvent event, CompositeStandardEvent.Builder builder) {
        super((Frame)parent, modal);
        if (cmpStd == null) {
            throw new IllegalArgumentException("Composite is null");
        }
        this.db = db;
        this.cmpStd = cmpStd;
        this.cmpStdEvent = event;
        if (builder != null) {
            assert (event == null);
            this.builder = builder;
            this.setTitle("Event : Add");
        } else if (event != null) {
            this.builder = CompositeStandardEvent.Builder.copyOf((CompositeStandardEvent)event);
            this.builder.event(event.getEvent());
            this.setTitle("Event : Edit");
        } else {
            this.builder = new CompositeStandardEvent.Builder();
            this.setTitle("Event : Add");
        }
        this.initComponents();
        this.init(cmpStd.isAgeScale());
    }

    private void init(boolean isAgeScale) {
        if (this.builder.getEvent() != null) {
            this.jTextFieldEventName.setText(this.builder.getEvent().toString());
            this.setEventType();
        }
        if (this.builder.getType() != null) {
            switch (this.builder.getType()) {
                case TOP: {
                    this.jRadioButtonTop.setSelected(true);
                    break;
                }
                case BASE: {
                    this.jRadioButtonBase.setSelected(true);
                    break;
                }
                case SINGLE: {
                    this.jRadioButtonSingle.setSelected(true);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (this.builder.getCSU() > 0.0) {
            this.jTextFieldCSU.setText("" + this.builder.getCSU());
        }
        if (this.cmpStdEvent != null) {
            this.jRadioButtonBase.setEnabled(false);
            this.jRadioButtonSingle.setEnabled(false);
            this.jRadioButtonTop.setEnabled(false);
            this.jButtonEvent.setEnabled(false);
        }
        this.jRadioButtonTop.setText(CompositeStandardEvent.getEvTypeString((SBEvent.EventType)SBEvent.EventType.TOP));
        this.jRadioButtonBase.setText(CompositeStandardEvent.getEvTypeString((SBEvent.EventType)SBEvent.EventType.BASE));
        if (isAgeScale) {
            this.jLabelCSUAge.setText("Age:");
        } else {
            this.jLabelCSUAge.setText("CSU:");
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void setEventType() {
        if (this.builder.getEvent().isSingle()) {
            this.jRadioButtonTop.setEnabled(false);
            this.jRadioButtonBase.setEnabled(false);
            this.builder.type(SBEvent.EventType.SINGLE);
        } else {
            this.jRadioButtonSingle.setEnabled(false);
        }
    }

    private void initComponents() {
        this.buttonGroupType = new ButtonGroup();
        this.jButtonEvent = new JButton();
        this.jTextFieldCSU = new JTextField();
        this.jTextFieldEventName = new JTextField();
        this.jLabelCSUAge = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jRadioButtonTop = new JRadioButton();
        this.jRadioButtonBase = new JRadioButton();
        this.jRadioButtonSingle = new JRadioButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonEvent.setText("...");
        this.jButtonEvent.setToolTipText("Choose name from Event Dictionary");
        this.jButtonEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCmpStdEvent.this.jButtonEventActionPerformed(evt);
            }
        });
        this.jTextFieldCSU.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DialogCmpStdEvent.this.jTextFieldCSUFocusGained(evt);
            }
        });
        this.jTextFieldCSU.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogCmpStdEvent.this.jTextFieldCSUKeyTyped(evt);
            }
        });
        this.jTextFieldEventName.setEditable(false);
        this.jTextFieldEventName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogCmpStdEvent.this.jTextFieldEventNameKeyTyped(evt);
            }
        });
        this.jLabelCSUAge.setText("CSU/Age:");
        this.jLabel2.setText("Event name:");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Event Type", 0, 0, null, new Color(51, 102, 204)));
        this.buttonGroupType.add(this.jRadioButtonTop);
        this.jRadioButtonTop.setText("Top event");
        this.jRadioButtonTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonTop.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupType.add(this.jRadioButtonBase);
        this.jRadioButtonBase.setText("Base event");
        this.jRadioButtonBase.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonBase.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupType.add(this.jRadioButtonSingle);
        this.jRadioButtonSingle.setText("Single event");
        this.jRadioButtonSingle.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonSingle.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonTop).addPreferredGap(1).add((Component)this.jRadioButtonBase).addPreferredGap(1).add((Component)this.jRadioButtonSingle).addContainerGap(123, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonTop).add((Component)this.jRadioButtonBase).add((Component)this.jRadioButtonSingle)).addContainerGap()));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCmpStdEvent.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCmpStdEvent.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCmpStdEvent.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabelCSUAge)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldEventName, -1, 281, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonEvent, -2, 28, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldCSU, -2, 132, -2).add(0, 0, Short.MAX_VALUE)))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelCSUAge).add((Component)this.jTextFieldCSU, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jButtonEvent).add((Component)this.jTextFieldEventName, -2, -1, -2)).addPreferredGap(1).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonEventActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogSelectEvent dialog = new DialogSelectEvent(this, true, this.db, this.builder.getEvent(), null);
            dialog.setLocationRelativeTo(this);
            this.setCursor(Cursor.getDefaultCursor());
            dialog.setVisible(true);
            if (dialog.selection != null) {
                this.builder.event(dialog.selection);
                this.jTextFieldEventName.setText(this.builder.getEvent().toString());
                this.setEventType();
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jTextFieldCSUFocusGained(FocusEvent evt) {
        this.jTextFieldCSU.setSelectionStart(0);
        this.jTextFieldCSU.setSelectionEnd(this.jTextFieldCSU.getText().length());
    }

    private void jTextFieldCSUKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldCSU, (int)6, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldEventNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldEventName, (int)100, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroupType.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "Select an event type", this.getTitle(), 0);
            return;
        }
        if (this.builder.getEvent() == null) {
            JOptionPane.showMessageDialog(this, "Select an event", this.getTitle(), 0);
            return;
        }
        if (this.jTextFieldCSU.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Enter a value for Age/CSU", this.getTitle(), 0);
            return;
        }
        SBEvent.EventType type = this.jRadioButtonTop.isSelected() ? SBEvent.EventType.TOP : (this.jRadioButtonBase.isSelected() ? SBEvent.EventType.BASE : SBEvent.EventType.SINGLE);
        this.builder.type(type);
        this.builder.csu(Double.parseDouble(this.jTextFieldCSU.getText()));
        if (this.cmpStd == null) {
            this.setOK();
        } else {
            if (this.cmpStd.hasEvent(this.builder, this.cmpStdEvent)) {
                JOptionPane.showMessageDialog(this, "Event already exists in composite standard", this.getTitle(), 0);
                return;
            }
            if (!this.cmpStd.checkCSU(this.builder)) {
                String msg = type == SBEvent.EventType.TOP ? "Top event cannot be older than existing base event" : "Base event cannot be younger than existing top event";
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 2);
                return;
            }
            try {
                if (this.cmpStdEvent != null) {
                    this.cmpStd.updateCsu(this.cmpStdEvent, this.builder.getCSU());
                } else {
                    this.cmpStd.addEvent(this.builder);
                }
                this.cmpStd.notifyObservers();
                this.setOK();
            }
            catch (SBException sbe) {
                this.db.doRollback();
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (SQLException sql) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (InvalidFieldException ife) {
                JOptionPane.showMessageDialog(this, ife.getMessage(), this.getTitle(), 2);
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogeventcomposite.html");
    }
}

