/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.ConnectionParameters;
import jsbugs.DialogConnection;
import jsbugs.DialogConnectionManager;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import util.SB;

public class DialogConnect
extends JDialog {
    boolean needsToShow = true;
    boolean inInitCombo = false;
    ConnectionParameters parms = null;
    SBdb sbdb = null;
    Frame parent;
    private JButton jButtonConnect;
    private JButton jButtonExit;
    private JButton jButtonHelp;
    private JButton jButtonManageConnections;
    private JCheckBox jCheckBoxRemember;
    private JCheckBox jCheckBoxSilent;
    private JComboBox jComboBoxDataSource;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPasswordField jPasswordField;
    private JSeparator jSeparator1;
    private JTextField jTextFieldLoginName;

    public DialogConnect(Frame parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Connect");
        this.getRootPane().setDefaultButton(this.jButtonConnect);
        List<ConnectionParameters> sbConns = ConnectionParameters.getConnections();
        if (sbConns.isEmpty()) {
            DialogConnection dialog = new DialogConnection(this.parent, true, sbConns, null);
            SB.centreDialog((Dialog)dialog);
            dialog.setVisible(true);
            if (!dialog.isOK) {
                System.exit(0);
            }
            this.parms = dialog.parameters;
            sbConns = ConnectionParameters.getConnections();
        } else if (sbConns.size() == 1) {
            this.parms = sbConns.get(0);
        }
        this.initCombo();
        this.parms = (ConnectionParameters)this.jComboBoxDataSource.getSelectedItem();
        if (this.parms.UID != null && !this.parms.UID.isEmpty()) {
            this.enableFields(!this.parms.isSingle);
            if (!this.parms.isSingle) {
                this.jTextFieldLoginName.setText(this.parms.UID);
                this.jPasswordField.setText(this.parms.pwd);
            }
            this.jCheckBoxRemember.setSelected(true);
        }
    }

    private void initCombo() {
        ConnectionParameters selected;
        this.inInitCombo = true;
        this.jComboBoxDataSource.removeAllItems();
        List<ConnectionParameters> sbConns = ConnectionParameters.getConnections();
        ConnectionParameters defaultParms = null;
        for (ConnectionParameters p : sbConns) {
            this.jComboBoxDataSource.addItem(p);
            if (!p.isDefault) continue;
            defaultParms = p;
        }
        if (defaultParms != null) {
            this.jComboBoxDataSource.setSelectedItem(defaultParms);
        }
        if ((selected = (ConnectionParameters)this.jComboBoxDataSource.getSelectedItem()) != null) {
            this.jTextFieldLoginName.setEnabled(!selected.isSingle);
            this.jPasswordField.setEnabled(!selected.isSingle);
        }
        this.inInitCombo = false;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBoxDataSource = new JComboBox();
        this.jButtonManageConnections = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldLoginName = new JTextField();
        this.jPasswordField = new JPasswordField();
        this.jSeparator1 = new JSeparator();
        this.jButtonConnect = new JButton();
        this.jButtonExit = new JButton();
        this.jCheckBoxRemember = new JCheckBox();
        this.jCheckBoxSilent = new JCheckBox();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(0);
        this.setAlwaysOnTop(true);
        this.setIconImage(null);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DialogConnect.this.windowClosing(evt);
            }
        });
        this.jLabel1.setText("Connection:");
        this.jComboBoxDataSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnect.this.jComboBoxDataSourceActionPerformed(evt);
            }
        });
        this.jButtonManageConnections.setText("Manage Connections...");
        this.jButtonManageConnections.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonManageConnections.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnect.this.jButtonManageConnectionsActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Login Name:");
        this.jLabel3.setText("Password:");
        this.jButtonConnect.setFont(this.jButtonConnect.getFont().deriveFont(this.jButtonConnect.getFont().getStyle() | 1));
        this.jButtonConnect.setText("Connect");
        this.jButtonConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnect.this.jButtonConnectActionPerformed(evt);
            }
        });
        this.jButtonExit.setText("Exit");
        this.jButtonExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnect.this.jButtonExitActionPerformed(evt);
            }
        });
        this.jCheckBoxRemember.setText("Remember data source login name and password");
        this.jCheckBoxSilent.setText("Don't show this dialog again");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnect.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSilent).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButtonManageConnections).addComponent(this.jPasswordField, -1, 191, Short.MAX_VALUE).addComponent(this.jTextFieldLoginName).addComponent(this.jComboBoxDataSource, 0, -1, Short.MAX_VALUE)))).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jCheckBoxRemember, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonConnect).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExit))).addContainerGap()));
        layout.linkSize(0, this.jButtonExit, this.jButtonHelp);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxDataSource, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonManageConnections).addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldLoginName, -2, 20, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jPasswordField, -2, -1, -2)).addGap(21, 21, 21).addComponent(this.jCheckBoxRemember).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxSilent).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 12, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonExit).addComponent(this.jButtonHelp).addComponent(this.jButtonConnect)).addContainerGap()));
        this.pack();
    }

    private void jButtonExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jButtonConnectActionPerformed(ActionEvent evt) {
        char[] passwordChars;
        if (this.jComboBoxDataSource.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(this, "No data source selected", this.getTitle(), 2);
        }
        this.parms = (ConnectionParameters)this.jComboBoxDataSource.getSelectedItem();
        if (this.jTextFieldLoginName.getText().length() > 0) {
            this.parms.UID = this.jTextFieldLoginName.getText();
        }
        if ((passwordChars = this.jPasswordField.getPassword()).length > 0) {
            this.parms.pwd = "";
            for (int i = 0; i < passwordChars.length; ++i) {
                this.parms.pwd = this.parms.pwd + passwordChars[i];
            }
        }
        try {
            this.parms.isDefault = true;
            this.parms.put(this.parms.isSingle ? true : this.jCheckBoxRemember.isSelected());
            ConnectionParameters.putSilent(this.jCheckBoxSilent.isSelected());
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
        }
    }

    private void jComboBoxDataSourceActionPerformed(ActionEvent evt) {
        if (this.inInitCombo) {
            return;
        }
        this.parms = (ConnectionParameters)this.jComboBoxDataSource.getSelectedItem();
        if (!this.parms.isSingle) {
            this.enableFields(true);
            this.jTextFieldLoginName.setText(this.parms.UID);
            this.jPasswordField.setText(this.parms.pwd);
        } else {
            this.enableFields(false);
        }
        if (this.parms.UID == null || this.parms.UID.isEmpty()) {
            this.jCheckBoxRemember.setSelected(false);
        } else {
            this.jCheckBoxRemember.setSelected(true);
        }
    }

    private void enableFields(boolean b) {
        this.jTextFieldLoginName.setEnabled(b);
        this.jPasswordField.setEnabled(b);
        this.jCheckBoxRemember.setEnabled(b);
    }

    private void jButtonManageConnectionsActionPerformed(ActionEvent evt) {
        DialogConnectionManager dialog = new DialogConnectionManager(this, true);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.hasChanged) {
            this.initCombo();
        }
    }

    private void windowClosing(WindowEvent evt) {
        this.jButtonExitActionPerformed(null);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtologin.html");
    }
}

