/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import jsbugs.ConnectionParameters;
import jsbugs.FrameJsbugs;
import util.SB;
import util.SbugsFileFilter;

public class DialogConnection
extends JDialog {
    List<ConnectionParameters> sbConns = null;
    ConnectionParameters selection = null;
    ConnectionParameters parameters = null;
    boolean isOK = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonDSN;
    private JButton jButtonFile;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxSQLintSec;
    private JComboBox jComboBoxJDBCdriver;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabelDSN;
    private JLabel jLabelSbchartODBC;
    private JLabel jLabelSchema;
    private JPanel jPanel1;
    private JPasswordField jPasswordField;
    private JRadioButton jRadioButtonJDBC;
    private JRadioButton jRadioButtonODBC;
    private JTextField jTextFieldDSN;
    private JTextField jTextFieldLoginName;
    private JTextField jTextFieldName;
    private JTextField jTextFieldSbchartODBC;
    private JTextField jTextFieldSchema;

    public DialogConnection(Frame parent, boolean modal, List<ConnectionParameters> sbConns, ConnectionParameters parms) {
        super(parent, modal);
        this.sbConns = sbConns;
        this.parameters = parms;
        this.initComponents();
        this.init();
    }

    public DialogConnection(JDialog parent, boolean modal, List<ConnectionParameters> sbConns, ConnectionParameters parms) {
        super((Dialog)parent, modal);
        this.sbConns = sbConns;
        this.parameters = parms;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("StrataBugs Connection : " + (this.parameters == null ? "Add" : this.parameters.name));
        this.getRootPane().setDefaultButton(this.jButtonOK);
        if (this.parameters != null) {
            this.jTextFieldName.setText(this.parameters.name);
            this.jTextFieldDSN.setText(this.parameters.hostName);
            this.jTextFieldSbchartODBC.setText(this.parameters.sbchartODBC);
            this.jTextFieldSchema.setText(this.parameters.instanceName);
            if (this.parameters.isSingle) {
                this.jTextFieldLoginName.setText(this.parameters.UID);
                this.jPasswordField.setText(this.parameters.pwd);
            }
            if (this.parameters.driverName.equalsIgnoreCase("odbc")) {
                this.jRadioButtonODBC.setSelected(true);
                this.jRadioButtonODBCActionPerformed(null);
            } else {
                this.jRadioButtonJDBC.setSelected(true);
                this.jComboBoxJDBCdriver.setSelectedItem(this.parameters.driverName);
                this.jRadioButtonJDBCActionPerformed(null);
            }
            this.jCheckBoxSQLintSec.setSelected(this.parameters.SQLServerIntegratedSecurity);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldLoginName = new JTextField();
        this.jLabel4 = new JLabel();
        this.jPasswordField = new JPasswordField();
        this.jLabel2 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonHelp = new JButton();
        this.jLabel5 = new JLabel();
        this.jTextFieldDSN = new JTextField();
        this.jLabelDSN = new JLabel();
        this.jButtonFile = new JButton();
        this.jLabelSchema = new JLabel();
        this.jTextFieldSchema = new JTextField();
        this.jRadioButtonODBC = new JRadioButton();
        this.jRadioButtonJDBC = new JRadioButton();
        this.jComboBoxJDBCdriver = new JComboBox();
        this.jButtonDSN = new JButton();
        this.jLabelSbchartODBC = new JLabel();
        this.jTextFieldSbchartODBC = new JTextField();
        this.jCheckBoxSQLintSec = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Single Login Details", 0, 0, null, new Color(51, 102, 204)));
        this.jLabel1.setText("<html>If all users connect to the database using the same<br> credentials, you may enter them here:</html>");
        this.jLabel3.setText("Login Name:");
        this.jLabel4.setText("Password:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPasswordField).addComponent(this.jTextFieldLoginName)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextFieldLoginName, -2, -1, -2)).addGap(8, 8, 8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jPasswordField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Connection name:");
        this.jTextFieldName.setText("SBUGS2-0");
        this.jTextFieldName.setToolTipText("Enter a recognisable name for the data source.");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnection.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnection.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnection.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel5.setHorizontalAlignment(11);
        this.jLabel5.setText("Connection type:");
        this.jTextFieldDSN.setToolTipText("Enter a recognisable name for the data source.");
        this.jLabelDSN.setHorizontalAlignment(11);
        this.jLabelDSN.setText("Data source/file name:");
        this.jButtonFile.setText("File...");
        this.jButtonFile.setToolTipText("Select a .mdb file");
        this.jButtonFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnection.this.jButtonFileActionPerformed(evt);
            }
        });
        this.jLabelSchema.setHorizontalAlignment(11);
        this.jLabelSchema.setText("Schema/prefix:");
        this.buttonGroup1.add(this.jRadioButtonODBC);
        this.jRadioButtonODBC.setSelected(true);
        this.jRadioButtonODBC.setText("odbc");
        this.jRadioButtonODBC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnection.this.jRadioButtonODBCActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonJDBC);
        this.jRadioButtonJDBC.setText("jdbc:");
        this.jRadioButtonJDBC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnection.this.jRadioButtonJDBCActionPerformed(evt);
            }
        });
        this.jComboBoxJDBCdriver.setModel(new DefaultComboBoxModel<String>(new String[]{"oracle", "sqlserver", "mysql", " "}));
        this.jComboBoxJDBCdriver.setEnabled(false);
        this.jButtonDSN.setText("ODBC...");
        this.jButtonDSN.setToolTipText("Shortcut to your computer's ODBC Data Source Administrator");
        this.jButtonDSN.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnection.this.jButtonDSNActionPerformed(evt);
            }
        });
        this.jLabelSbchartODBC.setHorizontalAlignment(11);
        this.jLabelSbchartODBC.setText("Charts DSN:");
        this.jTextFieldSbchartODBC.setToolTipText("ODBC Data Source Name for chart application connection (if different from Data source)");
        this.jCheckBoxSQLintSec.setText("Use integrated Security (SQL Server only)");
        this.jCheckBoxSQLintSec.setHorizontalAlignment(11);
        this.jCheckBoxSQLintSec.setHorizontalTextPosition(4);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabelSchema, -2, 151, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSchema, -2, 190, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonODBC).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonJDBC).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxJDBCdriver, -2, 90, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldName, -2, 190, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabelDSN).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDSN, -2, 190, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonDSN).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFile)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabelSbchartODBC).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSbchartODBC, -2, 190, -2)))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jCheckBoxSQLintSec, -2, 257, -2))))).addContainerGap()));
        layout.linkSize(0, this.jButtonCancel, this.jButtonHelp, this.jButtonOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldName, -2, -1, -2)).addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jRadioButtonODBC).addComponent(this.jRadioButtonJDBC).addComponent(this.jComboBoxJDBCdriver, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelDSN).addComponent(this.jTextFieldDSN, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelSbchartODBC).addComponent(this.jTextFieldSbchartODBC, -2, -1, -2)).addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonFile).addComponent(this.jButtonDSN, -2, 23, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelSchema).addComponent(this.jTextFieldSchema, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSQLintSec).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonHelp).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        String name;
        if (this.parameters == null) {
            this.parameters = new ConnectionParameters();
        }
        if (this.parameters.name != null && this.parameters.name.length() > 0) {
            this.parameters.oldName = this.parameters.name;
        }
        if ((name = this.jTextFieldName.getText().trim()).contains("/") || name.contains(".")) {
            JOptionPane.showMessageDialog(this, "Connection name cannot contain the following characters:\n\\ .", this.getTitle(), 2);
            this.jTextFieldName.requestFocus();
            return;
        }
        this.parameters.name = this.jTextFieldName.getText().trim();
        if (this.parameters.name.length() == 0) {
            JOptionPane.showMessageDialog(this, "Connection name is blank", this.getTitle(), 2);
            this.jTextFieldName.requestFocusInWindow();
            return;
        }
        this.parameters.hostName = this.jTextFieldDSN.getText();
        if (this.parameters.hostName.length() == 0) {
            JOptionPane.showMessageDialog(this, "Server/Data Source name is blank", this.getTitle(), 2);
            this.jTextFieldDSN.requestFocusInWindow();
            return;
        }
        this.parameters.sbchartODBC = this.jTextFieldSbchartODBC.getText();
        this.parameters.instanceName = this.jTextFieldSchema.getText();
        if (this.jRadioButtonODBC.isSelected()) {
            this.parameters.driverName = "odbc";
        } else {
            this.parameters.driverName = this.jComboBoxJDBCdriver.getSelectedItem().toString();
            if (this.parameters.instanceName.length() == 0) {
                JOptionPane.showMessageDialog(this, "No database name specifed", this.getTitle(), 2);
                return;
            }
        }
        this.parameters.UID = this.jTextFieldLoginName.getText();
        char[] passwordChars = this.jPasswordField.getPassword();
        this.parameters.pwd = "";
        for (int i = 0; i < passwordChars.length; ++i) {
            this.parameters.pwd = this.parameters.pwd + passwordChars[i];
        }
        this.parameters.isSingle = !this.jTextFieldLoginName.getText().isEmpty() || this.jPasswordField.getPassword().length != 0;
        this.parameters.SQLServerIntegratedSecurity = this.jCheckBoxSQLintSec.isSelected();
        try {
            this.parameters.put(this.parameters.isSingle);
            Iterator<ConnectionParameters> it = this.sbConns.iterator();
            while (it.hasNext()) {
                ConnectionParameters p = it.next();
                if (!p.name.equalsIgnoreCase(this.parameters.name)) continue;
                it.remove();
                break;
            }
            this.sbConns.add(this.parameters);
            this.isOK = true;
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtologin.html");
    }

    private void jButtonFileActionPerformed(ActionEvent evt) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter("mdb", "Access Files (*.mdb)");
        if (this.jTextFieldDSN.getText().length() > 0) {
            file = new File(this.jTextFieldDSN.getText());
            if (file.exists()) {
                jFileChooser.setSelectedFile(file);
            } else {
                jFileChooser.setSelectedFile(new File(System.getProperty("user.dir")));
            }
        } else {
            jFileChooser.setSelectedFile(new File(System.getProperty("user.dir")));
        }
        jFileChooser.setFileFilter((FileFilter)filter);
        jFileChooser.showOpenDialog(this);
        if (jFileChooser.getSelectedFile() != null) {
            file = jFileChooser.getSelectedFile();
            this.jTextFieldDSN.setText(file.getPath());
        }
    }

    private void jButtonDSNActionPerformed(ActionEvent evt) {
        try {
            String[] cmd = new String[]{"cmd.exe", "/c", "odbcad32.exe"};
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Error trying to invoke runtime :", 0);
            JOptionPane.showMessageDialog(this, "Cannot run this from here. Use Windows control panel | Administrative Tools | Data Sources...");
            ex.printStackTrace();
        }
    }

    private void jRadioButtonODBCActionPerformed(ActionEvent evt) {
        this.jComboBoxJDBCdriver.setEnabled(false);
        this.jLabelDSN.setText("Data Source/file name:");
        this.jLabelSchema.setText("Schema/prefix:");
        this.jButtonFile.setEnabled(true);
        this.jButtonDSN.setEnabled(true);
        this.jTextFieldSbchartODBC.setEnabled(false);
        this.jLabelSbchartODBC.setEnabled(false);
        this.jCheckBoxSQLintSec.setEnabled(false);
    }

    private void jRadioButtonJDBCActionPerformed(ActionEvent evt) {
        this.jComboBoxJDBCdriver.setEnabled(true);
        this.jLabelDSN.setText("Server name or IP:");
        this.jLabelSchema.setText("Database.schema name:");
        this.jButtonFile.setEnabled(false);
        this.jButtonDSN.setEnabled(false);
        this.jTextFieldSbchartODBC.setEnabled(true);
        this.jLabelSbchartODBC.setEnabled(true);
        this.jCheckBoxSQLintSec.setEnabled(true);
    }
}

