/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import jsbugs.ConnectionParameters;
import jsbugs.DialogConnection;

public class DialogConnectionManager
extends JDialog {
    boolean hasChanged = false;
    List<ConnectionParameters> sbConns;
    DefaultListModel model = new DefaultListModel();
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JLabel jLabel1;
    private JList jListConnections;
    private JScrollPane jScrollPane1;

    public DialogConnectionManager(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.sbConns = ConnectionParameters.getConnections();
        this.init();
    }

    public DialogConnectionManager(JDialog parent, boolean modal) {
        super((Dialog)parent, modal);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Manage Connections");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.sbConns = ConnectionParameters.getConnections();
        Iterator<ConnectionParameters> it = this.sbConns.iterator();
        this.model.clear();
        while (it.hasNext()) {
            this.model.addElement(it.next());
        }
        this.jListConnections.repaint();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jListConnections = new JList();
        this.jLabel1 = new JLabel();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 200));
        this.jListConnections.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.jListConnections.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jListConnections);
        this.jLabel1.setText("Saved connections:");
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.setToolTipText("Add a new data source");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnectionManager.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.setToolTipText("Edit selected data source]");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnectionManager.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.setToolTipText("Delete selected data source");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnectionManager.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogConnectionManager.this.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 257, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonAdd, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonEdit, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonClose, -1, -1, Short.MAX_VALUE))).addComponent(this.jLabel1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonAdd).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 106, Short.MAX_VALUE).addComponent(this.jButtonClose)).addComponent(this.jScrollPane1, -1, 210, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        ConnectionParameters parms;
        if (this.jListConnections.getSelectedValues().length < 1) {
            this.getToolkit().beep();
        }
        if ((parms = (ConnectionParameters)this.jListConnections.getSelectedValue()) != null) {
            parms.clear();
        }
        this.hasChanged = true;
        this.init();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        ConnectionParameters parms;
        if (this.jListConnections.getSelectedValues().length < 1) {
            this.getToolkit().beep();
        }
        if ((parms = (ConnectionParameters)this.jListConnections.getSelectedValue()) != null) {
            DialogConnection dialog = new DialogConnection(this, true, this.sbConns, parms);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            if (dialog.isOK) {
                this.hasChanged = true;
            }
        }
        this.init();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        DialogConnection dialog = new DialogConnection(this, true, this.sbConns, null);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.isOK) {
            this.hasChanged = true;
        }
        this.init();
    }
}

