/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.MatteBorder;
import javax.swing.filechooser.FileFilter;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.CoreImage;
import model2.Lastval;
import model2.SBImage;
import model2.SBdb;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class DialogCoreImage
extends SBDialog {
    private final char units;
    private final SBdb db;
    private final Well well;
    private CoreImage original = null;
    private SBImage image;
    CoreImage added = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JButton jButtonSelectImage;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabelImage;
    private JLabel jLabelUnits1;
    private JLabel jLabelUnits2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JTextField jTextFieldBaseDepth;
    private JTextField jTextFieldTopDepth;

    public DialogCoreImage(JDialog parent, boolean modal, SBdb db, Well well, CoreImage coreImage, char units, double defaultTop) throws SQLException, SBException, IOException {
        super((Dialog)parent, modal);
        this.initComponents();
        this.well = well;
        this.db = db;
        this.original = coreImage;
        this.units = units;
        this.init(defaultTop);
    }

    private void init(double defaultTop) throws SQLException, SBException, IOException {
        if (this.original == null) {
            this.setTitle("Core Image : Add");
            if (defaultTop > 0.0) {
                this.jTextFieldTopDepth.setText("" + SB.floatString((double)SB.convFromM((double)defaultTop, (char)this.units), (int)2));
            }
        } else {
            this.setTitle("Core Image : Edit");
            this.jTextFieldTopDepth.setText("" + SB.floatString((double)SB.convFromM((double)this.original.getTopDepth(), (char)this.units), (int)2));
            this.jTextFieldBaseDepth.setText("" + SB.floatString((double)SB.convFromM((double)this.original.getBaseDepth(), (char)this.units), (int)2));
            this.image = this.original.getImage();
            this.setImage();
        }
        SB.setUnitLabel((JLabel)this.jLabelUnits1, (char)this.units);
        SB.setUnitLabel((JLabel)this.jLabelUnits2, (char)this.units);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jTextFieldTopDepth = new JTextField();
        this.jTextFieldBaseDepth = new JTextField();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonSelectImage = new JButton();
        this.jLabelUnits1 = new JLabel();
        this.jLabelUnits2 = new JLabel();
        this.jLabelImage = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(265, 500));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                DialogCoreImage.this.formComponentResized(evt);
            }
        });
        this.jLabel1.setHorizontalAlignment(11);
        this.jLabel1.setText("Top depth:");
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText("Base depth:");
        this.jTextFieldTopDepth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogCoreImage.this.jTextFieldTopDepthKeyTyped(evt);
            }
        });
        this.jTextFieldBaseDepth.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogCoreImage.this.jTextFieldBaseDepthKeyTyped(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreImage.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreImage.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonSelectImage.setText("Select...");
        this.jButtonSelectImage.setToolTipText("Select an image");
        this.jButtonSelectImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreImage.this.jButtonSelectImageActionPerformed(evt);
            }
        });
        this.jLabelUnits1.setText("ft");
        this.jLabelUnits2.setText("ft");
        this.jLabelImage.setBackground(new Color(255, 255, 255));
        this.jLabelImage.setText("Press select to select image...");
        this.jLabelImage.setBorder(new MatteBorder(null));
        this.jSeparator1.setOrientation(1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator3, -1, 239, Short.MAX_VALUE).add((Component)this.jLabelImage, -1, 239, Short.MAX_VALUE).add((Component)this.jSeparator2, -1, 239, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldTopDepth, -2, 68, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jTextFieldBaseDepth, -2, 68, -2))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jLabelUnits2, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelUnits1)).add(16, 16, 16).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonSelectImage)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK, -2, 73, -2).addPreferredGap(0).add((Component)this.jButtonCancel, -2, 65, -2))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jSeparator1, -1, 46, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldTopDepth).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jLabelUnits1))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelUnits2).add((Component)this.jTextFieldBaseDepth, -2, -1, -2).add((Component)this.jLabel2))).add((Component)this.jButtonSelectImage)).addPreferredGap(1).add((Component)this.jSeparator2, -1, 3, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabelImage, -2, 333, -2).addPreferredGap(0).add((Component)this.jSeparator3, -2, 5, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        float baseDepth;
        if (this.jTextFieldTopDepth.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a top depth", this.getTitle(), 2);
            return;
        }
        if (this.jTextFieldBaseDepth.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "Enter a base depth", this.getTitle(), 2);
            return;
        }
        if (this.image == null) {
            JOptionPane.showMessageDialog(this, "Select an image", this.getTitle(), 2);
            return;
        }
        float topDepth = SB.convToM((float)Float.parseFloat(this.jTextFieldTopDepth.getText().trim()), (char)this.units);
        if (topDepth > (baseDepth = SB.convToM((float)Float.parseFloat(this.jTextFieldBaseDepth.getText().trim()), (char)this.units))) {
            JOptionPane.showMessageDialog(this, "Top depth cannot be greater than base depth", this.getTitle(), 2);
            return;
        }
        if ((double)baseDepth > this.well.getTD()) {
            JOptionPane.showMessageDialog(this, "Base depth is below well TD (" + this.well.getTD() + ")", this.getTitle(), 2);
            return;
        }
        try {
            for (CoreImage ci : this.well.getCoreImages()) {
                if (ci == this.original) continue;
                try {
                    SB.checkOverlap((int)((int)(topDepth * 100.0f)), (int)((int)(baseDepth * 100.0f)), (int)((int)(ci.getTopDepth() * 100.0)), (int)((int)(ci.getBaseDepth() * 100.0)));
                }
                catch (SBException ex) {
                    JOptionPane.showMessageDialog(this, "Top/Base depths overlp existing core image(s)", this.getTitle(), 1);
                    return;
                }
            }
            if (this.original != null) {
                this.well.deleteCoreImage(this.original);
            }
            this.added = this.well.addCoreImage((double)topDepth, (double)baseDepth, this.image);
            this.db.commit();
            this.setOK();
        }
        catch (SQLException sql) {
            this.db.doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.db);
        }
        catch (SBException sbe) {
            this.db.doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (FileNotFoundException f) {
            this.db.doRollback();
            JOptionPane.showMessageDialog(this, "File Error:\n" + f.getMessage(), this.getTitle(), 0);
        }
        catch (IOException ioe) {
            this.db.doRollback();
            JOptionPane.showMessageDialog(this, "File Error:\n" + ioe.getMessage(), this.getTitle(), 0);
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jTextFieldTopDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldTopDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldBaseDepthKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldBaseDepth, (int)8, (KeyEvent)evt, (boolean)true)) {
            this.getToolkit().beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSelectImageActionPerformed(ActionEvent evt) {
        SbugsFileFilter filterAll = new SbugsFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.db, (String)"WINIMG", (String)"UNXIMG"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("jpg");
        jFileChooser.setFileFilter((FileFilter)filter);
        if (jFileChooser.showOpenDialog(this) == 0) {
            String fileName = jFileChooser.getSelectedFile().getPath();
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.image = new SBImage(this.db, new File(fileName), false, false);
                Lastval.putString((SBdb)this.db, (String)"WINIMG", (String)"UNXIMG", (String)fileName);
                this.db.commit();
                this.setImage();
            }
            catch (SQLException sql) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (SBException sbe) {
                this.db.doRollback();
                SB.showStackError((String)"Error", (Exception)((Object)sbe));
            }
            catch (FileNotFoundException f) {
                this.db.doRollback();
                JOptionPane.showMessageDialog(this, "File Error:\n" + f.getMessage(), this.getTitle(), 0);
            }
            catch (IOException ioe) {
                this.db.doRollback();
                JOptionPane.showMessageDialog(this, "File Error:\n" + ioe.getMessage(), this.getTitle(), 0);
            }
            catch (RuntimeException re) {
                SB.showStackError((String)"", (Exception)re);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.jLabelImage.getWidth() > this.getWidth()) {
            int width = this.getWidth() - 30;
            int height = this.getHeight() - 200;
            this.jLabelImage.setIcon(null);
            this.jLabelImage.setSize(width, height);
        }
        try {
            this.setImage();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), this.getTitle(), 2);
            e.printStackTrace();
        }
    }

    private void setImage() throws SQLException, SBException, IOException {
        if (this.image != null) {
            this.jLabelImage.setText(null);
            ImageIcon icon = this.image.getImage(this.jLabelImage.getBounds().width, this.jLabelImage.getBounds().height, false);
            this.jLabelImage.setIcon(icon);
        } else {
            this.jLabelImage.setIcon(null);
            this.jLabelImage.setText("Press Select... to add an image here");
            this.jLabelImage.setHorizontalAlignment(0);
            this.jLabelImage.setVerticalAlignment(0);
        }
    }
}

