/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogCoreImage;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelCoreImages;
import model2.CoreImage;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogCoreImages
extends JDialog
implements Observer {
    private final TableModelCoreImages model = new TableModelCoreImages();
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JScrollPane jScrollPane1;
    private JTable jTableCoreImages;

    public DialogCoreImages(Frame parent, boolean modal, Well well) throws SQLException, SBException {
        super(parent, modal);
        this.model.well = well;
        this.initComponents();
        this.init();
    }

    @Override
    public void update(Observable obs, Object obj) {
        try {
            if (obs == this.model.well.getCores()) {
                this.jTableCoreImages.updateUI();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in update method: " + e);
        }
    }

    public Well getWell() {
        return this.model.well;
    }

    private void init() throws SQLException, SBException {
        SB.setTableHeaderBold((JTable)this.jTableCoreImages);
        TableColumnModel columnModel = this.jTableCoreImages.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelCoreImages.titles[i]);
            columnModel.getColumn(i).setWidth(TableModelCoreImages.widths[i]);
        }
        this.jTableCoreImages.setRowHeight(this.model.IMAGE_ROW_HEIGHT);
        this.setTitle("Core Images: " + this.model.well.getWellName());
        this.model.images = this.model.well.getCoreImages();
        this.model.units = this.model.well.getWellUnits();
        this.jTableCoreImages.updateUI();
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    private void initComponents() {
        this.jButtonAdd = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCoreImages = new JTable();
        this.jButtonEdit = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 400));
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreImages.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreImages.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreImages.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTableCoreImages.setModel(this.model);
        this.jTableCoreImages.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogCoreImages.this.jTableCoreImagesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableCoreImages);
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreImages.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreImages.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 271, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonAdd).add((Component)this.jButtonDelete).add((Component)this.jButtonEdit)).add((Component)this.jButtonHelp).add((Component)this.jButtonClose, -2, 63, -2)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonAdd, this.jButtonDelete}, 1);
        layout.linkSize(new Component[]{this.jButtonClose, this.jButtonHelp}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.jScrollPane1, -1, 493, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).add(3, 3, 3).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(0, 361, Short.MAX_VALUE).add((Component)this.jButtonHelp).add(8, 8, 8).add((Component)this.jButtonClose))).add(14, 14, 14)));
        this.pack();
    }

    private void jTableCoreImagesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            double defaultTop = this.model.images.isEmpty() ? 0.0 : this.model.images.get(this.model.images.size() - 1).getBaseDepth();
            DialogCoreImage dialog = new DialogCoreImage(this, true, this.model.well.getDataModel(), this.model.well, null, this.model.units, defaultTop);
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width - this.getX() - this.getWidth() > dialog.getWidth()) {
                dialog.setLocation(this.getX() + this.getWidth(), this.getY());
            } else {
                dialog.setLocationRelativeTo(this);
            }
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.model.fireTableDataChanged();
                int index = this.model.images.indexOf(dialog.added);
                this.jTableCoreImages.getSelectionModel().setSelectionInterval(index, index);
                this.jTableCoreImages.scrollRectToVisible(this.jTableCoreImages.getCellRect(index, 0, false));
            }
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error opening dialog", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.model.well.getDataModel());
        }
        catch (IOException e) {
            SB.showStackError((String)"Error opening dialog", (Exception)e);
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableCoreImages.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No rows selected", this.getTitle(), 1);
            return;
        }
        try {
            LinkedList<CoreImage> toDelete = new LinkedList<CoreImage>();
            for (int row : this.jTableCoreImages.getSelectedRows()) {
                CoreImage coreImage = this.model.images.get(row);
                int option = JOptionPane.showConfirmDialog(this, "Really delete: " + SB.convFromM((double)coreImage.getTopDepth(), (char)this.model.units) + "/" + SB.convFromM((double)coreImage.getBaseDepth(), (char)this.model.units) + "?", this.getTitle(), 0, 3);
                if (option != 0) continue;
                toDelete.add(coreImage);
            }
            for (CoreImage coreImage : toDelete) {
                this.model.well.deleteCoreImage(coreImage);
                this.model.well.getDataModel().commit();
            }
            this.jTableCoreImages.clearSelection();
            this.model.fireTableDataChanged();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error deleting core: " + e, this.getTitle(), 0);
            this.model.well.getDataModel().doRollback();
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        int row = this.jTableCoreImages.getSelectedRow();
        if (row < 0) {
            JOptionPane.showMessageDialog(this, "No images selected", this.getTitle(), 1);
            return;
        }
        CoreImage core = this.model.images.get(row);
        try {
            DialogCoreImage dialog = new DialogCoreImage(this, true, this.model.well.getDataModel(), this.model.well, core, this.model.units, 0.0);
            dialog.setLocation(this.getLocation().x + 25, this.getLocation().y + 25);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                this.jTableCoreImages.updateUI();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error constructing dialog", this.getTitle(), 0);
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogcoreimages.html");
    }
}

