/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelCoreShift;
import model2.CoredInterval;
import model2.Cores;
import model2.Coreshift;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.ColouredRenderer;
import util.SB;
import util.SBException;
import util.SbugsTable;
import util.TableSorter;

public class DialogCoreShifts
extends JDialog {
    Well well;
    TableModelCoreShift model = new TableModelCoreShift();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    private JButton jButtonAdd;
    private JButton jButtonCancel;
    private JButton jButtonGenerate;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JButton jButtonRead;
    private JButton jButtonRemove;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableShift;

    public DialogCoreShifts(JDialog parent, boolean modal, Well well, char units) throws SQLException {
        super((Dialog)parent, modal);
        this.well = well;
        this.initComponents();
        this.init(units);
    }

    private void init(char units) throws SQLException {
        this.setTitle("Core Shifts: " + this.well.getWellName());
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.model.load(this.well, units);
        SB.setTableHeaderBold((JTable)this.jTableShift);
        TableColumnModel columnModel = this.jTableShift.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelCoreShift.titles[i]);
            columnModel.getColumn(i).setWidth(TableModelCoreShift.widths[i]);
        }
        columnModel.getColumn(0).setCellRenderer((TableCellRenderer)new ColouredRenderer(false, new Color(220, 220, 220), 2));
        this.sorter.reallocateIndexes();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableShift = new SbugsTable(this.sorter);
        this.jButtonRead = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jButtonGenerate = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(300, 300));
        this.jTableShift.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableShift);
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreShifts.this.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreShifts.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreShifts.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreShifts.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreShifts.this.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreShifts.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonGenerate.setText("Generate");
        this.jButtonGenerate.setToolTipText("Create depth values from cored intervals");
        this.jButtonGenerate.setMargin(new Insets(2, 8, 2, 8));
        this.jButtonGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCoreShifts.this.jButtonGenerateActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 199, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.jButtonAdd, -1, 71, Short.MAX_VALUE).add((Component)this.jButtonOK, -1, 71, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, 71, Short.MAX_VALUE).add((Component)this.jButtonGenerate, -1, 71, Short.MAX_VALUE).add((Component)this.jButtonRemove, -1, -1, Short.MAX_VALUE).add((Component)this.jSeparator1, -1, 71, Short.MAX_VALUE).add((Component)this.jButtonRead, -1, 71, Short.MAX_VALUE).add((Component)this.jButtonCancel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 248, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonRemove).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.jButtonGenerate).addPreferredGap(0).add((Component)this.jButtonRead).addPreferredGap(0, 41, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (Coreshift.hasDuplicateDepths((Coreshift)this.model.coreshift)) {
            JOptionPane.showMessageDialog(this, "Cannot save because there are duplicate depths.\nEnsure that all depths are unique", this.getTitle(), 1);
            return;
        }
        try {
            if (this.jTableShift.isEditing()) {
                this.jTableShift.getCellEditor().stopCellEditing();
            }
            this.well.getCoreShift().update(this.well.getWellID(), this.model.coreshift);
            this.well.getDataModel().commit();
            this.dispose();
        }
        catch (SQLException sql) {
            this.well.getDataModel().doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.well.getDataModel());
        }
    }

    private void jButtonReadActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Not implemeted - send StrataData an example core shift file you would like to read", this.getTitle(), 1);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        int row = this.jTableShift.getSelectedRow();
        if (row >= 0) {
            Coreshift.CoreShiftDepth d = this.model.coreshift.get(row);
            this.model.coreshift.insertAfter(d);
        } else {
            row = this.model.coreshift.getSize();
            this.model.coreshift.insertAfter(null);
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
        this.jTableShift.setRowSelectionInterval(row, row);
        this.jScrollPane1.scrollRectToVisible(this.jTableShift.getCellRect(row, 0, true));
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        if (this.jTableShift.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this, "Select row(s) to remove", this.getTitle(), 2);
            return;
        }
        int[] selection = this.jTableShift.getSelectedRows();
        LinkedList<Coreshift.CoreShiftDepth> toRemove = new LinkedList<Coreshift.CoreShiftDepth>();
        for (int i : selection) {
            toRemove.add(this.model.coreshift.get(i));
        }
        for (Coreshift.CoreShiftDepth d : toRemove) {
            this.model.coreshift.remove(d);
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogcoreshifts.html");
    }

    private void jButtonGenerateActionPerformed(ActionEvent evt) {
        try {
            Cores cores = this.well.getCores();
            for (CoredInterval ci : cores.getList()) {
                this.model.coreshift.add(this.well.getWellID(), ci.getTopDepth(), 0.0f);
                this.model.coreshift.add(this.well.getWellID(), ci.getBaseDepth(), 0.0f);
            }
        }
        catch (SQLException sql) {
            SB.showStackError((String)"SQL Error", (SQLException)sql);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }
}

