/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import jsbugs.DialogCoreImages;
import jsbugs.DialogCoreShifts;
import jsbugs.DialogCoredInterval;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelCores;
import model2.CoredInterval;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;

public class DialogCores
extends JDialog
implements Observer {
    private final TableModelCores model = new TableModelCores();
    private final Well well;
    private ButtonGroup buttonGroupDepthUnits;
    private JButton jButtonAdd;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonImages;
    private JButton jButtonShifts;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable jTableCores;

    public DialogCores(Frame parent, boolean modal, Well well) throws SQLException, SBException {
        super(parent, modal);
        this.well = well;
        this.initComponents();
        this.init();
    }

    @Override
    public void update(Observable obs, Object obj) {
        try {
            if (obs == this.well.getCores()) {
                this.model.fireTableDataChanged();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in update method: " + e);
        }
    }

    public Well getWell() {
        return this.well;
    }

    private void init() throws SQLException, SBException {
        SB.setTableHeaderBold((JTable)this.jTableCores);
        TableColumnModel columnModel = this.jTableCores.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelCores.titles[i]);
            columnModel.getColumn(i).setWidth(TableModelCores.widths[i]);
        }
        this.setTitle("Cores: " + this.well.getWellName());
        this.jTableCores.repaint();
        this.model.setWell(this.well);
        this.buttonGroupDepthUnits.setSelected(this.model.units == 'F' ? this.jRadioButtonFeet.getModel() : this.jRadioButtonMetres.getModel(), true);
        this.model.cores.addObserver((Observer)this);
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    private void initComponents() {
        this.buttonGroupDepthUnits = new ButtonGroup();
        this.jButtonAdd = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableCores = new JTable();
        this.jButtonImages = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jButtonShifts = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(550, 280));
        this.jButtonAdd.setText("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCores.this.jButtonAddActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCores.this.jButtonEditActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCores.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCores.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTableCores.setModel(this.model);
        this.jTableCores.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DialogCores.this.jTableCoresMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableCores);
        this.jButtonImages.setText("Images...");
        this.jButtonImages.setMargin(new Insets(2, 12, 2, 12));
        this.jButtonImages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCores.this.jButtonImagesActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCores.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonShifts.setText("Shifts...");
        this.jButtonShifts.setToolTipText("Show core shifts/corrections");
        this.jButtonShifts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCores.this.jButtonShiftsActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Depth units", 0, 0, new Font("Tahoma", 0, 11), new Color(51, 102, 204)));
        this.buttonGroupDepthUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCores.this.jRadioButtonMetresActionPerformed(evt);
            }
        });
        this.buttonGroupDepthUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        this.jRadioButtonFeet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCores.this.jRadioButtonFeetActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonMetres).addPreferredGap(0).add((Component)this.jRadioButtonFeet).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButtonMetres, -2, 16, -2).add((Component)this.jRadioButtonFeet, -2, 16, -2)).add(0, 8, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(14, 14, 14).add((Component)this.jScrollPane1, -1, 416, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (Component)this.jButtonAdd, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonEdit, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonDelete, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jSeparator1).add(2, (Component)this.jButtonClose, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonShifts, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonImages, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonHelp, -1, -1, Short.MAX_VALUE))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).add(16, 16, 16).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonAdd).addPreferredGap(0).add((Component)this.jButtonEdit).addPreferredGap(0).add((Component)this.jButtonDelete).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).add(7, 7, 7).add((Component)this.jButtonImages).addPreferredGap(0).add((Component)this.jButtonShifts).add(43, 43, 43).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jTableCoresMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.jButtonEditActionPerformed(null);
        }
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        int row = this.jTableCores.getSelectedRow();
        if (row < 0) {
            JOptionPane.showMessageDialog(this, "No cores selected", this.getTitle(), 1);
            return;
        }
        CoredInterval core = this.model.cores.getCore(row);
        try {
            DialogCoredInterval dialog = new DialogCoredInterval(this, true, this.well, core, this.model.units);
            dialog.setLocation(this.getLocation().x + 20, this.getLocation().y + 20);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error constructing cores dialog", this.getTitle(), 0);
            e.printStackTrace();
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        try {
            DialogCoredInterval dialog = new DialogCoredInterval(this, true, this.well, null, this.model.units);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error opening cores dialog", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error opening cores dialog", sql, this.well.getDataModel());
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableCores.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No cores selected", this.getTitle(), 1);
            return;
        }
        try {
            LinkedList<CoredInterval> toDelete = new LinkedList<CoredInterval>();
            for (int row : this.jTableCores.getSelectedRows()) {
                CoredInterval core = this.model.cores.getCore(row);
                toDelete.add(core);
            }
            if (toDelete.size() > 0) {
                String msg = "Really delete " + (toDelete.size() == 1 ? "this cored interval?" : "these " + toDelete.size() + " cored intervals?");
                int option = JOptionPane.showConfirmDialog(this, msg, this.getTitle(), 0, 3);
                if (option != 0) {
                    return;
                }
                for (CoredInterval core : toDelete) {
                    this.model.cores.delete(this.well.getDataModel(), this.well.getWellID(), core);
                    this.well.getDataModel().commit();
                }
                this.jTableCores.clearSelection();
                this.model.cores.notifyObservers();
                this.well.setDataChanged();
                this.well.notifyObservers(toDelete.get(0));
            }
        }
        catch (SQLException sql) {
            this.well.getDataModel().doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.well.getDataModel());
        }
        catch (SBException sbe) {
            this.well.getDataModel().doRollback();
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (RuntimeException re) {
            SB.showStackError((String)"", (Exception)re);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonImagesActionPerformed(ActionEvent evt) {
        try {
            DialogCoreImages dialog = new DialogCoreImages((Frame)this.getParent(), false, this.well);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (SBException sbe) {
            SB.showStackError((String)"Error", (Exception)((Object)sbe));
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.well.getDataModel());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogcores.html");
    }

    private void jButtonShiftsActionPerformed(ActionEvent evt) {
        try {
            DialogCoreShifts dialog = new DialogCoreShifts(this, true, this.well, this.model.units);
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().width - this.getX() - this.getWidth() > dialog.getWidth()) {
                dialog.setLocation(this.getX() + this.getWidth(), this.getY());
            } else {
                dialog.setLocationRelativeTo(this);
            }
            dialog.setVisible(true);
            this.model.fireTableDataChanged();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.well.getDataModel());
        }
    }

    private void jRadioButtonMetresActionPerformed(ActionEvent evt) {
        this.setModelUnits('M');
    }

    private void jRadioButtonFeetActionPerformed(ActionEvent evt) {
        this.setModelUnits('F');
    }

    private void setModelUnits(char c) {
        if (this.model.units != c) {
            this.model.units = c;
            this.model.fireTableDataChanged();
        }
    }
}

