/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import jsbugs.FrameJsbugs;
import model2.Lastval;
import model2.Project;
import model2.SBChart;
import model2.SBdb;
import model2.Well;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;

public class DialogCreateDatabase
extends JDialog {
    SBdb db;
    Connection newDB = null;
    Project project;
    SwingWorker task = null;
    PrintWriter log = null;
    private JButton jButtonClose;
    private JButton jButtonFile;
    private JButton jButtonHelp;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldDataFile;
    private JTextField jTextFieldProject;
    private JTextPane jTextPaneProgress;

    public DialogCreateDatabase(Frame parent, boolean modal, SBdb db, Project project) {
        super(parent, modal);
        this.db = db;
        this.project = project;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Create Database");
        this.jTextFieldProject.setText(this.project.getName());
        this.jTextFieldDataFile.setText(null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldProject = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldDataFile = new JTextField();
        this.jButtonFile = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPaneProgress = new JTextPane();
        this.jButtonClose = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 300));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DialogCreateDatabase.this.formWindowClosing(evt);
            }
        });
        this.jLabel1.setText("Create a new database from project: ");
        this.jTextFieldProject.setBackground(new Color(255, 255, 204));
        this.jTextFieldProject.setEditable(false);
        this.jLabel2.setText("Database file:");
        this.jTextFieldDataFile.setEditable(false);
        this.jButtonFile.setText("File...");
        this.jButtonFile.setToolTipText("Select an empty StrataBugs database");
        this.jButtonFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCreateDatabase.this.jButtonFileActionPerformed(evt);
            }
        });
        this.jTextPaneProgress.setEditable(false);
        this.jScrollPane1.setViewportView(this.jTextPaneProgress);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCreateDatabase.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCreateDatabase.this.jButtonHelpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 381, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldProject, -1, 195, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldDataFile, -1, 239, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonFile)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonHelp);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldProject, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldDataFile, -2, -1, -2).addComponent(this.jButtonFile)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 179, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClose).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        try {
            if (this.newDB != null) {
                this.newDB.close();
                this.newDB = null;
            }
            this.dispose();
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    private void jButtonFileActionPerformed(ActionEvent evt) {
        JFileChooser jFileChooser = new JFileChooser();
        SbugsFileFilter filter = new SbugsFileFilter("mdb", "Access Files (*.mdb)");
        if (this.jTextFieldDataFile.getText().length() > 0) {
            jFileChooser.setSelectedFile(new File(this.jTextFieldDataFile.getText()));
        } else {
            try {
                jFileChooser.setSelectedFile(new File(Lastval.getString((SBdb)this.db, (String)"CREATEDB")));
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
        jFileChooser.setFileFilter((FileFilter)filter);
        jFileChooser.setDialogTitle("Select database file");
        try {
            if (jFileChooser.showOpenDialog(this) == 0 && jFileChooser.getSelectedFile() != null) {
                if (this.newDB != null) {
                    this.newDB.close();
                    this.newDB = null;
                }
                File file = jFileChooser.getSelectedFile();
                Lastval.putString((SBdb)this.db, (String)"CREATEDB", (String)file.getPath());
                this.db.commit();
                if (file.getName().equals("sbugs2-0.mdb")) {
                    String projName = this.project.getName();
                    projName = Well.makeCode((String)projName);
                    File newFile = new File(file.getParentFile().getPath() + File.separator + file.getName().substring(0, file.getName().length() - 4) + "_" + projName + ".mdb");
                    boolean toCopy = true;
                    if (newFile.exists()) {
                        int opt = JOptionPane.showConfirmDialog(this, "File: " + newFile.getAbsolutePath() + " exists.\nDelete and recreate?", this.getTitle(), 0, 3);
                        if (opt == 0) {
                            newFile.delete();
                        } else {
                            toCopy = false;
                        }
                    }
                    if (toCopy) {
                        this.copy(file, newFile);
                    }
                    file = newFile;
                }
                this.jTextFieldDataFile.setText(file.getPath());
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                String DSN = "Driver={Microsoft Access Driver (*.mdb)};DBQ=" + file.getPath();
                String loginName = "";
                String password = "";
                System.out.println("Connecting with: " + DSN + "," + loginName + "," + password.toUpperCase());
                this.newDB = DriverManager.getConnection("jdbc:odbc:" + DSN + ";UID=" + loginName + ";PWD=" + password.toUpperCase());
                this.jTextPaneProgress.setText("Connected");
                if (!this.checkExistingData()) {
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.task = new SwingWorker(){
                    boolean state = false;

                    public Object doInBackground() {
                        this.state = DialogCreateDatabase.this.processWells();
                        return "ok";
                    }

                    @Override
                    protected void done() {
                        if (this.state) {
                            DialogCreateDatabase.this.outputProgress(false, "\r\n...done");
                            DialogCreateDatabase.this.outputProgress(false, "\r\n\r\nTest new database by changing database from control panel File menu.");
                            DialogCreateDatabase.this.outputProgress(false, "\r\nNote: All passwords have been reset to the word 'SYSTEM' in the new database.");
                            DialogCreateDatabase.this.jButtonClose.setText("Finish");
                        } else {
                            DialogCreateDatabase.this.outputProgress(false, "\r\n...did not finish due to error");
                        }
                        DialogCreateDatabase.this.setCursor(Cursor.getDefaultCursor());
                        DialogCreateDatabase.this.jTextPaneProgress.setCursor(Cursor.getDefaultCursor());
                    }
                };
                this.task.execute();
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (Exception ex) {
            SB.showStackError((String)ex.getMessage(), (Exception)ex);
            ex.printStackTrace();
        }
    }

    boolean processWells() {
        try {
            int wellID;
            Well well;
            String sql;
            ResultSet rs;
            boolean hasSplitIDtable = false;
            DatabaseMetaData meta = this.db.getDatabase().getMetaData();
            String schema = this.db.getSchema();
            try {
                rs = meta.getTables(null, schema, "SPLITID", null);
            }
            catch (SQLException sqle) {
                rs = meta.getColumns(null, null, "SPLITID", "%");
            }
            if (rs.next()) {
                hasSplitIDtable = true;
            }
            rs.close();
            Statement stmt = this.db.getDatabase().createStatement();
            if (hasSplitIDtable) {
                sql = "DELETE FROM " + this.db.DBTableName("SPLITID") + " WHERE usrid=" + this.db.getUserID();
                try {
                    stmt.executeUpdate(this.db.modQuery(sql));
                    this.db.getDatabase().commit();
                }
                catch (SQLException se) {
                    this.printLog("Message from delete from table SPLITID: " + se.getMessage());
                }
            } else {
                sql = "CREATE TABLE " + this.db.DBTableName("SPLITID") + " (usrid int not null, label " + this.db.getDBCharType() + "(30) not null, id int not null, constraint splitid_pk primary key (usrid,label,id))";
                stmt.executeUpdate(this.db.modQuery(sql));
            }
            this.copyTable("USERDEF", null, false);
            this.copyTable("ABNSCHME", " WHERE scheme_id IN (SELECT abnsch_id FROM " + this.db.DBTableName("SBWLMB") + " s, " + this.db.DBTableName("ANALY_HDR") + " w where s.id=" + this.project.getID() + " AND s.well_id=w.well_id)", false);
            this.copyTable("ABNSCHMBR", " WHERE scheme_id IN (SELECT abnsch_id FROM " + this.db.DBTableName("SBWLMB") + " s, " + this.db.DBTableName("ANALY_HDR") + " w where s.id=" + this.project.getID() + " AND s.well_id=w.well_id)", false);
            this.copyTable("ENV_SCH", " WHERE envsch_id IN (SELECT envsch_id FROM " + this.db.DBTableName("SBWLMB") + " s, " + this.db.DBTableName("ANALY_HDR") + " w where s.id=" + this.project.getID() + " AND s.well_id=w.well_id)", false);
            this.copyTable("ENVSCHMBR", " WHERE envsch_id IN (SELECT envsch_id FROM " + this.db.DBTableName("SBWLMB") + " s, " + this.db.DBTableName("ANALY_HDR") + " w where s.id=" + this.project.getID() + " AND s.well_id=w.well_id)", false);
            this.copyTable("SPECIESTYPE", null, true);
            this.copyTable("CATEGORY", null, true);
            this.copyTable("LOGDEF", null, true);
            this.copyTable("CATCOL", null, true);
            this.copyTable("LICENCE", null, true);
            Iterator it = this.project.getWellIterator();
            int total = this.project.getSize();
            int n = 0;
            while (it.hasNext()) {
                well = (Well)it.next();
                wellID = well.getWellID();
                this.outputProgress(false, "\r\nProcessing (" + ++n + "/" + total + ") well: " + well.getWellName());
                this.copyTable("ENV_SCH", " WHERE envsch_id IN (SELECT envsch_id FROM " + this.db.DBTableName("IGD_ENV") + " i WHERE i.well_id=" + wellID + ")", false);
                this.copyTable("ENVSCHMBR", " WHERE envsch_id IN (SELECT envsch_id FROM " + this.db.DBTableName("IGD_ENV") + " i WHERE i.well_id=" + wellID + ")", false);
                this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("IGD") + " i WHERE i.well_id=" + wellID + ")", false);
                this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("BCMMNTS") + " i WHERE i.well_id=" + wellID + ")", false);
                this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("IGD_ENV") + " i WHERE i.well_id=" + wellID + ")", false);
                this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("SQPICK") + " i WHERE i.well_id=" + wellID + ")", false);
                this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("INTCMMNTS") + " i WHERE i.well_id=" + wellID + ")", false);
                this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("EVENTS") + " i WHERE i.well_id=" + wellID + ")", false);
                this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("LOC") + " i WHERE i.well_id=" + wellID + ")", false);
                this.copyTable("INTERP", " WHERE interp_id IN (SELECT interp_id FROM " + this.db.DBTableName("FAULTS") + " i WHERE i.well_id=" + wellID + ")", false);
                this.copyTable("WELLS", " WHERE well_code='" + well.getWellCode() + "'", false);
                this.copyTable("WELL_IDENT", " WHERE well_id=" + wellID, false);
                this.copyTable("CASING", " WHERE well_id=" + wellID, false);
                this.copyTable("CORES", " WHERE well_id=" + wellID, false);
                this.copyTable("CORESHIFT", " WHERE well_id=" + wellID, false);
                this.copyTable("IGD_SCH", " WHERE sch_id IN (SELECT sch_id FROM " + this.db.DBTableName("IGD") + " WHERE well_id=" + wellID + ")", false);
                this.copyTable("IGD_DICT", " WHERE sch_id IN (SELECT sch_id FROM " + this.db.DBTableName("IGD") + " WHERE well_id=" + wellID + ")", false);
                this.copyTable("IGD_SCH", " WHERE sch_id IN (SELECT sch_id FROM " + this.db.DBTableName("SURFACE") + " s," + this.db.DBTableName("SQPICK") + " p WHERE p.surface_id=s.surface_id AND p.well_id=" + wellID + ")", false);
                this.copyTable("IGD_DICT", " WHERE sch_id IN (SELECT sch_id FROM " + this.db.DBTableName("SURFACE") + " s," + this.db.DBTableName("SQPICK") + " p WHERE p.surface_id=s.surface_id AND p.well_id=" + wellID + ")", false);
                this.copyTable("SURFACE", " WHERE sch_id IN (SELECT sch_id FROM " + this.db.DBTableName("SURFACE") + " s," + this.db.DBTableName("SQPICK") + " p WHERE p.surface_id=s.surface_id AND p.well_id=" + wellID + ")", false);
                this.copyTable("INTCMMNTS", " WHERE well_id=" + wellID, false);
                this.copyTable("SBGS", " WHERE well_id=" + wellID, false);
                this.copyTable("SBILITH", " WHERE well_id=" + wellID, false);
                this.copyTable("SBQLITH", " WHERE well_id=" + wellID, false);
                this.copyTable("TVDHDR", " WHERE well_id=" + wellID, false);
                this.outputProgress(false, "\r\nLogs...");
                this.copyTable("LOG_CURVE", " WHERE well_id=" + wellID, false);
                this.copyTable("LOG_TRACE", " WHERE curve_id IN (SELECT curve_id FROM " + this.db.DBTableName("LOG_CURVE") + " WHERE well_id=" + wellID + ")", false);
                this.copyTable("WELLSMARK", " WHERE well_id=" + wellID, false);
                this.copyTable("WELLTVD", " WHERE well_id=" + wellID, false);
                this.copyTable("WELLTWT", " WHERE well_id=" + wellID, false);
                this.outputProgress(false, "\r\nSamples...");
                this.copyTable("SAMPLES", " WHERE well_id=" + wellID, false);
                this.copyTable("SBSLITH", " WHERE well_id=" + wellID, false);
                this.copyTable("SBSSR", " WHERE well_id=" + wellID, false);
                this.createSplitIDs(stmt, "SPEC_ID", "TAXONOCC", wellID);
                this.createSplitIDs(stmt, "EV_ID", "EVENTS", wellID);
                this.db.getDatabase().commit();
                Runtime.getRuntime().gc();
            }
            this.outputProgress(false, "\r\nProcessing genera...");
            this.copyTable("GENUS", " WHERE gen_id IN (SELECT g.gen_id FROM " + this.db.DBTableName("genus") + " g, " + this.db.DBTableName("species") + " s, " + this.db.DBTableName("splitid") + " x WHERE  usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=s.spec_id AND s.gen_id=g.gen_id)", false);
            this.outputProgress(false, "\r\nProcessing species...");
            this.copyTable("SPECIES", " WHERE spec_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='SPEC_ID')", false);
            this.copyTable("SYNSCH", null, true);
            this.outputProgress(false, "\r\nProcessing genera of synonyms...");
            this.copyTable("GENUS", " WHERE gen_id IN (SELECT s.gen_id FROM " + this.db.DBTableName("species") + " s, " + this.db.DBTableName("synonymy") + " sy, " + this.db.DBTableName("splitid") + " x WHERE  x.usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=sy.spec_id AND sy.pref=s.spec_id)", false);
            this.copyTable("GENUS", " WHERE gen_id IN (SELECT s.gen_id FROM " + this.db.DBTableName("species") + " s, " + this.db.DBTableName("synonymy") + " sy, " + this.db.DBTableName("splitid") + " x WHERE  x.usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=sy.pref AND sy.spec_id=s.spec_id)", false);
            this.outputProgress(false, "\r\nProcessing species of synonyms...");
            this.copyTable("SPECIES", " WHERE spec_id IN (SELECT pref FROM " + this.db.DBTableName("synonymy") + " s, " + this.db.DBTableName("splitid") + " x WHERE x.usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=s.spec_id)", false);
            this.copyTable("SPECIES", " WHERE spec_id IN (SELECT spec_id FROM " + this.db.DBTableName("synonymy") + " s, " + this.db.DBTableName("splitid") + " x WHERE x.usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=s.pref)", false);
            this.copyTable("SYNONYMY", " WHERE spec_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='SPEC_ID')", true);
            this.copyTable("SYNONYMY", " WHERE pref IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='SPEC_ID')", false);
            this.copyTable("GENUS", " WHERE gen_id IN (SELECT s.gen_id FROM " + this.db.DBTableName("species") + " s, " + this.db.DBTableName("eventdic") + " e," + this.db.DBTableName("cmpstdev") + " c WHERE e.spec_id=s.spec_id AND e.ev_id=c.ev_id AND c.std_id IN  (SELECT std_id FROM " + this.db.DBTableName("loc") + " WHERE well_id IN (select well_id from " + this.db.DBTableName("SBWLMB") + " WHERE ID=" + this.project.getID() + ")))", false);
            this.copyTable("SPECIES", " WHERE spec_id IN (SELECT spec_id FROM " + this.db.DBTableName("eventdic") + " e," + this.db.DBTableName("cmpstdev") + " c WHERE c.ev_id=e.ev_id AND c.std_id IN  (SELECT std_id FROM " + this.db.DBTableName("loc") + " WHERE well_id IN (select well_id from " + this.db.DBTableName("SBWLMB") + " WHERE ID=" + this.project.getID() + ")))", false);
            this.outputProgress(false, "\r\nProcessing events...");
            this.copyTable("GENUS", " WHERE gen_id IN (SELECT s.gen_id FROM " + this.db.DBTableName("species") + " s, " + this.db.DBTableName("eventdic") + " d, " + this.db.DBTableName("splitid") + " x WHERE x.usrid=" + this.db.getUserID() + " AND x.label='EV_ID' AND x.id=d.ev_id AND d.spec_id=s.spec_id)", false);
            this.copyTable("SPECIES", " WHERE spec_id IN (SELECT spec_id FROM " + this.db.DBTableName("eventdic") + " d, " + this.db.DBTableName("splitid") + " x WHERE x.usrid=" + this.db.getUserID() + " AND x.label='EV_ID' AND x.id=d.ev_id)", false);
            this.copyTable("EVENTDIC", " WHERE ev_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='EV_ID')", false);
            this.copyTable("EVENTDIC", " WHERE spec_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='SPEC_ID')", false);
            this.copyTable("EVENTDIC", " WHERE spec_id IN (SELECT pref FROM " + this.db.DBTableName("synonymy") + " s, " + this.db.DBTableName("splitid") + " x WHERE x.usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=s.spec_id)", false);
            this.copyTable("EVENTDIC", " WHERE spec_id IN (SELECT spec_id FROM " + this.db.DBTableName("synonymy") + " s, " + this.db.DBTableName("splitid") + " x WHERE x.usrid=" + this.db.getUserID() + " AND x.label='SPEC_ID' AND x.id=s.pref)", false);
            this.outputProgress(false, "\r\nProcessing composite standards...");
            this.copyTable("CMPSTD", " WHERE std_id IN (SELECT std_id FROM " + this.db.DBTableName("loc") + " WHERE well_id IN (select well_id from " + this.db.DBTableName("SBWLMB") + " WHERE ID=" + this.project.getID() + "))", false);
            this.copyTable("EVENTDIC", " WHERE ev_id IN (SELECT ev_id FROM " + this.db.DBTableName("cmpstdev") + " WHERE std_id IN (SELECT std_id FROM " + this.db.DBTableName("loc") + " WHERE well_id IN (select well_id from " + this.db.DBTableName("SBWLMB") + " WHERE ID=" + this.project.getID() + ")))", false);
            this.copyTable("CMPSTDEV", " WHERE std_id IN (SELECT std_id FROM " + this.db.DBTableName("loc") + " WHERE well_id IN (select well_id from " + this.db.DBTableName("SBWLMB") + " WHERE ID=" + this.project.getID() + "))", true);
            this.outputProgress(false, "\r\nProcessing images...");
            this.copyTable("SBIMAGE", " WHERE image_id IN (SELECT image_id FROM " + this.db.DBTableName("coreimage") + " WHERE well_id IN (select well_id from " + this.db.DBTableName("SBWLMB") + " WHERE ID=" + this.project.getID() + "))", true);
            this.copyTable("IMAGE_SET", " WHERE image_set_id IN (SELECT image_set_id FROM " + this.db.DBTableName("taxonocc") + " WHERE well_id IN (select well_id from " + this.db.DBTableName("SBWLMB") + " WHERE ID=" + this.project.getID() + "))", true);
            this.copyTable("SBIMAGE", " WHERE image_id IN (SELECT image_id FROM " + this.db.DBTableName("image_setmbr") + " WHERE image_set_id IN (SELECT image_set_id FROM " + this.db.DBTableName("taxonocc") + " WHERE well_id IN (SELECT well_id FROM " + this.db.DBTableName("SBWLMB") + " WHERE ID=" + this.project.getID() + ")))", true);
            this.copyTable("IMAGE_SETMBR", " WHERE image_set_id IN (SELECT image_set_id FROM " + this.db.DBTableName("taxonocc") + " WHERE well_id IN (select well_id from " + this.db.DBTableName("SBWLMB") + " WHERE ID=" + this.project.getID() + "))", true);
            this.outputProgress(false, "\r\nProcessing charts...");
            this.processCharts();
            it = this.project.getWellIterator();
            n = 0;
            while (it.hasNext()) {
                well = (Well)it.next();
                wellID = well.getWellID();
                this.outputProgress(false, "\r\nSecond round wells... Processing (" + ++n + "/" + total + ") well: " + well.getWellName());
                this.copyTable("BCMMNTS", " WHERE well_id=" + wellID, false);
                this.copyTable("EVENTS", " WHERE well_id=" + wellID, false);
                this.copyTable("FAULTS", " WHERE well_id=" + wellID, false);
                this.outputProgress(false, "\r\nAnalyses...");
                this.copyTable("ANALY_HDR", " WHERE well_id=" + wellID, false);
                this.outputProgress(false, "\r\nSample details...");
                this.copyTable("SMPDTL", " WHERE well_id=" + wellID, false);
                this.outputProgress(false, "\r\nOccurrences...");
                this.copyTable("TAXONOCC", " WHERE well_id=" + wellID, false);
                this.copyTable("IGD_SCH", " WHERE sch_id IN (SELECT sch_id FROM " + this.db.DBTableName("IGD") + " WHERE well_id=" + wellID + ")", false);
                this.copyTable("IGD_DICT", " WHERE sch_id IN (SELECT sch_id FROM " + this.db.DBTableName("IGD") + " WHERE well_id=" + wellID + ")", false);
                this.copyTable("IGD_HDR", " WHERE well_id=" + wellID, false);
                this.outputProgress(false, "\r\nIntervals...");
                this.copyTable("IGD", " WHERE well_id=" + wellID, false);
                this.copyTable("IGD_COLMAP", " WHERE well_id=" + wellID, false);
                this.copyTable("IGD_ENV", " WHERE well_id=" + wellID, false);
                this.copyTable("LOC", " WHERE well_id=" + wellID, false);
                this.copyTable("LOCNODE", " WHERE well_id=" + wellID, false);
                this.outputProgress(false, "\r\nPicks...");
                this.copyTable("SQPICK", " WHERE well_id=" + wellID, false);
                this.outputProgress(false, "\r\nCore images...");
                this.copyTable("SBIMAGE", " WHERE image_id IN (SELECT image_id FROM " + this.db.DBTableName("coreimage") + " WHERE well_id=" + wellID + ")", false);
                this.copyTable("COREIMAGE", " WHERE well_id=" + wellID, false);
                this.copyTable("LOC", " WHERE well_id=" + wellID, false);
                this.copyTable("LOCNODE", " WHERE well_id=" + wellID, false);
                this.db.getDatabase().commit();
                Runtime.getRuntime().gc();
            }
            try {
                sql = "SELECT user_id, abr FROM userdef";
                rs = stmt.executeQuery(this.db.modQuery(sql));
                HashSet<Integer> users = new HashSet<Integer>();
                while (rs.next()) {
                    int userID = rs.getInt("user_id");
                    String abr = rs.getString("abr");
                    if (abr.equalsIgnoreCase("SYS")) continue;
                    users.add(userID);
                }
                rs.close();
                for (Integer userID : users) {
                    sql = "DELETE FROM userdef WHERE user_id=" + userID;
                    try {
                        stmt.executeUpdate(sql);
                    }
                    catch (SQLException sqle) {
                        System.out.println("Can't delete userdef: " + userID);
                    }
                }
            }
            catch (SQLException sqle) {
                this.printLog("Error fetching USERDEF table in new database: " + sqle.getMessage());
            }
            try {
                sql = "UPDATE USERDEF SET PASSWORD=" + SB.DBString((String)"7A9EB559FA1322");
                Statement nStmt = this.newDB.createStatement();
                int nItems = nStmt.executeUpdate(sql);
                this.printLog("Number of users with password reset to SYSTEM: " + nItems);
                nStmt.close();
                this.newDB.commit();
            }
            catch (SQLException sqle) {
                this.printLog("Error from updating passwords in USERDEF table in new database: " + sqle.getMessage());
            }
            try {
                sql = "SELECT abr FROM catcol";
                Statement stmtCatcol = this.newDB.createStatement();
                ResultSet rsCatcol = stmtCatcol.executeQuery(sql);
                HashSet<Integer> groupIDs = new HashSet<Integer>();
                while (rsCatcol.next()) {
                    try {
                        int groupID = Integer.parseInt(rsCatcol.getString("abr"));
                        groupIDs.add(groupID);
                    }
                    catch (NumberFormatException pe) {}
                }
                rsCatcol.close();
                for (Integer groupID : groupIDs) {
                    sql = "SELECT grp_id FROM TXGROUP WHERE grp_id=" + groupID;
                    rsCatcol = stmtCatcol.executeQuery(sql);
                    boolean hasGroup = false;
                    if (rsCatcol.next()) {
                        int g = rsCatcol.getInt("grp_id");
                        if (groupID == g) {
                            hasGroup = true;
                        }
                    }
                    rsCatcol.close();
                    if (hasGroup) continue;
                    sql = "DELETE FROM catcol WHERE abr='" + groupID + "'";
                    stmtCatcol.executeUpdate(sql);
                }
                stmtCatcol.close();
                this.newDB.commit();
            }
            catch (SQLException sqle) {
                this.printLog("Error from CATCOL update in new database: " + sqle.getMessage());
            }
            return true;
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "SQL Error", 0);
            if (this.log != null) {
                ex.printStackTrace(this.log);
            }
            ex.printStackTrace();
        }
        catch (SBException ex) {
            JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage(), "Well Error", 0);
            if (this.log != null) {
                ex.printStackTrace(this.log);
            }
            ex.printStackTrace();
        }
        return false;
    }

    void processCharts() throws SQLException, SBException {
        PreparedStatement pStmt = this.db.getDatabase().prepareStatement("INSERT INTO " + this.db.DBTableName("splitid") + " (usrid,label,ID) VALUES (?,?,?)");
        LinkedList charts = new LinkedList();
        SBChart.load((SBdb)this.db, charts, (String)"%");
        for (SBChart chart : charts) {
            chart.loadData();
            Iterator itP = chart.getPanels().iterator();
            boolean chartRequired = false;
            while (itP.hasNext()) {
                SBChart.Panel chPanel = (SBChart.Panel)itP.next();
                Iterator itW = this.project.getWellIterator();
                while (itW.hasNext()) {
                    Well well = (Well)itW.next();
                    int wellID = well.getWellID();
                    if (wellID != chPanel.wellID) continue;
                    chartRequired = true;
                    break;
                }
                if (!chartRequired) continue;
                if (chPanel.groupID > 0) {
                    this.insertSplitID(pStmt, "GRP_ID", chPanel.groupID);
                }
                if (chPanel.filterGroup > 0) {
                    this.insertSplitID(pStmt, "GRP_ID", chPanel.filterGroup);
                }
                if (chPanel.highlightGroup > 0) {
                    this.insertSplitID(pStmt, "GRP_ID", chPanel.highlightGroup);
                }
                if (chPanel.setID > 0) {
                    this.insertSplitID(pStmt, "GRPSET_ID", chPanel.setID);
                }
                if (chPanel.cmpStdID <= 0) continue;
                this.insertSplitID(pStmt, "CMPSTD_ID", chPanel.setID);
            }
            if (!chartRequired) continue;
            this.insertSplitID(pStmt, "CHART_ID", chart.getChartID());
        }
        this.copyTable("SBCHARTS", " WHERE chart_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='CHART_ID')", false);
        this.copyTable("SBCHCLIN", " WHERE chart_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='CHART_ID')", false);
        this.copyTable("SBCHPANL", " WHERE chart_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='CHART_ID')", false);
        this.copyTable("SBLOGTRC", " WHERE chart_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='CHART_ID')", false);
        this.copyTable("TXGROUP", " WHERE grp_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='GRP_ID')", false);
        this.copyTable("GROUPMBR", " WHERE grp_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='GRP_ID')  AND spec_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='SPEC_ID')", false);
        this.copyTable("TXGROUP", " WHERE grp_id IN (SELECT grp_id FROM " + this.db.DBTableName("setmbr") + " s, " + this.db.DBTableName("splitid") + " i WHERE i.usrid=" + this.db.getUserID() + " AND i.label='GRPSET_ID' AND i.id=s.grpset_id)", false);
        this.copyTable("GROUPMBR", " WHERE grp_id IN (SELECT grp_id FROM " + this.db.DBTableName("setmbr") + " s, " + this.db.DBTableName("splitid") + " i WHERE i.usrid=" + this.db.getUserID() + " AND i.label='GRPSET_ID' AND i.id=s.grpset_id) AND  spec_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='SPEC_ID')", false);
        this.copyTable("GROUPSET", " WHERE grpset_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='GRPSET_ID')", false);
        this.copyTable("SETMBR", " WHERE grpset_id IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='GRPSET_ID')", true);
        this.copyTable("CMPSTD", " WHERE STD_ID IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='CMPSTD_ID')", false);
        this.copyTable("CMPSTDEV", " WHERE STD_ID IN (SELECT id FROM " + this.db.DBTableName("splitid") + " WHERE usrid=" + this.db.getUserID() + " AND label='CMPSTD_ID')", false);
    }

    void insertSplitID(PreparedStatement pStmt, String name, int ID) throws SQLException {
        block2: {
            pStmt.setInt(1, this.db.getUserID());
            pStmt.setString(2, name);
            pStmt.setInt(3, ID);
            try {
                pStmt.executeUpdate();
            }
            catch (SQLException se) {
                if (se.getMessage().equalsIgnoreCase("GENERAL ERROR") || se.getMessage().startsWith("[Oracle][ODBC][Ora]ORA-00001: unique constraint ") || se.getMessage().contains("Violation of PRIMARY KEY constraint 'splitid_pk'")) break block2;
                throw se;
            }
        }
    }

    void createSplitIDs(Statement stmt, String columnName, String tableName, int wellID) throws SQLException {
        String sql = "SELECT " + columnName + " FROM " + this.db.DBTableName(tableName) + " WHERE well_id=" + wellID;
        ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
        PreparedStatement pStmt = this.db.getDatabase().prepareStatement("INSERT INTO " + this.db.DBTableName("splitid") + " (usrid,label,ID) VALUES (" + this.db.getUserID() + ",'" + columnName + "',?)");
        while (rs.next()) {
            pStmt.setInt(1, rs.getInt(columnName));
            try {
                pStmt.executeUpdate();
            }
            catch (SQLException se) {
                if (se.getMessage().equalsIgnoreCase("GENERAL ERROR") || se.getMessage().startsWith("[Oracle][ODBC][Ora]ORA-00001: unique constraint ") || se.getMessage().contains("Violation of PRIMARY KEY constraint 'splitid_pk'")) continue;
                System.out.println(se.getMessage());
                throw se;
            }
        }
        pStmt.close();
    }

    void outputProgress(boolean clear, String text) {
        if (clear) {
            this.jTextPaneProgress.setText("");
        }
        this.jTextPaneProgress.setText(this.jTextPaneProgress.getText() + text);
        this.jTextPaneProgress.scrollRectToVisible(new Rectangle(0, this.jTextPaneProgress.getHeight(), this.jTextPaneProgress.getWidth(), 10));
        this.jTextPaneProgress.setCursor(Cursor.getPredefinedCursor(3));
    }

    void printLog(String entry) {
        if (this.log != null) {
            this.log.println(entry);
        } else {
            System.out.println(entry);
        }
    }

    void copyTable(String tableName, String whereClause, boolean clearValues) throws SQLException {
        int i;
        ResultSet rs;
        Statement newStmt = this.newDB.createStatement();
        if (clearValues) {
            newStmt.executeUpdate("DELETE FROM " + tableName);
        }
        String selectQuery = "SELECT * FROM " + tableName;
        ResultSet rsNew = newStmt.executeQuery(selectQuery);
        ResultSetMetaData meta = rsNew.getMetaData();
        int nCols = meta.getColumnCount();
        selectQuery = "SELECT ";
        for (int i2 = 1; i2 <= nCols; ++i2) {
            selectQuery = selectQuery + meta.getColumnName(i2);
            if (i2 >= nCols) continue;
            selectQuery = selectQuery + ",";
        }
        selectQuery = selectQuery + " FROM " + this.db.DBTableName(tableName);
        Statement stmt = this.db.getDatabase().createStatement();
        if (whereClause != null) {
            selectQuery = selectQuery + whereClause;
        }
        try {
            this.printLog("Executing query in copyTable: " + selectQuery);
            rs = stmt.executeQuery(selectQuery);
        }
        catch (SQLException se) {
            selectQuery = "SELECT * FROM " + this.db.DBTableName(tableName);
            if (whereClause != null) {
                selectQuery = selectQuery + whereClause;
            }
            this.printLog("Re-trying: Select query: " + selectQuery);
            rs = stmt.executeQuery(selectQuery);
            meta = rs.getMetaData();
            nCols = meta.getColumnCount();
        }
        String sql = "INSERT INTO " + tableName + "(";
        boolean foundUpsize = false;
        for (i = 1; i <= nCols; ++i) {
            String colName = meta.getColumnName(i);
            if (colName.equals("upsize_ts")) {
                foundUpsize = true;
                continue;
            }
            sql = sql + colName;
            if (i >= nCols) continue;
            sql = sql + ",";
        }
        if (foundUpsize) {
            if (sql.charAt(sql.length() - 1) == ',') {
                sql = sql.substring(0, sql.length() - 1);
            }
            --nCols;
        }
        sql = sql + " ) VALUES (";
        for (i = 1; i <= nCols; ++i) {
            sql = sql + "?";
            if (i >= nCols) continue;
            sql = sql + ",";
        }
        sql = sql + ")";
        PreparedStatement pStmt = this.newDB.prepareStatement(sql);
        while (rs.next()) {
            String paramString = "";
            pStmt.clearParameters();
            for (int col = 1; col <= nCols; ++col) {
                Object obj = !(this.db.getDBType() != SBdb.DBType.MSSQLSERVER && this.db.getDBType() != SBdb.DBType.ORACLE || meta.getColumnType(col) != 12 && meta.getColumnType(col) != -1) ? rs.getString(col) : rs.getObject(col);
                if (obj != null) {
                    pStmt.setObject(col, obj);
                } else if (meta.getColumnName(col).equalsIgnoreCase("INTERP_ID")) {
                    pStmt.setInt(col, 0);
                } else {
                    int type = meta.getColumnType(col);
                    if (type == 3) {
                        type = 8;
                    }
                    if (type == 6) {
                        type = 8;
                    }
                    pStmt.setNull(col, type);
                }
                paramString = paramString + obj + ",";
            }
            try {
                pStmt.executeUpdate();
            }
            catch (SQLException se) {
                if (se.getMessage().equalsIgnoreCase("GENERAL ERROR")) {
                    this.printLog("Duplicate record error when inserting into " + tableName + ": " + paramString);
                    continue;
                }
                this.printLog("SQL :" + sql);
                throw se;
            }
        }
        newStmt.close();
        pStmt.close();
        stmt.close();
        this.newDB.commit();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.jButtonCloseActionPerformed(null);
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogcreatedatabase.html");
    }

    private boolean checkExistingData() throws SQLException {
        Statement stmt = this.newDB.createStatement();
        String sql = "SELECT count(*) AS nWells FROM WELLS";
        ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
        int nWells = 0;
        if (rs.next()) {
            nWells = rs.getInt("nWells");
        }
        if (nWells > 0 && JOptionPane.showConfirmDialog(this, "WARNING: selected database contains existing data. Continue (at your own risk)?", this.getTitle(), 0, 2) != 0) {
            stmt.close();
            return false;
        }
        stmt.close();
        return true;
    }
}

