/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jsbugs.FrameJsbugs;
import model2.Curve;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.TableSorter;

public class DialogCurve
extends JDialog {
    private final TableModelCurve model = new TableModelCurve();
    private final TableSorter sorter = new TableSorter((TableModel)this.model);
    private final Curve curve;
    private final Well well;
    private static final String[] titles = new String[]{"Depth", "Value"};
    private static final int[] widths = new int[]{30, 30};
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JScrollPane jScrollPane1;
    private JTable jTableCurve;

    public DialogCurve(Dialog parent, boolean modal, Curve curve, Well well) {
        super(parent, modal);
        this.curve = curve;
        this.well = well;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Edit Wireline Log");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        SB.setTableHeaderBold((JTable)this.jTableCurve);
        TableColumnModel columnModel = this.jTableCurve.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(titles[i]);
            columnModel.getColumn(i).setWidth(widths[i]);
        }
        this.jTableCurve.updateUI();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCurve = new JTable();
        this.jButtonDelete = new JButton();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(250, 300));
        this.jTableCurve.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableCurve);
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurve.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurve.this.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 190, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jButtonDelete).add((Component)this.jButtonClose)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonClose, this.jButtonDelete}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonDelete).addPreferredGap(0, 346, Short.MAX_VALUE).add((Component)this.jButtonClose)).add((Component)this.jScrollPane1, -1, 392, Short.MAX_VALUE)).add(14, 14, 14)));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableCurve.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No row selected", this.getTitle(), 1);
            return;
        }
        int count = this.jTableCurve.getSelectedRowCount();
        int option = JOptionPane.showConfirmDialog(this, "Really delete " + (count == 1 ? "this " : "these ") + count + " row" + (count == 1 ? "?" : "s?"), this.getTitle(), 0, 3);
        if (option == 0) {
            LinkedList toDelete = new LinkedList();
            try {
                for (int row : this.jTableCurve.getSelectedRows()) {
                    toDelete.add(this.curve.getTrace().get(row));
                }
                for (Curve.CurveValue cv : toDelete) {
                    this.curve.deleteRow(this.well.getDataModel(), cv);
                }
                this.well.getDataModel().commit();
                this.sorter.reallocateIndexes();
                this.model.fireTableDataChanged();
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error", sql, this.well.getDataModel());
            }
        }
    }

    private class TableModelCurve
    extends AbstractTableModel {
        private TableModelCurve() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (DialogCurve.this.curve == null) {
                return 0;
            }
            return DialogCurve.this.curve.getTrace().size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            Curve.CurveValue curveValue = (Curve.CurveValue)DialogCurve.this.curve.getTrace().get(row);
            switch (col) {
                case 0: {
                    return SB.getDepthString((double)curveValue.getDepth(), (char)DialogCurve.this.well.getWellUnits(), (int)2, (char)DialogCurve.this.well.getType());
                }
                case 1: {
                    return curveValue.getValue();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object obj, int row, int col) {
            switch (col) {
                default: 
            }
        }

        public Class getColumnClass(int c) {
            switch (c) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Curve.CurveValue.class;
                }
            }
            return Object.class;
        }
    }
}

