/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.DialogFilePreview;
import jsbugs.DialogLogDefs;
import jsbugs.FrameJsbugs;
import jsbugs.SBDialog;
import model2.LogDef;
import model2.LogFile;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class DialogCurveReader
extends SBDialog {
    DefaultComboBoxModel logDefModel = new DefaultComboBoxModel();
    DefaultComboBoxModel curveDefModel = new DefaultComboBoxModel();
    private final LogFile file;
    private final Well well;
    String curve;
    int nCurve;
    LogDef logDef;
    char units;
    float depthFilter;
    private ButtonGroup buttonGroupInputUnits;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonLogDef;
    private JButton jButtonOK;
    private JButton jButtonView;
    private JComboBox jComboBoxCurve;
    private JComboBox jComboBoxType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JRadioButton jRadioButtonFeet;
    private JRadioButton jRadioButtonMetres;
    private JSeparator jSeparator1;
    private JTextField jTextFieldDepthFilter;
    private JTextField jTextFieldFileName;
    private JTextField jTextFieldLogType;

    public DialogCurveReader(JDialog parent, boolean modal, Well well, LogFile logFile) throws SQLException, IOException {
        super((Dialog)parent, modal);
        this.file = logFile;
        this.well = well;
        this.initComponents();
        this.init();
    }

    private void init() throws SQLException, IOException {
        this.setTitle("Wireline Log Curve Reader : " + this.well.getWellName());
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldFileName.setText(this.file.getPath());
        this.populateTypeCombo();
        this.jComboBoxType.repaint();
        if (this.file.getDepthUnits() > '\u0000') {
            if (this.file.getDepthUnits() == 'M') {
                this.jRadioButtonMetres.setSelected(true);
            } else {
                this.jRadioButtonFeet.setSelected(true);
            }
        }
        Iterator it = this.file.getCurveHeaders();
        while (it.hasNext()) {
            LogFile.CurveHeader c = (LogFile.CurveHeader)it.next();
            this.curveDefModel.addElement(c.getMnem());
        }
        this.jComboBoxCurve.repaint();
        this.jComboBoxCurveActionPerformed(null);
    }

    void populateTypeCombo() throws SQLException {
        this.logDefModel.removeAllElements();
        Collection c = this.well.getDataModel().getLogDef().values();
        LinkedList list = new LinkedList(c);
        Collections.sort(list);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            this.logDefModel.addElement(it.next());
        }
    }

    private void initComponents() {
        this.buttonGroupInputUnits = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldFileName = new JTextField();
        this.jComboBoxCurve = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jTextFieldDepthFilter = new JTextField();
        this.jLabel4 = new JLabel();
        this.jButtonHelp = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonView = new JButton();
        this.jComboBoxType = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jTextFieldLogType = new JTextField();
        this.jButtonLogDef = new JButton();
        this.jLabel5 = new JLabel();
        this.jRadioButtonMetres = new JRadioButton();
        this.jRadioButtonFeet = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Filename:");
        this.jTextFieldFileName.setEditable(false);
        this.jComboBoxCurve.setModel(this.curveDefModel);
        this.jComboBoxCurve.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurveReader.this.jComboBoxCurveActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Column:");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurveReader.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurveReader.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jTextFieldDepthFilter.setText("0.0");
        this.jTextFieldDepthFilter.setToolTipText("<html>This is the minimum depth distance between sucessive depth samples to read from the file<br/>Increase this value to make file reading faster</html>");
        this.jTextFieldDepthFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DialogCurveReader.this.jTextFieldDepthFilterKeyTyped(evt);
            }
        });
        this.jLabel4.setText("Depth filter value:");
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurveReader.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonView.setText("View...");
        this.jButtonView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurveReader.this.jButtonViewActionPerformed(evt);
            }
        });
        this.jComboBoxType.setMaximumRowCount(20);
        this.jComboBoxType.setModel(this.logDefModel);
        this.jComboBoxType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurveReader.this.jComboBoxTypeActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Type:");
        this.jTextFieldLogType.setEditable(false);
        this.jButtonLogDef.setText("Edit defaults...");
        this.jButtonLogDef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurveReader.this.jButtonLogDefActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Input units:");
        this.buttonGroupInputUnits.add(this.jRadioButtonMetres);
        this.jRadioButtonMetres.setText("Metres");
        this.jRadioButtonMetres.setToolTipText("");
        this.buttonGroupInputUnits.add(this.jRadioButtonFeet);
        this.jRadioButtonFeet.setText("Feet");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 460, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.jTextFieldDepthFilter, -1, 53, Short.MAX_VALUE).add(30, 30, 30).add((Component)this.jLabel5).addPreferredGap(1).add((Component)this.jRadioButtonMetres).addPreferredGap(0).add((Component)this.jRadioButtonFeet).add(118, 118, 118)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel3).add((Component)this.jLabel2).add((Component)this.jLabel1)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldFileName, -1, 337, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonView)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jComboBoxCurve, 0, -1, Short.MAX_VALUE).add(1, (Component)this.jComboBoxType, 0, 117, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jTextFieldLogType, -1, 176, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonLogDef)))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldFileName, -2, -1, -2).add((Component)this.jLabel1).add((Component)this.jButtonView)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jComboBoxCurve, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxType, -2, -1, -2).add((Component)this.jLabel3).add((Component)this.jTextFieldLogType, -2, -1, -2).add((Component)this.jButtonLogDef)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.jTextFieldDepthFilter, -2, -1, -2).add((Component)this.jRadioButtonMetres).add((Component)this.jRadioButtonFeet).add((Component)this.jLabel5)).addPreferredGap(1).add((Component)this.jSeparator1, -2, 10, -2).add(11, 11, 11).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroupInputUnits.getSelection() == null) {
            JOptionPane.showMessageDialog(this, "You must specify depth units.", this.getTitle(), 2);
            return;
        }
        this.units = this.jRadioButtonFeet.isSelected() ? (char)70 : (char)77;
        this.logDef = (LogDef)this.jComboBoxType.getSelectedItem();
        this.curve = (String)this.jComboBoxCurve.getSelectedItem();
        this.nCurve = this.jComboBoxCurve.getSelectedIndex();
        this.depthFilter = Float.parseFloat(this.jTextFieldDepthFilter.getText());
        this.setOK();
    }

    private void jComboBoxTypeActionPerformed(ActionEvent evt) {
        this.logDef = (LogDef)this.jComboBoxType.getSelectedItem();
        if (this.logDef != null) {
            this.jTextFieldLogType.setText(this.logDef.getTitle());
        }
    }

    private void jComboBoxCurveActionPerformed(ActionEvent evt) {
        try {
            String curveType = (String)this.jComboBoxCurve.getSelectedItem();
            this.logDef = (LogDef)this.well.getDataModel().getLogDef().get(curveType);
            if (this.logDef != null) {
                this.jComboBoxType.setSelectedItem(this.logDef);
            }
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.well.getDataModel());
        }
    }

    private void jTextFieldDepthFilterKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldDepthFilter, (int)4, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtowireline.html");
    }

    private void jButtonLogDefActionPerformed(ActionEvent evt) {
        try {
            DialogLogDefs dialog = new DialogLogDefs(this, true, this.well.getDataModel());
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            this.populateTypeCombo();
        }
        catch (SQLException sql) {
            FrameJsbugs.showStackError("SQL Error", sql, this.well.getDataModel());
        }
    }

    private void jButtonViewActionPerformed(ActionEvent evt) {
        DialogFilePreview dialog = new DialogFilePreview(this, false, this.file.getPath());
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }
}

