/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.TableModel;
import jsbugs.DialogCurve;
import jsbugs.DialogCurveReader;
import jsbugs.DialogFilePreview;
import jsbugs.FrameJsbugs;
import jsbugs.TableModelCurves;
import model2.Curve;
import model2.Lastval;
import model2.LogFile;
import model2.SBdb;
import model2.Well;
import util.SB;
import util.SbugsFileFilter;
import util.TableSorter;

public class DialogCurves
extends JDialog {
    TableModelCurves model = new TableModelCurves();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    private LogFile logFile = null;
    private JButton jButtonClose;
    private JButton jButtonDelete;
    private JButton jButtonEdit;
    private JButton jButtonHelp;
    private JButton jButtonRead;
    private JScrollPane jScrollPane1;
    private JTable jTableCurves;

    public DialogCurves(Frame parent, boolean modal, Well well) throws SQLException {
        super(parent, modal);
        this.initComponents();
        this.init(well);
    }

    private void init(Well well) throws SQLException {
        this.model.setupTable(this.jTableCurves);
        this.model.setWell(well);
        this.setTitle("Wireline Logs : " + well.getWellName());
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableCurves);
        this.sorter.reallocateIndexes();
        this.sorter.fireTableDataChanged();
    }

    Well getWell() {
        return this.model.well;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTableCurves = new JTable();
        this.jButtonClose = new JButton();
        this.jButtonRead = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonEdit = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(550, 250));
        this.jTableCurves.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableCurves);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurves.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jButtonRead.setText("Read...");
        this.jButtonRead.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurves.this.jButtonReadActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurves.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurves.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogCurves.this.jButtonEditActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 631, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButtonClose, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonRead, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonHelp, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addComponent(this.jButtonDelete, -1, 69, Short.MAX_VALUE).addComponent(this.jButtonEdit, GroupLayout.Alignment.LEADING, -2, 69, -2)).addContainerGap()));
        layout.linkSize(0, this.jButtonClose, this.jButtonDelete, this.jButtonRead);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 335, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButtonRead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 202, Short.MAX_VALUE).addComponent(this.jButtonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClose))).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonReadActionPerformed(ActionEvent evt) {
        SbugsFileFilter filterAll = new SbugsFileFilter();
        JFileChooser jFileChooser = new JFileChooser();
        File setDir = null;
        try {
            setDir = new File(Lastval.getString((SBdb)this.model.well.getDataModel(), (String)"WINLOGIMP", (String)"UNXLOGIMP"));
        }
        catch (SQLException ex) {
            // empty catch block
        }
        jFileChooser.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file = jFileChooser.getSelectedFile();
            try {
                Lastval.putString((SBdb)this.model.well.getDataModel(), (String)"WINLOGIMP", (String)"UNXLOGIMP", (String)file.getPath());
                this.model.well.getDataModel().commit();
                if (this.logFile != null && !file.getPath().equals(this.logFile.getPath())) {
                    this.logFile = null;
                }
                if (this.logFile == null) {
                    this.logFile = new LogFile(file);
                    if (this.logFile.hasformatException()) {
                        JOptionPane.showMessageDialog(this, "Warning: there were errors encountered during file read. Check for missing or suspicious log values.", this.getTitle(), 2);
                    }
                }
                DialogCurveReader dialog = new DialogCurveReader(this, true, this.model.well, this.logFile);
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
                if (dialog.isOK()) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    Curve curve = new Curve(this.logFile, dialog.units, dialog.logDef, dialog.nCurve, dialog.depthFilter, this.model.well.getType());
                    if (curve.getTopDepth() == null) {
                        JOptionPane.showMessageDialog(this, "Could not read any data from file for this curve.");
                        return;
                    }
                    if (this.model.curves.checkOverlap(curve) && JOptionPane.showConfirmDialog(this, "This curve overlaps other curves in the database. Continue to add curve (not recommended)?", "Curves overlap", 0) != 0) {
                        return;
                    }
                    this.model.curves.add(this.model.well.getDataModel(), this.model.well, curve);
                    this.sorter.reallocateIndexes();
                    this.sorter.fireTableDataChanged();
                    this.model.well.getDataModel().commit();
                }
            }
            catch (FileNotFoundException fnf) {
                JOptionPane.showMessageDialog(this, "File not found", this.getTitle(), 2);
            }
            catch (IOException ioe) {
                SB.showStackError((String)"Problem reading file", (Exception)ioe);
                DialogFilePreview dialog = new DialogFilePreview(this, true, file.getPath());
                dialog.setLocationRelativeTo(this);
                dialog.setVisible(true);
            }
            catch (SQLException sql) {
                this.model.well.getDataModel().doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.model.well.getDataModel());
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        if (this.jTableCurves.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No curves selected", this.getTitle(), 1);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int[] selection = this.jTableCurves.getSelectedRows();
            LinkedList toDelete = new LinkedList();
            for (int i = 0; i < selection.length; ++i) {
                toDelete.add(this.model.curves.getCurves().get(this.sorter.getIndexOf(selection[i])));
            }
            int opt = JOptionPane.showConfirmDialog(this, "Really delete " + (toDelete.size() == 1 ? "this curve?" : "these " + toDelete.size() + " curves?"), this.getTitle(), 0, 3);
            if (opt != 0) {
                return;
            }
            Iterator it = toDelete.iterator();
            while (it.hasNext()) {
                this.model.curves.delete(this.model.well.getDataModel(), (Curve)it.next());
            }
            this.model.well.getDataModel().commit();
            this.sorter.reallocateIndexes();
            this.sorter.fireTableDataChanged();
        }
        catch (SQLException sql) {
            this.model.well.getDataModel().doRollback();
            FrameJsbugs.showStackError("SQL Error", sql, this.model.well.getDataModel());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("howtowireline.html");
    }

    private void jButtonEditActionPerformed(ActionEvent evt) {
        if (this.jTableCurves.getSelectedRow() < 0) {
            JOptionPane.showMessageDialog(this, "No curves selected", this.getTitle(), 1);
            return;
        }
        Curve curve = (Curve)this.model.curves.getCurves().get(this.sorter.getIndexOf(this.jTableCurves.getSelectedRow()));
        DialogCurve dialog = new DialogCurve((Dialog)this, true, curve, this.model.well);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
    }
}

