/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import jsbugs.FrameJsbugs;
import model2.SBdb;
import util.SB;

public class DialogDBInfo
extends JDialog {
    private final TableModelInfo model = new TableModelInfo();
    private final SBdb db;
    private JButton jButtonClose;
    private JLabel jLabelFileSize;
    private JScrollPane jScrollPane1;
    private JTable jTableInfo;

    public DialogDBInfo(Frame parent, boolean modal, SBdb db) {
        super(parent, modal);
        this.db = db;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Database Statistics");
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.model.items = new LinkedList<InfoItem>();
        try {
            InfoItem item;
            InfoItem item2;
            InfoItem item3;
            double size = this.db.getFileSize();
            if (size > 0.0) {
                if (size > 1800.0) {
                    this.jLabelFileSize.setForeground(Color.red);
                }
                this.jLabelFileSize.setText(this.jLabelFileSize.getText() + " " + size + " MB  (2.0 GB limit)");
            } else {
                this.jLabelFileSize.setEnabled(false);
            }
            String info = this.db.getDatabaseInfo();
            StringTokenizer tok = new StringTokenizer(info, ",");
            if (tok.hasMoreTokens()) {
                this.model.items.add(new InfoItem("Wells", Integer.parseInt(tok.nextToken())));
            }
            if (tok.hasMoreTokens()) {
                item3 = new InfoItem("Projects", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item3);
            }
            if (tok.hasMoreTokens()) {
                item3 = new InfoItem("Samples", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item3);
            }
            if (tok.hasMoreTokens()) {
                item3 = new InfoItem("Analyses", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item3);
            }
            if (tok.hasMoreTokens()) {
                item3 = new InfoItem("Occurrences", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item3);
            }
            if (tok.hasMoreTokens()) {
                item3 = new InfoItem("Images", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item3);
            }
            InfoItem blank0 = new InfoItem("", 0);
            this.model.items.add(blank0);
            if (tok.hasMoreTokens()) {
                item2 = new InfoItem("Versions", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item2);
            }
            if (tok.hasMoreTokens()) {
                this.model.items.add(new InfoItem("Depth/Age curves", Integer.parseInt(tok.nextToken())));
            }
            if (tok.hasMoreTokens()) {
                item2 = new InfoItem("Stratigraphic Intervals", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item2);
            }
            if (tok.hasMoreTokens()) {
                item2 = new InfoItem("Environments", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item2);
            }
            if (tok.hasMoreTokens()) {
                item2 = new InfoItem("Events", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item2);
            }
            if (tok.hasMoreTokens()) {
                item2 = new InfoItem("Biostratigraphic comments", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item2);
            }
            if (tok.hasMoreTokens()) {
                item2 = new InfoItem("Sequence picks", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item2);
            }
            if (tok.hasMoreTokens()) {
                item2 = new InfoItem("Interval comments", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item2);
            }
            if (tok.hasMoreTokens()) {
                item2 = new InfoItem("Faults", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item2);
            }
            if (tok.hasMoreTokens()) {
                item2 = new InfoItem("Wireline log curves", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item2);
            }
            if (tok.hasMoreTokens()) {
                item2 = new InfoItem("Charts", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item2);
            }
            InfoItem blank = new InfoItem("", 0);
            this.model.items.add(blank);
            if (tok.hasMoreTokens()) {
                item = new InfoItem("Users", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item);
            }
            if (tok.hasMoreTokens()) {
                item = new InfoItem("Species", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item);
            }
            if (tok.hasMoreTokens()) {
                item = new InfoItem("Genera", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item);
            }
            if (tok.hasMoreTokens()) {
                item = new InfoItem("Categories", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item);
            }
            if (tok.hasMoreTokens()) {
                item = new InfoItem("Taxon groups", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item);
            }
            if (tok.hasMoreTokens()) {
                item = new InfoItem("Stratigraphic schemes", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item);
            }
            if (tok.hasMoreTokens()) {
                item = new InfoItem("Composite standards", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item);
            }
            if (tok.hasMoreTokens()) {
                item = new InfoItem("Environment schemes", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item);
            }
            if (tok.hasMoreTokens()) {
                item = new InfoItem("Age curves", Integer.parseInt(tok.nextToken()));
                this.model.items.add(item);
            }
        }
        catch (SQLException e) {
            FrameJsbugs.showStackError("Error getting database info", e, this.db);
        }
        SB.setTableHeaderBold((JTable)this.jTableInfo);
        TableColumnModel columnModel = this.jTableInfo.getTableHeader().getColumnModel();
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(TableModelInfo.titles[i]);
            columnModel.getColumn(i).setWidth(TableModelInfo.widths[i]);
        }
        columnModel.getColumn(1).setCellRenderer(new InfoRenderer());
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void initComponents() {
        this.jLabelFileSize = new JLabel();
        this.jButtonClose = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTableInfo = new JTable();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(250, 300));
        this.jLabelFileSize.setText("Access file size:");
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogDBInfo.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jTableInfo.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableInfo);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 298, Short.MAX_VALUE).addComponent(this.jLabelFileSize).addComponent(this.jButtonClose, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelFileSize).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 460, Short.MAX_VALUE).addGap(11, 11, 11).addComponent(this.jButtonClose).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private static class TableModelInfo
    extends AbstractTableModel {
        List<InfoItem> items;
        static String[] titles = new String[]{"Data type", "No. records"};
        static int[] widths = new int[]{100, 30};

        private TableModelInfo() {
        }

        @Override
        public int getRowCount() {
            if (this.items == null) {
                return 0;
            }
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.items == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return " " + this.items.get((int)rowIndex).name;
                }
                case 1: {
                    return " " + this.items.get((int)rowIndex).number;
                }
            }
            return null;
        }
    }

    private static class InfoRenderer
    extends DefaultTableCellRenderer {
        private InfoRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            if (value.toString().equals(" 0")) {
                this.setText("");
            } else {
                this.setText("" + value);
            }
        }
    }

    private static class InfoItem {
        String name;
        int number;

        InfoItem(String name, int number) {
            this.name = name;
            this.number = number;
        }
    }
}

