/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import jsbugs.Chart;
import jsbugs.ChartActions;
import jsbugs.ChartJPanel;
import jsbugs.ZoomAction;
import model2.IGDScheme;
import org.jdesktop.layout.GroupLayout;
import util.SBException;

public class DialogDrawIGDScheme
extends JDialog
implements ChartActions {
    private ChartJPanel schemeChartJPanel = new ChartJPanel(null);
    float schemeZoom = 1.0f;
    static final float zoomIncrement = 1.5f;
    private JButton jButtonClose;
    private JButton jButtonZoomIn;
    private JButton jButtonZoomOut;
    private JScrollPane jScrollPaneSchemeChart;
    private JToolBar jToolBar1;

    public DialogDrawIGDScheme(JDialog parent, boolean modal, IGDScheme scheme1, IGDScheme scheme2) throws SQLException, SBException {
        super((Dialog)parent, modal);
        this.initComponents();
        this.init(scheme1, scheme2);
    }

    private void init(IGDScheme scheme1, IGDScheme scheme2) throws SQLException, SBException {
        this.setTitle("Compare Schemes: " + scheme1.toString() + " / " + scheme2.toString());
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.schemeChartJPanel.chart = new Chart();
        this.schemeChartJPanel.chart.chartProperties.setPanelHeaderHeight(60.0f);
        this.jScrollPaneSchemeChart.getVerticalScrollBar().setUnitIncrement(20);
        this.jScrollPaneSchemeChart.getViewport().add((Component)this.schemeChartJPanel, null);
        this.schemeChartJPanel.chart.getAddSchemeBlock().addScheme(scheme1);
        this.schemeChartJPanel.chart.getAddSchemeBlock().addScheme(scheme2);
        this.schemeChartJPanel.chart.calcChartSize();
        scheme1.addObserver((Observer)this.schemeChartJPanel);
        scheme2.addObserver((Observer)this.schemeChartJPanel);
        this.setSchemeScrollPaneSize();
        this.initKeyBindings();
    }

    private void setSchemeScrollPaneSize() {
        this.schemeChartJPanel.setSize(this.schemeZoom);
        this.schemeChartJPanel.revalidate();
        this.schemeChartJPanel.repaint();
    }

    private void initKeyBindings() {
        this.jToolBar1.getInputMap(2).put(KeyStroke.getKeyStroke(61, 128), "zoomIn");
        this.jToolBar1.getInputMap(2).put(KeyStroke.getKeyStroke(45, 128), "zoomOut");
        this.jToolBar1.getActionMap().put("zoomIn", new ZoomAction(true, this));
        this.jToolBar1.getActionMap().put("zoomOut", new ZoomAction(false, this));
    }

    private void initComponents() {
        this.jScrollPaneSchemeChart = new JScrollPane();
        this.jButtonClose = new JButton();
        this.jToolBar1 = new JToolBar();
        this.jButtonZoomIn = new JButton();
        this.jButtonZoomOut = new JButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(400, 500));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogDrawIGDScheme.this.jButtonCloseActionPerformed(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButtonZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomIn16.png")));
        this.jButtonZoomIn.setToolTipText("Zoom in (Ctrl + +)");
        this.jButtonZoomIn.setFocusable(false);
        this.jButtonZoomIn.setHorizontalTextPosition(0);
        this.jButtonZoomIn.setVerticalTextPosition(3);
        this.jButtonZoomIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogDrawIGDScheme.this.jButtonZoomInActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomIn);
        this.jButtonZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/jsbugs/icon_new/ZoomIcons/ZoomOut16.png")));
        this.jButtonZoomOut.setToolTipText("Zoom out (Ctrl + -)");
        this.jButtonZoomOut.setFocusable(false);
        this.jButtonZoomOut.setHorizontalTextPosition(0);
        this.jButtonZoomOut.setVerticalTextPosition(3);
        this.jButtonZoomOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogDrawIGDScheme.this.jButtonZoomOutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonZoomOut);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPaneSchemeChart, -1, 710, Short.MAX_VALUE).add((Component)this.jToolBar1, -2, -1, -2).add(2, (Component)this.jButtonClose)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jToolBar1, -2, 35, -2).addPreferredGap(0).add((Component)this.jScrollPaneSchemeChart, -1, 586, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jButtonClose).addContainerGap()));
        this.pack();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonZoomInActionPerformed(ActionEvent evt) {
        this.zoom(true);
    }

    private void jButtonZoomOutActionPerformed(ActionEvent evt) {
        this.zoom(false);
    }

    @Override
    public void chartProperties() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void zoom(boolean in) {
        this.schemeChartJPanel.zoom(this.schemeChartJPanel.zoom, 1.5f, in);
    }

    @Override
    public void undoRedo(boolean undo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

