/*
 * Decompiled with CFR 0.152.
 */
package jsbugs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import jsbugs.EditAbnTableModel;
import jsbugs.FrameJsbugs;
import model2.AbnScheme;
import model2.AnalystHeader;
import model2.SBdb;
import model2.Sample;
import model2.Smpdtl;
import model2.TaxonOcc;
import model2.Well;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.TableSorter;

public class DialogEditAbundance
extends JDialog {
    EditAbnTableModel model = new EditAbnTableModel();
    TableSorter sorter = new TableSorter((TableModel)this.model);
    SBdb db;
    Well well;
    char discID;
    String analyst;
    int analyNo;
    JComboBox comboBox = new JComboBox();
    boolean inStartup = true;
    AnalystHeader hdr = null;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JComboBox jComboBoxAbnScheme;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JTable jTableAb;
    private JTextField jTextFieldAnalyst;
    private JTextField jTextFieldDiscipline;
    private JTextField jTextFieldExistingAbn;
    private JTextField jTextFieldWellName;

    public DialogEditAbundance(JDialog parent, boolean modal, SBdb db, Well well, char discID, String analyst, int analyNo) throws SBException, SQLException {
        super((Dialog)parent, modal);
        this.db = db;
        this.well = well;
        this.discID = discID;
        this.analyst = analyst;
        this.analyNo = analyNo;
        this.initComponents();
        this.init();
    }

    private void init() throws SBException, SQLException {
        AbnScheme scheme2;
        this.hdr = this.well.getAnalystHeader(this.analyst, this.discID, this.analyNo, true);
        AbnScheme orig = this.db.getAbnScheme(this.hdr.getAbnSchID(), true);
        this.setTitle("Well Abundance : Edit : " + orig);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.model.setupTable(this.jTableAb, this.comboBox);
        this.sorter.addMouseListenerToHeaderInTable(this.jTableAb);
        this.jTextFieldWellName.setText(this.well.getWellName());
        this.jTextFieldDiscipline.setText(SBdb.getDiscAbr((char)this.discID));
        this.jComboBoxAbnScheme.removeAllItems();
        for (AbnScheme scheme2 : this.db.getAbnSchemes()) {
            this.jComboBoxAbnScheme.addItem(scheme2);
        }
        this.jComboBoxAbnScheme.setSelectedItem(orig);
        this.jTextFieldExistingAbn.setText(orig.toString());
        this.well.loadAnalyses();
        this.jTextFieldAnalyst.setText(this.analyst + "(" + this.analyNo + ")");
        if (orig == null && (scheme2 = this.db.getAbnScheme(this.well, (int)this.discID, true)) != null) {
            this.jComboBoxAbnScheme.setSelectedItem(scheme2);
        }
        this.inStartup = false;
        this.model.setSize(0);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Sample sample : this.well.getSamples()) {
            for (Smpdtl dtl : sample.getAnalyses()) {
                if (dtl.getAnalyID() != this.hdr.getAnalyID()) continue;
                for (TaxonOcc fss : dtl.getOccur()) {
                    if (fss.getSubAbund().length() <= 0) continue;
                    if (map.get(fss.getSubAbund()) == null) {
                        map.put(fss.getSubAbund(), 1);
                        continue;
                    }
                    int n = (Integer)map.get(fss.getSubAbund());
                    map.remove(fss.getSubAbund());
                    map.put(fss.getSubAbund(), ++n);
                }
            }
        }
        if (map.isEmpty()) {
            JOptionPane.showMessageDialog(this, "No subjective occurrence entries found.\nYou can assign a different scheme to the suite, if required, without reassigning abundance for occurrences.", this.getTitle(), 1);
            this.model.setSize(0);
        } else {
            this.model.setSize(map.size());
            Iterator itm = map.keySet().iterator();
            int i = 0;
            while (itm.hasNext()) {
                int index;
                this.model.donorAbr[i] = (String)itm.next();
                this.model.occs[i] = (Integer)map.get(this.model.donorAbr[i]);
                this.model.donorMin[i] = orig != null ? ((index = orig.getIndex(this.model.donorAbr[i])) >= 0 ? orig.getLowBound(index) : 0) : 0;
                ++i;
            }
        }
        this.sorter.reallocateIndexes();
        this.sorter.sortByColumn(0);
        this.sorter.sort((Object)this);
        this.sorter.fireTableDataChanged();
        this.jComboBoxAbnSchemeActionPerformed(null);
    }

    private void initComponents() {
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextFieldWellName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextFieldDiscipline = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldAnalyst = new JTextField();
        this.jLabel3 = new JLabel();
        this.jComboBoxAbnScheme = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTableAb = new JTable();
        this.jButtonHelp = new JButton();
        this.jLabel5 = new JLabel();
        this.jTextFieldExistingAbn = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(345, 400));
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEditAbundance.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEditAbundance.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Well:");
        this.jTextFieldWellName.setEditable(false);
        this.jLabel2.setText("Discipline:");
        this.jTextFieldDiscipline.setEditable(false);
        this.jLabel4.setText("Analysis suite:");
        this.jTextFieldAnalyst.setEditable(false);
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText("New Abundance Scheme for suite:");
        this.jComboBoxAbnScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEditAbundance.this.jComboBoxAbnSchemeActionPerformed(evt);
            }
        });
        this.jTableAb.setModel((TableModel)this.sorter);
        this.jScrollPane1.setViewportView(this.jTableAb);
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogEditAbundance.this.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel5.setHorizontalAlignment(11);
        this.jLabel5.setText("Abundance Scheme assigned to suite:");
        this.jTextFieldExistingAbn.setEditable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, 0, 0, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabel1).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldAnalyst).add((Component)this.jTextFieldWellName).add((Component)this.jTextFieldDiscipline))).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel3).add((Component)this.jLabel5)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldExistingAbn).add((Component)this.jComboBoxAbnScheme, 0, 162, Short.MAX_VALUE)))))).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldWellName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jTextFieldAnalyst, -2, -1, -2).add((Component)this.jLabel4)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jTextFieldDiscipline, -2, -1, -2).add(2, (Component)this.jLabel2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.jTextFieldExistingAbn, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxAbnScheme, -2, -1, -2).add((Component)this.jLabel3)).addPreferredGap(1).add((Component)this.jScrollPane1, -1, 248, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int i;
        AbnScheme abnScheme = (AbnScheme)this.jComboBoxAbnScheme.getSelectedItem();
        for (i = 0; i < this.model.nRows; ++i) {
            if (this.model.targetDesc[i].length() != 0) continue;
            JOptionPane.showMessageDialog(this, "Not all entries are in selected scheme, select matching entries for all abbreviations shown.", this.getTitle(), 2);
            return;
        }
        for (i = 0; i < this.model.nRows; ++i) {
            String targetAbr = abnScheme.getAbr(this.model.targetDesc[i]);
            if (targetAbr.equals(this.model.donorAbr[i])) continue;
            for (int j = 0; j < this.model.nRows; ++j) {
                if (i == j) continue;
                String targetAbr2 = abnScheme.getAbr(this.model.targetDesc[j]);
                if (!targetAbr.equals(this.model.donorAbr[j]) || this.model.donorAbr[j].equals(targetAbr2)) continue;
                JOptionPane.showMessageDialog(this, "You can't edit '" + this.model.donorAbr[i] + "' to '" + targetAbr + "' because '" + targetAbr + "' is being changed to '" + targetAbr2 + "'.", this.getTitle(), 2);
                return;
            }
        }
        if (this.hdr == null) {
            JOptionPane.showMessageDialog(this, "Cannot find analyst header. Abundance scheme not updated", this.getTitle(), 1);
            return;
        }
        try {
            AbnScheme currentScheme = this.db.getAbnScheme(this.well, this.hdr.getAnalyID(), true);
            if (abnScheme != currentScheme) {
                this.hdr.setAbnScheme(this.well, abnScheme);
            }
            int nUpdated = 0;
            for (int i2 = 0; i2 < this.model.nRows; ++i2) {
                String targetAbr = abnScheme.getAbr(this.model.targetDesc[i2]);
                if (targetAbr.equals(this.model.donorAbr[i2])) continue;
                nUpdated += this.well.updateSubjAbund(this.model.donorAbr[i2], targetAbr, this.hdr.getAnalyID());
            }
            this.db.commit();
            String msg = "";
            if (abnScheme != currentScheme) {
                msg = msg + "Scheme in suite reassigned.";
            }
            if (nUpdated > 0) {
                if (msg.length() > 0) {
                    msg = msg + "\n";
                }
                msg = msg + "Number of occurrence entries updated: " + nUpdated;
            }
            if (msg.length() > 0) {
                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 1);
            }
            this.dispose();
        }
        catch (SBException ex) {
            SB.showStackError((String)"Error", (Exception)((Object)ex));
            this.db.doRollback();
        }
        catch (SQLException ex) {
            SB.showStackError((String)"SQL Error", (SQLException)ex);
            this.db.doRollback();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBoxAbnSchemeActionPerformed(ActionEvent evt) {
        if (this.inStartup) {
            return;
        }
        AbnScheme abnScheme = (AbnScheme)this.jComboBoxAbnScheme.getSelectedItem();
        this.comboBox.removeAllItems();
        abnScheme.fillCombo(this.comboBox, false);
        for (int i = 0; i < this.model.nRows; ++i) {
            try {
                this.model.targetDesc[i] = abnScheme.getClassName(this.model.donorAbr[i]);
                continue;
            }
            catch (SBException ex) {
                this.model.targetDesc[i] = "";
            }
        }
        this.sorter.reallocateIndexes();
        this.sorter.sort((Object)this);
        this.sorter.fireTableDataChanged();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogeditabundance.html");
    }
}

